/*use when UPDATE B069 TO B071*/
USE lego;

CREATE TABLE IF NOT EXISTS  `t_atic_nfa_syslog` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `dev_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `anomalyId` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `creationTime` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `updateTime` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `subType` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `severity` varchar(16) COLLATE utf8_bin DEFAULT NULL,
  `status` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `direction` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `resource` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `resourceId` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `importance` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `current` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `threshold` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `unit` varchar(16) COLLATE utf8_bin DEFAULT NULL,
  `dstIp1` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `dstIp2` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `dstIp3` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `dstPort1` varchar(16) COLLATE utf8_bin DEFAULT NULL,
  `dstPort2` varchar(16) COLLATE utf8_bin DEFAULT NULL,
  `srcIp1` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `srcIp2` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `srcIp3` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `srcPort1` varchar(16) COLLATE utf8_bin DEFAULT NULL,
  `srcPort2` varchar(16) COLLATE utf8_bin DEFAULT NULL,
  `protocol` varchar(16) COLLATE utf8_bin DEFAULT NULL,
  `url` varchar(511) COLLATE utf8_bin DEFAULT NULL,
  `remark` varchar(511) COLLATE utf8_bin DEFAULT NULL,
  `detail` text COLLATE utf8_bin,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `t_atic_dev_syslog` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_time` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `dev_ip` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `task` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `terminal_ip` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `user` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `vrf` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `command` varchar(128) COLLATE utf8_bin DEFAULT NULL,
  `detail` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS  `p_operate_log` (
  `time` bigint(20) unsigned NOT NULL,
  `username` varchar(32) NOT NULL,
  `ip` varchar(40) NOT NULL,
  `type` varchar(20) NOT NULL,
  `result` tinyint(4) NOT NULL,
  `content` varchar(1024) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

ALTER TABLE t_atic_nfa_syslog MODIFY COLUMN detail  TEXT;
ALTER TABLE t_atic_nfa_syslog MODIFY COLUMN remark  VARCHAR(512);
ALTER TABLE t_atic_nfa_syslog MODIFY COLUMN url  VARCHAR(512);
ALTER TABLE t_atic_nfa_syslog  ADD  COLUMN `atic_time` int(11) DEFAULT 0  AFTER `pkid`;
ALTER TABLE t_atic_dev_syslog  ADD  COLUMN `atic_time` int(11) DEFAULT 0  AFTER `pkid`;
ALTER TABLE p_operate_log ADD INDEX log_time (TIME);
