/*use when UPDATE V5R1C30BO56 TO V5R1C30B057*/
USE `lego`;


CREATE TABLE IF NOT EXISTS `t_atic_blackhole_api_config` (
  `id` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `sp` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
  `defend_scope` VARCHAR(11) COLLATE utf8_bin DEFAULT NULL,
  `url` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
  `username` VARCHAR(500) COLLATE utf8_bin DEFAULT NULL,
  `password` VARCHAR(500) COLLATE utf8_bin DEFAULT NULL,
  `enable_status` INT(11) DEFAULT NULL,
  `unblock_time` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=INNODB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP PROCEDURE IF EXISTS add_blackhole;
DELIMITER //
CREATE PROCEDURE add_blackhole() BEGIN
	IF NOT EXISTS(SELECT * FROM information_schema.columns
	       WHERE table_name = 't_atic_blackhole' AND column_name ='sp' OR column_name='blackhole_mode' OR column_name='default_scope')
	THEN
	  ALTER TABLE `t_atic_blackhole` ADD COLUMN `sp` VARCHAR(255) DEFAULT '\-\-' AFTER `device_id`;
	  ALTER TABLE `t_atic_blackhole` ADD COLUMN `blackhole_mode` INT(255) DEFAULT 0 AFTER `pkid`;
	  ALTER TABLE `t_atic_blackhole` ADD COLUMN `default_scope` VARCHAR(255) DEFAULT 0 AFTER `sp`;
	END IF;
	END;
//
DELIMITER ;
CALL add_blackhole(); 

ALTER TABLE `t_atic_blackhole` MODIFY COLUMN `black_mask` VARCHAR(255);


DROP PROCEDURE IF EXISTS add_faultRule;
DELIMITER //
CREATE PROCEDURE add_faultRule() BEGIN
	IF NOT EXISTS(SELECT * FROM information_schema.columns
	       WHERE table_name = 't_fault_severity_rule' AND column_name ='zone_id')
	THEN
	 ALTER TABLE `t_fault_severity_rule` ADD COLUMN `zone_id` BIGINT(20) DEFAULT 0 AFTER `id`;
	END IF;
	END;	  
//
DELIMITER ;
CALL add_faultRule(); 


DROP PROCEDURE IF EXISTS add_zoneInfo;
DELIMITER //
CREATE PROCEDURE add_zoneInfo() BEGIN
	IF NOT EXISTS(SELECT * FROM information_schema.columns
	       WHERE table_name = 't_atic_zone_info' AND column_name ='industry')
	THEN
	 ALTER TABLE `t_atic_zone_info` ADD COLUMN `industry` VARCHAR(64) COLLATE utf8_bin DEFAULT NULL;
	END IF;
	END;	  
//
DELIMITER ;
CALL add_zoneInfo(); 
UPDATE `t_atic_zone_info` SET industry = 'Other';



