USE `lego`;

DROP PROCEDURE IF EXISTS add_device_nfa;
DELIMITER //
CREATE PROCEDURE add_device_nfa() BEGIN
	IF NOT EXISTS(SELECT * FROM information_schema.columns
	       WHERE table_name = 't_atic_device_nfa' AND column_name ='flowspec_enable' OR column_name='outbound_enable' OR column_name='bgp_router_id' OR column_name='local_address' OR column_name='local_as')
	THEN
	  ALTER TABLE t_atic_device_nfa ADD COLUMN `flowspec_enable` bit(1) DEFAULT false AFTER end_delay;
	  ALTER TABLE t_atic_device_nfa ADD COLUMN `outbound_enable` bit(1) DEFAULT false AFTER flowspec_enable;
	  ALTER TABLE t_atic_device_nfa ADD COLUMN `bgp_router_id` varchar(255) AFTER outbound_enable;
	  ALTER TABLE t_atic_device_nfa ADD COLUMN `local_address` varchar(255) AFTER bgp_router_id;
	  ALTER TABLE t_atic_device_nfa ADD COLUMN `local_as` bigint(1) DEFAULT 0 AFTER local_address;
	END IF;
	END;
//
DELIMITER ;
CALL add_device_nfa();
