USE `lego`;

-- 2018.4.25 lwx554684
/* SCC提供的阈值和时长 */
DROP TABLE IF EXISTS `t_atic_blackhole_np_config`;
CREATE TABLE `t_atic_blackhole_np_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `np_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `time_long` int(11) DEFAULT NULL,
  `black_hole_threshold` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- 2018.4.25 lwx554684
/* 阶梯封堵删除失败存储采集器ip和防护对象ip,用于定时同步删除采集器*/
DROP TABLE IF EXISTS `t_atic_blackhole_np_config_failed`;
CREATE TABLE `t_atic_blackhole_np_config_failed` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `np_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `collector_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- 2018.4.25 lwx554684
ALTER TABLE `t_atic_blackhole` ADD COLUMN `blackhole_type` INT(10) DEFAULT null ;

/*osgi框架整改后一些类的路径改变所引入的升级脚本*/

UPDATE `t_protocol` SET template_type = 'com.huawei.atic.south.model.SnmpPara', discriminator ='com.huawei.atic.south.model.SnmpPara' WHERE template_type = 'com.hs.lego.com.south.sdk.model.SnmpPara';
UPDATE `t_protocol` SET template_type = 'com.huawei.atic.south.model.TelnetPara', discriminator = 'com.huawei.atic.south.model.TelnetPara' WHERE template_type = 'com.hs.lego.com.south.sdk.model.TelnetPara';

UPDATE `t_managedobject` AS t SET t.type = 'com.huawei.atic.resource.model.Node' WHERE t.type = 'com.hs.lego.cbb.resource.sdk.model.Node';
UPDATE `t_managedobject` AS t SET t.type = 'com.huawei.atic.device.model.Collector' WHERE t.type = 'com.hs.atic.res.model.Collector';


DROP PROCEDURE IF EXISTS add_udpflood_direction;
DELIMITER //
CREATE PROCEDURE add_udpflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_udpflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_udpflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_udpflood_direction();

DROP PROCEDURE IF EXISTS add_tcpflood_direction;
DELIMITER //
CREATE PROCEDURE add_tcpflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_tcpflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_tcpflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_tcpflood_direction();

DROP PROCEDURE IF EXISTS add_sipflood_direction;
DELIMITER //
CREATE PROCEDURE add_sipflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_sipflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_sipflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_sipflood_direction();

DROP PROCEDURE IF EXISTS add_otherflood_direction;
DELIMITER //
CREATE PROCEDURE add_otherflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_otherflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_otherflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_otherflood_direction();

DROP PROCEDURE IF EXISTS add_icmpflood_direction;
DELIMITER //
CREATE PROCEDURE add_icmpflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_icmpflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_icmpflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_icmpflood_direction();

DROP PROCEDURE IF EXISTS add_httpsflood_direction;
DELIMITER //
CREATE PROCEDURE add_httpsflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_httpsflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_httpsflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_httpsflood_direction();

DROP PROCEDURE IF EXISTS add_httpflood_direction;
DELIMITER //
CREATE PROCEDURE add_httpflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_httpflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_httpflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_httpflood_direction();

DROP PROCEDURE IF EXISTS add_dnsflood_direction;
DELIMITER //
CREATE PROCEDURE add_dnsflood_direction() BEGIN
	IF EXISTS(SELECT * FROM t_vsm_zone_dnsflood
	       WHERE service_id IS null and direction IS null)
	THEN
	  UPDATE `t_vsm_zone_dnsflood` SET direction = 1 WHERE service_id IS null and direction IS null;
	END IF;
	END;
//
DELIMITER ;
CALL add_dnsflood_direction();

/*syslog server日志解耦开始*/
/* 日志服务器新增字段：转发默认防护对象日志*/
ALTER TABLE t_atic_syslog_server ADD COLUMN `default_zone_syslog` INT(1) UNSIGNED DEFAULT 1 AFTER `server_port`;

/*start procedure to update_syslog_server*/
DELIMITER $$
-- function:计算拆分后字符串的个数函数
DROP FUNCTION IF EXISTS calc_length $$
CREATE FUNCTION calc_length(str VARCHAR(255), splitstr VARCHAR(5)) RETURNS INT(11)
BEGIN 
	RETURN LENGTH(str)-LENGTH(REPLACE(str, splitstr, ''))+1;
END $$

-- function:分割字符，取第x个
DELIMITER $$
DROP FUNCTION IF EXISTS `get_split_string` $$
CREATE FUNCTION `get_split_string`
( f_string VARCHAR(1000),f_delimiter VARCHAR(5),f_order INT)
	RETURNS VARCHAR(255) CHARSET utf8
BEGIN
	DECLARE result VARCHAR(255) DEFAULT ''; 
	SET result = REVERSE(SUBSTRING_INDEX(REVERSE(SUBSTRING_INDEX(f_string,f_delimiter,f_order)),f_delimiter,1));
	RETURN result;
END$$
DELIMITER ;

/* 更新日志服务器信息 */
DROP PROCEDURE IF EXISTS update_syslog_server;
-- 创建存储过程
DELIMITER ;//
CREATE PROCEDURE update_syslog_server()
BEGIN
	-- 数据库所有字段
	DECLARE id INT;
	DECLARE server_ip VARCHAR(255);
	DECLARE server_port INT;
	DECLARE default_zone_syslog INT;
	DECLARE atic_optlog INT;
	DECLARE device_syslog INT;
	DECLARE third_syslog INT;
	DECLARE flow_syslog INT;
	DECLARE flow_syslog_outbound INT;
	DECLARE ip_flow_seconds_syslog INT;
	DECLARE alarm_syslog INT;
	DECLARE alarm_min_level INT;
	DECLARE alarm_abnormity_log INT;
	DECLARE alarm_attack_log INT;
	DECLARE alarm_refresh_log INT;
	DECLARE alarm_detail_log INT;
	DECLARE alarm_abnormity_log_outbound INT;
	DECLARE alarm_attack_log_outbound INT;
	DECLARE alarm_refresh_log_outbound INT;
	DECLARE alarm_detail_log_outbound INT;
	DECLARE transfer_protocol INT;
	
	DECLARE all_count INT DEFAULT 0; 
	DECLARE cnt INT DEFAULT 0; 
	DECLARE i INT DEFAULT 0;
	DECLARE ip VARCHAR(255); 

	-- 遍历数据结束标志 
	DECLARE Adone INT DEFAULT FALSE; 
	/** 声明游标，并将查询结果存到游标中 **/	
	DECLARE cursor_sever CURSOR FOR SELECT syslog.id,syslog.server_ip,syslog.server_port,syslog.default_zone_syslog,syslog.atic_optlog,syslog.device_syslog,syslog.third_syslog,syslog.flow_syslog,syslog.flow_syslog_outbound,syslog.ip_flow_seconds_syslog,syslog.alarm_syslog,syslog.alarm_min_level,syslog.alarm_abnormity_log,syslog.alarm_attack_log,syslog.alarm_refresh_log,syslog.alarm_detail_log,syslog.alarm_abnormity_log_outbound,syslog.alarm_attack_log_outbound,syslog.alarm_refresh_log_outbound,syslog.alarm_detail_log_outbound,syslog.transfer_protocol,COUNT(*) AS all_count FROM t_atic_syslog_server syslog;
	-- 将结束标志绑定到游标 
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET Adone = TRUE; 
	-- 打开游标
	OPEN cursor_sever;
	read_loop: LOOP
		-- 取值 取多个字段
		FETCH cursor_sever INTO id,server_ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol,all_count; 
		IF Adone THEN
			LEAVE read_loop;
		END IF;
		-- 如果日志服务器里有数据，则拆分。
		-- select all_count;
		IF all_count > 0 THEN
		    BEGIN
			SET cnt = calc_length(server_ip,',');
			UPDATE t_atic_syslog_server SET id=0 WHERE id=1;
			WHILE i < cnt
			DO
				SET i = i + 1;
				SET ip = get_split_string(server_ip,',',i);
				INSERT INTO t_atic_syslog_server(id,server_ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol) 
					VALUES(i,ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol);
				-- SELECT * FROM t_atic_syslog_server;
			END WHILE;
		    END; 
		END IF; 
	END LOOP;
	CLOSE cursor_sever;

END;//
DELIMITER ;
-- 调用存储过程
CALL update_syslog_server();
-- 删除原始数据
DELETE FROM t_atic_syslog_server WHERE id=0;

-- 所有数据库更新完成后清除临时数据
DROP PROCEDURE IF EXISTS update_syslog_server;
DROP FUNCTION IF EXISTS calc_length;
DROP FUNCTION IF EXISTS get_split_string;
/*end procedure to update_syslog_server*/

/*syslog server日志解耦结束*/

