USE `lego`;

/*删除首页设备防护能力报表*/
DELETE FROM t_atic_homepage_portal WHERE homepage_entity_id IN (SELECT PKID FROM t_atic_homepage_entity WHERE flow_type = 7);
DELETE FROM t_atic_homepage_entity WHERE flow_type = 7;

/*https 防御策略如果勾选SSL防御，默认勾选重协商次数检查*/
UPDATE t_vsm_zone_httpsflood SET https_nego_check_enable = TRUE WHERE https_ssl_enable IS TRUE AND service_id IS NOT NULL;

UPDATE t_vsm_zone_nfa_policy SET t_vsm_zone_nfa_policy.name = 'Tcp_Malformed_Flood' WHERE  t_vsm_zone_nfa_policy.name = 'Tcp_Abnormal_Flood';

/*新增硬件过滤器*/
DROP PROCEDURE IF EXISTS add_np_filter;
-- 创建存储过程
DELIMITER ;//
CREATE PROCEDURE add_np_filter()
BEGIN
	DECLARE filterIndex INT DEFAULT 22; 
	SET filterIndex = (SELECT MAX(filter_index) FROM t_vsm_np_filter) + 1;
	INSERT INTO `t_vsm_np_filter` (`filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) VALUES('CoAP_Amplification_Attack','UDP',NULL,1,10000,filterIndex);
	
END;//
DELIMITER ;
-- 调用存储过程
CALL add_np_filter();
DROP PROCEDURE IF EXISTS add_np_filter;
INSERT INTO `t_vsm_np_filter_rule` (`filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) VALUES((SELECT pkid FROM t_vsm_np_filter WHERE filter_name = 'CoAP_Amplification_Attack'),NULL,NULL,NULL,5683,256,65535,NULL);

INSERT INTO t_atic_streamonitor_measurename(NAME, description,TYPE) VALUES ('ackPpsRatio', '基于目的IP的出流量/入流量的 ACK pps比例',1);
INSERT INTO `t_atic_streamonitor_ruleconditionrelationship` (`ruleId`, `measureName`, `operator`, `targetValue`, `groupId`, `conditionInGroupId`, `logicOperator`, `type`) VALUES('8','ackPpsRatio','1','50','3','1','0','1');
UPDATE `t_atic_streamonitor_ruleconditionrelationship` SET targetValue = 90 WHERE pkid = 26;

UPDATE t_atic_streamonitor_rule SET RULENAME='ACK False Negative Check',DESCRIPTION='Checks the configuration and application of ACK defense' WHERE PKID='1';
UPDATE t_atic_streamonitor_rule SET RULENAME='SYN False Negative Check',DESCRIPTION='Checks the configuration and application of SYN defense' WHERE PKID='2';
UPDATE t_atic_streamonitor_rule SET RULENAME='TCP False Negative Check',DESCRIPTION='Checks the configuration and application of TCP defense' WHERE PKID='3';
UPDATE t_atic_streamonitor_rule SET RULENAME='HTTP False Negative Check',DESCRIPTION='Checks the configuration and application of HTTP defense' WHERE PKID='4';
UPDATE t_atic_streamonitor_rule SET RULENAME='UDP False Negative Check',DESCRIPTION='Checks the configuration and application of UDP defense' WHERE PKID='5';
UPDATE t_atic_streamonitor_rule SET RULENAME='DNS False Negative Check',DESCRIPTION='Checks the configuration and application of DNS defense' WHERE PKID='6';
UPDATE t_atic_streamonitor_rule SET RULENAME='SYN False Positive Check',DESCRIPTION='Checks the application of SYN defense' WHERE PKID='7';
UPDATE t_atic_streamonitor_rule SET RULENAME='ACK False Positive Check',DESCRIPTION='Checks the application of ACK defense' WHERE PKID='8';
UPDATE t_atic_streamonitor_rule SET RULENAME='TCP NewCurCon False Positive Check',DESCRIPTION='Checks the application of TCP defense' WHERE PKID='9';
UPDATE t_atic_streamonitor_rule SET RULENAME='HTTP False Positive Check',DESCRIPTION='Checks the application of HTTP defense' WHERE PKID='10';
UPDATE t_atic_streamonitor_rule SET RULENAME='UDP False Positive Check',DESCRIPTION='Checks the application of UDP defense' WHERE PKID='11';
UPDATE t_atic_streamonitor_rule SET RULENAME='DNS Request False Positive Check',DESCRIPTION='Checks the application of DNS defense' WHERE PKID='12';


