USE `collector`;

ALTER TABLE `collector`.`atic_zone_flow_sum` 
   ADD COLUMN `IS_ABNORMAL` INT(1) UNSIGNED DEFAULT '0' NOT NULL AFTER `FINRST_PPS`;

ALTER TABLE `collector`.`atic_biz_info` ADD COLUMN `PKID` INT(10) UNSIGNED NOT NULL DEFAULT '0' FIRST;
ALTER TABLE collector.atic_biz_info ADD INDEX KEY_PKID (PKID);
ALTER TABLE collector.atic_biz_info ADD INDEX KEY_DEVICE_IP (DEVICE_IP);
ALTER TABLE collector.atic_biz_info ADD INDEX KEY_ZONE_ID (ZONE_ID);

DROP TABLE IF EXISTS  `ATIC_BASELINE_TASK`;

CREATE TABLE `ATIC_BASELINE_TASK` (
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `START_CYC` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `START_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
   KEY `KEY_ZONE_ID` (`ZONE_ID`) 
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS  `ATIC_BASELINE_DATA`;

CREATE TABLE `ATIC_BASELINE_DATA` (
  `PKID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CPU_SIZE` INT(2) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_PKID` (`PKID`) 
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS  `ATIC_BASELINE_DETAIL`;

CREATE TABLE `ATIC_BASELINE_DETAIL` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
   KEY `KEY_ZONE_ID` (`ZONE_ID`) ,
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`) ,
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`) ,
   KEY `KEY_BIZ_ID` (`BIZ_ID`) 
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS  `ATIC_SERVICE_LEARNING_TASK`;

CREATE TABLE `ATIC_SERVICE_LEARNING_TASK` (
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',  
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',  
  `START_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `END_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;