USE `collector`;
ALTER TABLE `collector`.`atic_static_dns_cache` ADD COLUMN `REQUEST_TYPE` VARCHAR(10)  NOT NULL DEFAULT '' AFTER DNS_NAME;
ALTER TABLE `collector`.`atic_static_dns_cache_h` ADD COLUMN `REQUEST_TYPE` VARCHAR(10)  NOT NULL DEFAULT '' AFTER DNS_NAME;
ALTER TABLE `collector`.`atic_static_dns_cache_d` ADD COLUMN `REQUEST_TYPE` VARCHAR(10)  NOT NULL DEFAULT '' AFTER DNS_NAME;
ALTER TABLE `collector`.`atic_dns_topn` ADD COLUMN `REQUEST_TYPE` VARCHAR(10)  NOT NULL DEFAULT '' AFTER DNS_NAME;
ALTER TABLE `collector`.`atic_dns_topn_h` ADD COLUMN `REQUEST_TYPE` VARCHAR(10)  NOT NULL DEFAULT '' AFTER DNS_NAME;
ALTER TABLE `collector`.`atic_dns_topn_d` ADD COLUMN `REQUEST_TYPE` VARCHAR(10)  NOT NULL DEFAULT '' AFTER DNS_NAME; 
ALTER TABLE `collector`.`atic_attack_log` ADD COLUMN `PPS_OR_KBPS` TINYINT(3)  NOT NULL AFTER LIMIT_VALUE; 
ALTER TABLE `collector`.`atic_ip_attack_exact_log` ADD COLUMN `PPS_OR_KBPS` TINYINT(3)  NOT NULL AFTER LIMIT_VALUE; 
DROP TABLE IF EXISTS `atic_zombie_info`;
CREATE TABLE `atic_zombie_info` (
  `LOG_TIME` INT(10) UNSIGNED DEFAULT NULL COMMENT 'TIME', 
  `DEVICE_IP` INT(10) UNSIGNED DEFAULT NULL,
  `DEVICE_TYPE` INT(1) UNSIGNED DEFAULT NULL,   
  `ZONE_ID` INT(10) UNSIGNED NOT NULL default '0',  
  `BOT_ID` INT(10) UNSIGNED DEFAULT NULL, 
  `BOT_TYPE` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_ROLE` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_TYPE_NUM` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_ROLE_NUM` INT(4) UNSIGNED DEFAULT NULL,
  `DEST_IP` INT(10) UNSIGNED DEFAULT NULL,
  `SRC_IP` INT(10) UNSIGNED DEFAULT NULL,
  `DEST_PORT` INT(10) UNSIGNED DEFAULT NULL,
  `SRC_PORT` INT(10) UNSIGNED DEFAULT NULL,
  `IS_DIRECT` INT(1) UNSIGNED DEFAULT NULL,
  `L4_PROTOCOL` INT(10) UNSIGNED DEFAULT NULL,
  `L7_protocol` INT(10) UNSIGNED DEFAULT NULL,
  `IS_FILTER` INT(1) UNSIGNED DEFAULT NULL,
  `DETECT_TIME` INT(10) UNSIGNED DEFAULT NULL,
  `AGE_TIME` INT(10) UNSIGNED DEFAULT NULL,
  `PASS_PACKETS` INT(10) UNSIGNED DEFAULT NULL,
  `FILTER_PACKETS` INT(10) UNSIGNED DEFAULT NULL,
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_BOT_TYPE` (`BOT_TYPE`),
   KEY `KEY_DEST_IP` (`DEST_IP`),
   KEY `KEY_SRC_IP` (`SRC_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zombie_info_h`;

CREATE TABLE `atic_zombie_info_h` (
  `LOG_TIME` INT(10) UNSIGNED DEFAULT NULL COMMENT 'TIME', 
  `DEVICE_IP` INT(10) UNSIGNED DEFAULT NULL,
  `DEVICE_TYPE` INT(1) UNSIGNED DEFAULT NULL,   
  `ZONE_ID` INT(10) UNSIGNED NOT NULL default '0',   
  `BOT_ID` INT(10) UNSIGNED DEFAULT NULL, 
  `BOT_TYPE` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_ROLE` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_TYPE_NUM` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_ROLE_NUM` INT(4) UNSIGNED DEFAULT NULL,
  `DEST_IP` INT(10) UNSIGNED DEFAULT NULL,
  `SRC_IP` INT(10) UNSIGNED DEFAULT NULL,
  `DEST_PORT` INT(10) UNSIGNED DEFAULT NULL,
  `SRC_PORT` INT(10) UNSIGNED DEFAULT NULL,
  `IS_DIRECT` INT(1) UNSIGNED DEFAULT NULL,
  `L4_PROTOCOL` INT(10) UNSIGNED DEFAULT NULL,
  `L7_protocol` INT(10) UNSIGNED DEFAULT NULL,
  `IS_FILTER` INT(1) UNSIGNED DEFAULT NULL,
  `DETECT_TIME` INT(10) UNSIGNED DEFAULT NULL,
  `AGE_TIME` INT(10) UNSIGNED DEFAULT NULL,
  `PASS_PACKETS` INT(10) UNSIGNED DEFAULT NULL,
  `FILTER_PACKETS` INT(10) UNSIGNED DEFAULT NULL,
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_BOT_TYPE` (`BOT_TYPE`),
   KEY `KEY_DEST_IP` (`DEST_IP`),
   KEY `KEY_SRC_IP` (`SRC_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `atic_zombie_info_d`;

CREATE TABLE `atic_zombie_info_d` (
  `LOG_TIME` INT(10) UNSIGNED DEFAULT NULL COMMENT 'TIME', 
  `DEVICE_IP` INT(10) UNSIGNED DEFAULT NULL,
  `DEVICE_TYPE` INT(1) UNSIGNED DEFAULT NULL,    
  `ZONE_ID` INT(10) UNSIGNED NOT NULL default '0',   
  `BOT_ID` INT(10) UNSIGNED DEFAULT NULL, 
  `BOT_TYPE` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_ROLE` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_TYPE_NUM` INT(4) UNSIGNED DEFAULT NULL,
  `BOT_ROLE_NUM` INT(4) UNSIGNED DEFAULT NULL,
  `DEST_IP` INT(10) UNSIGNED DEFAULT NULL,
  `SRC_IP` INT(10) UNSIGNED DEFAULT NULL,
  `DEST_PORT` INT(10) UNSIGNED DEFAULT NULL,
  `SRC_PORT` INT(10) UNSIGNED DEFAULT NULL,
  `IS_DIRECT` INT(1) UNSIGNED DEFAULT NULL,
  `L4_PROTOCOL` INT(10) UNSIGNED DEFAULT NULL,
  `L7_protocol` INT(10) UNSIGNED DEFAULT NULL,
  `IS_FILTER` INT(1) UNSIGNED DEFAULT NULL,
  `DETECT_TIME` INT(10) UNSIGNED DEFAULT NULL,
  `AGE_TIME` INT(10) UNSIGNED DEFAULT NULL,
  `PASS_PACKETS` INT(10) UNSIGNED DEFAULT NULL,
  `FILTER_PACKETS` INT(10) UNSIGNED DEFAULT NULL,
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_BOT_TYPE` (`BOT_TYPE`),
   KEY `KEY_DEST_IP` (`DEST_IP`),
   KEY `KEY_SRC_IP` (`SRC_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_dns_defend`;

CREATE TABLE `atic_dns_defend` (
  `LOG_TIME` INT(10) UNSIGNED DEFAULT NULL, 
  `DEVICE_IP` int(10) UNSIGNED DEFAULT NULL,
  `DEVICE_TYPE` int(1) UNSIGNED DEFAULT NULL, 
  `DNS_NAME` VARCHAR(256) DEFAULT NULL,
  `SRC_IP` VARCHAR(500) DEFAULT NULL,
  `REQUEST_TIME` INT(10) UNSIGNED DEFAULT NULL,
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_dns_defend_h`;

CREATE TABLE `atic_dns_defend_h` (
  `LOG_TIME` INT(10) UNSIGNED DEFAULT NULL, 
  `DEVICE_IP` int(10) UNSIGNED DEFAULT NULL,
  `DEVICE_TYPE` int(1) UNSIGNED DEFAULT NULL, 
  `DNS_NAME` VARCHAR(256) DEFAULT NULL,
  `REQUEST_TIME` INT(10) UNSIGNED DEFAULT NULL,
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `atic_dns_defend_d`;

CREATE TABLE `atic_dns_defend_d` (
  `LOG_TIME` INT(10) UNSIGNED DEFAULT NULL, 
  `DEVICE_IP` int(10) UNSIGNED DEFAULT NULL,
  `DEVICE_TYPE` int(1) UNSIGNED DEFAULT NULL, 
  `DNS_NAME` VARCHAR(256) DEFAULT NULL,
  `REQUEST_TIME` INT(10) UNSIGNED DEFAULT NULL,
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;


/*IP_BIZ_OTHER*/

/*ATIC_IP_BIZ_OTHER*/

DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER`;
CREATE TABLE `ATIC_IP_BIZ_OTHER` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_IP_BIZ_OTHER_H*/

DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_H`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/*ATIC_IP_BIZ_OTHER_D*/

DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_D`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_BIZ_ID` (`BIZ_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_IP_BIZ_OTHER_MAX_H*/
DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_MAX_H`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_MAX_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/*ATIC_IP_BIZ_OTHER_MAX_D*/
DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_MAX_D`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_MAX_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/*ATIC_IP_BIZ_OTHER_DROP*/
DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_DROP`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_DROP` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_IP_BIZ_OTHER_DROP_H*/
DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_DROP_H`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_DROP_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT  NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/*ATIC_IP_BIZ_OTHER_DROP_D*/

DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_DROP_D`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_DROP_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_IP_BIZ_OTHER_DROP_MAX_H*/
DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_DROP_MAX_H`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_DROP_MAX_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_IP_BIZ_OTHER_DROP_MAX_D*/
DROP TABLE IF EXISTS `ATIC_IP_BIZ_OTHER_DROP_MAX_D`;
CREATE TABLE `ATIC_IP_BIZ_OTHER_DROP_MAX_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `ZONE_IP` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`),
   KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER*/

DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_H*/

DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_H`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_D*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_D`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_MAX_H*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_MAX_H`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_MAX_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_MAX_D*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_MAX_D`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_MAX_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/*ATIC_ZONE_BIZ_OTHER_DROP*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_DROP`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_DROP` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_DROP_H*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_DROP_H`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_DROP_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_DROP_D*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_DROP_D`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_DROP_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_DROP_MAX_H*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_DROP_MAX_H`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_DROP_MAX_H` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*ATIC_ZONE_BIZ_OTHER_DROP_MAX_D*/
DROP TABLE IF EXISTS `ATIC_ZONE_BIZ_OTHER_DROP_MAX_D`;
CREATE TABLE `ATIC_ZONE_BIZ_OTHER_DROP_MAX_D` (
  `LOG_TIME` int(10) unsigned NOT NULL default '0',
  `DEVICE_IP` int(10) unsigned NOT NULL default '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL default '0',
  `ZONE_ID` int(10) unsigned NOT NULL default '0',
  `BIZ_ID` int(10) unsigned NOT NULL default '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL default '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL default '0',
   KEY `KEY_LOG_TIME` (`LOG_TIME`),
   KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
   KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
   KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


ALTER TABLE `ATIC_IP_IN` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_IP_BIZ_TCP` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_IP_BIZ_UDP` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_IP_BIZ_TCP_DNS` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_IP_BIZ_HTTP` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_IP_BIZ_HTTPS` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_IP_BIZ_SIP` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_IP_BIZ_UDP_DNS` DROP COLUMN `IS_ABNORMAL`;
ALTER TABLE `ATIC_ZONE_FLOW_SUM` DROP COLUMN `IS_ABNORMAL`;

DROP TABLE IF EXISTS `atic_ip_in_max`;
CREATE TABLE `atic_ip_in_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0', 
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `atic_ip_drop_max`;
CREATE TABLE `atic_ip_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0', 
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `atic_zone_in_max`;
CREATE TABLE `atic_zone_in_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0', 
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `atic_zone_drop_max`;
CREATE TABLE `atic_zone_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0', 
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `atic_biz_flow_sum_drop_max`;
CREATE TABLE `atic_biz_flow_sum_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_biz_flow_sum_max`;
CREATE TABLE `atic_biz_flow_sum_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_dev_flow_sum_drop_max`;
CREATE TABLE `atic_dev_flow_sum_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_dev_flow_sum_max`;
CREATE TABLE `atic_dev_flow_sum_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_http_drop_max`;
CREATE TABLE `atic_ip_biz_http_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `GET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `POST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HOST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_http_max`;
CREATE TABLE `atic_ip_biz_http_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `GET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `POST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HOST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_https_drop_max`;
CREATE TABLE `atic_ip_biz_https_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HELLO_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_https_max`;
CREATE TABLE `atic_ip_biz_https_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HELLO_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_other_drop_max`;
CREATE TABLE `atic_ip_biz_other_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_other_max`;
CREATE TABLE `atic_ip_biz_other_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_sip_drop_max`;
CREATE TABLE `atic_ip_biz_sip_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `ZONE_IP` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_INVITE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_sip_max`;
CREATE TABLE `atic_ip_biz_sip_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `ZONE_IP` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_INVITE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_drop_max`;
CREATE TABLE `atic_ip_biz_tcp_dns_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_max`;
CREATE TABLE `atic_ip_biz_tcp_dns_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_tcp_drop_max`;
CREATE TABLE `atic_ip_biz_tcp_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_tcp_max`;
CREATE TABLE `atic_ip_biz_tcp_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_drop_max`;
CREATE TABLE `atic_ip_biz_udp_dns_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `ZONE_IP` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SERVER_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `A_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `PTR_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `NS_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `MX_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TXT_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `CNNAME_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SOA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `AAAAA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `OTHER_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `FRAG_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `LARGE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `ILEGAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TTL_DENIED_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_max`;
CREATE TABLE `atic_ip_biz_udp_dns_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `ZONE_IP` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SERVER_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `A_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `PTR_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `NS_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `MX_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TXT_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `CNNAME_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SOA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `AAAAA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `OTHER_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `FRAG_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `LARGE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `ILEGAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TTL_DENIED_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_udp_drop_max`;
CREATE TABLE `atic_ip_biz_udp_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_biz_udp_max`;
CREATE TABLE `atic_ip_biz_udp_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_flow_sum_drop_max`;
CREATE TABLE `atic_ip_flow_sum_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_ip_flow_sum_max`;
CREATE TABLE `atic_ip_flow_sum_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_slot_flow_sum_drop_max`;
CREATE TABLE `atic_slot_flow_sum_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SLOT_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_SLOT_ID` (`SLOT_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_slot_flow_sum_max`;
CREATE TABLE `atic_slot_flow_sum_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SLOT_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_SLOT_ID` (`SLOT_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_http_drop_max`;
CREATE TABLE `atic_zone_biz_http_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `GET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `POST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HOST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_http_max`;
CREATE TABLE `atic_zone_biz_http_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `GET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `POST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HOST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_https_drop_max`;
CREATE TABLE `atic_zone_biz_https_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HELLO_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_https_max`;
CREATE TABLE `atic_zone_biz_https_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HELLO_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_other_drop_max`;
CREATE TABLE `atic_zone_biz_other_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_other_max`;
CREATE TABLE `atic_zone_biz_other_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_sip_drop_max`;
CREATE TABLE `atic_zone_biz_sip_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_INVITE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_sip_max`;
CREATE TABLE `atic_zone_biz_sip_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_INVITE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SIP_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_drop_max`;
CREATE TABLE `atic_zone_biz_tcp_dns_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_max`;
CREATE TABLE `atic_zone_biz_tcp_dns_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_tcp_drop_max`;
CREATE TABLE `atic_zone_biz_tcp_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_tcp_max`;
CREATE TABLE `atic_zone_biz_tcp_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_drop_max`;
CREATE TABLE `atic_zone_biz_udp_dns_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SERVER_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `A_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `PTR_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `NS_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `MX_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TXT_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `CNNAME_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SOA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `AAAAA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `OTHER_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `FRAG_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `LARGE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `ILEGAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TTL_DENIED_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_max`;
CREATE TABLE `atic_zone_biz_udp_dns_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL,
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL,
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL,
  `ZONE_ID` INT(10) UNSIGNED NOT NULL,
  `BIZ_ID` INT(10) UNSIGNED NOT NULL,
  `TOTAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TOTAL_KBPS` INT(10) UNSIGNED DEFAULT NULL,
  `INCREASE_CON` INT(10) UNSIGNED DEFAULT NULL,
  `CUR_CON` INT(10) UNSIGNED DEFAULT NULL,
  `REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SERVER_REPLY_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `A_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `PTR_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `NS_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `MX_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TXT_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `CNNAME_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `SOA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `AAAAA_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `OTHER_REQUEST_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `FRAG_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `LARGE_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `ILEGAL_PPS` INT(10) UNSIGNED DEFAULT NULL,
  `TTL_DENIED_PPS` INT(10) UNSIGNED DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_udp_drop_max`;
CREATE TABLE `atic_zone_biz_udp_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_biz_udp_max`;
CREATE TABLE `atic_zone_biz_udp_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BIZ_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEVICE_IP` (`DEVICE_IP`),
  KEY `KEY_DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_flow_sum_drop_max`;
CREATE TABLE `atic_zone_flow_sum_drop_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `atic_zone_flow_sum_max`;
CREATE TABLE `atic_zone_flow_sum_max` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTP_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `HTTPS_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYN_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `SYNACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ACK_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `FINRST_PPS` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_DEV_IP` (`DEVICE_IP`),
  KEY `KEY_DEV_TYPE` (`DEVICE_TYPE`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

ALTER TABLE `atic_zone_blacklist` ADD COLUMN `ZONE_IP` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER `BIZ_ID`;
ALTER TABLE `atic_zone_blacklist` ADD COLUMN `START_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER `ZONE_IP`;

UPDATE `atic_ip_attack_exact_Log` SET current_value = 0,limit_value = 0;
UPDATE `atic_attack_log` SET current_value = 0,limit_value = 0;