/*use when UPDATE B053 TO B055*/
USE `collector`;
ALTER TABLE `COLLECTOR`.`ATIC_BIZ_INFO` ADD COLUMN `SUM_SIZE` INT(10) UNSIGNED NOT NULL DEFAULT '1';

#ATIC_PARTITION_RULE
DROP TABLE IF EXISTS `ATIC_PARTITION_RULE`;

CREATE TABLE `ATIC_PARTITION_RULE` (
  `RULE_ID` int(2) NOT NULL AUTO_INCREMENT,
  `PARTITION_TIME` int(2) NOT NULL DEFAULT '1',
  `PARTITION_UNIT` ENUM('D','M') NOT NULL DEFAULT 'M',
  `PARTITION_HOLD_TIME` int(2) NOT NULL DEFAULT '12',
  `PARTITION_HOLD_UNIT` ENUM('D','M') NOT NULL DEFAULT 'M',
  `TABLES` varchar(8000) DEFAULT NULL,
  `PARTITION_EXPRESSION` varchar(200) NOT NULL DEFAULT 'LOG_TIME',
  `H0LD_TYPE` ENUM('D','M','Y')  NOT NULL DEFAULT 'M' COMMENT 'for matching atic,when atic changed hold time,collector changged by this field. D is original table ,M is hour table,Y is day table.',
  `REFRESH_MARK` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`RULE_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


INSERT  INTO `ATIC_PARTITION_RULE`(`RULE_ID`,`PARTITION_TIME`,`PARTITION_UNIT`,`PARTITION_HOLD_TIME`,`PARTITION_HOLD_UNIT`,`TABLES`,`PARTITION_EXPRESSION`,`H0LD_TYPE`,`REFRESH_MARK`) 
VALUES 
(1,1,'D',90,'D','ATIC_IP_IN,ATIC_IP_IN_MAX,ATIC_IP_DROP,ATIC_IP_DROP_MAX,ATIC_ZONE_IN,ATIC_ZONE_IN_MAX,ATIC_ZONE_DROP,ATIC_ZONE_DROP_MAX,ATIC_IP_BIZ_TCP,ATIC_IP_BIZ_TCP_MAX,ATIC_IP_BIZ_TCP_DROP,ATIC_IP_BIZ_TCP_DROP_MAX,ATIC_ZONE_BIZ_TCP,ATIC_ZONE_BIZ_TCP_MAX,ATIC_ZONE_BIZ_TCP_DROP,ATIC_ZONE_BIZ_TCP_DROP_MAX,ATIC_IP_BIZ_UDP,ATIC_IP_BIZ_UDP_MAX,ATIC_IP_BIZ_UDP_DROP,ATIC_IP_BIZ_UDP_DROP_MAX,ATIC_ZONE_BIZ_UDP,ATIC_ZONE_BIZ_UDP_MAX,ATIC_ZONE_BIZ_UDP_DROP,ATIC_ZONE_BIZ_UDP_DROP_MAX,ATIC_IP_BIZ_HTTP,ATIC_IP_BIZ_HTTP_MAX,ATIC_IP_BIZ_HTTP_DROP,ATIC_IP_BIZ_HTTP_DROP_MAX,ATIC_ZONE_BIZ_HTTP,ATIC_ZONE_BIZ_HTTP_MAX,ATIC_ZONE_BIZ_HTTP_DROP,ATIC_ZONE_BIZ_HTTP_DROP_MAX,ATIC_IP_BIZ_HTTPS,ATIC_IP_BIZ_HTTPS_MAX,ATIC_IP_BIZ_HTTPS_DROP,ATIC_IP_BIZ_HTTPS_DROP_MAX,ATIC_ZONE_BIZ_HTTPS,ATIC_ZONE_BIZ_HTTPS_MAX,ATIC_ZONE_BIZ_HTTPS_DROP,ATIC_ZONE_BIZ_HTTPS_DROP_MAX,ATIC_IP_BIZ_TCP_DNS,ATIC_IP_BIZ_TCP_DNS_MAX,ATIC_IP_BIZ_TCP_DNS_DROP,ATIC_IP_BIZ_TCP_DNS_DROP_MAX,ATIC_ZONE_BIZ_TCP_DNS,ATIC_ZONE_BIZ_TCP_DNS_MAX,ATIC_ZONE_BIZ_TCP_DNS_DROP,ATIC_ZONE_BIZ_TCP_DNS_DROP_MAX,ATIC_IP_BIZ_UDP_DNS,ATIC_IP_BIZ_UDP_DNS_MAX,ATIC_IP_BIZ_UDP_DNS_DROP,ATIC_IP_BIZ_UDP_DNS_DROP_MAX,ATIC_ZONE_BIZ_UDP_DNS,ATIC_ZONE_BIZ_UDP_DNS_MAX,ATIC_ZONE_BIZ_UDP_DNS_DROP,ATIC_ZONE_BIZ_UDP_DNS_DROP_MAX,ATIC_IP_BIZ_SIP,ATIC_IP_BIZ_SIP_MAX,ATIC_IP_BIZ_SIP_DROP,ATIC_IP_BIZ_SIP_DROP_MAX,ATIC_ZONE_BIZ_SIP,ATIC_ZONE_BIZ_SIP_MAX,ATIC_ZONE_BIZ_SIP_DROP,ATIC_ZONE_BIZ_SIP_DROP_MAX,ATIC_IP_BIZ_OTHER,ATIC_IP_BIZ_OTHER_MAX,ATIC_IP_BIZ_OTHER_DROP,ATIC_IP_BIZ_OTHER_DROP_MAX,ATIC_ZONE_BIZ_OTHER,ATIC_ZONE_BIZ_OTHER_MAX,ATIC_ZONE_BIZ_OTHER_DROP,ATIC_ZONE_BIZ_OTHER_DROP_MAX,ATIC_IP_FLOW_SUM,ATIC_IP_FLOW_SUM_MAX,ATIC_IP_FLOW_SUM_DROP,ATIC_IP_FLOW_SUM_DROP_MAX,ATIC_ZONE_FLOW_SUM,ATIC_ZONE_FLOW_SUM_MAX,ATIC_ZONE_FLOW_SUM_DROP,ATIC_ZONE_FLOW_SUM_DROP_MAX,ATIC_BIZ_FLOW_SUM,ATIC_BIZ_FLOW_SUM_MAX,ATIC_BIZ_FLOW_SUM_DROP,ATIC_BIZ_FLOW_SUM_DROP_MAX,ATIC_SRC_DNS_TOPN,ATIC_DNS_TOPN,ATIC_STATIC_DNS_CACHE,ATIC_DEV_FLOW_SUM,ATIC_DEV_FLOW_SUM_DROP,ATIC_DEV_FLOW_SUM_DROP_MAX,ATIC_DEV_FLOW_SUM_MAX,ATIC_SLOT_FLOW_SUM,ATIC_SLOT_FLOW_SUM_DROP,ATIC_IP_ATTACK_FLOW,ATIC_ZONE_ATTACK_FLOW,ATIC_IP_USERDEF_DNS_TYPE,ATIC_ZONE_USERDEF_DNS_TYPE,ATIC_DNS_DEFEND,ATIC_ZOMBIE_INFO','LOG_TIME','D',0),
(2,1,'M',12,'M','ATIC_ZONE_IN_H,ATIC_ZONE_DROP_H,ATIC_IP_BIZ_TCP_H,ATIC_IP_BIZ_TCP_MAX_H,ATIC_IP_BIZ_TCP_DROP_H,ATIC_IP_BIZ_TCP_DROP_MAX_H,ATIC_ZONE_BIZ_TCP_H,ATIC_ZONE_BIZ_TCP_MAX_H,ATIC_ZONE_BIZ_TCP_DROP_H,ATIC_ZONE_BIZ_TCP_DROP_MAX_H,ATIC_IP_BIZ_UDP_H,ATIC_IP_BIZ_UDP_MAX_H,ATIC_IP_BIZ_UDP_DROP_H,ATIC_IP_BIZ_UDP_DROP_MAX_H,ATIC_ZONE_BIZ_UDP_H,ATIC_ZONE_BIZ_UDP_MAX_H,ATIC_ZONE_BIZ_UDP_DROP_H,ATIC_ZONE_BIZ_UDP_DROP_MAX_H,ATIC_IP_BIZ_HTTP_H,ATIC_IP_BIZ_HTTP_MAX_H,ATIC_IP_BIZ_HTTP_DROP_H,ATIC_IP_BIZ_HTTP_DROP_MAX_H,ATIC_ZONE_BIZ_HTTP_H,ATIC_ZONE_BIZ_HTTP_MAX_H,ATIC_ZONE_BIZ_HTTP_DROP_H,ATIC_ZONE_BIZ_HTTP_DROP_MAX_H,ATIC_IP_BIZ_HTTPS_H,ATIC_IP_BIZ_HTTPS_MAX_H,ATIC_IP_BIZ_HTTPS_DROP_H,ATIC_IP_BIZ_HTTPS_DROP_MAX_H,ATIC_ZONE_BIZ_HTTPS_H,ATIC_ZONE_BIZ_HTTPS_MAX_H,ATIC_ZONE_BIZ_HTTPS_DROP_H,ATIC_ZONE_BIZ_HTTPS_DROP_MAX_H,ATIC_IP_BIZ_TCP_DNS_H,ATIC_IP_BIZ_TCP_DNS_MAX_H,ATIC_IP_BIZ_TCP_DNS_DROP_H,ATIC_IP_BIZ_TCP_DNS_DROP_MAX_H,ATIC_ZONE_BIZ_TCP_DNS_H,ATIC_ZONE_BIZ_TCP_DNS_MAX_H,ATIC_ZONE_BIZ_TCP_DNS_DROP_H,ATIC_ZONE_BIZ_TCP_DNS_DROP_MAX_H,ATIC_IP_BIZ_UDP_DNS_H,ATIC_IP_BIZ_UDP_DNS_MAX_H,ATIC_IP_BIZ_UDP_DNS_DROP_H,ATIC_IP_BIZ_UDP_DNS_DROP_MAX_H,ATIC_ZONE_BIZ_UDP_DNS_H,ATIC_ZONE_BIZ_UDP_DNS_MAX_H,ATIC_ZONE_BIZ_UDP_DNS_DROP_H,ATIC_ZONE_BIZ_UDP_DNS_DROP_MAX_H,ATIC_IP_BIZ_SIP_H,ATIC_IP_BIZ_SIP_MAX_H,ATIC_IP_BIZ_SIP_DROP_H,ATIC_IP_BIZ_SIP_DROP_MAX_H,ATIC_ZONE_BIZ_SIP_H,ATIC_ZONE_BIZ_SIP_MAX_H,ATIC_ZONE_BIZ_SIP_DROP_H,ATIC_ZONE_BIZ_SIP_DROP_MAX_H,ATIC_IP_BIZ_OTHER_H,ATIC_IP_BIZ_OTHER_MAX_H,ATIC_IP_BIZ_OTHER_DROP_H,ATIC_IP_BIZ_OTHER_DROP_MAX_H,ATIC_ZONE_BIZ_OTHER_H,ATIC_ZONE_BIZ_OTHER_MAX_H,ATIC_ZONE_BIZ_OTHER_DROP_H,ATIC_ZONE_BIZ_OTHER_DROP_MAX_H,ATIC_ZONE_FLOW_SUM_H,ATIC_ZONE_FLOW_SUM_MAX_H,ATIC_ZONE_FLOW_SUM_DROP_H,ATIC_ZONE_FLOW_SUM_DROP_MAX_H,ATIC_BIZ_FLOW_SUM_H,ATIC_BIZ_FLOW_SUM_MAX_H,ATIC_BIZ_FLOW_SUM_DROP_H,ATIC_BIZ_FLOW_SUM_DROP_MAX_H,ATIC_SRC_DNS_TOPN_H,ATIC_DNS_TOPN_H,ATIC_STATIC_DNS_CACHE_H,ATIC_DEV_FLOW_SUM_H,ATIC_DEV_FLOW_SUM_DROP_H,ATIC_DEV_FLOW_SUM_DROP_MAX_H,ATIC_DEV_FLOW_SUM_MAX_H,ATIC_SLOT_FLOW_SUM_H,ATIC_SLOT_FLOW_SUM_DROP_H,ATIC_SLOT_FLOW_SUM_DROP_MAX_H,ATIC_SLOT_FLOW_SUM_MAX_H,ATIC_IP_ATTACK_FLOW_H,ATIC_ZONE_ATTACK_FLOW_H,ATIC_IP_USERDEF_DNS_TYPE_H,ATIC_ZONE_USERDEF_DNS_TYPE_H,ATIC_DNS_DEFEND_H,ATIC_ZOMBIE_INFO_H','LOG_TIME','M',0),
(3,6,'M',12,'M','ATIC_IP_IN_D,ATIC_IP_DROP_D,ATIC_ZONE_IN_D,ATIC_ZONE_DROP_D,ATIC_IP_BIZ_TCP_D,ATIC_IP_BIZ_TCP_MAX_D,ATIC_IP_BIZ_TCP_DROP_D,ATIC_IP_BIZ_TCP_DROP_MAX_D,ATIC_ZONE_BIZ_TCP_D,ATIC_ZONE_BIZ_TCP_MAX_D,ATIC_ZONE_BIZ_TCP_DROP_D,ATIC_ZONE_BIZ_TCP_DROP_MAX_D,ATIC_IP_BIZ_UDP_D,ATIC_IP_BIZ_UDP_MAX_D,ATIC_IP_BIZ_UDP_DROP_D,ATIC_IP_BIZ_UDP_DROP_MAX_D,ATIC_ZONE_BIZ_UDP_D,ATIC_ZONE_BIZ_UDP_MAX_D,ATIC_ZONE_BIZ_UDP_DROP_D,ATIC_ZONE_BIZ_UDP_DROP_MAX_D,ATIC_IP_BIZ_HTTP_D,ATIC_IP_BIZ_HTTP_MAX_D,ATIC_IP_BIZ_HTTP_DROP_D,ATIC_IP_BIZ_HTTP_DROP_MAX_D,ATIC_ZONE_BIZ_HTTP_D,ATIC_ZONE_BIZ_HTTP_MAX_D,ATIC_ZONE_BIZ_HTTP_DROP_D,ATIC_ZONE_BIZ_HTTP_DROP_MAX_D,ATIC_IP_BIZ_HTTPS_D,ATIC_IP_BIZ_HTTPS_MAX_D,ATIC_IP_BIZ_HTTPS_DROP_D,ATIC_IP_BIZ_HTTPS_DROP_MAX_D,ATIC_ZONE_BIZ_HTTPS_D,ATIC_ZONE_BIZ_HTTPS_MAX_D,ATIC_ZONE_BIZ_HTTPS_DROP_D,ATIC_ZONE_BIZ_HTTPS_DROP_MAX_D,ATIC_IP_BIZ_TCP_DNS_D,ATIC_IP_BIZ_TCP_DNS_MAX_D,ATIC_IP_BIZ_TCP_DNS_DROP_D,ATIC_IP_BIZ_TCP_DNS_DROP_MAX_D,ATIC_ZONE_BIZ_TCP_DNS_D,ATIC_ZONE_BIZ_TCP_DNS_MAX_D,ATIC_ZONE_BIZ_TCP_DNS_DROP_D,ATIC_ZONE_BIZ_TCP_DNS_DROP_MAX_D,ATIC_IP_BIZ_UDP_DNS_D,ATIC_IP_BIZ_UDP_DNS_MAX_D,ATIC_IP_BIZ_UDP_DNS_DROP_D,ATIC_IP_BIZ_UDP_DNS_DROP_MAX_D,ATIC_ZONE_BIZ_UDP_DNS_D,ATIC_ZONE_BIZ_UDP_DNS_MAX_D,ATIC_ZONE_BIZ_UDP_DNS_DROP_D,ATIC_ZONE_BIZ_UDP_DNS_DROP_MAX_D,ATIC_IP_BIZ_SIP_D,ATIC_IP_BIZ_SIP_MAX_D,ATIC_IP_BIZ_SIP_DROP_D,ATIC_IP_BIZ_SIP_DROP_MAX_D,ATIC_ZONE_BIZ_SIP_D,ATIC_ZONE_BIZ_SIP_MAX_D,ATIC_ZONE_BIZ_SIP_DROP_D,ATIC_ZONE_BIZ_SIP_DROP_MAX_D,ATIC_IP_BIZ_OTHER_D,ATIC_IP_BIZ_OTHER_MAX_D,ATIC_IP_BIZ_OTHER_DROP_D,ATIC_IP_BIZ_OTHER_DROP_MAX_D,ATIC_ZONE_BIZ_OTHER_D,ATIC_ZONE_BIZ_OTHER_MAX_D,ATIC_ZONE_BIZ_OTHER_DROP_D,ATIC_ZONE_BIZ_OTHER_DROP_MAX_D,ATIC_IP_FLOW_SUM_D,ATIC_IP_FLOW_SUM_MAX_D,ATIC_IP_FLOW_SUM_DROP_D,ATIC_IP_FLOW_SUM_DROP_MAX_D,ATIC_ZONE_FLOW_SUM_D,ATIC_ZONE_FLOW_SUM_MAX_D,ATIC_ZONE_FLOW_SUM_DROP_D,ATIC_ZONE_FLOW_SUM_DROP_MAX_D,ATIC_BIZ_FLOW_SUM_D,ATIC_BIZ_FLOW_SUM_MAX_D,ATIC_BIZ_FLOW_SUM_DROP_D,ATIC_BIZ_FLOW_SUM_DROP_MAX_D,ATIC_SRC_DNS_TOPN_D,ATIC_DNS_TOPN_D,ATIC_STATIC_DNS_CACHE_D,ATIC_DEV_FLOW_SUM_D,ATIC_DEV_FLOW_SUM_DROP_D,ATIC_DEV_FLOW_SUM_DROP_MAX_D,ATIC_DEV_FLOW_SUM_MAX_D,ATIC_SLOT_FLOW_SUM_D,ATIC_SLOT_FLOW_SUM_DROP_D,ATIC_SLOT_FLOW_SUM_DROP_MAX_D,ATIC_SLOT_FLOW_SUM_MAX_D,ATIC_IP_ATTACK_FLOW_D,ATIC_ZONE_ATTACK_FLOW_D,ATIC_IP_USERDEF_DNS_TYPE_D,ATIC_ZONE_USERDEF_DNS_TYPE_D,ATIC_DNS_DEFEND_D,ATIC_ZOMBIE_INFO_D','LOG_TIME','Y',0),
(4,1,'M',12,'M','ATIC_IP_ATTACK_EXACT_lOG,ATIC_IP_ATTACK_LOG','START_TIME_ALERT','M',0),
(5,7,'D',12,'M','ATIC_IP_FLOW_SUM_H,ATIC_IP_FLOW_SUM_DROP_H,ATIC_IP_IN_H,ATIC_IP_DROP_H,ATIC_IP_FLOW_SUM_MAX_H,ATIC_IP_FLOW_SUM_DROP_MAX_H','LOG_TIME','M',1);

UPDATE ATIC_PARTITION_RULE SET PARTITION_HOLD_TIME = (SELECT PARTITION_HOLD_MUL_VAR FROM  ATIC_PARTITION_CONF WHERE TABLE_TYPE = 'original_table' ) , PARTITION_HOLD_UNIT =  (SELECT PARTITION_SEP_UNIT FROM  ATIC_PARTITION_CONF WHERE TABLE_TYPE = 'original_table' )  WHERE H0LD_TYPE = 'D';

UPDATE ATIC_PARTITION_RULE SET PARTITION_HOLD_TIME = (SELECT PARTITION_HOLD_MUL_VAR FROM  ATIC_PARTITION_CONF WHERE TABLE_TYPE = 'day_table' ) , PARTITION_HOLD_UNIT =  (SELECT PARTITION_SEP_UNIT FROM  ATIC_PARTITION_CONF WHERE TABLE_TYPE = 'day_table' )  WHERE H0LD_TYPE = 'Y';

UPDATE ATIC_PARTITION_RULE SET PARTITION_HOLD_TIME = (SELECT PARTITION_HOLD_MUL_VAR FROM  ATIC_PARTITION_CONF WHERE TABLE_TYPE = 'hour_table' ) , PARTITION_HOLD_UNIT =  (SELECT PARTITION_SEP_UNIT FROM  ATIC_PARTITION_CONF WHERE TABLE_TYPE = 'hour_table' )  WHERE H0LD_TYPE = 'M';

DROP TABLE IF EXISTS `ATIC_PARTITION_CONF`;