/*use when UPDATE V5R1C20 TO V5R1C30B001*/
USE `COLLECTOR`;

CREATE TABLE IF NOT EXISTS `ATIC_MIN_SUM_IP_FLOW` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `TOTAL_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ATIC_MIN_SUM_ZONE_FLOW` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ZONE_ID` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ATIC_MIN_SUM_DEV_FLOW` (
  `LOG_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `DEVICE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP_MAX` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;


/*use when UPDATE V5R1CC30B003 TO V5R1C30B005*/

CREATE TABLE IF NOT EXISTS `ATIC_BASELINE_NFA_DATA` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',  
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',  
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0', 
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',  
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0', 
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_PKID` (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `ATIC_BASELINE_NFA_DETAIL` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',  
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',  
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0', 
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',  
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0', 
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


/*use when UPDATE V5R1CC30B001 TO V5R1C30B012*/

ALTER TABLE ATIC_PARTITION_RULE MODIFY PARTITION_UNIT ENUM('D','M','H') NOT NULL DEFAULT 'M';

DROP PROCEDURE IF EXISTS add_partition_rule;
DELIMITER //
CREATE PROCEDURE add_partition_rule()
BEGIN
    IF NOT EXISTS(SELECT * FROM ATIC_PARTITION_RULE WHERE RULE_ID = 7)
    THEN
    INSERT INTO `ATIC_PARTITION_RULE`(`RULE_ID`,`PARTITION_TIME`,`PARTITION_UNIT`,`PARTITION_HOLD_TIME`,`PARTITION_HOLD_UNIT`,`TABLES`,`PARTITION_EXPRESSION`,`H0LD_TYPE`,`REFRESH_MARK`) 
VALUES 
(7,1,'H',7,'D','ATIC_MIN_SUM_IP_FLOW,ATIC_MIN_SUM_ZONE_FLOW,ATIC_MIN_SUM_DEV_FLOW','LOG_TIME','D',0);
    END IF;
END;
//
DELIMITER ;
CALL add_partition_rule();
DROP PROCEDURE IF EXISTS add_partition_rule;

/*use when UPDATE V5R1CC30B017 TO V5R1C30B018*/

ALTER TABLE atic_attack_log MODIFY COLUMN SRC_IP varchar(1024);
ALTER TABLE atic_ip_attack_exact_log MODIFY COLUMN SRC_IP varchar(1024);
ALTER TABLE atic_ip_attack_log MODIFY COLUMN SRC_IP varchar(1024);
ALTER TABLE atic_biz_attack_log MODIFY COLUMN SRC_IP varchar(1024);
ALTER TABLE atic_zone_attack_log MODIFY COLUMN SRC_IP varchar(1024);


/*use when UPDATE V5R1CC30B018 TO V5R1C30B019*/
DROP PROCEDURE IF EXISTS alter_basic_task;
DELIMITER //
CREATE PROCEDURE alter_basic_task()
BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 'ATIC_BASELINE_TASK' AND column_name ='PKID')
    THEN
	  ALTER TABLE ATIC_BASELINE_TASK ADD COLUMN `PKID` INT(10) UNSIGNED NOT NULL DEFAULT '0' FIRST;
    END IF;
END;
//
DELIMITER ;
CALL alter_basic_task();
DROP PROCEDURE IF EXISTS alter_basic_task;

DROP PROCEDURE IF EXISTS alter_basic_detail;
DELIMITER //
CREATE PROCEDURE alter_basic_detail()
BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 'ATIC_BASELINE_DETAIL' AND column_name ='PKID')
    THEN
      ALTER TABLE ATIC_BASELINE_DETAIL ADD COLUMN `PKID` INT(10) UNSIGNED NOT NULL DEFAULT '0' FIRST;
    END IF;
END;
//
DELIMITER ;
CALL alter_basic_detail();
DROP PROCEDURE IF EXISTS alter_basic_detail;

DROP PROCEDURE IF EXISTS alter_baseline_nfa_detail;
DELIMITER //
CREATE PROCEDURE alter_baseline_nfa_detail()
BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 'ATIC_BASELINE_NFA_DETAIL' AND column_name ='PKID')
    THEN
      ALTER TABLE ATIC_BASELINE_NFA_DETAIL ADD COLUMN `PKID` INT(10) UNSIGNED NOT NULL DEFAULT '0' FIRST;
    END IF; 
END;
//
DELIMITER ;
CALL alter_baseline_nfa_detail();
DROP PROCEDURE IF EXISTS alter_baseline_nfa_detail;

ALTER TABLE atic_biz_attack_log MODIFY COLUMN DST_IP varchar(1024);
ALTER TABLE atic_zone_attack_log MODIFY COLUMN DST_IP varchar(1024);


/*use when UPDATE V5R1CC30B022 TO V5R1C30B023*/

DROP PROCEDURE IF EXISTS add_system_conf;
DELIMITER //
CREATE PROCEDURE add_system_conf()
BEGIN
    IF NOT EXISTS(SELECT * FROM atic_system_conf WHERE SYS_VAR = 'protal_sftp_server')
    THEN
    INSERT  INTO `atic_system_conf`(`SYS_VAR`,`SYS_VALUE`,`REMARK`) VALUES ('protal_sftp_server','','');
    END IF;
    IF NOT EXISTS(SELECT * FROM atic_system_conf WHERE SYS_VALUE = 'protal_sftp_port')
    THEN
      INSERT  INTO `atic_system_conf`(`SYS_VAR`,`SYS_VALUE`,`REMARK`) VALUES ('protal_sftp_port','','');
          END IF;
	IF NOT EXISTS(SELECT * FROM atic_system_conf WHERE SYS_VALUE = 'protal_sftp_username')
    THEN
      INSERT  INTO `atic_system_conf`(`SYS_VAR`,`SYS_VALUE`,`REMARK`) VALUES ('protal_sftp_username','','');
          END IF;
	IF NOT EXISTS(SELECT * FROM atic_system_conf WHERE SYS_VALUE = 'protal_sftp_pwd')
    THEN
      INSERT  INTO `atic_system_conf`(`SYS_VAR`,`SYS_VALUE`,`REMARK`) VALUES ('protal_sftp_pwd','','');
    END IF;
END;
//
DELIMITER ;
CALL add_system_conf();
DROP PROCEDURE IF EXISTS add_system_conf;



/*use when UPDATE V5R1CC30B027 TO V5R1C30B028*/

DROP PROCEDURE IF EXISTS alter_baseline_detail;
DELIMITER //
CREATE PROCEDURE alter_baseline_detail()
BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 'ATIC_BASELINE_DETAIL' AND column_name ='IS_ALERT')
    THEN
      ALTER TABLE ATIC_BASELINE_DETAIL ADD COLUMN `IS_ALERT` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0';
    END IF;
END;
//
DELIMITER ;
CALL alter_baseline_detail();
DROP PROCEDURE IF EXISTS alter_baseline_detail;

DROP PROCEDURE IF EXISTS alter_baseline_nfa_detail2;
DELIMITER //
CREATE PROCEDURE alter_baseline_nfa_detail2()
BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE table_name = 'ATIC_BASELINE_NFA_DETAIL' AND column_name ='IS_ALERT')
    THEN
      ALTER TABLE ATIC_BASELINE_NFA_DETAIL ADD COLUMN `IS_ALERT` TINYINT(1) UNSIGNED NOT NULL DEFAULT '0';
    END IF;
END;
//
DELIMITER ;
CALL alter_baseline_nfa_detail2();
DROP PROCEDURE IF EXISTS alter_baseline_nfa_detail2;
