USE `COLLECTOR`;

DROP PROCEDURE IF EXISTS add_tables_qps;
DELIMITER //
CREATE PROCEDURE add_tables_qps()
BEGIN
	DECLARE namex VARCHAR(64);
	DECLARE donex INT DEFAULT 0;  /*用于判断是否结束循环*/
	DECLARE pkid_tables_cur CURSOR FOR SELECT table_name from information_schema.`TABLES` where table_name in ('atic_ip_in', 'atic_ip_in_d', 'atic_ip_in_h', 'atic_ip_in_max', 'atic_zone_in', 'atic_zone_in_d', 'atic_zone_in_h', 'atic_zone_in_max', 'atic_ip_drop', 'atic_ip_drop_d', 'atic_ip_drop_h', 'atic_ip_drop_max', 'atic_zone_drop', 'atic_zone_drop_d', 'atic_zone_drop_h', 'atic_zone_drop_max','ATIC_ZONE_FLOW_SUM','ATIC_ZONE_FLOW_SUM_MAX'
	,'ATIC_ZONE_FLOW_SUM_H', 'ATIC_ZONE_FLOW_SUM_MAX_H', 'atic_zone_flow_sum_d', 'atic_zone_flow_sum_max_d', 'ATIC_ZONE_FLOW_SUM_DROP', 'ATIC_ZONE_FLOW_SUM_DROP_MAX', 'ATIC_ZONE_FLOW_SUM_DROP_H', 'ATIC_ZONE_FLOW_SUM_DROP_MAX_H', 'atic_zone_flow_sum_drop_d','atic_zone_flow_sum_drop_max_d','ATIC_IP_FLOW_SUM','ATIC_IP_FLOW_SUM_MAX', 'ATIC_IP_FLOW_SUM_H', 'ATIC_IP_FLOW_SUM_MAX_H', 'atic_ip_flow_sum_d', 'atic_ip_flow_sum_max_d', 'ATIC_IP_FLOW_SUM_DROP', 'ATIC_IP_FLOW_SUM_DROP_MAX', 'ATIC_IP_FLOW_SUM_DROP_H', 'ATIC_IP_FLOW_SUM_DROP_MAX_H','atic_ip_flow_sum_drop_d','atic_ip_flow_sum_drop_max_d');
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET donex = 1;
	
		OPEN pkid_tables_cur;  /*打开游标*/
			REPEAT
				FETCH pkid_tables_cur INTO namex;
          IF NOT donex THEN
						
						set @sqlStr1 = CONCAT('alter table ', namex, ' add COLUMN SIP_INVITE_QPS int(10) unsigned NOT NULL DEFAULT 0 AFTER SIP_INVITE_KBPS');
						PREPARE stmt1 from @sqlStr1;
						IF NOT EXISTS (select * from information_schema.`COLUMNS` where TABLE_name = namex and COLUMN_NAME = 'SIP_INVITE_QPS') THEN EXECUTE stmt1; END IF;
         END if;
			UNTIL donex END REPEAT;

		CLOSE pkid_tables_cur;  /*关闭游标*/
END
//
DELIMITER ;

call add_tables_qps();

DROP PROCEDURE IF EXISTS add_tables_qps;


-- 建表sql -- max
DROP PROCEDURE IF EXISTS add_tables_qps_max;
DELIMITER //
CREATE PROCEDURE add_tables_qps_max()
BEGIN
	DECLARE namex1 VARCHAR(64);
	DECLARE donex1 INT DEFAULT 0;  /*用于判断是否结束循环*/
	DECLARE pkid_tables_cur1 CURSOR FOR SELECT table_name from information_schema.`TABLES` where table_name in ('atic_ip_in_d', 'atic_ip_in_h', 'atic_zone_in_d', 'atic_zone_in_h', 'atic_ip_drop_d', 'atic_ip_drop_h', 'atic_zone_drop_d', 'atic_zone_drop_h');
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET donex1 = 1;
	
		OPEN pkid_tables_cur1;  /*打开游标*/
			REPEAT
				FETCH pkid_tables_cur1 INTO namex1; 
          IF NOT donex1 THEN
						
						set @sqlStr1_max = CONCAT('alter table ', namex1, ' add COLUMN `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT 0 AFTER MAX_SIP_INVITE_KBPS');
						PREPARE stmt1_max from @sqlStr1_max;
						IF NOT EXISTS (select * from information_schema.`COLUMNS` where TABLE_name = namex1 and COLUMN_NAME = 'MAX_SIP_INVITE_QPS') THEN EXECUTE stmt1_max; END IF;
         END if;
			UNTIL donex1 END REPEAT;

		CLOSE pkid_tables_cur1;  /*关闭游标*/
END
//
DELIMITER ;

call add_tables_qps_max();

DROP PROCEDURE IF EXISTS add_tables_qps_max;

/* syslog server日志服务器解耦 开始*/
/*Table structure for table `atic_syslog_server`*/
DROP TABLE IF EXISTS  `atic_syslog_server`;
CREATE TABLE `atic_syslog_server` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `server_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
  `server_port` INT(11) DEFAULT NULL,
  `default_zone_syslog` INT(11) DEFAULT '1',
  `atic_optlog` INT(11) DEFAULT NULL,
  `device_syslog` INT(11) DEFAULT NULL,
  `third_syslog` INT(11) DEFAULT NULL,
  `flow_syslog` INT(11) DEFAULT NULL,
  `flow_syslog_outbound` INT(11) DEFAULT NULL,
  `ip_flow_seconds_syslog` INT(11) DEFAULT NULL,
  `alarm_syslog` INT(11) DEFAULT NULL,
  `alarm_min_level` INT(11) DEFAULT NULL,
  `alarm_abnormity_log` INT(11) DEFAULT NULL,
  `alarm_attack_log` INT(11) DEFAULT NULL,
  `alarm_refresh_log` INT(11) DEFAULT NULL,
  `alarm_detail_log` INT(11) DEFAULT NULL,
  `alarm_abnormity_log_outbound` INT(11) DEFAULT NULL,
  `alarm_attack_log_outbound` INT(11) DEFAULT NULL,
  `alarm_refresh_log_outbound` INT(11) DEFAULT NULL,
  `alarm_detail_log_outbound` INT(11) DEFAULT NULL,
  `transfer_protocol` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;
/*Data for the table `atic_syslog_server` */
/*start procedure to update_syslog_server*/
DELIMITER $$
-- function:计算拆分后字符串的个数函数
DROP FUNCTION IF EXISTS calc_length $$
CREATE FUNCTION calc_length(str VARCHAR(255), splitstr VARCHAR(5)) RETURNS INT(11)
BEGIN 
	RETURN LENGTH(str)-LENGTH(REPLACE(str, splitstr, ''))+1;
END $$

-- function:分割字符，取第x个
DELIMITER $$
DROP FUNCTION IF EXISTS `get_split_string` $$
CREATE FUNCTION `get_split_string`
( f_string VARCHAR(1000),f_delimiter VARCHAR(5),f_order INT)
	RETURNS VARCHAR(255) CHARSET utf8
BEGIN
	DECLARE result VARCHAR(255) DEFAULT ''; 
	SET result = REVERSE(SUBSTRING_INDEX(REVERSE(SUBSTRING_INDEX(f_string,f_delimiter,f_order)),f_delimiter,1));
	RETURN result;
END$$
DELIMITER ;

/* 更新日志服务器信息 */
DROP PROCEDURE IF EXISTS update_syslog_server;
-- 创建存储过程
DELIMITER ;//
CREATE PROCEDURE update_syslog_server()
BEGIN
	-- 数据库所有字段
	DECLARE id INT;
	DECLARE server_ip VARCHAR(255);
	DECLARE server_port INT;
	DECLARE default_zone_syslog INT DEFAULT 1;
	DECLARE atic_optlog INT DEFAULT 0; -- atic侧转发，只记录，升级时为空，默认赋值0
	DECLARE device_syslog INT DEFAULT 0; -- atic侧转发，只记录，升级时为空，默认赋值0
	DECLARE third_syslog INT DEFAULT 0; -- atic侧转发，只记录，升级时为空，默认赋值0
	DECLARE flow_syslog INT;
	DECLARE flow_syslog_outbound INT DEFAULT 0;
	DECLARE ip_flow_seconds_syslog INT DEFAULT 0;
	DECLARE alarm_syslog INT DEFAULT 0;
	DECLARE alarm_min_level INT;
	DECLARE alarm_abnormity_log INT;
	DECLARE alarm_attack_log INT;
	DECLARE alarm_refresh_log INT;
	DECLARE alarm_detail_log INT;
	DECLARE alarm_abnormity_log_outbound INT;
	DECLARE alarm_attack_log_outbound INT;
	DECLARE alarm_refresh_log_outbound INT;
	DECLARE alarm_detail_log_outbound INT;
	DECLARE transfer_protocol INT;
	
	DECLARE cnt INT DEFAULT 0; 
	DECLARE i INT DEFAULT 0;
	DECLARE ip VARCHAR(255);
	
	DECLARE old_server_ip VARCHAR(255);
	DECLARE sys_var VARCHAR(255);
	DECLARE sys_value TEXT;
	
	-- SELECT conf.sys_value FROM atic_system_conf conf WHERE conf.sys_var='logserver_ip' INTO old_server_ip;
	-- IF NULL != old_server_ip AND '' != old_server_ip THEN
		-- 遍历数据结束标志 
		DECLARE Adone INT DEFAULT FALSE; 
		
		/** 声明游标，并将查询结果存到游标中 **/
		DECLARE cursor_sever CURSOR FOR SELECT syslog.sys_var,syslog.sys_value FROM atic_system_conf syslog;
		-- 将结束标志绑定到游标 
		DECLARE CONTINUE HANDLER FOR NOT FOUND SET Adone = TRUE; 
		-- 打开游标
		OPEN cursor_sever;
		read_loop: LOOP
			-- 取值 取多个字段
			FETCH cursor_sever INTO sys_var,sys_value; 
			IF Adone THEN
				LEAVE read_loop;
			END IF;
			-- 赋值
			IF 'logserver_ip' = sys_var THEN
				SET server_ip = sys_value;
			ELSEIF 'logserver_port' = sys_var THEN
				SET server_port = sys_value;
			ELSEIF 'defaultZoneSyslog' = sys_var THEN
				SET default_zone_syslog = sys_value;
			ELSEIF 'atic_optlog' = sys_var THEN
				SET atic_optlog = sys_value;
			ELSEIF 'device_syslog' = sys_var THEN
				SET device_syslog = sys_value;
			ELSEIF 'third_syslog' = sys_var THEN
				SET third_syslog = sys_value;
			ELSEIF 'syslog_flow_enabled' = sys_var THEN
				IF 'true' = sys_value THEN
					SET flow_syslog = 1;
				ELSE
					SET flow_syslog = 0;
				END IF;
			ELSEIF 'syslog_outbound_flow_enabled' = sys_var THEN
				IF 'true' = sys_value THEN
					SET flow_syslog_outbound = 1;
				ELSE
					SET flow_syslog_outbound = 0;
				END IF;
			ELSEIF 'syslog_ip_flow_seconds' = sys_var THEN
				IF 'true' = sys_value THEN
					SET ip_flow_seconds_syslog = 1;
				ELSE
					SET ip_flow_seconds_syslog = 0;
				END IF;
			ELSEIF 'alarm_syslog' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_syslog = 1;
				ELSE
					SET alarm_syslog = 0;
				END IF;
			ELSEIF 'syslog_attack_severity' = sys_var THEN
				IF NULL = sys_value OR 0 = sys_value THEN
					SET alarm_min_level = 4;
				ELSE
					SET alarm_min_level = sys_value;
				END IF;
			ELSEIF 'syslog_abnormal_enabled' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_abnormity_log = 1;
				ELSE
					SET alarm_abnormity_log = 0;
				END IF;
			ELSEIF 'syslog_attack_enabled' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_attack_log = 1;
				ELSE
					SET alarm_attack_log = 0;
				END IF;
			ELSEIF 'syslog_attacking' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_refresh_log = 1;
				ELSE
					SET alarm_refresh_log = 0;
				END IF;
			ELSEIF 'syslog_attack_detail' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_detail_log = 1;
				ELSE
					SET alarm_detail_log = 0;
				END IF;
			ELSEIF 'syslog_outbound_abnormal_enabled' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_abnormity_log_outbound = 1;
				ELSE
					SET alarm_abnormity_log_outbound = 0;
				END IF;
			ELSEIF 'syslog_outbound_attack_enabled' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_attack_log_outbound = 1;
				ELSE
					SET alarm_attack_log_outbound = 0;
				END IF;
			ELSEIF 'syslog_outbound_attacking' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_refresh_log_outbound = 1;
				ELSE
					SET alarm_refresh_log_outbound = 0;
				END IF;
			ELSEIF 'syslog_outbound_attack_detail' = sys_var THEN
				IF 'true' = sys_value THEN
					SET alarm_detail_log_outbound = 1;
				ELSE
					SET alarm_detail_log_outbound = 0;
				END IF;
			ELSEIF 'syslog_transfer_protocol' = sys_var THEN
				IF NULL = sys_value OR 0 = sys_value THEN
					SET transfer_protocol = 4;
				ELSE
					SET transfer_protocol = sys_value;
				END IF;
			END IF;
			
		END LOOP;
		-- 日志服务器拆分
		SET cnt = calc_length(server_ip,',');
		WHILE i < cnt
		DO
			SET i = i + 1;
			SET ip = get_split_string(server_ip,',',i);
			INSERT INTO atic_syslog_server(id,server_ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol) 
				VALUES(i,ip,server_port,default_zone_syslog,atic_optlog,device_syslog,third_syslog,flow_syslog,flow_syslog_outbound,ip_flow_seconds_syslog,alarm_syslog,alarm_min_level,alarm_abnormity_log,alarm_attack_log,alarm_refresh_log,alarm_detail_log,alarm_abnormity_log_outbound,alarm_attack_log_outbound,alarm_refresh_log_outbound,alarm_detail_log_outbound,transfer_protocol);
			-- SELECT * FROM atic_syslog_server;
		END WHILE;
		CLOSE cursor_sever;
	-- END IF;
END;//
DELIMITER ;
-- 调用存储过程
CALL update_syslog_server();
-- 原始表里的数据废弃，不再处理

-- 所有数据库更新完成后清除临时数据
DROP PROCEDURE IF EXISTS update_syslog_server;
DROP FUNCTION IF EXISTS calc_length;
DROP FUNCTION IF EXISTS get_split_string;
/*end procedure to update_syslog_server*/
/*syslog server 日志服务器解耦结束*/
