USE `COLLECTOR`;

DROP PROCEDURE IF EXISTS update_BaselineDataAndDetail;
DELIMITER //
CREATE PROCEDURE update_BaselineDataAndDetail() 
	BEGIN
		#data
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='TCP_SRC_INCREASE_CON')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `TCP_SRC_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER SIP_INVITE_PPS;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='TCP_SRC_CUR_CON')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `TCP_SRC_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_SRC_INCREASE_CON;
		END IF;
		#detail
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='TCP_SRC_INCREASE_CON')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `TCP_SRC_INCREASE_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER SIP_INVITE_PPS;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='TCP_SRC_CUR_CON')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `TCP_SRC_CUR_CON` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_SRC_INCREASE_CON;
		END IF;
	END;
//	  
DELIMITER ;
CALL update_BaselineDataAndDetail();


-- 建表sql
DROP PROCEDURE IF EXISTS add_tables_port;
DELIMITER //
CREATE PROCEDURE add_tables_port()
BEGIN
	DECLARE namex VARCHAR(64);
	DECLARE donex INT DEFAULT 0;  /*用于判断是否结束循环*/
	DECLARE pkid_tables_cur CURSOR FOR SELECT table_name from information_schema.`TABLES` where table_name in ('ATIC_IP_ATTACK_EXACT_LOG', 'ATIC_ATTACK_LOG', 'ATIC_ZONE_ATTACK_FLOW_H', 'ATIC_IP_ATTACK_FLOW_H', 'ATIC_ZONE_ATTACK_FLOW', 'ATIC_IP_ATTACK_FLOW', 'ATIC_ZONE_ATTACK_FLOW_D', 'ATIC_IP_ATTACK_FLOW_D');
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET donex = 1;
	
		OPEN pkid_tables_cur;  /*打开游标*/
			REPEAT
				FETCH pkid_tables_cur INTO namex;
          IF NOT donex THEN
						
						set @sqlStr1 = CONCAT('alter table ', namex, ' add COLUMN `PORTS` varchar(2000) NOT NULL DEFAULT 0 AFTER IP_TCP_CONCUR_CONN');
						PREPARE stmt1 from @sqlStr1;
						IF NOT EXISTS (select * from information_schema.`COLUMNS` where TABLE_name = namex and COLUMN_NAME = 'PORTS') THEN EXECUTE stmt1; END IF;
         END if;
			UNTIL donex END REPEAT;

		CLOSE pkid_tables_cur;  /*关闭游标*/
END
//
DELIMITER ;

call add_tables_port();

DROP PROCEDURE IF EXISTS add_tables_port;