USE `COLLECTOR`;

ALTER TABLE atic_collector_disk MODIFY COLUMN disk_name VARCHAR(10) DEFAULT NULL;

DROP PROCEDURE IF EXISTS update_BaselineDataAndDetail;
DELIMITER //
CREATE PROCEDURE update_BaselineDataAndDetail() 
	BEGIN
		#data
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='TCP_RATIO')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `TCP_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_SRC_CUR_CON;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='TCP_L500_RATIO')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `TCP_L500_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_RATIO;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='SYN_PKT_NUM')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `SYN_PKT_NUM` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_L500_RATIO;
		END IF;
		#detail
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='TCP_RATIO')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `TCP_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_SRC_CUR_CON;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='TCP_L500_RATIO')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `TCP_L500_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_RATIO;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='SYN_PKT_NUM')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `SYN_PKT_NUM` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_L500_RATIO;
		END IF;
	END;
//	  
DELIMITER ;
CALL update_BaselineDataAndDetail();