USE `COLLECTOR`;

CREATE TABLE IF NOT EXISTS `atic_zone_blacklist_history` (
  `PKID` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `ZONE_ID` INT(10) NOT NULL,
  `BIZ_ID` INT(10) NOT NULL,
  `ZONE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `START_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `END_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BLACK_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `PROTOCOL` INT(11) NOT NULL,
  `PORT` INT(11) NOT NULL,
  `BLACK_TYPE` INT(11) NOT NULL,
  `STATUS` INT(11) NOT NULL,
  `ENABLE` INT(11) NOT NULL DEFAULT '1',
  KEY (`PKID`),
  KEY (`END_TIME`)
) ENGINE=MYISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `atic_filter` (
  `FILTER_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `FILTER_NAME` varchar(64) NOT NULL DEFAULT '',
  KEY `KEY_FILTER_ID` (`FILTER_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

DROP PROCEDURE IF EXISTS createBlacklistHistoryTable;
DELIMITER //
CREATE PROCEDURE createBlacklistHistoryTable() 
	BEGIN
		#170 createBlacklistHistoryTable
		IF NOT EXISTS(SELECT * FROM ATIC_PARTITION_RULE WHERE RULE_ID=8)
		THEN
			INSERT INTO `ATIC_PARTITION_RULE`(`RULE_ID`,`PARTITION_TIME`,`PARTITION_UNIT`,`PARTITION_HOLD_TIME`,`PARTITION_HOLD_UNIT`,`TABLES`,`PARTITION_EXPRESSION`,`H0LD_TYPE`,`REFRESH_MARK`) 
			VALUES (8,24,'H',2,'D','atic_zone_blacklist_history','END_TIME','H',0);
		END IF;
		#158 add syslog_ip_flow_seconds to atic_system_conf
		IF NOT EXISTS(SELECT * FROM atic_system_conf WHERE PKID=45)
		THEN
			INSERT INTO `atic_system_conf`(`PKID`,`SYS_VAR`,`SYS_VALUE`,`REMARK`) VALUES (45,'syslog_ip_flow_seconds','','');
		END IF;
	END;
//	  
DELIMITER ;
CALL createBlacklistHistoryTable();
DROP PROCEDURE IF EXISTS createBlacklistHistoryTable;

DROP PROCEDURE IF EXISTS update_BaselineDataAndDetail;
DELIMITER //
CREATE PROCEDURE update_BaselineDataAndDetail() 
	BEGIN
		#data
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='TCP_RATIO')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `TCP_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_SRC_CUR_CON;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='TCP_L500_RATIO')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `TCP_L500_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_RATIO;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_data' AND column_name='SYN_PKT_NUM')
		THEN
			ALTER TABLE atic_baseline_data  ADD COLUMN  `SYN_PKT_NUM` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_L500_RATIO;
		END IF;
		#detail
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='TCP_RATIO')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `TCP_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_SRC_CUR_CON;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='TCP_L500_RATIO')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `TCP_L500_RATIO` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_RATIO;
		END IF;
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='atic_baseline_detail' AND column_name='SYN_PKT_NUM')
		THEN
			ALTER TABLE atic_baseline_detail  ADD COLUMN  `SYN_PKT_NUM` INT(10) UNSIGNED NOT NULL DEFAULT '0' AFTER TCP_L500_RATIO;
		END IF;
	END;
//	  
DELIMITER ;
CALL update_BaselineDataAndDetail();

ALTER TABLE atic_blackhole_np_config MODIFY COLUMN `black_hole_threshold` int(11);