USE `collector`;

/*Table structure for table `atic_attack_log` */

DROP TABLE IF EXISTS `atic_attack_log`;

CREATE TABLE `atic_attack_log` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `START_TIME_ALERT` int(10) unsigned NOT NULL DEFAULT '0',
  `START_TIME_ATTACK` int(10) unsigned NOT NULL DEFAULT '0',
  `END_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DURATION` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_STATUS` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `DROP_KBITS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `SRC_IP` varchar(5000) NOT NULL DEFAULT '0',
  `SRC_IP_FLOW` LONGTEXT COLLATE utf8_bin,
  `INTERACTIVE` int(10) DEFAULT '0',
  `CURRENT_VALUE` bigint(20) unsigned NOT NULL DEFAULT '0',
  `LIMIT_VALUE` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PPS_OR_KBPS` tinyint(3) unsigned NOT NULL,
  `MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `CURRENT_VALUE_1` bigint(20) unsigned NOT NULL DEFAULT '0',
  `LIMIT_VALUE_1` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PPS_OR_KBPS_1` tinyint(3) unsigned NOT NULL,
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  PRIMARY KEY (`PKID`),
  KEY `ZONE_ID` (`ZONE_ID`),
  KEY `ZONE_IP` (`ZONE_IP`),
  KEY `DEVICE_IP` (`DEVICE_IP`),
  KEY `DEVICE_TYPE` (`DEVICE_TYPE`),
  KEY `ATTACK_TYPE` (`ATTACK_TYPE`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_attack_log` */

/*Table structure for table `atic_baseline_data` */

DROP TABLE IF EXISTS `atic_baseline_data`;

CREATE TABLE `atic_baseline_data` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `CPU_SIZE` int(2) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_SRC_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_SRC_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',  
  `TCP_RATIO` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_L500_RATIO` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PKT_NUM` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_PKID` (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_baseline_data` */

/*Table structure for table `atic_baseline_detail` */

DROP TABLE IF EXISTS `atic_baseline_detail`;

CREATE TABLE `atic_baseline_detail` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_SRC_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_SRC_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_RATIO` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_L500_RATIO` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PKT_NUM` int(10) unsigned NOT NULL DEFAULT '0',
  `IS_ALERT` tinyint(1) NOT NULL DEFAULT '0',
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_PKID` (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_baseline_detail` */

/*Table structure for table `atic_baseline_nfa_data` */

DROP TABLE IF EXISTS `atic_baseline_nfa_data`;

CREATE TABLE `atic_baseline_nfa_data` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_PKID` (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_baseline_nfa_data` */

/*Table structure for table `atic_baseline_nfa_detail` */

DROP TABLE IF EXISTS `atic_baseline_nfa_detail`;

CREATE TABLE `atic_baseline_nfa_detail` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `IS_ALERT` tinyint(1) NOT NULL DEFAULT '0',
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_BIZ_ID` (`BIZ_ID`),
  KEY `KEY_PKID` (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_baseline_nfa_detail` */

/*Table structure for table `atic_baseline_task` */

DROP TABLE IF EXISTS `atic_baseline_task`;

CREATE TABLE `atic_baseline_task` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `START_CYC` int(10) unsigned NOT NULL DEFAULT '0',
  `START_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_baseline_task` */

/*Table structure for table `atic_biz_attack_log` */

DROP TABLE IF EXISTS `atic_biz_attack_log`;

CREATE TABLE `atic_biz_attack_log` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `START_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `END_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DURATION` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TIMES` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_STATUS` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TYPES` varchar(255) NOT NULL DEFAULT '0',
  `SRC_IP` varchar(5000) DEFAULT '0',
  `DST_IP` varchar(5000) DEFAULT '0',
  `MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`PKID`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_attack_log` */

/*Table structure for table `atic_biz_flow_sum` */

DROP TABLE IF EXISTS `atic_biz_flow_sum`;

CREATE TABLE `atic_biz_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum` */

/*Table structure for table `atic_biz_flow_sum_d` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_d`;

CREATE TABLE `atic_biz_flow_sum_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_d` */

/*Table structure for table `atic_biz_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_drop`;

CREATE TABLE `atic_biz_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_drop` */

/*Table structure for table `atic_biz_flow_sum_drop_d` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_drop_d`;

CREATE TABLE `atic_biz_flow_sum_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_drop_d` */

/*Table structure for table `atic_biz_flow_sum_drop_h` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_drop_h`;

CREATE TABLE `atic_biz_flow_sum_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_drop_h` */

/*Table structure for table `atic_biz_flow_sum_drop_max` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_drop_max`;

CREATE TABLE `atic_biz_flow_sum_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_drop_max` */

/*Table structure for table `atic_biz_flow_sum_drop_max_d` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_drop_max_d`;

CREATE TABLE `atic_biz_flow_sum_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_drop_max_d` */

/*Table structure for table `atic_biz_flow_sum_drop_max_h` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_drop_max_h`;

CREATE TABLE `atic_biz_flow_sum_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_drop_max_h` */

/*Table structure for table `atic_biz_flow_sum_h` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_h`;

CREATE TABLE `atic_biz_flow_sum_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_h` */

/*Table structure for table `atic_biz_flow_sum_max` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_max`;

CREATE TABLE `atic_biz_flow_sum_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_max` */

/*Table structure for table `atic_biz_flow_sum_max_d` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_max_d`;

CREATE TABLE `atic_biz_flow_sum_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_max_d` */

/*Table structure for table `atic_biz_flow_sum_max_h` */

DROP TABLE IF EXISTS `atic_biz_flow_sum_max_h`;

CREATE TABLE `atic_biz_flow_sum_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_flow_sum_max_h` */

/*Table structure for table `atic_biz_info` */

DROP TABLE IF EXISTS `atic_biz_info`;

CREATE TABLE `atic_biz_info` (
  `PKID` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `SERVICE_NAME` varchar(255) NOT NULL DEFAULT '',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `DST_PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `DEEP_PROTOCOL_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DEEP_PROTOCOL_NAME` varchar(255) NOT NULL DEFAULT '0',
  `APPID` int(10) unsigned NOT NULL DEFAULT '0',
  `APPNAME` varchar(255) NOT NULL DEFAULT '0',
  `SRVID` int(10) unsigned NOT NULL DEFAULT '0',
  `SRVNAME` varchar(255) NOT NULL DEFAULT '0',
  `BIZ_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SUM_SIZE` int(10) unsigned NOT NULL DEFAULT '1',
  KEY `KEY_PKID` (`PKID`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_biz_info` */

/*Table structure for table `atic_capture_task` */

DROP TABLE IF EXISTS `atic_capture_task`;

CREATE TABLE `atic_capture_task` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PCAP_ID` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `FILE_NAME` varchar(255) NOT NULL,
  `PCAP_TYPE` int(11) NOT NULL,
  `ZONE_ID` int(10) NOT NULL,
  `REQUIRED_PCAP_NUMBER` int(11) NOT NULL,
  `CAPTURE_NUMBER` int(11) DEFAULT NULL,
  PRIMARY KEY (`PKID`),
  UNIQUE KEY `FILE_NAME` (`FILE_NAME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_capture_task` */

/*Table structure for table `atic_collector_disk` */

DROP TABLE IF EXISTS `atic_collector_disk`;

CREATE TABLE `atic_collector_disk` (
  `MONITOR_TIME` int(10) unsigned NOT NULL,
  `DISK_NAME` varchar(10) DEFAULT NULL,
  `DISK_SIZE` int(10) DEFAULT NULL,
  `DISK_USE_RATIO` int(10) DEFAULT NULL,
  KEY `KEY_MONITOR_TIME` (`MONITOR_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_collector_disk` */

/*Table structure for table `atic_collector_perf` */

DROP TABLE IF EXISTS `atic_collector_perf`;

CREATE TABLE `atic_collector_perf` (
  `MONITOR_TIME` int(10) unsigned NOT NULL,
  `CPU_USE_RATIO` int(10) DEFAULT NULL,
  `MEM_USE_RATIO` int(10) DEFAULT NULL,
  KEY `KEY_MONITOR_TIME` (`MONITOR_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_collector_perf` */

/*Table structure for table `atic_default_biz_relation` */

DROP TABLE IF EXISTS `atic_default_biz_relation`;

CREATE TABLE `atic_default_biz_relation` (
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_default_biz_relation` */

/*Table structure for table `atic_default_zone_relation` */

DROP TABLE IF EXISTS `atic_default_zone_relation`;

CREATE TABLE `atic_default_zone_relation` (
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_default_zone_relation` */

/*Table structure for table `atic_min_dev_flow_sum` */

DROP TABLE IF EXISTS `atic_min_dev_flow_sum`;

CREATE TABLE `atic_min_dev_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_dev_flow_sum` */

/*Table structure for table `atic_dev_flow_sum` */

DROP TABLE IF EXISTS `atic_dev_flow_sum`;

CREATE TABLE `atic_dev_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum` */

/*Table structure for table `atic_dev_flow_sum_d` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_d`;

CREATE TABLE `atic_dev_flow_sum_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_d` */

/*Table structure for table `atic_min_dev_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_min_dev_flow_sum_drop`;

CREATE TABLE `atic_min_dev_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_dev_flow_sum_drop` */

/*Table structure for table `atic_dev_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_drop`;

CREATE TABLE `atic_dev_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_drop` */

/*Table structure for table `atic_dev_flow_sum_drop_d` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_drop_d`;

CREATE TABLE `atic_dev_flow_sum_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_drop_d` */

/*Table structure for table `atic_dev_flow_sum_drop_h` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_drop_h`;

CREATE TABLE `atic_dev_flow_sum_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_drop_h` */

/*Table structure for table `atic_min_dev_flow_sum_drop_max` */

DROP TABLE IF EXISTS `atic_min_dev_flow_sum_drop_max`;

CREATE TABLE `atic_min_dev_flow_sum_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_dev_flow_sum_drop_max` */

/*Table structure for table `atic_dev_flow_sum_drop_max` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_drop_max`;

CREATE TABLE `atic_dev_flow_sum_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_drop_max` */

/*Table structure for table `atic_dev_flow_sum_drop_max_d` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_drop_max_d`;

CREATE TABLE `atic_dev_flow_sum_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_drop_max_d` */

/*Table structure for table `atic_dev_flow_sum_drop_max_h` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_drop_max_h`;

CREATE TABLE `atic_dev_flow_sum_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_drop_max_h` */

/*Table structure for table `atic_dev_flow_sum_h` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_h`;

CREATE TABLE `atic_dev_flow_sum_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_h` */

/*Table structure for table `atic_min_dev_flow_sum_max` */

DROP TABLE IF EXISTS `atic_min_dev_flow_sum_max`;

CREATE TABLE `atic_min_dev_flow_sum_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_dev_flow_sum_max` */

/*Table structure for table `atic_min_dev_flow_sum_forward_max` */

DROP TABLE IF EXISTS `atic_min_dev_flow_sum_forward_max`;

CREATE TABLE `atic_min_dev_flow_sum_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_dev_flow_sum_forward_max` */

/*Table structure for table `atic_dev_flow_sum_max` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_max`;

CREATE TABLE `atic_dev_flow_sum_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_max` */

/*Table structure for table `atic_dev_flow_sum_forward_max` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_forward_max`;

CREATE TABLE `atic_dev_flow_sum_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_forward_max` */

/*Table structure for table `atic_dev_flow_sum_max_d` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_max_d`;

CREATE TABLE `atic_dev_flow_sum_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_max_d` */

/*Table structure for table `atic_dev_flow_sum_forward_max_d` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_forward_max_d`;

CREATE TABLE `atic_dev_flow_sum_forward_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_forward_max_d` */

/*Table structure for table `atic_dev_flow_sum_max_h` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_max_h`;

CREATE TABLE `atic_dev_flow_sum_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_max_h` */

/*Table structure for table `atic_dev_flow_sum_forward_max_h` */

DROP TABLE IF EXISTS `atic_dev_flow_sum_forward_max_h`;

CREATE TABLE `atic_dev_flow_sum_forward_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_flow_sum_forward_max_h` */

/*Table structure for table `atic_dev_work_time` */

DROP TABLE IF EXISTS `atic_dev_work_time`;

CREATE TABLE `atic_dev_work_time` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `STOP_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `START_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dev_work_time` */

/*Table structure for table `atic_device` */

DROP TABLE IF EXISTS `atic_device`;

CREATE TABLE `atic_device` (
  `MO_ID` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) DEFAULT NULL,
  `SERVICE_TYPE` int(10) DEFAULT '1',
  `NET_MODE` int(10) DEFAULT '1',
  `LOG_IP` varchar(40) NOT NULL DEFAULT '',
  `ENCRYPT_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `LOG_PWD` varchar(512) DEFAULT ''
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_device` */

/*Table structure for table `atic_dns_defend` */

DROP TABLE IF EXISTS `atic_dns_defend`;

CREATE TABLE `atic_dns_defend` (
  `LOG_TIME` int(10) unsigned DEFAULT NULL,
  `DEVICE_IP` varchar(40) DEFAULT '',
  `DEVICE_TYPE` int(1) unsigned DEFAULT NULL,
  `DNS_NAME` varchar(256) DEFAULT NULL,
  `SRC_IP` varchar(500) DEFAULT NULL,
  `REQUEST_TIME` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dns_defend` */

/*Table structure for table `atic_dns_defend_d` */

DROP TABLE IF EXISTS `atic_dns_defend_d`;

CREATE TABLE `atic_dns_defend_d` (
  `LOG_TIME` int(10) unsigned DEFAULT NULL,
  `DEVICE_IP` varchar(40) DEFAULT '',
  `DEVICE_TYPE` int(1) unsigned DEFAULT NULL,
  `DNS_NAME` varchar(256) DEFAULT NULL,
  `REQUEST_TIME` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dns_defend_d` */

/*Table structure for table `atic_dns_defend_h` */

DROP TABLE IF EXISTS `atic_dns_defend_h`;

CREATE TABLE `atic_dns_defend_h` (
  `LOG_TIME` int(10) unsigned DEFAULT NULL,
  `DEVICE_IP` varchar(40) DEFAULT '',
  `DEVICE_TYPE` int(1) unsigned DEFAULT NULL,
  `DNS_NAME` varchar(256) DEFAULT NULL,
  `REQUEST_TIME` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dns_defend_h` */

/*Table structure for table `atic_dns_topn` */

DROP TABLE IF EXISTS `atic_dns_topn`;

CREATE TABLE `atic_dns_topn` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOPN_TYPE` int(2) NOT NULL DEFAULT '9',
  `DNS_NAME` varchar(1024) NOT NULL DEFAULT '0',
  `REQUEST_TYPE` varchar(10) NOT NULL DEFAULT '',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_TOPN_TYPE` (`TOPN_TYPE`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dns_topn` */

/*Table structure for table `atic_dns_topn_d` */

DROP TABLE IF EXISTS `atic_dns_topn_d`;

CREATE TABLE `atic_dns_topn_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOPN_TYPE` int(2) NOT NULL DEFAULT '9',
  `DNS_NAME` varchar(1024) NOT NULL DEFAULT '0',
  `REQUEST_TYPE` varchar(10) NOT NULL DEFAULT '',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_TOPN_TYPE` (`TOPN_TYPE`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dns_topn_d` */

/*Table structure for table `atic_dns_topn_h` */

DROP TABLE IF EXISTS `atic_dns_topn_h`;

CREATE TABLE `atic_dns_topn_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOPN_TYPE` int(2) NOT NULL DEFAULT '9',
  `DNS_NAME` varchar(1024) NOT NULL DEFAULT '0',
  `REQUEST_TYPE` varchar(10) NOT NULL DEFAULT '',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_TOPN_TYPE` (`TOPN_TYPE`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_dns_topn_h` */

/*Table structure for table `atic_fault_severity_rule` */

DROP TABLE IF EXISTS `atic_fault_severity_rule`;

CREATE TABLE `atic_fault_severity_rule` (
  `id` bigint(20) NOT NULL,
  `zone_id` bigint(20) NOT NULL DEFAULT '0',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `severity` int(11) DEFAULT NULL,
  `in_traffic_pps_status` int(11) DEFAULT NULL,
  `in_traffic_pps` int(11) DEFAULT NULL,
  `in_traffic_mbps_status` int(11) DEFAULT NULL,
  `in_traffic_mbps` int(11) DEFAULT NULL,
  `current_conn_status` int(11) DEFAULT NULL,
  `current_connection` int(11) DEFAULT NULL,
  `new_conn_status` int(11) DEFAULT NULL,
  `new_connection` int(11) DEFAULT NULL,
  `duration_status` int(11) DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `diversion_action` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_fault_severity_rule` */

insert  into `atic_fault_severity_rule`(`id`,`zone_id`,`DIRECTION`,`severity`,`in_traffic_pps_status`,`in_traffic_pps`,`in_traffic_mbps_status`,`in_traffic_mbps`,`current_conn_status`,`current_connection`,`new_conn_status`,`new_connection`,`duration_status`,`duration`,`diversion_action`) values (1,0,1,4,1,200000,1,500,1,10000,1,500,1,1800,1),(2,0,1,3,1,20000,1,50,1,5000,1,300,1,600,1),(3,0,1,2,1,2000,1,5,1,1000,1,100,1,360,1),(4,0,1,1,1,1,1,1,1,1,1,1,1,1,0),(5,0,2,4,1,200000,1,500,1,10000,1,500,1,1800,0),(6,0,2,3,1,20000,1,50,1,5000,1,300,1,600,0),(7,0,2,2,1,2000,1,5,1,1000,1,100,1,360,0),(8,0,2,1,1,1,1,1,1,1,1,1,1,1,0);

/*Table structure for table `atic_ip_anomaly_times_d` */

DROP TABLE IF EXISTS `atic_ip_anomaly_times_d`;

CREATE TABLE `atic_ip_anomaly_times_d` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ALERT_TIMES` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TIMES` int(10) unsigned DEFAULT '0',
  KEY `PKID` (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_anomaly_times_d` */

/*Table structure for table `atic_ip_anomaly_times_h` */

DROP TABLE IF EXISTS `atic_ip_anomaly_times_h`;

CREATE TABLE `atic_ip_anomaly_times_h` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ALERT_TIMES` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TIMES` int(10) unsigned DEFAULT '0',
  KEY `PKID` (`PKID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_anomaly_times_h` */

/*Table structure for table `atic_ip_attack_exact_log` */

DROP TABLE IF EXISTS `atic_ip_attack_exact_log`;

CREATE TABLE `atic_ip_attack_exact_log` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `START_TIME_ALERT` int(10) unsigned NOT NULL DEFAULT '0',
  `START_TIME_ATTACK` int(10) unsigned NOT NULL DEFAULT '0',
  `END_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DURATION` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_STATUS` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `DROP_KBITS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `SRC_IP` varchar(5000) NOT NULL DEFAULT '0',
  `SRC_IP_FLOW` LONGTEXT COLLATE utf8_bin,
  `INTERACTIVE` int(10) DEFAULT '0',
  `CURRENT_VALUE` bigint(20) unsigned NOT NULL DEFAULT '0',
  `LIMIT_VALUE` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PPS_OR_KBPS` tinyint(3) unsigned NOT NULL,
  `MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `CURRENT_VALUE_1` bigint(20) unsigned NOT NULL DEFAULT '0',
  `LIMIT_VALUE_1` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PPS_OR_KBPS_1` tinyint(3) unsigned NOT NULL,
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  KEY `KEY_PKID` (`PKID`),
  KEY `ZONE_ID` (`ZONE_ID`),
  KEY `ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_attack_exact_log` */

/*Table structure for table `atic_ip_attack_flow` */

DROP TABLE IF EXISTS `atic_ip_attack_flow`;

CREATE TABLE `atic_ip_attack_flow` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_KBPS` int(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PPS` int(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_attack_flow` */

/*Table structure for table `atic_ip_attack_flow_d` */

DROP TABLE IF EXISTS `atic_ip_attack_flow_d`;

CREATE TABLE `atic_ip_attack_flow_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_KBPS` int(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PPS` int(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_attack_flow_d` */

/*Table structure for table `atic_ip_attack_flow_h` */

DROP TABLE IF EXISTS `atic_ip_attack_flow_h`;

CREATE TABLE `atic_ip_attack_flow_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_KBPS` int(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PPS` int(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_attack_flow_h` */

/*Table structure for table `atic_ip_attack_log` */

DROP TABLE IF EXISTS `atic_ip_attack_log`;

CREATE TABLE `atic_ip_attack_log` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `START_TIME_ALERT` int(10) unsigned NOT NULL DEFAULT '0',
  `START_TIME_ATTACK` int(10) unsigned NOT NULL DEFAULT '0',
  `END_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DURATION` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TIMES` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_STATUS` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ALERT_TYPES` varchar(255) NOT NULL DEFAULT '0',
  `ATTACK_TYPES` varchar(255) NOT NULL DEFAULT '0',
  `SRC_IP` varchar(5000) NOT NULL DEFAULT '0',
  `EXACT_LOG_ID` text,
  `MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_PKID` (`PKID`),
  KEY `ZONE_ID` (`ZONE_ID`),
  KEY `ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_attack_log` */

/*Table structure for table `atic_ip_biz_http` */

DROP TABLE IF EXISTS `atic_ip_biz_http`;

CREATE TABLE `atic_ip_biz_http` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http` */

/*Table structure for table `atic_ip_biz_http_d` */

DROP TABLE IF EXISTS `atic_ip_biz_http_d`;

CREATE TABLE `atic_ip_biz_http_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_d` */

/*Table structure for table `atic_ip_biz_http_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_http_drop`;

CREATE TABLE `atic_ip_biz_http_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_drop` */

/*Table structure for table `atic_ip_biz_http_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_http_drop_d`;

CREATE TABLE `atic_ip_biz_http_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_drop_d` */

/*Table structure for table `atic_ip_biz_http_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_http_drop_h`;

CREATE TABLE `atic_ip_biz_http_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_drop_h` */

/*Table structure for table `atic_ip_biz_http_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_http_drop_max`;

CREATE TABLE `atic_ip_biz_http_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_drop_max` */

/*Table structure for table `atic_ip_biz_http_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_http_drop_max_d`;

CREATE TABLE `atic_ip_biz_http_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_drop_max_d` */

/*Table structure for table `atic_ip_biz_http_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_http_drop_max_h`;

CREATE TABLE `atic_ip_biz_http_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_drop_max_h` */

/*Table structure for table `atic_ip_biz_http_h` */

DROP TABLE IF EXISTS `atic_ip_biz_http_h`;

CREATE TABLE `atic_ip_biz_http_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_h` */

/*Table structure for table `atic_ip_biz_http_max` */

DROP TABLE IF EXISTS `atic_ip_biz_http_max`;

CREATE TABLE `atic_ip_biz_http_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_max` */

/*Table structure for table `atic_ip_biz_http_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_http_max_d`;

CREATE TABLE `atic_ip_biz_http_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_max_d` */

/*Table structure for table `atic_ip_biz_http_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_http_max_h`;

CREATE TABLE `atic_ip_biz_http_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_http_max_h` */

/*Table structure for table `atic_ip_biz_https` */

DROP TABLE IF EXISTS `atic_ip_biz_https`;

CREATE TABLE `atic_ip_biz_https` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https` */

/*Table structure for table `atic_ip_biz_https_d` */

DROP TABLE IF EXISTS `atic_ip_biz_https_d`;

CREATE TABLE `atic_ip_biz_https_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_d` */

/*Table structure for table `atic_ip_biz_https_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_https_drop`;

CREATE TABLE `atic_ip_biz_https_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_drop` */

/*Table structure for table `atic_ip_biz_https_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_https_drop_d`;

CREATE TABLE `atic_ip_biz_https_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_drop_d` */

/*Table structure for table `atic_ip_biz_https_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_https_drop_h`;

CREATE TABLE `atic_ip_biz_https_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_drop_h` */

/*Table structure for table `atic_ip_biz_https_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_https_drop_max`;

CREATE TABLE `atic_ip_biz_https_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_drop_max` */

/*Table structure for table `atic_ip_biz_https_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_https_drop_max_d`;

CREATE TABLE `atic_ip_biz_https_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_drop_max_d` */

/*Table structure for table `atic_ip_biz_https_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_https_drop_max_h`;

CREATE TABLE `atic_ip_biz_https_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_drop_max_h` */

/*Table structure for table `atic_ip_biz_https_h` */

DROP TABLE IF EXISTS `atic_ip_biz_https_h`;

CREATE TABLE `atic_ip_biz_https_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_h` */

/*Table structure for table `atic_ip_biz_https_max` */

DROP TABLE IF EXISTS `atic_ip_biz_https_max`;

CREATE TABLE `atic_ip_biz_https_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_max` */

/*Table structure for table `atic_ip_biz_https_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_https_max_d`;

CREATE TABLE `atic_ip_biz_https_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_max_d` */

/*Table structure for table `atic_ip_biz_https_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_https_max_h`;

CREATE TABLE `atic_ip_biz_https_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_https_max_h` */

/*Table structure for table `atic_ip_biz_other` */

DROP TABLE IF EXISTS `atic_ip_biz_other`;

CREATE TABLE `atic_ip_biz_other` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other` */

/*Table structure for table `atic_ip_biz_other_d` */

DROP TABLE IF EXISTS `atic_ip_biz_other_d`;

CREATE TABLE `atic_ip_biz_other_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_d` */

/*Table structure for table `atic_ip_biz_other_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_other_drop`;

CREATE TABLE `atic_ip_biz_other_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_drop` */

/*Table structure for table `atic_ip_biz_other_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_other_drop_d`;

CREATE TABLE `atic_ip_biz_other_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_drop_d` */

/*Table structure for table `atic_ip_biz_other_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_other_drop_h`;

CREATE TABLE `atic_ip_biz_other_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_drop_h` */

/*Table structure for table `atic_ip_biz_other_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_other_drop_max`;

CREATE TABLE `atic_ip_biz_other_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_drop_max` */

/*Table structure for table `atic_ip_biz_other_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_other_drop_max_d`;

CREATE TABLE `atic_ip_biz_other_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_drop_max_d` */

/*Table structure for table `atic_ip_biz_other_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_other_drop_max_h`;

CREATE TABLE `atic_ip_biz_other_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_drop_max_h` */

/*Table structure for table `atic_ip_biz_other_h` */

DROP TABLE IF EXISTS `atic_ip_biz_other_h`;

CREATE TABLE `atic_ip_biz_other_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_h` */

/*Table structure for table `atic_ip_biz_other_max` */

DROP TABLE IF EXISTS `atic_ip_biz_other_max`;

CREATE TABLE `atic_ip_biz_other_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_max` */

/*Table structure for table `atic_ip_biz_other_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_other_max_d`;

CREATE TABLE `atic_ip_biz_other_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_max_d` */

/*Table structure for table `atic_ip_biz_other_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_other_max_h`;

CREATE TABLE `atic_ip_biz_other_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_other_max_h` */

/*Table structure for table `atic_ip_biz_sip` */

DROP TABLE IF EXISTS `atic_ip_biz_sip`;

CREATE TABLE `atic_ip_biz_sip` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip` */

/*Table structure for table `atic_ip_biz_sip_d` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_d`;

CREATE TABLE `atic_ip_biz_sip_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_d` */

/*Table structure for table `atic_ip_biz_sip_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_drop`;

CREATE TABLE `atic_ip_biz_sip_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_drop` */

/*Table structure for table `atic_ip_biz_sip_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_drop_d`;

CREATE TABLE `atic_ip_biz_sip_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_drop_d` */

/*Table structure for table `atic_ip_biz_sip_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_drop_h`;

CREATE TABLE `atic_ip_biz_sip_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_drop_h` */

/*Table structure for table `atic_ip_biz_sip_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_drop_max`;

CREATE TABLE `atic_ip_biz_sip_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_drop_max` */

/*Table structure for table `atic_ip_biz_sip_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_drop_max_d`;

CREATE TABLE `atic_ip_biz_sip_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_drop_max_d` */

/*Table structure for table `atic_ip_biz_sip_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_drop_max_h`;

CREATE TABLE `atic_ip_biz_sip_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_drop_max_h` */

/*Table structure for table `atic_ip_biz_sip_h` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_h`;

CREATE TABLE `atic_ip_biz_sip_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_h` */

/*Table structure for table `atic_ip_biz_sip_max` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_max`;

CREATE TABLE `atic_ip_biz_sip_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_max` */

/*Table structure for table `atic_ip_biz_sip_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_max_d`;

CREATE TABLE `atic_ip_biz_sip_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_max_d` */

/*Table structure for table `atic_ip_biz_sip_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_sip_max_h`;

CREATE TABLE `atic_ip_biz_sip_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_sip_max_h` */

/*Table structure for table `atic_ip_biz_tcp` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp`;

CREATE TABLE `atic_ip_biz_tcp` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp` */

/*Table structure for table `atic_ip_biz_tcp_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_d`;

CREATE TABLE `atic_ip_biz_tcp_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_d` */

/*Table structure for table `atic_ip_biz_tcp_dns` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns`;

CREATE TABLE `atic_ip_biz_tcp_dns` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns` */

/*Table structure for table `atic_ip_biz_tcp_dns_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_d`;

CREATE TABLE `atic_ip_biz_tcp_dns_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_d` */

/*Table structure for table `atic_ip_biz_tcp_dns_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_drop`;

CREATE TABLE `atic_ip_biz_tcp_dns_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_drop` */

/*Table structure for table `atic_ip_biz_tcp_dns_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_drop_d`;

CREATE TABLE `atic_ip_biz_tcp_dns_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_drop_d` */

/*Table structure for table `atic_ip_biz_tcp_dns_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_drop_h`;

CREATE TABLE `atic_ip_biz_tcp_dns_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_drop_h` */

/*Table structure for table `atic_ip_biz_tcp_dns_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_drop_max`;

CREATE TABLE `atic_ip_biz_tcp_dns_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_drop_max` */

/*Table structure for table `atic_ip_biz_tcp_dns_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_drop_max_d`;

CREATE TABLE `atic_ip_biz_tcp_dns_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_drop_max_d` */

/*Table structure for table `atic_ip_biz_tcp_dns_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_drop_max_h`;

CREATE TABLE `atic_ip_biz_tcp_dns_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_drop_max_h` */

/*Table structure for table `atic_ip_biz_tcp_dns_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_h`;

CREATE TABLE `atic_ip_biz_tcp_dns_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_h` */

/*Table structure for table `atic_ip_biz_tcp_dns_max` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_max`;

CREATE TABLE `atic_ip_biz_tcp_dns_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_max` */

/*Table structure for table `atic_ip_biz_tcp_dns_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_max_d`;

CREATE TABLE `atic_ip_biz_tcp_dns_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_max_d` */

/*Table structure for table `atic_ip_biz_tcp_dns_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_dns_max_h`;

CREATE TABLE `atic_ip_biz_tcp_dns_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_dns_max_h` */

/*Table structure for table `atic_ip_biz_tcp_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_drop`;

CREATE TABLE `atic_ip_biz_tcp_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_drop` */

/*Table structure for table `atic_ip_biz_tcp_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_drop_d`;

CREATE TABLE `atic_ip_biz_tcp_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_drop_d` */

/*Table structure for table `atic_ip_biz_tcp_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_drop_h`;

CREATE TABLE `atic_ip_biz_tcp_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_drop_h` */

/*Table structure for table `atic_ip_biz_tcp_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_drop_max`;

CREATE TABLE `atic_ip_biz_tcp_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_drop_max` */

/*Table structure for table `atic_ip_biz_tcp_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_drop_max_d`;

CREATE TABLE `atic_ip_biz_tcp_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_drop_max_d` */

/*Table structure for table `atic_ip_biz_tcp_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_drop_max_h`;

CREATE TABLE `atic_ip_biz_tcp_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_drop_max_h` */

/*Table structure for table `atic_ip_biz_tcp_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_h`;

CREATE TABLE `atic_ip_biz_tcp_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_h` */

/*Table structure for table `atic_ip_biz_tcp_max` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_max`;

CREATE TABLE `atic_ip_biz_tcp_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_max` */

/*Table structure for table `atic_ip_biz_tcp_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_max_d`;

CREATE TABLE `atic_ip_biz_tcp_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_max_d` */

/*Table structure for table `atic_ip_biz_tcp_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_tcp_max_h`;

CREATE TABLE `atic_ip_biz_tcp_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_tcp_max_h` */

/*Table structure for table `atic_ip_biz_udp` */

DROP TABLE IF EXISTS `atic_ip_biz_udp`;

CREATE TABLE `atic_ip_biz_udp` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp` */

/*Table structure for table `atic_ip_biz_udp_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_d`;

CREATE TABLE `atic_ip_biz_udp_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_d` */

/*Table structure for table `atic_ip_biz_udp_dns` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns`;

CREATE TABLE `atic_ip_biz_udp_dns` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns` */

/*Table structure for table `atic_ip_biz_udp_dns_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_d`;

CREATE TABLE `atic_ip_biz_udp_dns_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_d` */

/*Table structure for table `atic_ip_biz_udp_dns_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_drop`;

CREATE TABLE `atic_ip_biz_udp_dns_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REPLY_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_drop` */

/*Table structure for table `atic_ip_biz_udp_dns_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_drop_d`;

CREATE TABLE `atic_ip_biz_udp_dns_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REPLY_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_drop_d` */

/*Table structure for table `atic_ip_biz_udp_dns_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_drop_h`;

CREATE TABLE `atic_ip_biz_udp_dns_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REPLY_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_drop_h` */

/*Table structure for table `atic_ip_biz_udp_dns_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_drop_max`;

CREATE TABLE `atic_ip_biz_udp_dns_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_drop_max` */

/*Table structure for table `atic_ip_biz_udp_dns_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_drop_max_d`;

CREATE TABLE `atic_ip_biz_udp_dns_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_drop_max_d` */

/*Table structure for table `atic_ip_biz_udp_dns_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_drop_max_h`;

CREATE TABLE `atic_ip_biz_udp_dns_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_drop_max_h` */

/*Table structure for table `atic_ip_biz_udp_dns_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_h`;

CREATE TABLE `atic_ip_biz_udp_dns_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_h` */

/*Table structure for table `atic_ip_biz_udp_dns_max` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_max`;

CREATE TABLE `atic_ip_biz_udp_dns_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_max` */

/*Table structure for table `atic_ip_biz_udp_dns_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_max_d`;

CREATE TABLE `atic_ip_biz_udp_dns_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_max_d` */

/*Table structure for table `atic_ip_biz_udp_dns_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_dns_max_h`;

CREATE TABLE `atic_ip_biz_udp_dns_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_dns_max_h` */

/*Table structure for table `atic_ip_biz_udp_drop` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_drop`;

CREATE TABLE `atic_ip_biz_udp_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_drop` */

/*Table structure for table `atic_ip_biz_udp_drop_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_drop_d`;

CREATE TABLE `atic_ip_biz_udp_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_drop_d` */

/*Table structure for table `atic_ip_biz_udp_drop_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_drop_h`;

CREATE TABLE `atic_ip_biz_udp_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_drop_h` */

/*Table structure for table `atic_ip_biz_udp_drop_max` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_drop_max`;

CREATE TABLE `atic_ip_biz_udp_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_drop_max` */

/*Table structure for table `atic_ip_biz_udp_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_drop_max_d`;

CREATE TABLE `atic_ip_biz_udp_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_drop_max_d` */

/*Table structure for table `atic_ip_biz_udp_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_drop_max_h`;

CREATE TABLE `atic_ip_biz_udp_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_drop_max_h` */

/*Table structure for table `atic_ip_biz_udp_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_h`;

CREATE TABLE `atic_ip_biz_udp_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_h` */

/*Table structure for table `atic_ip_biz_udp_max` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_max`;

CREATE TABLE `atic_ip_biz_udp_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_max` */

/*Table structure for table `atic_ip_biz_udp_max_d` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_max_d`;

CREATE TABLE `atic_ip_biz_udp_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_max_d` */

/*Table structure for table `atic_ip_biz_udp_max_h` */

DROP TABLE IF EXISTS `atic_ip_biz_udp_max_h`;

CREATE TABLE `atic_ip_biz_udp_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_biz_udp_max_h` */

/*Table structure for table `atic_ip_drop` */

DROP TABLE IF EXISTS `atic_ip_drop`;

CREATE TABLE `atic_ip_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_drop` */

/*Table structure for table `atic_ip_drop_d` */

DROP TABLE IF EXISTS `atic_ip_drop_d`;

CREATE TABLE `atic_ip_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_drop_d` */

/*Table structure for table `atic_ip_drop_h` */

DROP TABLE IF EXISTS `atic_ip_drop_h`;

CREATE TABLE `atic_ip_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_drop_h` */

/*Table structure for table `atic_ip_drop_max` */

DROP TABLE IF EXISTS `atic_ip_drop_max`;

CREATE TABLE `atic_ip_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_drop_max` */

/*Table structure for table `atic_min_ip_flow_sum` */

DROP TABLE IF EXISTS `atic_min_ip_flow_sum`;

CREATE TABLE `atic_min_ip_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_ip_flow_sum` */

/*Table structure for table `atic_ip_flow_sum` */

DROP TABLE IF EXISTS `atic_ip_flow_sum`;

CREATE TABLE `atic_ip_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum` */

/*Table structure for table `atic_ip_flow_sum_d` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_d`;

CREATE TABLE `atic_ip_flow_sum_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_d` */

/*Table structure for table `atic_min_ip_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_min_ip_flow_sum_drop`;

CREATE TABLE `atic_min_ip_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_ip_flow_sum_drop` */

/*Table structure for table `atic_ip_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_drop`;

CREATE TABLE `atic_ip_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_drop` */

/*Table structure for table `atic_ip_flow_sum_drop_d` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_drop_d`;

CREATE TABLE `atic_ip_flow_sum_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_drop_d` */

/*Table structure for table `atic_ip_flow_sum_drop_h` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_drop_h`;

CREATE TABLE `atic_ip_flow_sum_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_drop_h` */

/*Table structure for table `atic_min_ip_flow_sum_drop_max` */

DROP TABLE IF EXISTS `atic_min_ip_flow_sum_drop_max`;

CREATE TABLE `atic_min_ip_flow_sum_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_ip_flow_sum_drop_max` */

/*Table structure for table `atic_ip_flow_sum_drop_max` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_drop_max`;

CREATE TABLE `atic_ip_flow_sum_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_drop_max` */

/*Table structure for table `atic_ip_flow_sum_drop_max_d` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_drop_max_d`;

CREATE TABLE `atic_ip_flow_sum_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_drop_max_d` */

/*Table structure for table `atic_ip_flow_sum_drop_max_h` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_drop_max_h`;

CREATE TABLE `atic_ip_flow_sum_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_drop_max_h` */

/*Table structure for table `atic_ip_flow_sum_h` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_h`;

CREATE TABLE `atic_ip_flow_sum_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_h` */

/*Table structure for table `atic_min_ip_flow_sum_max` */

DROP TABLE IF EXISTS `atic_min_ip_flow_sum_max`;

CREATE TABLE `atic_min_ip_flow_sum_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_ip_flow_sum_max` */

/*Table structure for table `atic_min_ip_flow_sum_forward_max` */

DROP TABLE IF EXISTS `atic_min_ip_flow_sum_forward_max`;

CREATE TABLE `atic_min_ip_flow_sum_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_ip_flow_sum_forward_max` */

/*Table structure for table `atic_ip_flow_sum_max` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_max`;

CREATE TABLE `atic_ip_flow_sum_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_max` */

/*Table structure for table `atic_ip_flow_sum_forward_max` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_forward_max`;

CREATE TABLE `atic_ip_flow_sum_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*Data for the table `atic_ip_flow_sum_forward_max` */

/*Table structure for table `atic_ip_flow_sum_max_d` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_max_d`;

CREATE TABLE `atic_ip_flow_sum_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_max_d` */

/*Table structure for table `atic_ip_flow_sum_forward_max_d` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_forward_max_d`;

CREATE TABLE `atic_ip_flow_sum_forward_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*Data for the table `atic_ip_flow_sum_forward_max_d` */

/*Table structure for table `atic_ip_flow_sum_max_h` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_max_h`;

CREATE TABLE `atic_ip_flow_sum_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_max_h` */

/*Table structure for table `atic_ip_flow_sum_forward_max_h` */

DROP TABLE IF EXISTS `atic_ip_flow_sum_forward_max_h`;

CREATE TABLE `atic_ip_flow_sum_forward_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_flow_sum_forward_max_h` */

/*Table structure for table `atic_ip_in` */

DROP TABLE IF EXISTS `atic_ip_in`;

CREATE TABLE `atic_ip_in` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_in` */

/*Table structure for table `atic_ip_in_d` */

DROP TABLE IF EXISTS `atic_ip_in_d`;

CREATE TABLE `atic_ip_in_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_in_d` */

/*Table structure for table `atic_ip_in_h` */

DROP TABLE IF EXISTS `atic_ip_in_h`;

CREATE TABLE `atic_ip_in_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_in_h` */

/*Table structure for table `atic_ip_in_max` */

DROP TABLE IF EXISTS `atic_ip_in_max`;

CREATE TABLE `atic_ip_in_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_in_max` */

/*Table structure for table `atic_ip_forward_max` */

DROP TABLE IF EXISTS `atic_ip_forward_max`;

CREATE TABLE `atic_ip_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_forward_max` */

/*Table structure for table `atic_ip_forward` */

DROP TABLE IF EXISTS `atic_ip_forward`;

CREATE TABLE `atic_ip_forward` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_forward` */

/*Table structure for table `atic_ip_forward_d` */

DROP TABLE IF EXISTS `atic_ip_forward_d`;

CREATE TABLE `atic_ip_forward_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_forward_d` */

/*Table structure for table `atic_ip_forward_h` */

DROP TABLE IF EXISTS `atic_ip_forward_h`;

CREATE TABLE `atic_ip_forward_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_forward_h` */

/*Table structure for table `atic_ip_userdef_dns_type` */

DROP TABLE IF EXISTS `atic_ip_userdef_dns_type`;

CREATE TABLE `atic_ip_userdef_dns_type` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TYPE_CODE` int(10) unsigned DEFAULT NULL,
  `CODE_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_userdef_dns_type` */

/*Table structure for table `atic_ip_userdef_dns_type_d` */

DROP TABLE IF EXISTS `atic_ip_userdef_dns_type_d`;

CREATE TABLE `atic_ip_userdef_dns_type_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TYPE_CODE` int(10) unsigned DEFAULT NULL,
  `CODE_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_userdef_dns_type_d` */

/*Table structure for table `atic_ip_userdef_dns_type_h` */

DROP TABLE IF EXISTS `atic_ip_userdef_dns_type_h`;

CREATE TABLE `atic_ip_userdef_dns_type_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TYPE_CODE` int(10) unsigned DEFAULT NULL,
  `CODE_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_IP` (`ZONE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_ip_userdef_dns_type_h` */

/*Table structure for table `atic_location_flow_sum` */

DROP TABLE IF EXISTS `atic_location_flow_sum`;

CREATE TABLE `atic_location_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOCATION_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_location_flow_sum` */

/*Table structure for table `atic_location_flow_sum_d` */

DROP TABLE IF EXISTS `atic_location_flow_sum_d`;

CREATE TABLE `atic_location_flow_sum_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOCATION_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_location_flow_sum_d` */

/*Table structure for table `atic_location_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_location_flow_sum_drop`;

CREATE TABLE `atic_location_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOCATION_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_location_flow_sum_drop` */

/*Table structure for table `atic_location_flow_sum_drop_d` */

DROP TABLE IF EXISTS `atic_location_flow_sum_drop_d`;

CREATE TABLE `atic_location_flow_sum_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOCATION_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_location_flow_sum_drop_d` */

/*Table structure for table `atic_location_flow_sum_drop_h` */

DROP TABLE IF EXISTS `atic_location_flow_sum_drop_h`;

CREATE TABLE `atic_location_flow_sum_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOCATION_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_location_flow_sum_drop_h` */

/*Table structure for table `atic_location_flow_sum_h` */

DROP TABLE IF EXISTS `atic_location_flow_sum_h`;

CREATE TABLE `atic_location_flow_sum_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `LOCATION_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_location_flow_sum_h` */

/*Table structure for table `atic_min_sum_dev_flow` */

DROP TABLE IF EXISTS `atic_min_sum_dev_flow`;

CREATE TABLE `atic_min_sum_dev_flow` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_sum_dev_flow` */

/*Table structure for table `atic_min_sum_ip_flow` */

DROP TABLE IF EXISTS `atic_min_sum_ip_flow`;

CREATE TABLE `atic_min_sum_ip_flow` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `TOTAL_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_sum_ip_flow` */

/*Table structure for table `atic_min_sum_zone_flow` */

DROP TABLE IF EXISTS `atic_min_sum_zone_flow`;

CREATE TABLE `atic_min_sum_zone_flow` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_IN_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS_DROP_MAX` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_sum_zone_flow` */

/*Table structure for table `atic_partition_rule` */

DROP TABLE IF EXISTS `atic_partition_rule`;

CREATE TABLE `atic_partition_rule` (
  `RULE_ID` int(2) NOT NULL AUTO_INCREMENT,
  `PARTITION_TIME` int(2) NOT NULL DEFAULT '1',
  `PARTITION_UNIT` enum('D','M','H') NOT NULL DEFAULT 'M',
  `PARTITION_HOLD_TIME` int(2) NOT NULL DEFAULT '12',
  `PARTITION_HOLD_UNIT` enum('D','M') NOT NULL DEFAULT 'M',
  `TABLES` varchar(8000) DEFAULT NULL,
  `PARTITION_EXPRESSION` varchar(200) NOT NULL DEFAULT 'LOG_TIME',
  `H0LD_TYPE` enum('D','H','M','Y') NOT NULL DEFAULT 'M' COMMENT 'for matching atic,when atic changed hold time,collector changged by this field. D is original table ,M is hour table,Y is day table.',
  `REFRESH_MARK` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`RULE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_partition_rule` */

insert  into `atic_partition_rule`(`RULE_ID`,`PARTITION_TIME`,`PARTITION_UNIT`,`PARTITION_HOLD_TIME`,`PARTITION_HOLD_UNIT`,`TABLES`,`PARTITION_EXPRESSION`,`H0LD_TYPE`,`REFRESH_MARK`) values (1,1,'D',90,'D','ATIC_IP_IN,ATIC_IP_IN_MAX,ATIC_IP_DROP,ATIC_IP_DROP_MAX,ATIC_ZONE_IN,ATIC_ZONE_IN_MAX,ATIC_ZONE_DROP,ATIC_ZONE_DROP_MAX,ATIC_IP_FLOW_SUM,ATIC_IP_FLOW_SUM_MAX,ATIC_IP_FLOW_SUM_DROP,ATIC_IP_FLOW_SUM_DROP_MAX,ATIC_ZONE_FLOW_SUM,ATIC_ZONE_FLOW_SUM_MAX,ATIC_ZONE_FLOW_SUM_DROP,ATIC_ZONE_FLOW_SUM_DROP_MAX,ATIC_SRC_DNS_TOPN,ATIC_DNS_TOPN,ATIC_STATIC_DNS_CACHE,ATIC_IP_ATTACK_FLOW,ATIC_ZONE_ATTACK_FLOW,ATIC_IP_USERDEF_DNS_TYPE,ATIC_ZONE_USERDEF_DNS_TYPE,ATIC_DNS_DEFEND,ATIC_ZOMBIE_INFO,atic_location_flow_sum,atic_location_flow_sum_drop','LOG_TIME','D',0),(2,1,'M',12,'M','ATIC_ZONE_IN_H,ATIC_ZONE_DROP_H,ATIC_IP_BIZ_TCP_H,ATIC_IP_BIZ_TCP_MAX_H,ATIC_IP_BIZ_TCP_DROP_H,ATIC_IP_BIZ_TCP_DROP_MAX_H,ATIC_ZONE_BIZ_TCP_H,ATIC_ZONE_BIZ_TCP_MAX_H,ATIC_ZONE_BIZ_TCP_DROP_H,ATIC_ZONE_BIZ_TCP_DROP_MAX_H,ATIC_IP_BIZ_UDP_H,ATIC_IP_BIZ_UDP_MAX_H,ATIC_IP_BIZ_UDP_DROP_H,ATIC_IP_BIZ_UDP_DROP_MAX_H,ATIC_ZONE_BIZ_UDP_H,ATIC_ZONE_BIZ_UDP_MAX_H,ATIC_ZONE_BIZ_UDP_DROP_H,ATIC_ZONE_BIZ_UDP_DROP_MAX_H,ATIC_IP_BIZ_HTTP_H,ATIC_IP_BIZ_HTTP_MAX_H,ATIC_IP_BIZ_HTTP_DROP_H,ATIC_IP_BIZ_HTTP_DROP_MAX_H,ATIC_ZONE_BIZ_HTTP_H,ATIC_ZONE_BIZ_HTTP_MAX_H,ATIC_ZONE_BIZ_HTTP_DROP_H,ATIC_ZONE_BIZ_HTTP_DROP_MAX_H,ATIC_IP_BIZ_HTTPS_H,ATIC_IP_BIZ_HTTPS_MAX_H,ATIC_IP_BIZ_HTTPS_DROP_H,ATIC_IP_BIZ_HTTPS_DROP_MAX_H,ATIC_ZONE_BIZ_HTTPS_H,ATIC_ZONE_BIZ_HTTPS_MAX_H,ATIC_ZONE_BIZ_HTTPS_DROP_H,ATIC_ZONE_BIZ_HTTPS_DROP_MAX_H,ATIC_IP_BIZ_TCP_DNS_H,ATIC_IP_BIZ_TCP_DNS_MAX_H,ATIC_IP_BIZ_TCP_DNS_DROP_H,ATIC_IP_BIZ_TCP_DNS_DROP_MAX_H,ATIC_ZONE_BIZ_TCP_DNS_H,ATIC_ZONE_BIZ_TCP_DNS_MAX_H,ATIC_ZONE_BIZ_TCP_DNS_DROP_H,ATIC_ZONE_BIZ_TCP_DNS_DROP_MAX_H,ATIC_IP_BIZ_UDP_DNS_H,ATIC_IP_BIZ_UDP_DNS_MAX_H,ATIC_IP_BIZ_UDP_DNS_DROP_H,ATIC_IP_BIZ_UDP_DNS_DROP_MAX_H,ATIC_ZONE_BIZ_UDP_DNS_H,ATIC_ZONE_BIZ_UDP_DNS_MAX_H,ATIC_ZONE_BIZ_UDP_DNS_DROP_H,ATIC_ZONE_BIZ_UDP_DNS_DROP_MAX_H,ATIC_IP_BIZ_SIP_H,ATIC_IP_BIZ_SIP_MAX_H,ATIC_IP_BIZ_SIP_DROP_H,ATIC_IP_BIZ_SIP_DROP_MAX_H,ATIC_ZONE_BIZ_SIP_H,ATIC_ZONE_BIZ_SIP_MAX_H,ATIC_ZONE_BIZ_SIP_DROP_H,ATIC_ZONE_BIZ_SIP_DROP_MAX_H,ATIC_IP_BIZ_OTHER_H,ATIC_IP_BIZ_OTHER_MAX_H,ATIC_IP_BIZ_OTHER_DROP_H,ATIC_IP_BIZ_OTHER_DROP_MAX_H,ATIC_ZONE_BIZ_OTHER_H,ATIC_ZONE_BIZ_OTHER_MAX_H,ATIC_ZONE_BIZ_OTHER_DROP_H,ATIC_ZONE_BIZ_OTHER_DROP_MAX_H,ATIC_ZONE_FLOW_SUM_H,ATIC_ZONE_FLOW_SUM_MAX_H,ATIC_ZONE_FLOW_SUM_DROP_H,ATIC_ZONE_FLOW_SUM_DROP_MAX_H,ATIC_BIZ_FLOW_SUM_H,ATIC_BIZ_FLOW_SUM_MAX_H,ATIC_BIZ_FLOW_SUM_DROP_H,ATIC_BIZ_FLOW_SUM_DROP_MAX_H,ATIC_SRC_DNS_TOPN_H,ATIC_DNS_TOPN_H,ATIC_STATIC_DNS_CACHE_H,ATIC_DEV_FLOW_SUM_H,ATIC_DEV_FLOW_SUM_DROP_H,ATIC_DEV_FLOW_SUM_DROP_MAX_H,ATIC_DEV_FLOW_SUM_MAX_H,ATIC_SLOT_FLOW_SUM_H,ATIC_SLOT_FLOW_SUM_DROP_H,ATIC_IP_ATTACK_FLOW_H,ATIC_ZONE_ATTACK_FLOW_H,ATIC_IP_USERDEF_DNS_TYPE_H,ATIC_ZONE_USERDEF_DNS_TYPE_H,ATIC_DNS_DEFEND_H,ATIC_ZOMBIE_INFO_H,ATIC_IP_ANOMALY_TIMES_H,atic_location_flow_sum_h,atic_location_flow_sum_drop_h','LOG_TIME','M',0),(3,6,'M',12,'M','ATIC_IP_IN_D,ATIC_IP_DROP_D,ATIC_ZONE_IN_D,ATIC_ZONE_DROP_D,ATIC_IP_BIZ_TCP_D,ATIC_IP_BIZ_TCP_MAX_D,ATIC_IP_BIZ_TCP_DROP_D,ATIC_IP_BIZ_TCP_DROP_MAX_D,ATIC_ZONE_BIZ_TCP_D,ATIC_ZONE_BIZ_TCP_MAX_D,ATIC_ZONE_BIZ_TCP_DROP_D,ATIC_ZONE_BIZ_TCP_DROP_MAX_D,ATIC_IP_BIZ_UDP_D,ATIC_IP_BIZ_UDP_MAX_D,ATIC_IP_BIZ_UDP_DROP_D,ATIC_IP_BIZ_UDP_DROP_MAX_D,ATIC_ZONE_BIZ_UDP_D,ATIC_ZONE_BIZ_UDP_MAX_D,ATIC_ZONE_BIZ_UDP_DROP_D,ATIC_ZONE_BIZ_UDP_DROP_MAX_D,ATIC_IP_BIZ_HTTP_D,ATIC_IP_BIZ_HTTP_MAX_D,ATIC_IP_BIZ_HTTP_DROP_D,ATIC_IP_BIZ_HTTP_DROP_MAX_D,ATIC_ZONE_BIZ_HTTP_D,ATIC_ZONE_BIZ_HTTP_MAX_D,ATIC_ZONE_BIZ_HTTP_DROP_D,ATIC_ZONE_BIZ_HTTP_DROP_MAX_D,ATIC_IP_BIZ_HTTPS_D,ATIC_IP_BIZ_HTTPS_MAX_D,ATIC_IP_BIZ_HTTPS_DROP_D,ATIC_IP_BIZ_HTTPS_DROP_MAX_D,ATIC_ZONE_BIZ_HTTPS_D,ATIC_ZONE_BIZ_HTTPS_MAX_D,ATIC_ZONE_BIZ_HTTPS_DROP_D,ATIC_ZONE_BIZ_HTTPS_DROP_MAX_D,ATIC_IP_BIZ_TCP_DNS_D,ATIC_IP_BIZ_TCP_DNS_MAX_D,ATIC_IP_BIZ_TCP_DNS_DROP_D,ATIC_IP_BIZ_TCP_DNS_DROP_MAX_D,ATIC_ZONE_BIZ_TCP_DNS_D,ATIC_ZONE_BIZ_TCP_DNS_MAX_D,ATIC_ZONE_BIZ_TCP_DNS_DROP_D,ATIC_ZONE_BIZ_TCP_DNS_DROP_MAX_D,ATIC_IP_BIZ_UDP_DNS_D,ATIC_IP_BIZ_UDP_DNS_MAX_D,ATIC_IP_BIZ_UDP_DNS_DROP_D,ATIC_IP_BIZ_UDP_DNS_DROP_MAX_D,ATIC_ZONE_BIZ_UDP_DNS_D,ATIC_ZONE_BIZ_UDP_DNS_MAX_D,ATIC_ZONE_BIZ_UDP_DNS_DROP_D,ATIC_ZONE_BIZ_UDP_DNS_DROP_MAX_D,ATIC_IP_BIZ_SIP_D,ATIC_IP_BIZ_SIP_MAX_D,ATIC_IP_BIZ_SIP_DROP_D,ATIC_IP_BIZ_SIP_DROP_MAX_D,ATIC_ZONE_BIZ_SIP_D,ATIC_ZONE_BIZ_SIP_MAX_D,ATIC_ZONE_BIZ_SIP_DROP_D,ATIC_ZONE_BIZ_SIP_DROP_MAX_D,ATIC_IP_BIZ_OTHER_D,ATIC_IP_BIZ_OTHER_MAX_D,ATIC_IP_BIZ_OTHER_DROP_D,ATIC_IP_BIZ_OTHER_DROP_MAX_D,ATIC_ZONE_BIZ_OTHER_D,ATIC_ZONE_BIZ_OTHER_MAX_D,ATIC_ZONE_BIZ_OTHER_DROP_D,ATIC_ZONE_BIZ_OTHER_DROP_MAX_D,ATIC_IP_FLOW_SUM_D,ATIC_IP_FLOW_SUM_MAX_D,ATIC_IP_FLOW_SUM_DROP_D,ATIC_IP_FLOW_SUM_DROP_MAX_D,ATIC_ZONE_FLOW_SUM_D,ATIC_ZONE_FLOW_SUM_MAX_D,ATIC_ZONE_FLOW_SUM_DROP_D,ATIC_ZONE_FLOW_SUM_DROP_MAX_D,ATIC_BIZ_FLOW_SUM_D,ATIC_BIZ_FLOW_SUM_MAX_D,ATIC_BIZ_FLOW_SUM_DROP_D,ATIC_BIZ_FLOW_SUM_DROP_MAX_D,ATIC_SRC_DNS_TOPN_D,ATIC_DNS_TOPN_D,ATIC_STATIC_DNS_CACHE_D,ATIC_DEV_FLOW_SUM_D,ATIC_DEV_FLOW_SUM_DROP_D,ATIC_DEV_FLOW_SUM_DROP_MAX_D,ATIC_DEV_FLOW_SUM_MAX_D,ATIC_SLOT_FLOW_SUM_D,ATIC_SLOT_FLOW_SUM_DROP_D,ATIC_IP_ATTACK_FLOW_D,ATIC_ZONE_ATTACK_FLOW_D,ATIC_IP_USERDEF_DNS_TYPE_D,ATIC_ZONE_USERDEF_DNS_TYPE_D,ATIC_DNS_DEFEND_D,ATIC_ZOMBIE_INFO_D,ATIC_IP_ANOMALY_TIMES_D,atic_location_flow_sum_d,atic_location_flow_sum_drop_d','LOG_TIME','Y',0),(4,1,'M',12,'M','ATIC_IP_ATTACK_EXACT_lOG,ATIC_IP_ATTACK_LOG','START_TIME_ALERT','M',0),(5,7,'D',12,'M','ATIC_IP_FLOW_SUM_H,ATIC_IP_FLOW_SUM_DROP_H,ATIC_IP_IN_H,ATIC_IP_DROP_H,ATIC_IP_FLOW_SUM_MAX_H,ATIC_IP_FLOW_SUM_DROP_MAX_H','LOG_TIME','M',0),(6,7,'D',90,'D','ATIC_BIZ_FLOW_SUM,ATIC_BIZ_FLOW_SUM_MAX,ATIC_BIZ_FLOW_SUM_DROP,ATIC_BIZ_FLOW_SUM_DROP_MAX,ATIC_DEV_FLOW_SUM,ATIC_DEV_FLOW_SUM_DROP,ATIC_DEV_FLOW_SUM_DROP_MAX,ATIC_DEV_FLOW_SUM_MAX,ATIC_SLOT_FLOW_SUM,ATIC_SLOT_FLOW_SUM_DROP,ATIC_IP_BIZ_TCP,ATIC_IP_BIZ_TCP_MAX,ATIC_IP_BIZ_TCP_DROP,ATIC_IP_BIZ_TCP_DROP_MAX,ATIC_ZONE_BIZ_TCP,ATIC_ZONE_BIZ_TCP_MAX,ATIC_ZONE_BIZ_TCP_DROP,ATIC_ZONE_BIZ_TCP_DROP_MAX,ATIC_IP_BIZ_UDP,ATIC_IP_BIZ_UDP_MAX,ATIC_IP_BIZ_UDP_DROP,ATIC_IP_BIZ_UDP_DROP_MAX,ATIC_ZONE_BIZ_UDP,ATIC_ZONE_BIZ_UDP_MAX,ATIC_ZONE_BIZ_UDP_DROP,ATIC_ZONE_BIZ_UDP_DROP_MAX,ATIC_IP_BIZ_HTTP,ATIC_IP_BIZ_HTTP_MAX,ATIC_IP_BIZ_HTTP_DROP,ATIC_IP_BIZ_HTTP_DROP_MAX,ATIC_ZONE_BIZ_HTTP,ATIC_ZONE_BIZ_HTTP_MAX,ATIC_ZONE_BIZ_HTTP_DROP,ATIC_ZONE_BIZ_HTTP_DROP_MAX,ATIC_IP_BIZ_HTTPS,ATIC_IP_BIZ_HTTPS_MAX,ATIC_IP_BIZ_HTTPS_DROP,ATIC_IP_BIZ_HTTPS_DROP_MAX,ATIC_ZONE_BIZ_HTTPS,ATIC_ZONE_BIZ_HTTPS_MAX,ATIC_ZONE_BIZ_HTTPS_DROP,ATIC_ZONE_BIZ_HTTPS_DROP_MAX,ATIC_IP_BIZ_TCP_DNS,ATIC_IP_BIZ_TCP_DNS_MAX,ATIC_IP_BIZ_TCP_DNS_DROP,ATIC_IP_BIZ_TCP_DNS_DROP_MAX,ATIC_ZONE_BIZ_TCP_DNS,ATIC_ZONE_BIZ_TCP_DNS_MAX,ATIC_ZONE_BIZ_TCP_DNS_DROP,ATIC_ZONE_BIZ_TCP_DNS_DROP_MAX,ATIC_IP_BIZ_UDP_DNS,ATIC_IP_BIZ_UDP_DNS_MAX,ATIC_IP_BIZ_UDP_DNS_DROP,ATIC_IP_BIZ_UDP_DNS_DROP_MAX,ATIC_ZONE_BIZ_UDP_DNS,ATIC_ZONE_BIZ_UDP_DNS_MAX,ATIC_ZONE_BIZ_UDP_DNS_DROP,ATIC_ZONE_BIZ_UDP_DNS_DROP_MAX,ATIC_IP_BIZ_SIP,ATIC_IP_BIZ_SIP_MAX,ATIC_IP_BIZ_SIP_DROP,ATIC_IP_BIZ_SIP_DROP_MAX,ATIC_ZONE_BIZ_SIP,ATIC_ZONE_BIZ_SIP_MAX,ATIC_ZONE_BIZ_SIP_DROP,ATIC_ZONE_BIZ_SIP_DROP_MAX,ATIC_IP_BIZ_OTHER,ATIC_IP_BIZ_OTHER_MAX,ATIC_IP_BIZ_OTHER_DROP,ATIC_IP_BIZ_OTHER_DROP_MAX,ATIC_ZONE_BIZ_OTHER,ATIC_ZONE_BIZ_OTHER_MAX,ATIC_ZONE_BIZ_OTHER_DROP,ATIC_ZONE_BIZ_OTHER_DROP_MAX','LOG_TIME','D',0),(7,1,'H',1,'D','ATIC_MIN_SUM_IP_FLOW,ATIC_MIN_SUM_ZONE_FLOW,ATIC_MIN_SUM_DEV_FLOW','LOG_TIME','H',0),(8,24,'H',2,'D','atic_zone_blacklist_history','END_TIME','H',0);

/*Table structure for table `atic_pcap_file` */

DROP TABLE IF EXISTS `atic_pcap_file`;

CREATE TABLE `atic_pcap_file` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `PCAP_ID` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned DEFAULT NULL,
  `FILE_NAME` varchar(255) NOT NULL,
  `PCAP_TYPE` int(11) NOT NULL,
  `ZONE_ID` int(10) NOT NULL,
  `ZONE_IP` varchar(40) DEFAULT '',
  `STATUS` int(11) NOT NULL,
  `PCAP_NUMBER` int(11) NOT NULL,
  `FILE_SIZE` int(11) NOT NULL,
  `START_TIME` int(10) unsigned NOT NULL,
  `END_TIME` int(10) unsigned NOT NULL,
  `ATTACK_TYPE` int(10) unsigned DEFAULT NULL,
  `PROTOCOL` int(10) unsigned DEFAULT NULL,
  `PORT` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`PKID`),
  UNIQUE KEY `FILE_NAME` (`FILE_NAME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_pcap_file` */

/*Table structure for table `atic_service_learning_task` */

DROP TABLE IF EXISTS `atic_service_learning_task`;

CREATE TABLE `atic_service_learning_task` (
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `START_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `END_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_service_learning_task` */

/*Table structure for table `atic_slot_flow_sum` */

DROP TABLE IF EXISTS `atic_slot_flow_sum`;

CREATE TABLE `atic_slot_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `SLOT_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_slot_flow_sum` */

/*Table structure for table `atic_slot_flow_sum_d` */

DROP TABLE IF EXISTS `atic_slot_flow_sum_d`;

CREATE TABLE `atic_slot_flow_sum_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `SLOT_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_slot_flow_sum_d` */

/*Table structure for table `atic_slot_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_slot_flow_sum_drop`;

CREATE TABLE `atic_slot_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `SLOT_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_slot_flow_sum_drop` */

/*Table structure for table `atic_slot_flow_sum_drop_d` */

DROP TABLE IF EXISTS `atic_slot_flow_sum_drop_d`;

CREATE TABLE `atic_slot_flow_sum_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `SLOT_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_slot_flow_sum_drop_d` */

/*Table structure for table `atic_slot_flow_sum_drop_h` */

DROP TABLE IF EXISTS `atic_slot_flow_sum_drop_h`;

CREATE TABLE `atic_slot_flow_sum_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `SLOT_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_slot_flow_sum_drop_h` */

/*Table structure for table `atic_slot_flow_sum_h` */

DROP TABLE IF EXISTS `atic_slot_flow_sum_h`;

CREATE TABLE `atic_slot_flow_sum_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `SLOT_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_slot_flow_sum_h` */

/*Table structure for table `atic_src_dns_topn` */

DROP TABLE IF EXISTS `atic_src_dns_topn`;

CREATE TABLE `atic_src_dns_topn` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SRC_IP` varchar(40) NOT NULL DEFAULT '',
  `TOPN_TYPE` int(2) NOT NULL DEFAULT '7',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_SRC_IP` (`SRC_IP`),
  KEY `KEY_TOPN_TYPE` (`TOPN_TYPE`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_src_dns_topn` */

/*Table structure for table `atic_src_dns_topn_d` */

DROP TABLE IF EXISTS `atic_src_dns_topn_d`;

CREATE TABLE `atic_src_dns_topn_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SRC_IP` varchar(40) NOT NULL DEFAULT '',
  `TOPN_TYPE` int(2) NOT NULL DEFAULT '7',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_SRC_IP` (`SRC_IP`),
  KEY `KEY_TOPN_TYPE` (`TOPN_TYPE`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_src_dns_topn_d` */

/*Table structure for table `atic_src_dns_topn_h` */

DROP TABLE IF EXISTS `atic_src_dns_topn_h`;

CREATE TABLE `atic_src_dns_topn_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `SRC_IP` varchar(40) NOT NULL DEFAULT '',
  `TOPN_TYPE` int(2) NOT NULL DEFAULT '7',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_SRC_IP` (`SRC_IP`),
  KEY `KEY_TOPN_TYPE` (`TOPN_TYPE`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_src_dns_topn_h` */

/*Table structure for table `atic_static_dns_cache` */

DROP TABLE IF EXISTS `atic_static_dns_cache`;

CREATE TABLE `atic_static_dns_cache` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_NAME` varchar(255) NOT NULL DEFAULT '0',
  `REQUEST_TYPE` varchar(10) NOT NULL DEFAULT '',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_static_dns_cache` */

/*Table structure for table `atic_static_dns_cache_d` */

DROP TABLE IF EXISTS `atic_static_dns_cache_d`;

CREATE TABLE `atic_static_dns_cache_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_NAME` varchar(255) NOT NULL DEFAULT '0',
  `REQUEST_TYPE` varchar(10) NOT NULL DEFAULT '',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_static_dns_cache_d` */

/*Table structure for table `atic_static_dns_cache_h` */

DROP TABLE IF EXISTS `atic_static_dns_cache_h`;

CREATE TABLE `atic_static_dns_cache_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_NAME` varchar(255) NOT NULL DEFAULT '0',
  `REQUEST_TYPE` varchar(10) NOT NULL DEFAULT '',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_static_dns_cache_h` */

/*Table structure for table `atic_system_conf` */

DROP TABLE IF EXISTS `atic_system_conf`;

CREATE TABLE `atic_system_conf` (
  `PKID` int(10) NOT NULL AUTO_INCREMENT,
  `SYS_VAR` varchar(255) DEFAULT NULL,
  `SYS_VALUE` text,
  `REMARK` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`PKID`),
  KEY `KEY_SYS_VAR` (`SYS_VAR`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_system_conf` */

insert  into `atic_system_conf`(`PKID`,`SYS_VAR`,`SYS_VALUE`,`REMARK`) values (1,'table_d_hold_days','10','day table hold days in database'),(2,'table_m_hold_months','3','month table hold months in database'),(3,'table_y_hold_years','3','year table hold years in database'),(4,'server_ip','','ATIC Server IP'),(5,'rmi_ssl','false',''),(7,'logserver_ip','',''),(12,'devMonitor_hold_days','1','device perf hold days in database'),(13,'collectorMonitor_hold_days','1','collector perf hold days in database'),(14,'divert_delay_time','300','diversion stop delay time'),(15,'dev_dont_work_interval','300','unit is second'),(16,'collector_version','0','0 is ATIC version,1 is nip manager,2 is simply nip manager for report'),(17,'day_count_time','0','record the time which the anmaly count thread excute day count'),(18,'hour_count_time','0','record the time which the anmaly count thread excute hour count'),(19,'html_adaptor_start','0','1 is start html_adaptor,0 is not'),(20,'html_adaptor_port','9092','if start html adaptor,collector will use this port for commnication.'),(21,'blackhole_enable','0','blackhole_enable.0 is disable,1 is enable.'),(22,'blackhole_threshold','100','blackhole threshold'),(23,'aes_key','','aes keyword'),(24,'creat_reportData_csvFile','0','1 is super atic for china mobile,should creat csv file data, 0 is not'),(27,'disk_threshold','5120','unit is MB'),(28,'syslog_attack_enabled','true',''),(29,'syslog_abnormal_enabled','true',''),(30,'syslog_attacking','true',''),(31,'syslog_attack_detail','true',''),(32,'syslog_attack_severity','0',''),(33,'syslog_flow_enabled','true',''),(34,'logserver_port','514',''),(35,'protal_sftp_server','','The sftp server ip of MSS.'),(36,'protal_sftp_port','',''),(37,'protal_sftp_username','',''),(38,'protal_sftp_pwd','',''),(39,'syslog_transfer_protocol','',''),(40,'syslog_outbound_flow_enabled','',''),(41,'syslog_outbound_attack_enabled','',''),(42,'syslog_outbound_abnormal_enabled','',''),(43,'syslog_outbound_attack_detail','',''),(44,'syslog_outbound_attacking','',''),(45,'syslog_ip_flow_seconds','','');

/*Table structure for table `atic_userdef_biz_relation` */

DROP TABLE IF EXISTS `atic_userdef_biz_relation`;

CREATE TABLE `atic_userdef_biz_relation` (
  `DEVICE_IP` varchar(64) DEFAULT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` varchar(64) DEFAULT NULL,
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_userdef_biz_relation` */

/*Table structure for table `atic_zombie_info` */

DROP TABLE IF EXISTS `atic_zombie_info`;

CREATE TABLE `atic_zombie_info` (
  `LOG_TIME` int(10) unsigned DEFAULT NULL COMMENT 'TIME',
  `DEVICE_IP` varchar(40) DEFAULT '',
  `DEVICE_TYPE` int(1) unsigned DEFAULT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BOT_ID` int(10) unsigned DEFAULT NULL,
  `BOT_TYPE` int(4) unsigned DEFAULT NULL,
  `BOT_ROLE` int(4) unsigned DEFAULT NULL,
  `BOT_TYPE_NUM` int(4) unsigned DEFAULT NULL,
  `BOT_ROLE_NUM` int(4) unsigned DEFAULT NULL,
  `DEST_IP` varchar(40) DEFAULT '',
  `SRC_IP` varchar(40) DEFAULT '',
  `DEST_PORT` int(10) unsigned DEFAULT NULL,
  `SRC_PORT` int(10) unsigned DEFAULT NULL,
  `IS_DIRECT` int(1) unsigned DEFAULT NULL,
  `L4_PROTOCOL` int(10) unsigned DEFAULT NULL,
  `L7_protocol` int(10) unsigned DEFAULT NULL,
  `IS_FILTER` int(1) unsigned DEFAULT NULL,
  `DETECT_TIME` int(10) unsigned DEFAULT NULL,
  `AGE_TIME` int(10) unsigned DEFAULT NULL,
  `PASS_PACKETS` int(10) unsigned DEFAULT NULL,
  `FILTER_PACKETS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_DEST_IP` (`DEST_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zombie_info` */

/*Table structure for table `atic_zombie_info_d` */

DROP TABLE IF EXISTS `atic_zombie_info_d`;

CREATE TABLE `atic_zombie_info_d` (
  `LOG_TIME` int(10) unsigned DEFAULT NULL COMMENT 'TIME',
  `DEVICE_IP` varchar(40) DEFAULT '',
  `DEVICE_TYPE` int(1) unsigned DEFAULT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BOT_ID` int(10) unsigned DEFAULT NULL,
  `BOT_TYPE` int(4) unsigned DEFAULT NULL,
  `BOT_ROLE` int(4) unsigned DEFAULT NULL,
  `BOT_TYPE_NUM` int(4) unsigned DEFAULT NULL,
  `BOT_ROLE_NUM` int(4) unsigned DEFAULT NULL,
  `DEST_IP` varchar(40) DEFAULT '',
  `SRC_IP` varchar(40) DEFAULT '',
  `DEST_PORT` int(10) unsigned DEFAULT NULL,
  `SRC_PORT` int(10) unsigned DEFAULT NULL,
  `IS_DIRECT` int(1) unsigned DEFAULT NULL,
  `L4_PROTOCOL` int(10) unsigned DEFAULT NULL,
  `L7_protocol` int(10) unsigned DEFAULT NULL,
  `IS_FILTER` int(1) unsigned DEFAULT NULL,
  `DETECT_TIME` int(10) unsigned DEFAULT NULL,
  `AGE_TIME` int(10) unsigned DEFAULT NULL,
  `PASS_PACKETS` int(10) unsigned DEFAULT NULL,
  `FILTER_PACKETS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_DEST_IP` (`DEST_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zombie_info_d` */

/*Table structure for table `atic_zombie_info_h` */

DROP TABLE IF EXISTS `atic_zombie_info_h`;

CREATE TABLE `atic_zombie_info_h` (
  `LOG_TIME` int(10) unsigned DEFAULT NULL COMMENT 'TIME',
  `DEVICE_IP` varchar(40) DEFAULT '',
  `DEVICE_TYPE` int(1) unsigned DEFAULT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BOT_ID` int(10) unsigned DEFAULT NULL,
  `BOT_TYPE` int(4) unsigned DEFAULT NULL,
  `BOT_ROLE` int(4) unsigned DEFAULT NULL,
  `BOT_TYPE_NUM` int(4) unsigned DEFAULT NULL,
  `BOT_ROLE_NUM` int(4) unsigned DEFAULT NULL,
  `DEST_IP` varchar(40) DEFAULT '',
  `SRC_IP` varchar(40) DEFAULT '',
  `DEST_PORT` int(10) unsigned DEFAULT NULL,
  `SRC_PORT` int(10) unsigned DEFAULT NULL,
  `IS_DIRECT` int(1) unsigned DEFAULT NULL,
  `L4_PROTOCOL` int(10) unsigned DEFAULT NULL,
  `L7_protocol` int(10) unsigned DEFAULT NULL,
  `IS_FILTER` int(1) unsigned DEFAULT NULL,
  `DETECT_TIME` int(10) unsigned DEFAULT NULL,
  `AGE_TIME` int(10) unsigned DEFAULT NULL,
  `PASS_PACKETS` int(10) unsigned DEFAULT NULL,
  `FILTER_PACKETS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`),
  KEY `KEY_DEST_IP` (`DEST_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zombie_info_h` */

/*Table structure for table `atic_zone_attack_flow` */

DROP TABLE IF EXISTS `atic_zone_attack_flow`;

CREATE TABLE `atic_zone_attack_flow` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_KBPS` int(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PPS` int(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_attack_flow` */

/*Table structure for table `atic_zone_attack_flow_d` */

DROP TABLE IF EXISTS `atic_zone_attack_flow_d`;

CREATE TABLE `atic_zone_attack_flow_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_KBPS` int(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PPS` int(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_attack_flow_d` */

/*Table structure for table `atic_zone_attack_flow_h` */

DROP TABLE IF EXISTS `atic_zone_attack_flow_h`;

CREATE TABLE `atic_zone_attack_flow_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `PROTOCOL` int(10) unsigned NOT NULL DEFAULT '0',
  `PORT` int(10) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_KBPS` int(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PPS` int(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `PORTS` varchar(2000) NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_attack_flow_h` */

/*Table structure for table `atic_zone_attack_log` */

DROP TABLE IF EXISTS `atic_zone_attack_log`;

CREATE TABLE `atic_zone_attack_log` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `START_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `END_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DURATION` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TIMES` int(10) unsigned NOT NULL DEFAULT '0',
  `ATTACK_STATUS` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `DROP_BYTES` bigint(20) unsigned NOT NULL DEFAULT '0',
  `DROP_PACKETS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `ATTACK_TYPES` varchar(255) NOT NULL DEFAULT '0',
  `SRC_IP` varchar(5000) DEFAULT '0',
  `DST_IP` varchar(5000) DEFAULT '0',
  `MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_DROP_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_PPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_MAX_IN_KBPS` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_NEW_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  `IP_TCP_CONCUR_CONN` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`PKID`),
  KEY `ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_attack_log` */

/*Table structure for table `atic_zone_biz_http` */

DROP TABLE IF EXISTS `atic_zone_biz_http`;

CREATE TABLE `atic_zone_biz_http` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http` */

/*Table structure for table `atic_zone_biz_http_d` */

DROP TABLE IF EXISTS `atic_zone_biz_http_d`;

CREATE TABLE `atic_zone_biz_http_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_d` */

/*Table structure for table `atic_zone_biz_http_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_http_drop`;

CREATE TABLE `atic_zone_biz_http_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_drop` */

/*Table structure for table `atic_zone_biz_http_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_http_drop_d`;

CREATE TABLE `atic_zone_biz_http_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_drop_d` */

/*Table structure for table `atic_zone_biz_http_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_http_drop_h`;

CREATE TABLE `atic_zone_biz_http_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_drop_h` */

/*Table structure for table `atic_zone_biz_http_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_http_drop_max`;

CREATE TABLE `atic_zone_biz_http_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_drop_max` */

/*Table structure for table `atic_zone_biz_http_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_http_drop_max_d`;

CREATE TABLE `atic_zone_biz_http_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_drop_max_d` */

/*Table structure for table `atic_zone_biz_http_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_http_drop_max_h`;

CREATE TABLE `atic_zone_biz_http_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_drop_max_h` */

/*Table structure for table `atic_zone_biz_http_h` */

DROP TABLE IF EXISTS `atic_zone_biz_http_h`;

CREATE TABLE `atic_zone_biz_http_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_h` */

/*Table structure for table `atic_zone_biz_http_max` */

DROP TABLE IF EXISTS `atic_zone_biz_http_max`;

CREATE TABLE `atic_zone_biz_http_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_max` */

/*Table structure for table `atic_zone_biz_http_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_http_max_d`;

CREATE TABLE `atic_zone_biz_http_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_max_d` */

/*Table structure for table `atic_zone_biz_http_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_http_max_h`;

CREATE TABLE `atic_zone_biz_http_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `POST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HOST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_http_max_h` */

/*Table structure for table `atic_zone_biz_https` */

DROP TABLE IF EXISTS `atic_zone_biz_https`;

CREATE TABLE `atic_zone_biz_https` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https` */

/*Table structure for table `atic_zone_biz_https_d` */

DROP TABLE IF EXISTS `atic_zone_biz_https_d`;

CREATE TABLE `atic_zone_biz_https_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_d` */

/*Table structure for table `atic_zone_biz_https_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_https_drop`;

CREATE TABLE `atic_zone_biz_https_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_drop` */

/*Table structure for table `atic_zone_biz_https_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_https_drop_d`;

CREATE TABLE `atic_zone_biz_https_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_drop_d` */

/*Table structure for table `atic_zone_biz_https_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_https_drop_h`;

CREATE TABLE `atic_zone_biz_https_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_drop_h` */

/*Table structure for table `atic_zone_biz_https_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_https_drop_max`;

CREATE TABLE `atic_zone_biz_https_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_drop_max` */

/*Table structure for table `atic_zone_biz_https_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_https_drop_max_d`;

CREATE TABLE `atic_zone_biz_https_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_drop_max_d` */

/*Table structure for table `atic_zone_biz_https_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_https_drop_max_h`;

CREATE TABLE `atic_zone_biz_https_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_drop_max_h` */

/*Table structure for table `atic_zone_biz_https_h` */

DROP TABLE IF EXISTS `atic_zone_biz_https_h`;

CREATE TABLE `atic_zone_biz_https_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_h` */

/*Table structure for table `atic_zone_biz_https_max` */

DROP TABLE IF EXISTS `atic_zone_biz_https_max`;

CREATE TABLE `atic_zone_biz_https_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_max` */

/*Table structure for table `atic_zone_biz_https_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_https_max_d`;

CREATE TABLE `atic_zone_biz_https_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_max_d` */

/*Table structure for table `atic_zone_biz_https_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_https_max_h`;

CREATE TABLE `atic_zone_biz_https_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `HELLO_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_https_max_h` */

/*Table structure for table `atic_zone_biz_other` */

DROP TABLE IF EXISTS `atic_zone_biz_other`;

CREATE TABLE `atic_zone_biz_other` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other` */

/*Table structure for table `atic_zone_biz_other_d` */

DROP TABLE IF EXISTS `atic_zone_biz_other_d`;

CREATE TABLE `atic_zone_biz_other_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_d` */

/*Table structure for table `atic_zone_biz_other_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_other_drop`;

CREATE TABLE `atic_zone_biz_other_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_drop` */

/*Table structure for table `atic_zone_biz_other_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_other_drop_d`;

CREATE TABLE `atic_zone_biz_other_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_drop_d` */

/*Table structure for table `atic_zone_biz_other_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_other_drop_h`;

CREATE TABLE `atic_zone_biz_other_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_drop_h` */

/*Table structure for table `atic_zone_biz_other_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_other_drop_max`;

CREATE TABLE `atic_zone_biz_other_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_drop_max` */

/*Table structure for table `atic_zone_biz_other_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_other_drop_max_d`;

CREATE TABLE `atic_zone_biz_other_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_drop_max_d` */

/*Table structure for table `atic_zone_biz_other_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_other_drop_max_h`;

CREATE TABLE `atic_zone_biz_other_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_drop_max_h` */

/*Table structure for table `atic_zone_biz_other_h` */

DROP TABLE IF EXISTS `atic_zone_biz_other_h`;

CREATE TABLE `atic_zone_biz_other_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_h` */

/*Table structure for table `atic_zone_biz_other_max` */

DROP TABLE IF EXISTS `atic_zone_biz_other_max`;

CREATE TABLE `atic_zone_biz_other_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_max` */

/*Table structure for table `atic_zone_biz_other_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_other_max_d`;

CREATE TABLE `atic_zone_biz_other_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_max_d` */

/*Table structure for table `atic_zone_biz_other_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_other_max_h`;

CREATE TABLE `atic_zone_biz_other_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_other_max_h` */

/*Table structure for table `atic_zone_biz_sip` */

DROP TABLE IF EXISTS `atic_zone_biz_sip`;

CREATE TABLE `atic_zone_biz_sip` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip` */

/*Table structure for table `atic_zone_biz_sip_d` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_d`;

CREATE TABLE `atic_zone_biz_sip_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_d` */

/*Table structure for table `atic_zone_biz_sip_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_drop`;

CREATE TABLE `atic_zone_biz_sip_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_drop` */

/*Table structure for table `atic_zone_biz_sip_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_drop_d`;

CREATE TABLE `atic_zone_biz_sip_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_drop_d` */

/*Table structure for table `atic_zone_biz_sip_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_drop_h`;

CREATE TABLE `atic_zone_biz_sip_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_drop_h` */

/*Table structure for table `atic_zone_biz_sip_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_drop_max`;

CREATE TABLE `atic_zone_biz_sip_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_drop_max` */

/*Table structure for table `atic_zone_biz_sip_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_drop_max_d`;

CREATE TABLE `atic_zone_biz_sip_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_drop_max_d` */

/*Table structure for table `atic_zone_biz_sip_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_drop_max_h`;

CREATE TABLE `atic_zone_biz_sip_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_drop_max_h` */

/*Table structure for table `atic_zone_biz_sip_h` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_h`;

CREATE TABLE `atic_zone_biz_sip_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_h` */

/*Table structure for table `atic_zone_biz_sip_max` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_max`;

CREATE TABLE `atic_zone_biz_sip_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_max` */

/*Table structure for table `atic_zone_biz_sip_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_max_d`;

CREATE TABLE `atic_zone_biz_sip_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_max_d` */

/*Table structure for table `atic_zone_biz_sip_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_sip_max_h`;

CREATE TABLE `atic_zone_biz_sip_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `SIP_INVITE_PPS` int(10) unsigned DEFAULT NULL,
  `SIP_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_sip_max_h` */

/*Table structure for table `atic_zone_biz_tcp` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp`;

CREATE TABLE `atic_zone_biz_tcp` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp` */

/*Table structure for table `atic_zone_biz_tcp_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_d`;

CREATE TABLE `atic_zone_biz_tcp_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_d` */

/*Table structure for table `atic_zone_biz_tcp_dns` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns`;

CREATE TABLE `atic_zone_biz_tcp_dns` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns` */

/*Table structure for table `atic_zone_biz_tcp_dns_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_d`;

CREATE TABLE `atic_zone_biz_tcp_dns_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_d` */

/*Table structure for table `atic_zone_biz_tcp_dns_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_drop`;

CREATE TABLE `atic_zone_biz_tcp_dns_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_drop` */

/*Table structure for table `atic_zone_biz_tcp_dns_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_drop_d`;

CREATE TABLE `atic_zone_biz_tcp_dns_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_drop_d` */

/*Table structure for table `atic_zone_biz_tcp_dns_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_drop_h`;

CREATE TABLE `atic_zone_biz_tcp_dns_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_drop_h` */

/*Table structure for table `atic_zone_biz_tcp_dns_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_drop_max`;

CREATE TABLE `atic_zone_biz_tcp_dns_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_drop_max` */

/*Table structure for table `atic_zone_biz_tcp_dns_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_drop_max_d`;

CREATE TABLE `atic_zone_biz_tcp_dns_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_drop_max_d` */

/*Table structure for table `atic_zone_biz_tcp_dns_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_drop_max_h`;

CREATE TABLE `atic_zone_biz_tcp_dns_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_drop_max_h` */

/*Table structure for table `atic_zone_biz_tcp_dns_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_h`;

CREATE TABLE `atic_zone_biz_tcp_dns_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_h` */

/*Table structure for table `atic_zone_biz_tcp_dns_max` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_max`;

CREATE TABLE `atic_zone_biz_tcp_dns_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_max` */

/*Table structure for table `atic_zone_biz_tcp_dns_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_max_d`;

CREATE TABLE `atic_zone_biz_tcp_dns_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_max_d` */

/*Table structure for table `atic_zone_biz_tcp_dns_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_dns_max_h`;

CREATE TABLE `atic_zone_biz_tcp_dns_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_dns_max_h` */

/*Table structure for table `atic_zone_biz_tcp_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_drop`;

CREATE TABLE `atic_zone_biz_tcp_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_drop` */

/*Table structure for table `atic_zone_biz_tcp_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_drop_d`;

CREATE TABLE `atic_zone_biz_tcp_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_drop_d` */

/*Table structure for table `atic_zone_biz_tcp_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_drop_h`;

CREATE TABLE `atic_zone_biz_tcp_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_drop_h` */

/*Table structure for table `atic_zone_biz_tcp_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_drop_max`;

CREATE TABLE `atic_zone_biz_tcp_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_drop_max` */

/*Table structure for table `atic_zone_biz_tcp_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_drop_max_d`;

CREATE TABLE `atic_zone_biz_tcp_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_drop_max_d` */

/*Table structure for table `atic_zone_biz_tcp_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_drop_max_h`;

CREATE TABLE `atic_zone_biz_tcp_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_drop_max_h` */

/*Table structure for table `atic_zone_biz_tcp_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_h`;

CREATE TABLE `atic_zone_biz_tcp_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_h` */

/*Table structure for table `atic_zone_biz_tcp_max` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_max`;

CREATE TABLE `atic_zone_biz_tcp_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_max` */

/*Table structure for table `atic_zone_biz_tcp_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_max_d`;

CREATE TABLE `atic_zone_biz_tcp_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_max_d` */

/*Table structure for table `atic_zone_biz_tcp_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_tcp_max_h`;

CREATE TABLE `atic_zone_biz_tcp_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_tcp_max_h` */

/*Table structure for table `atic_zone_biz_udp` */

DROP TABLE IF EXISTS `atic_zone_biz_udp`;

CREATE TABLE `atic_zone_biz_udp` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp` */

/*Table structure for table `atic_zone_biz_udp_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_d`;

CREATE TABLE `atic_zone_biz_udp_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_d` */

/*Table structure for table `atic_zone_biz_udp_dns` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns`;

CREATE TABLE `atic_zone_biz_udp_dns` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SERVER_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `A_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `PTR_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `NS_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MX_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TXT_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `CNNAME_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SOA_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `AAAAA_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_REQUEST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `LARGE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ILEGAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TTL_DENIED_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns` */

/*Table structure for table `atic_zone_biz_udp_dns_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_d`;

CREATE TABLE `atic_zone_biz_udp_dns_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_d` */

/*Table structure for table `atic_zone_biz_udp_dns_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_drop`;

CREATE TABLE `atic_zone_biz_udp_dns_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REPLY_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_drop` */

/*Table structure for table `atic_zone_biz_udp_dns_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_drop_d`;

CREATE TABLE `atic_zone_biz_udp_dns_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REPLY_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_drop_d` */

/*Table structure for table `atic_zone_biz_udp_dns_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_drop_h`;

CREATE TABLE `atic_zone_biz_udp_dns_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REQUEST_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `REPLY_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_drop_h` */

/*Table structure for table `atic_zone_biz_udp_dns_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_drop_max`;

CREATE TABLE `atic_zone_biz_udp_dns_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_drop_max` */

/*Table structure for table `atic_zone_biz_udp_dns_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_drop_max_d`;

CREATE TABLE `atic_zone_biz_udp_dns_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_drop_max_d` */

/*Table structure for table `atic_zone_biz_udp_dns_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_drop_max_h`;

CREATE TABLE `atic_zone_biz_udp_dns_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_drop_max_h` */

/*Table structure for table `atic_zone_biz_udp_dns_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_h`;

CREATE TABLE `atic_zone_biz_udp_dns_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_h` */

/*Table structure for table `atic_zone_biz_udp_dns_max` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_max`;

CREATE TABLE `atic_zone_biz_udp_dns_max` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_max` */

/*Table structure for table `atic_zone_biz_udp_dns_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_max_d`;

CREATE TABLE `atic_zone_biz_udp_dns_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_max_d` */

/*Table structure for table `atic_zone_biz_udp_dns_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_dns_max_h`;

CREATE TABLE `atic_zone_biz_udp_dns_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TOTAL_PPS` int(10) unsigned DEFAULT NULL,
  `TOTAL_KBPS` int(10) unsigned DEFAULT NULL,
  `INCREASE_CON` int(10) unsigned DEFAULT NULL,
  `CUR_CON` int(10) unsigned DEFAULT NULL,
  `REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `SERVER_REPLY_PPS` int(10) unsigned DEFAULT NULL,
  `A_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `PTR_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `NS_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `MX_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `TXT_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `CNNAME_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `SOA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `AAAAA_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `OTHER_REQUEST_PPS` int(10) unsigned DEFAULT NULL,
  `FRAG_PPS` int(10) unsigned DEFAULT NULL,
  `LARGE_PPS` int(10) unsigned DEFAULT NULL,
  `ILEGAL_PPS` int(10) unsigned DEFAULT NULL,
  `TTL_DENIED_PPS` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_dns_max_h` */

/*Table structure for table `atic_zone_biz_udp_drop` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_drop`;

CREATE TABLE `atic_zone_biz_udp_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_drop` */

/*Table structure for table `atic_zone_biz_udp_drop_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_drop_d`;

CREATE TABLE `atic_zone_biz_udp_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_drop_d` */

/*Table structure for table `atic_zone_biz_udp_drop_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_drop_h`;

CREATE TABLE `atic_zone_biz_udp_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_drop_h` */

/*Table structure for table `atic_zone_biz_udp_drop_max` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_drop_max`;

CREATE TABLE `atic_zone_biz_udp_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_drop_max` */

/*Table structure for table `atic_zone_biz_udp_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_drop_max_d`;

CREATE TABLE `atic_zone_biz_udp_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_drop_max_d` */

/*Table structure for table `atic_zone_biz_udp_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_drop_max_h`;

CREATE TABLE `atic_zone_biz_udp_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_drop_max_h` */

/*Table structure for table `atic_zone_biz_udp_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_h`;

CREATE TABLE `atic_zone_biz_udp_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_h` */

/*Table structure for table `atic_zone_biz_udp_max` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_max`;

CREATE TABLE `atic_zone_biz_udp_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_max` */

/*Table structure for table `atic_zone_biz_udp_max_d` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_max_d`;

CREATE TABLE `atic_zone_biz_udp_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_max_d` */

/*Table structure for table `atic_zone_biz_udp_max_h` */

DROP TABLE IF EXISTS `atic_zone_biz_udp_max_h`;

CREATE TABLE `atic_zone_biz_udp_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SPECIAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_biz_udp_max_h` */

/*Table structure for table `atic_zone_blacklist` */

DROP TABLE IF EXISTS `atic_zone_blacklist`;

CREATE TABLE `atic_zone_blacklist` (
  `PKID` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `ZONE_ID` int(10) NOT NULL,
  `BIZ_ID` int(10) NOT NULL,
  `ZONE_IP` varchar(40) NOT NULL DEFAULT '',
  `START_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `BLACK_IP` varchar(40) NOT NULL DEFAULT '',
  `PROTOCOL` int(11) NOT NULL,
  `PORT` int(11) NOT NULL,
  `BLACK_TYPE` int(11) NOT NULL,
  `STATUS` int(11) NOT NULL,
  `ENABLE` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`PKID`),
  INDEX index_ns (`ZONE_ID`,`BLACK_IP`,`PORT`,`PROTOCOL`,`DEVICE_IP`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_blacklist` */

DROP TABLE IF EXISTS `atic_zone_blacklist_history`;

CREATE TABLE `atic_zone_blacklist_history` (
  `PKID` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `DEVICE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `ZONE_ID` INT(10) NOT NULL,
  `BIZ_ID` INT(10) NOT NULL,
  `ZONE_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `START_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `END_TIME` INT(10) UNSIGNED NOT NULL DEFAULT '0',
  `BLACK_IP` VARCHAR(40) NOT NULL DEFAULT '',
  `PROTOCOL` INT(11) NOT NULL,
  `PORT` INT(11) NOT NULL,
  `BLACK_TYPE` INT(11) NOT NULL,
  `STATUS` INT(11) NOT NULL,
  `ENABLE` INT(11) NOT NULL DEFAULT '1',
  KEY (`PKID`),
  KEY (`END_TIME`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Table structure for table `atic_zone_drop` */

DROP TABLE IF EXISTS `atic_zone_drop`;

CREATE TABLE `atic_zone_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_drop` */

/*Table structure for table `atic_zone_drop_d` */

DROP TABLE IF EXISTS `atic_zone_drop_d`;

CREATE TABLE `atic_zone_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_drop_d` */

/*Table structure for table `atic_zone_drop_h` */

DROP TABLE IF EXISTS `atic_zone_drop_h`;

CREATE TABLE `atic_zone_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_drop_h` */

/*Table structure for table `atic_zone_drop_max` */

DROP TABLE IF EXISTS `atic_zone_drop_max`;

CREATE TABLE `atic_zone_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_drop_max` */

/*Table structure for table `atic_min_zone_flow_sum` */

DROP TABLE IF EXISTS `atic_min_zone_flow_sum`;

CREATE TABLE `atic_min_zone_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_zone_flow_sum` */

/*Table structure for table `atic_zone_flow_sum` */

DROP TABLE IF EXISTS `atic_zone_flow_sum`;

CREATE TABLE `atic_zone_flow_sum` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum` */

/*Table structure for table `atic_zone_flow_sum_d` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_d`;

CREATE TABLE `atic_zone_flow_sum_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_d` */

/*Table structure for table `atic_min_zone_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_min_zone_flow_sum_drop`;

CREATE TABLE `atic_min_zone_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_zone_flow_sum_drop` */

/*Table structure for table `atic_zone_flow_sum_drop` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_drop`;

CREATE TABLE `atic_zone_flow_sum_drop` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_drop` */

/*Table structure for table `atic_zone_flow_sum_drop_d` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_drop_d`;

CREATE TABLE `atic_zone_flow_sum_drop_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_drop_d` */

/*Table structure for table `atic_zone_flow_sum_drop_h` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_drop_h`;

CREATE TABLE `atic_zone_flow_sum_drop_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_REBOUND_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_REBOUND_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_drop_h` */

/*Table structure for table `atic_min_zone_flow_sum_drop_max` */

DROP TABLE IF EXISTS `atic_min_zone_flow_sum_drop_max`;

CREATE TABLE `atic_min_zone_flow_sum_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_zone_flow_sum_drop_max` */

/*Table structure for table `atic_zone_flow_sum_drop_max` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_drop_max`;

CREATE TABLE `atic_zone_flow_sum_drop_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_drop_max` */

/*Table structure for table `atic_zone_flow_sum_drop_max_d` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_drop_max_d`;

CREATE TABLE `atic_zone_flow_sum_drop_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_drop_max_d` */

/*Table structure for table `atic_zone_flow_sum_drop_max_h` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_drop_max_h`;

CREATE TABLE `atic_zone_flow_sum_drop_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_drop_max_h` */

/*Table structure for table `atic_zone_flow_sum_h` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_h`;

CREATE TABLE `atic_zone_flow_sum_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_h` */

/*Table structure for table `atic_min_zone_flow_sum_max` */

DROP TABLE IF EXISTS `atic_min_zone_flow_sum_max`;

CREATE TABLE `atic_min_zone_flow_sum_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_zone_flow_sum_max` */

/*Table structure for table `atic_min_zone_flow_sum_forward_max` */

DROP TABLE IF EXISTS `atic_min_zone_flow_sum_forward_max`;

CREATE TABLE `atic_min_zone_flow_sum_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_min_zone_flow_sum_forward_max` */

/*Table structure for table `atic_zone_flow_sum_max` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_max`;

CREATE TABLE `atic_zone_flow_sum_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_max` */

/*Table structure for table `atic_zone_flow_sum_forward_max` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_forward_max`;

CREATE TABLE `atic_zone_flow_sum_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_forward_max` */

/*Table structure for table `atic_zone_flow_sum_max_d` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_max_d`;

CREATE TABLE `atic_zone_flow_sum_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_max_d` */

/*Table structure for table `atic_zone_flow_sum_forward_max_d` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_forward_max_d`;

CREATE TABLE `atic_zone_flow_sum_forward_max_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_forward_max_d` */

/*Table structure for table `atic_zone_flow_sum_max_h` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_max_h`;

CREATE TABLE `atic_zone_flow_sum_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_max_h` */

/*Table structure for table `atic_zone_flow_sum_forward_max_h` */

DROP TABLE IF EXISTS `atic_zone_flow_sum_forward_max_h`;

CREATE TABLE `atic_zone_flow_sum_forward_max_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDPFRAG_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYN_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SYNACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ACK_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `FINRST_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_flow_sum_forward_max_h` */

/*Table structure for table `atic_zone_in` */

DROP TABLE IF EXISTS `atic_zone_in`;

CREATE TABLE `atic_zone_in` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_in` */

/*Table structure for table `atic_zone_in_d` */

DROP TABLE IF EXISTS `atic_zone_in_d`;

CREATE TABLE `atic_zone_in_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_in_d` */

/*Table structure for table `atic_zone_in_h` */

DROP TABLE IF EXISTS `atic_zone_in_h`;

CREATE TABLE `atic_zone_in_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_in_h` */

/*Table structure for table `atic_zone_in_max` */

DROP TABLE IF EXISTS `atic_zone_in_max`;

CREATE TABLE `atic_zone_in_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_INCREASE_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_CUR_CON` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_in_max` */

/*Table structure for table `atic_zone_forward` */

DROP TABLE IF EXISTS `atic_zone_forward`;

CREATE TABLE `atic_zone_forward` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_forward` */

/*Table structure for table `atic_zone_forward_d` */

DROP TABLE IF EXISTS `atic_zone_forward_d`;

CREATE TABLE `atic_zone_forward_d` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_forward_d` */

/*Table structure for table `atic_zone_forward_h` */

DROP TABLE IF EXISTS `atic_zone_forward_h`;

CREATE TABLE `atic_zone_forward_h` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `MAX_SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_forward_h` */

/*Table structure for table `atic_zone_forward_max` */

DROP TABLE IF EXISTS `atic_zone_forward_max`;

CREATE TABLE `atic_zone_forward_max` (
  `LOG_TIME` int(10) unsigned NOT NULL DEFAULT '0',
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DIRECTION` int(1) unsigned NOT NULL DEFAULT '1',
  `DEVICE_TYPE` int(10) unsigned NOT NULL DEFAULT '0',
  `ZONE_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `BIZ_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TOTAL_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `TCP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `UDP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `ICMP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `OTHER_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTP_GET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `HTTPS_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REQUSET_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `DNS_REPLY_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_PPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_KBPS` int(10) unsigned NOT NULL DEFAULT '0',
  `SIP_INVITE_QPS` int(10) unsigned NOT NULL DEFAULT '0',
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_forward_max` */

/*Table structure for table `atic_zone_userdef_dns_type` */

DROP TABLE IF EXISTS `atic_zone_userdef_dns_type`;

CREATE TABLE `atic_zone_userdef_dns_type` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TYPE_CODE` int(10) unsigned DEFAULT NULL,
  `CODE_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_userdef_dns_type` */

/*Table structure for table `atic_zone_userdef_dns_type_d` */

DROP TABLE IF EXISTS `atic_zone_userdef_dns_type_d`;

CREATE TABLE `atic_zone_userdef_dns_type_d` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TYPE_CODE` int(10) unsigned DEFAULT NULL,
  `CODE_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_userdef_dns_type_d` */

/*Table structure for table `atic_zone_userdef_dns_type_h` */

DROP TABLE IF EXISTS `atic_zone_userdef_dns_type_h`;

CREATE TABLE `atic_zone_userdef_dns_type_h` (
  `LOG_TIME` int(10) unsigned NOT NULL,
  `DEVICE_IP` varchar(40) NOT NULL DEFAULT '',
  `DEVICE_TYPE` int(10) unsigned NOT NULL,
  `ZONE_ID` int(10) unsigned NOT NULL,
  `BIZ_ID` int(10) unsigned NOT NULL,
  `TYPE_CODE` int(10) unsigned DEFAULT NULL,
  `CODE_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_VALUE` int(10) unsigned DEFAULT NULL,
  `CODE_DROP_MAX_VALUE` int(10) unsigned DEFAULT NULL,
  KEY `KEY_LOG_TIME` (`LOG_TIME`),
  KEY `KEY_ZONE_ID` (`ZONE_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_zone_userdef_dns_type_h` */

/*Table structure for table `atic_filter` */

DROP TABLE IF EXISTS `atic_filter`;

CREATE TABLE `atic_filter` (
  `FILTER_ID` int(10) unsigned NOT NULL DEFAULT '0',
  `FILTER_NAME` varchar(64) NOT NULL DEFAULT '',
  KEY `KEY_FILTER_ID` (`FILTER_ID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

/*Data for the table `atic_filter` */

/*Table structure for table `atic_blackhole_np_config` */

DROP TABLE IF EXISTS `atic_blackhole_np_config`;

CREATE TABLE `atic_blackhole_np_config` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `np_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `time_long` int(11) DEFAULT NULL,
  `black_hole_threshold` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

/*Data for the table `atic_blackhole_np_config` */

/*Table structure for table `atic_syslog_server`*/
DROP TABLE IF EXISTS  `atic_syslog_server`;
CREATE TABLE `atic_syslog_server` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `server_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
  `server_port` INT(11) DEFAULT NULL,
  `default_zone_syslog` INT(11) DEFAULT '1',
  `atic_optlog` INT(11) DEFAULT NULL,
  `device_syslog` INT(11) DEFAULT NULL,
  `third_syslog` INT(11) DEFAULT NULL,
  `flow_syslog` INT(11) DEFAULT NULL,
  `flow_syslog_outbound` INT(11) DEFAULT NULL,
  `ip_flow_seconds_syslog` INT(11) DEFAULT NULL,
  `alarm_syslog` INT(11) DEFAULT NULL,
  `alarm_min_level` INT(11) DEFAULT NULL,
  `alarm_abnormity_log` INT(11) DEFAULT NULL,
  `alarm_attack_log` INT(11) DEFAULT NULL,
  `alarm_refresh_log` INT(11) DEFAULT NULL,
  `alarm_detail_log` INT(11) DEFAULT NULL,
  `alarm_abnormity_log_outbound` INT(11) DEFAULT NULL,
  `alarm_attack_log_outbound` INT(11) DEFAULT NULL,
  `alarm_refresh_log_outbound` INT(11) DEFAULT NULL,
  `alarm_detail_log_outbound` INT(11) DEFAULT NULL,
  `transfer_protocol` INT(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
/*Data for the table `atic_syslog_server` */
