# Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
# Upgrade firewall tables

--
-- Change engine of the firewall tables to InnoDB
--
ALTER TABLE mysql.firewall_whitelist ENGINE=InnoDB;
ALTER TABLE mysql.firewall_users ENGINE=InnoDB;

--
-- Add a column that serves as a primary key of the table
--
SET @firewall_whitelist_id_column =
  (SELECT COUNT(column_name) FROM information_schema.columns
     WHERE table_schema = 'mysql' AND table_name = 'firewall_whitelist' AND
           table_type = 'BASE TABLE' AND column_name = 'ID');
SET @cmd="ALTER TABLE mysql.firewall_whitelist ADD ID INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY";
SET @str = IF(@firewall_whitelist_id_column > 0, "SET @dummy = 0", @cmd);
PREPARE stmt FROM @str;
EXECUTE stmt;
DROP PREPARE stmt;
