var CBB_Shim = CBB_Shim;
if (typeof CBB_Shim == "undefined") {
	CBB_Shim = function(t) {
		this._doc;
		this.target;
		this.jShim = null;
		var ie = $.browser.msie && /6.0/.test(navigator.userAgent);
		this.init = function() {
			if(typeof t == "string") {
				this.target = $("#" + c.target);
			} else  if(typeof t == "object"){
				this.target = t.css && t.attr?t:$(t);
			}
			
			var tel = this.target.get(0);
			this._doc = tel.ownerDocument;
			this.jShim = $("<iframe frameborder='' class='cbb_shim'/>", this._doc).addClass("cbb_shim").css({
				zIndex : tel.style.zIndex - 1
			}).appendTo(tel.parentNode);
			var width = this.target.outerWidth();
			
			this.jShim.css({
				position : "absolute",
				top : this.target.attr("offsetTop"),
				left : this.target.attr("offsetLeft"),
				right : this.target.css("right"),
				bottom : this.target.css("bottom"),
				display: "none",
				width : width = width > 0 ? width : "",
				height: this.target.outerHeight()
			});
		}
		
		this.show = function() {
			if(ie) this.jShim.show();
		}
		
		this.hide = function() {
			if(ie) this.jShim.hide();
		}
		
		this.destory = function() {
			if(ie) this.jShim.remove();
		}
		
		if (ie) { 
			this.init(t);
		}
	}
}

var CBB_Mask = CBB_Mask;
if (typeof CBB_Mask == "undefined") {
	CBB_Mask = function(config) {
		this._doc = document;
		this.jMaskMsg;
		this.jMask;
		this.target;
		this.shim;
		
		var self = this;

		_defaults = {
			id : null,
			loadingClass : null,
			zIndex : 800,
			loadingMode: false,
			msg: ""
		};

		this.hide = function() {
			this.jMask.css("display", "none");
			if(this.jMaskMsg) {
				this.jMaskMsg.fadeOut(0);
			}
			this.shim.hide();
		}

		this.show = function() {
			if ($.browser.msie && /6.0/.test(navigator.userAgent)) {
				this.jMask.css({
					width : this.target.outerWidth(),
					height : this.target.outerHeight()
				});
			}
			this.jMask.show();
			
			if(this.jMaskMsg) {
				this.jMaskMsg.show();
				this.jMaskMsg.css({
					top:(this.jMask.height()/2 - this.jMaskMsg.height()/2) + "px",
					left:(this.jMask.width()/2 - this.jMaskMsg.innerWidth()/2) + "px"
				});
			}
			
			if(!this.shim) {
				this.shim = new CBB_Shim(this.jMask);
			}
			this.shim.show();
		}

		this.destory = function() {
			this.jMask.remove();
			this.shim.destory();
			this.shim = null;
		}
		
		this.init = function(c) {
			c = $.extend({}, _defaults, c);
			this.c = c;
			
			if(typeof c.target == "string") {
				this.target = $("#" + c.target);
			} else  if(typeof c.target == "object"){
				if(c.target.css && c.target.attr) {
					this.target = c.target;
				} else {
					this.target = $(c.target)
				}
			}
			
			var tel = this.target.get(0);
			
			this._doc = this.target.get(0).ownerDocument;
			this.jMask = $("<div class='cbb_mask'/>", this._doc).css({
				zIndex : this.c.zIndex
			}).appendTo(tel.parentNode);
			
			var width = this.target.outerWidth();
			
			this.jMask.css({
				position : "absolute",
				top : this.target.attr("offsetTop"),
				left : this.target.attr("offsetLeft"),
				right : this.target.css("right"),
				bottom : this.target.css("bottom"),
				display: "none",
				width : width = width > 0 ? width : "",
				height: this.target.outerHeight()
			});
			
			if(this.c.loadingMode) {
				this.jMaskMsg = $('<div class="cbb_mask_msg cbb_mask_loading"></div>', this._doc).css("z-index", this.c.zIndex + 1).appendTo(this.jMask);
				$("<div/>", this._doc).appendTo(this.jMaskMsg).text(this.c.msg).css("z-index", this.c.zIndex + 2);
				if(this.c.imgClass) {
					this.jMaskMsg.addClass(this.c.imgClass);
				}
			}
			
			if(this.c.maskClass) {
				this.jMask.addClass(this.c.maskClass);
			}
		}

		this.init(config);
	}
}
