function AgileTheme() {
	return {
        theme: {
            // 默认色板
            color: [
                '#eeb666', '#8298cd', '#a7e52d', '#efe034', '#af90da',  
                '#ffa235', '#fc5043', '#777777', '#468bf3',  '#f87fa7'
            ],
            // 图表标题
            title: {
                itemGap: 8,
                textStyle: {
                    fontWeight: 'normal',
                    color: "#666666"
                }
            },
            axis: {
                splitLine: {show: false}
            },
            // 值域
            dataRange: {
                color: ['#1178ad', '#72bbd0']
            },
            // 工具箱
            toolbox: {
                show : false,
                color: ['#42ccef', '#42ccef', '#42ccef', '#42ccef']
            },
            legend: {
                itemWidth: 10,
                itemHeight: 10,
                x: "right",
                y: "top",
                padding: [5, 40, 5, 5]
            },
            // 提示框
            tooltip: {
                backgroundColor: "#ffffff",
                borderWidth: 1,
                borderRadius: 4,
                borderColor: "#dfdfdf",
                padding: 5,
                textStyle: {
                    color: "#666",
                    fontSize: 11,
                    fontFamily: 'Helvetica, 微软雅黑, Arial, Verdana, sans-serif'
                },
                axisPointer: {
                    type: 'line',
                    lineStyle: {
                        color: '#d5d5d5',
                        width: 1,
                        type: 'solid'
                    }
                }
            },
            // 区域缩放控制器
            dataZoom: {
                showDetail: false,
                axis: {
                    axisLine: {
                        show: false
                    },
                    axisLabel: {
                        textStyle: {
                            fontSize: 10,
                            color: '#999'
                        }
                    },
                    axisTick: {
                        length: 8,
                        lineStyle: {
                            color: '#999',
                            width: 1
                        }
                    }
                },
                handleSize: 5,
                dataBackgroundColor: '#5ecc49',            // 数据背景颜色
                fillerColor: 'rgba(255,255,255,0)',   // 填充颜色
                handleColor: '#008acd'    // 手柄颜色
            },
            noDataLoadingOption: {
                effect: "noEffect"
            },
            grid: {
                borderWidth: 0,
                x: 40,
                y: 40,
                x2: 40,
                y2: 40
            },
            polar : {
                axisLine: {            // 坐标轴线
                    lineStyle: {       // 属性lineStyle控制线条样式
                        color: '#ddd'
                    }
                },
                splitArea : {
                    show : true,
                    areaStyle : {
                        color: ['rgba(250,250,250,0.2)','rgba(200,200,200,0.2)']
                    }
                },
                splitLine : {
                    lineStyle : {
                        color : '#ddd'
                    }
                }
            },

            timeline : {
                lineStyle : {
                    color : '#008acd'
                },
                controlStyle : {
                    normal : { color : '#008acd'},
                    emphasis : { color : '#008acd'}
                },
                symbol : 'emptyCircle',
                symbolSize : 3
            },

            // 柱形图默认参数
            bar: {
                itemStyle: {
                    normal: {
                        barBorderRadius: 0
                    },
                    emphasis: {
                        barBorderRadius: 0
                    }
                }
            },

            // 折线图默认参数
            line: {
                smooth : true,
                symbol: 'rect',  // 拐点图形类型
                symbolSize: 1           // 拐点图形大小
            },

            // K线图默认参数
            k: {
                itemStyle: {
                    normal: {
                        color: '#d87a80',       // 阳线填充颜色
                        color0: '#2ec7c9',      // 阴线填充颜色
                        lineStyle: {
                            color: '#d87a80',   // 阳线边框颜色
                            color0: '#2ec7c9'   // 阴线边框颜色
                        }
                    }
                }
            },

            // 散点图默认参数
            scatter: {
                symbol: 'circle',    // 图形类型
                symbolSize: 4        // 图形大小，半宽（半径）参数，当图形为方向或菱形则总宽度为symbolSize * 2
            },

            // 雷达图默认参数
            radar : {
                symbol: 'emptyCircle',    // 图形类型
                symbolSize:3
                //symbol: null,         // 拐点图形类型
                //symbolRotate : null,  // 图形旋转控制
            },

            map: {
                itemStyle: {
                    normal: {
                        areaStyle: {
                            color: '#ddd'
                        },
                        label: {
                            textStyle: {
                                color: '#d87a80'
                            }
                        }
                    },
                    emphasis: {                 // 也是选中样式
                        areaStyle: {
                            color: '#fe994e'
                        }
                    }
                }
            },

            force : {
                itemStyle: {
                    normal: {
                        linkStyle : {
                            color : '#1e90ff'
                        }
                    }
                }
            },

            chord : {
                itemStyle : {
                    normal : {
                        borderWidth: 1,
                        borderColor: 'rgba(128, 128, 128, 0.5)',
                        chordStyle : {
                            lineStyle : {
                                color : 'rgba(128, 128, 128, 0.5)'
                            }
                        }
                    },
                    emphasis : {
                        borderWidth: 1,
                        borderColor: 'rgba(128, 128, 128, 0.5)',
                        chordStyle : {
                            lineStyle : {
                                color : 'rgba(128, 128, 128, 0.5)'
                            }
                        }
                    }
                }
            },

            gauge : {
                axisLine: {            // 坐标轴线
                    lineStyle: {       // 属性lineStyle控制线条样式
                        color: [[0.2, '#2ec7c9'],[0.8, '#5ab1ef'],[1, '#d87a80']],
                        width: 10
                    }
                },
                axisTick: {            // 坐标轴小标记
                    splitNumber: 10,   // 每份split细分多少段
                    length :15,        // 属性length控制线长
                    lineStyle: {       // 属性lineStyle控制线条样式
                        color: 'auto'
                    }
                },
                splitLine: {           // 分隔线
                    length :22,         // 属性length控制线长
                    lineStyle: {       // 属性lineStyle（详见lineStyle）控制线条样式
                        color: 'auto'
                    }
                },
                pointer : {
                    width : 5
                }
            },

            textStyle: {
                fontFamily: '微软雅黑, Arial, Verdana, sans-serif'
            }

        },
        options: {
            xAxis: {
                splitLine: {show: false},
                axisLine: {
                    lineStyle: {
                        color: '#cfcfcf',
                        width: 1,
                        type: 'solid'
                    }
                },
                axisTick: {
                    show: true,
                    length: 5,
                    lineStyle: {
                        color: '#cfcfcf',
                        width: 1
                    }
                },
                axisLabel: {
                    textStyle: {
                        fontSize: 11,
                        fontFamily: 'Helvetica, 微软雅黑, Arial, Verdana, sans-serif',
                        fontWeight: 'normal',
                        color: '#666'
                    }
                }
            },
            yAxis: {
                splitLine: {
                    show: true,
                    lineStyle: {
                        color: ['#cfcfcf'],
                        width: 1,
                        type: 'dotted'
                    }
                },
                axisLine: {
                    lineStyle: {
                        color: '#cfcfcf',
                        width: 1,
                        type: 'solid'
                    }
                },
                axisTick: {
                    show: true,
                    length: 5,
                    lineStyle: {
                        color: '#cfcfcf',
                        width: 1
                    }
                },
                axisLabel: {
                    textStyle: {
                        fontSize: 11,
                        fontFamily: 'Helvetica, 微软雅黑, Arial, Verdana, sans-serif',
                        fontWeight: 'normal',
                        color: '#666'
                    }
                }
            }
        }
    };
};
var agileUiTheme = new AgileTheme();
/**
 * 统一管理窗口自适应问题 
 * */
var CURRENT_ECHARTS=[];