USE lego;
DROP TABLE IF EXISTS `t_atic_report_config`;
CREATE TABLE `t_atic_report_config` (`pkid` INT(11) NOT NULL auto_increment,`report_var` VARCHAR(255) DEFAULT NULL,`report_value` VARCHAR(255) DEFAULT NULL,PRIMARY KEY (`pkid`)) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `t_atic_blackhole`;

CREATE TABLE `t_atic_blackhole` (`pkid` bigint(20) NOT NULL AUTO_INCREMENT, `device_id` bigint(20) DEFAULT NULL,`black_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,`black_mask` varchar(255) DEFAULT NULL,`nexthop_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,`enable_time` bigint(20) DEFAULT NULL, `enable_status` int(11) DEFAULT NULL, `detail` varchar(255) COLLATE utf8_bin DEFAULT NULL,  PRIMARY KEY (`pkid`),  UNIQUE KEY `unique` (`device_id`,`black_ip`,`black_mask`,`nexthop_ip`)) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `t_atic_blackhole_conf`;

CREATE TABLE `t_atic_blackhole_conf` (  `paramName` varchar(255) COLLATE utf8_bin NOT NULL,  `param_value` varchar(255) COLLATE utf8_bin DEFAULT NULL,  PRIMARY KEY (`paramName`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

insert  into `t_atic_blackhole_conf`(`paramName`,`param_value`) values ('nexthopIp','NULL 0');

CREATE TABLE `p_operate_log` (`time` bigint(20) unsigned NOT NULL,  `username` varchar(32) NOT NULL,  `ip` varchar(40) NOT NULL,  `type` varchar(20) NOT NULL,  `result` tinyint(4) NOT NULL,  `content` varchar(1024) DEFAULT NULL,  KEY `log_time` (`time`)) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `p_sysconfig` (`sys_name` varchar(64) DEFAULT NULL,  `logo` varchar(64) DEFAULT NULL,  `logo_hyperlink` varchar(255) DEFAULT NULL,  `skin` varchar(64) DEFAULT NULL,  `telephone` varchar(255) DEFAULT NULL,  `email` varchar(255) DEFAULT NULL,  `copyright` varchar(512) DEFAULT NULL,  `default_pwd` varchar(32) DEFAULT NULL) ENGINE=InnoDB DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `t_fault`;
CREATE TABLE `t_fault` (`fault_id` bigint(20) NOT NULL AUTO_INCREMENT,`fault_define_id` varchar(32) COLLATE utf8_bin NOT NULL,`severity` tinyint(4) NOT NULL,`source_type` tinyint(4) NOT NULL,`mo_id` bigint(20) NOT NULL,`extend_mo_id` bigint(20) DEFAULT NULL,`source` varchar(64) COLLATE utf8_bin DEFAULT NULL,`create_time` datetime DEFAULT NULL,`mod_time` datetime DEFAULT NULL,`count` int(11) DEFAULT NULL,`clear_status` tinyint(4) DEFAULT NULL,`clear_time` datetime DEFAULT NULL,`clear_user` varchar(32) COLLATE utf8_bin DEFAULT NULL,`confirm_status` tinyint(4) DEFAULT NULL,`confirm_time` datetime DEFAULT NULL,`confirm_user` varchar(32) COLLATE utf8_bin DEFAULT NULL,`fault_param` varchar(5120) COLLATE utf8_bin DEFAULT NULL,`param_sha_code` varchar(64) COLLATE utf8_bin DEFAULT NULL,PRIMARY KEY (`fault_id`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
DROP TABLE IF EXISTS `t_fault_statistic`;
CREATE TABLE `t_fault_statistic` (`fault_id` BIGINT(20) NOT NULL,  `fault_define_id` VARCHAR(32) COLLATE utf8_bin NOT NULL,  `mo_id` BIGINT(20) DEFAULT NULL,  `extend_mo_id` BIGINT(20) DEFAULT NULL,  `severity` TINYINT(4) NOT NULL,  PRIMARY KEY (`fault_id`)) ENGINE=MEMORY DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `t_fault_detail`;
CREATE TABLE `t_fault_detail` (  `fault_detail_id` bigint(20) NOT NULL AUTO_INCREMENT,  `fault_id` bigint(20) NOT NULL,  `severity` int(11) DEFAULT NULL,  `create_time` datetime DEFAULT NULL,  `clear_status` tinyint(4) DEFAULT NULL,  `clear_time` datetime DEFAULT NULL,  `clear_user` varchar(32) COLLATE utf8_bin DEFAULT NULL,  `confirm_status` tinyint(4) DEFAULT NULL,  `confirm_time` datetime DEFAULT NULL,  `confirm_user` varchar(32) COLLATE utf8_bin DEFAULT NULL,  `fault_param` varchar(5120) COLLATE utf8_bin DEFAULT NULL,  PRIMARY KEY (`fault_detail_id`)) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
ALTER TABLE `t_fault_detail` ADD INDEX t_fault_detail_fault_id ( `fault_id` );
ALTER TABLE `t_fault_detail` ADD INDEX t_fault_detail_create_time( `create_time` );

DROP TABLE IF EXISTS `t_atic_dev_syslog`;
CREATE TABLE `t_atic_dev_syslog` (  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,  `atic_time` bigint(20) DEFAULT NULL,  `log_time` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `dev_ip` varchar(64) COLLATE utf8_bin DEFAULT NULL,  `dev_id` bigint(20) DEFAULT NULL,  `task` varchar(64) COLLATE utf8_bin DEFAULT NULL,  `terminal_ip` varchar(64) COLLATE utf8_bin DEFAULT NULL,  `user` varchar(64) COLLATE utf8_bin DEFAULT NULL,  `vrf` varchar(64) COLLATE utf8_bin DEFAULT NULL,  `command` varchar(128) COLLATE utf8_bin DEFAULT NULL,  `detail` text COLLATE utf8_bin,  PRIMARY KEY (`pkid`)) ENGINE=InnoDB AUTO_INCREMENT=6818 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
ALTER TABLE `t_atic_dev_syslog` ADD INDEX t_atic_dev_syslog_atic_time ( `atic_time` );
ALTER TABLE `t_atic_dev_syslog` ADD INDEX t_atic_dev_syslog_dev_ip ( `dev_ip` );
ALTER TABLE `t_atic_dev_syslog` ADD INDEX t_atic_dev_syslog_terminal_ip ( `terminal_ip` );
ALTER TABLE `t_atic_dev_syslog` ADD INDEX t_atic_dev_syslog_user ( `user` );
ALTER TABLE `t_atic_dev_syslog` ADD INDEX t_atic_dev_syslog_command ( `command` );

DROP TABLE IF EXISTS `t_atic_nfa_syslog`;
CREATE TABLE IF NOT EXISTS `t_atic_nfa_syslog` (  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,  `atic_time` bigint(20) DEFAULT NULL,  `dev_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `dev_id` bigint(20) DEFAULT NULL,  `anomalyId` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `creationTime` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `updateTime` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `type` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `subType` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `severity` varchar(16) COLLATE utf8_bin DEFAULT NULL,  `status` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `direction` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `resource` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `resourceId` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `importance` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `current` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `threshold` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `unit` varchar(16) COLLATE utf8_bin DEFAULT NULL,  `dstIp1` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `dstIp2` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `dstIp3` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `dstPort1` varchar(16) COLLATE utf8_bin DEFAULT NULL,  `dstPort2` varchar(16) COLLATE utf8_bin DEFAULT NULL,  `srcIp1` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `srcIp2` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `srcIp3` varchar(255) COLLATE utf8_bin DEFAULT NULL,  `srcPort1` varchar(16) COLLATE utf8_bin DEFAULT NULL,  `srcPort2` varchar(16) COLLATE utf8_bin DEFAULT NULL,  `protocol` varchar(16) COLLATE utf8_bin DEFAULT NULL,  `url` varchar(511) COLLATE utf8_bin DEFAULT NULL,  `remark` varchar(511) COLLATE utf8_bin DEFAULT NULL,  `detail` text COLLATE utf8_bin,  PRIMARY KEY (`pkid`)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
ALTER TABLE `t_atic_nfa_syslog` ADD INDEX t_atic_nfa_syslog_atic_time ( `atic_time` );
ALTER TABLE `t_atic_nfa_syslog` ADD INDEX t_atic_nfa_syslog_dev_ip ( `dev_ip` );