/* use when UPDATE B022 TO B023 */
USE `lego`;
DELIMITER $$
DROP VIEW IF EXISTS `v_secnesigsas_inner_service`$$
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `v_secnesigsas_inner_service` AS (SELECT `zs`.`zone_id` AS `zone_id`,`zs`.`protocol` AS `protocol`,`zs`.`pkid` AS `pkid`,`zs`.`service_name` AS `service_name`,`zi`.`zone_type` AS `zone_type` FROM ((`t_vsm_zone_service` `zs` JOIN `t_secnesigsas` `sas` ON((`zs`.`device_id` = `sas`.`moid`))) JOIN `t_atic_zone_info` `zi` ON(((`zs`.`zone_id` = `zi`.`zone_id`) AND (`zi`.`zone_type` = 3)))))$$
DELIMITER ;

USE `lego`;
DROP TRIGGER /*!50032 IF EXISTS */ `ti_t_vsm_zone_notexcel`;
DELIMITER $$
CREATE TRIGGER `ti_t_vsm_zone_notexcel` AFTER INSERT ON `t_vsm_zone_notexcel` 
    FOR EACH ROW BEGIN
          DECLARE deviceId BIGINT DEFAULT NULL;
          DECLARE tcp_limit_rate BIGINT DEFAULT NULL;
          DECLARE icmp_limit_rate BIGINT DEFAULT NULL;
          DECLARE udp_limit_rate BIGINT DEFAULT NULL;
          DECLARE other_limit_rate BIGINT DEFAULT NULL;
          DECLARE total_limit_rate BIGINT DEFAULT NULL;
          DECLARE tcp_warn_limit_rate BIGINT DEFAULT NULL;
          DECLARE icmp_warn_limit_rate BIGINT DEFAULT NULL;
          DECLARE udp_warn_limit_rate BIGINT DEFAULT NULL;
          DECLARE other_warn_limit_rate BIGINT DEFAULT NULL;
	  SELECT device_id INTO deviceId
	  FROM t_vsm_zone_service WHERE pkid = new.service_id;
	  
          IF ISNULL(deviceId) = 0
	      THEN IF CAST(new.tcp_limit_enable AS SIGNED) = 1
                      THEN SET tcp_limit_rate = new.tcp_limit_rate;
                   END IF;
                   IF CAST(new.icmp_limit_enable AS SIGNED) = 1
                      THEN SET icmp_limit_rate = new.icmp_limit_rate;
                   END IF;
                   IF CAST(new.udp_limit_enable AS SIGNED) = 1
                      THEN SET udp_limit_rate = new.udp_limit_rate;
                   END IF;
                   IF CAST(new.other_limit_enable AS SIGNED) = 1
                      THEN SET other_limit_rate = new.other_limit_rate;
                   END IF;
                   IF CAST(new.total_limit_enable AS SIGNED) = 1
                      THEN SET total_limit_rate = new.total_limit_rate;
                   END IF;
                   IF CAST(new.tcp_warn_enable AS SIGNED) = 1
                      THEN SET tcp_warn_limit_rate = new.tcp_warn_limit_rate;
                   END IF;
                   IF CAST(new.icmp_warn_enable AS SIGNED) = 1
                      THEN SET icmp_warn_limit_rate = new.icmp_warn_limit_rate;
                   END IF;
                   IF CAST(new.udp_warn_enable AS SIGNED) = 1
                      THEN SET udp_warn_limit_rate = new.udp_warn_limit_rate;
                   END IF;
                   IF CAST(new.other_warn_enable AS SIGNED) = 1
                      THEN SET other_warn_limit_rate = new.other_warn_limit_rate;
                   END IF;
                   
                   INSERT INTO sweb.atic_dev_advanced_conf(DEVICE_ID,GLOBAL_TCP,GLOBAL_UDP,GLOBAL_ICMP,GLOBAL_OTHER,GLOBAL_TOTAL,WARN_TCP,WARN_UDP,WARN_ICMP,WARN_OTHER) 
	           VALUES(deviceId,tcp_limit_rate,udp_limit_rate,icmp_limit_rate,other_limit_rate,total_limit_rate,tcp_warn_limit_rate,udp_warn_limit_rate,icmp_warn_limit_rate,other_warn_limit_rate);
          END IF;
END;
$$

DELIMITER ;

USE `lego`;
DROP TRIGGER /*!50032 IF EXISTS */ `tu_t_vsm_zone_notexcel`;
DELIMITER $$
CREATE TRIGGER `tu_t_vsm_zone_notexcel` AFTER UPDATE ON `t_vsm_zone_notexcel` 
    FOR EACH ROW BEGIN
          DECLARE deviceId BIGINT DEFAULT NULL;
          DECLARE tcp_limit_rate BIGINT DEFAULT NULL;
          DECLARE icmp_limit_rate BIGINT DEFAULT NULL;
          DECLARE udp_limit_rate BIGINT DEFAULT NULL;
          DECLARE other_limit_rate BIGINT DEFAULT NULL;
          DECLARE total_limit_rate BIGINT DEFAULT NULL;
          DECLARE tcp_warn_limit_rate BIGINT DEFAULT NULL;
          DECLARE icmp_warn_limit_rate BIGINT DEFAULT NULL;
          DECLARE udp_warn_limit_rate BIGINT DEFAULT NULL;
          DECLARE other_warn_limit_rate BIGINT DEFAULT NULL;
	  SELECT device_id INTO deviceId
	  FROM t_vsm_zone_service WHERE pkid = new.service_id;
	  
          IF ISNULL(deviceId) = 0
	      THEN IF CAST(new.tcp_limit_enable AS SIGNED) = 1
                      THEN SET tcp_limit_rate = new.tcp_limit_rate;
                   END IF;
                   IF CAST(new.icmp_limit_enable AS SIGNED) = 1
                      THEN SET icmp_limit_rate = new.icmp_limit_rate;
                   END IF;
                   IF CAST(new.udp_limit_enable AS SIGNED) = 1
                      THEN SET udp_limit_rate = new.udp_limit_rate;
                   END IF;
                   IF CAST(new.other_limit_enable AS SIGNED) = 1
                      THEN SET other_limit_rate = new.other_limit_rate;
                   END IF;
                   IF CAST(new.total_limit_enable AS SIGNED) = 1
                      THEN SET total_limit_rate = new.total_limit_rate;
                   END IF;
                   IF CAST(new.tcp_warn_enable AS SIGNED) = 1
                      THEN SET tcp_warn_limit_rate = new.tcp_warn_limit_rate;
                   END IF;
                   IF CAST(new.icmp_warn_enable AS SIGNED) = 1
                      THEN SET icmp_warn_limit_rate = new.icmp_warn_limit_rate;
                   END IF;
                   IF CAST(new.udp_warn_enable AS SIGNED) = 1
                      THEN SET udp_warn_limit_rate = new.udp_warn_limit_rate;
                   END IF;
                   IF CAST(new.other_warn_enable AS SIGNED) = 1
                      THEN SET other_warn_limit_rate = new.other_warn_limit_rate;
                   END IF;
		   UPDATE sweb.atic_dev_advanced_conf SET GLOBAL_TCP=tcp_limit_rate,GLOBAL_UDP=udp_limit_rate,GLOBAL_ICMP=icmp_limit_rate,GLOBAL_OTHER=other_limit_rate,GLOBAL_TOTAL=total_limit_rate,WARN_TCP=tcp_warn_limit_rate,WARN_UDP=udp_warn_limit_rate,WARN_ICMP=icmp_warn_limit_rate,WARN_OTHER=other_warn_limit_rate WHERE DEVICE_ID=deviceId;
          
          END IF;
END;
$$

DELIMITER ;

USE `lego`;
DROP TRIGGER /*!50032 IF EXISTS */ `td_t_vsm_zone_notexcel`;
DELIMITER $$
CREATE TRIGGER `td_t_vsm_zone_notexcel` AFTER DELETE ON `t_vsm_zone_notexcel` 
    FOR EACH ROW BEGIN
          DECLARE deviceId BIGINT DEFAULT NULL;
    SELECT device_id INTO deviceId
	  FROM t_vsm_zone_service WHERE pkid = old.service_id;
	  
          IF ISNULL(deviceId) = 0
	      THEN DELETE FROM sweb.atic_dev_advanced_conf WHERE DEVICE_ID=deviceId;
          END IF;
END;
$$

DELIMITER ;

USE `lego`;
DROP TABLE IF EXISTS `atic_sig_sasareamap`;
CREATE TABLE `atic_sig_sasareamap` (
  `pkid` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `SAS_IP` BIGINT(20) NOT NULL,
  `AREA_ID` BIGINT(20) NOT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

USE `lego`;
DROP PROCEDURE IF EXISTS add_area_map;   
DELIMITER $$
CREATE PROCEDURE `lego`.`add_area_map`()
    BEGIN
		DECLARE areaId BIGINT;   
		DECLARE s INT DEFAULT 0;
		DECLARE sasIp BIGINT;   
		DECLARE cursor_areaId CURSOR FOR SELECT DISTINCT SIG_AREAID FROM atic_sig_cusidmap;
		DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET s=1;            
		SELECT INET_ATON(tto.ip_address) INTO sasIp FROM t_topoobject tto INNER JOIN t_managedobject tmo ON tto.moid = tmo.moid AND tmo.discriminator = 'SecNESigSas' LIMIT 1;
		IF(!ISNULL(sasIp) AND sasIp <> 0 AND sasIp <> '')
			THEN 
				OPEN cursor_areaId;   
				FETCH  cursor_areaId INTO areaId;   
				WHILE s <> 1 DO   
					INSERT INTO atic_sig_sasareamap(SAS_IP,AREA_ID) VALUES(sasIp,areaId);   
					FETCH  cursor_areaId INTO areaId;
				END WHILE;   
				CLOSE cursor_areaId ;   
		END IF;
    END$$
DELIMITER ;
CALL add_area_map();
DROP PROCEDURE IF EXISTS add_area_map;

INSERT INTO atic_sig_sycinfo(infoKey, infoValue) VALUES( 'sigDBIP', (SELECT CASE WHEN (SELECT COUNT(1) FROM t_sigsasinfo) > 0 THEN (SELECT ipaddressofdb FROM t_sigsasinfo LIMIT 1) ELSE '' END));
INSERT INTO atic_sig_sycinfo(infoKey, infoValue) VALUES( 'sigDBUserName', (SELECT CASE WHEN (SELECT COUNT(1) FROM t_sigsasinfo) > 0 THEN (SELECT usernameofdb FROM t_sigsasinfo LIMIT 1) ELSE '' END));
INSERT INTO atic_sig_sycinfo(infoKey, infoValue) VALUES( 'sigDBPassWord', (SELECT CASE WHEN (SELECT COUNT(1) FROM t_sigsasinfo) > 0 THEN (SELECT passwordofdb FROM t_sigsasinfo LIMIT 1) ELSE '' END));
UPDATE atic_sig_sycinfo SET infoKey = 'lastTimeAreaIds' WHERE infoKey = 'areaIds';
INSERT INTO atic_sig_sycinfo(infoKey, infoValue) VALUES( 'areaIds', (SELECT CASE WHEN (SELECT COUNT(1) FROM t_sigsasinfo) > 0 THEN (SELECT areaids FROM t_sigsasinfo LIMIT 1) ELSE '' END));
INSERT INTO atic_sig_sycinfo(infoKey, infoValue) VALUES('lastTimeSyncSigZoneInfo','');
USE `lego`;
DROP TABLE IF EXISTS `t_sigsasinfo`;

ALTER TABLE `lego`.`t_vsm_zone_device`  ADD COLUMN `vpn_name` VARCHAR(255) DEFAULT '';

/*B022 TO B023 dnsflood modify*/
alter table `lego`.`t_vsm_zone_dnsflood` add column `srcip_other_req_mode` int(11) NULL after `srcip_req_limit_enable`;
alter table `lego`.`t_vsm_zone_dnsflood` add column `srcip_other_resp_mode` int(11) NULL after `srcip_resp_alert_rate`;

/*B023 version divert delay time unit is min */
ALTER TABLE `lego`.`t_atic_logholdtime`  ADD COLUMN `divertDelay_Time` int(10) DEFAULT '5';
UPDATE `lego`.`t_atic_divert_tactics` SET `vpn_name` = '' WHERE ISNULL(`vpn_name`);
UPDATE t_vsm_neconf_abnormaldfn SET params = (SELECT params FROM (SELECT t.device_id, CASE WHEN t.device_id IN (SELECT MOID FROM lego.t_ne WHERE devosversionname LIKE '%V200R001%' AND devversionname LIKE '%8000E%') AND t.deploy_state <> 'UNDEPLOY' THEN CONCAT(t.PARAMS,'LARGE_UDP:0:4000:Bytes:28:65535,') WHEN t.device_id IN (SELECT MOID FROM lego.t_ne WHERE devosversionname LIKE '%V200R001%' AND devversionname LIKE '%8000E%') AND t.deploy_state = 'UNDEPLOY' THEN CONCAT(t.PARAMS,',LARGE_UDP:0:4000:Bytes:28:65535') ELSE t.params END AS params FROM t_vsm_neconf_abnormaldfn t) m WHERE t_vsm_neconf_abnormaldfn.device_id = m.device_id);
