/* use when UPDATE B029 TO B033 */
USE `lego`;

set global log_bin_trust_function_creators=TRUE;
CREATE TABLE IF NOT EXISTS `t_atic_zone_list_ip` (
  `pkid` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `zone_id` BIGINT(20) DEFAULT NULL,
  `zone_ip` VARCHAR(32) DEFAULT NULL,
  `string_mask` VARCHAR(32) DEFAULT NULL,
  `int_mask` INT(11) DEFAULT NULL,
  `start_ip` VARCHAR(32) DEFAULT NULL,
  `end_ip` VARCHAR(32) DEFAULT NULL,
  `ip_type` INT(11) DEFAULT NULL,
  `mask_type` INT(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=INNODB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

USE `lego`;
DROP PROCEDURE IF EXISTS add_Ip_to_ListIp;   
DELIMITER $$
CREATE PROCEDURE `lego`.`add_Ip_to_ListIp`()
    BEGIN
		DECLARE s INT DEFAULT 0;
		DECLARE zoneId BIGINT(20); 
		DECLARE zoneIp VARCHAR(32);   
		DECLARE zoneMask VARCHAR(32);  
		DECLARE startIp BIGINT(20);  
		DECLARE endIp BIGINT(20); 
		DECLARE cursor_zoneIp CURSOR FOR SELECT zone_id,zone_ip,mask,start_ip,end_ip FROM t_atic_zone_ip;
		DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET s=1;            
		OPEN cursor_zoneIp;   
		FETCH  cursor_zoneIp INTO zoneId, zoneIp, zoneMask, startIp, endIp;   
		WHILE s <> 1 DO   
			INSERT INTO t_atic_zone_list_ip(zone_id,zone_ip,string_mask,int_mask,start_ip,end_ip,ip_type,mask_type) VALUES(zoneId,zoneIp,zoneMask,0,INET_NTOA(startIp),INET_NTOA(endIp),0,0);   
			FETCH  cursor_zoneIp INTO zoneId, zoneIp, zoneMask, startIp, endIp;  
		END WHILE;   
		CLOSE cursor_zoneIp ;   
    END$$
DELIMITER ;
CALL add_Ip_to_ListIp();
DROP PROCEDURE IF EXISTS add_Ip_to_ListIp;

DROP TRIGGER /*!50032 IF EXISTS */ `ti_t_atic_collector_device`;
DELIMITER $$
CREATE TRIGGER `ti_t_atic_collector_device` AFTER INSERT ON `t_atic_collector_device` 
    FOR EACH ROW 
    BEGIN
        DECLARE countSwebDevice INT;
        DECLARE collectorId INT;
        DECLARE collectorIP VARCHAR(255);
        SELECT COUNT(1) INTO countSwebDevice FROM sweb.atic_device WHERE PKID = new.device_id;
        IF countSwebDevice > 0
            THEN SELECT PKID INTO collectorId FROM sweb.atic_collector WHERE PKID = new.collector_id;
                 IF (ISNULL(collectorId) = 0)
                     THEN UPDATE sweb.atic_device SET COLLECTOR = new.collector_id WHERE PKID = new.device_id;
                     ELSE SELECT too.ip_address INTO collectorIP FROM t_topoobject too WHERE too.moid = new.collector_id;
                          INSERT INTO sweb.atic_collector(PKID,COLLECTOR_IP,LINK_STATUS,COLLECTOR_STATUS,COLLECTOR_NAME,LOG_SERVER,REMARK,XML_FTP_IP,FTP_USERNAME,FTP_PASSWORD,FTP_PORT) 
	                            VALUES(NEW.collector_id, INET_ATON(collectorIP) ,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
	                        UPDATE sweb.atic_device SET COLLECTOR = new.collector_id WHERE PKID = new.device_id;
                 END IF;
        END IF;
    END;
$$
DELIMITER ;


DROP TRIGGER /*!50032 IF EXISTS */ `tu_t_atic_collector_device`;
DELIMITER $$
CREATE TRIGGER `tu_t_atic_collector_device` AFTER UPDATE ON `t_atic_collector_device` 
    FOR EACH ROW 
    BEGIN
        DECLARE countSwebDevice INT;
        SELECT COUNT(1) INTO countSwebDevice FROM sweb.atic_device WHERE PKID = new.device_id;
        IF countSwebDevice > 0
            THEN UPDATE sweb.atic_device SET COLLECTOR = new.collector_id where PKID = new.device_id;
        END IF;
    END;
$$
DELIMITER ;


DROP TRIGGER /*!50032 IF EXISTS */ `td_t_atic_collector_device`;
DELIMITER $$
CREATE TRIGGER `td_t_atic_collector_device` AFTER DELETE ON `t_atic_collector_device` 
    FOR EACH ROW 
    BEGIN
        DECLARE countSwebDevice INT;
        SELECT COUNT(1) INTO countSwebDevice FROM sweb.atic_device WHERE PKID = old.device_id;
        IF countSwebDevice > 0
            THEN UPDATE sweb.atic_device SET COLLECTOR = NULL WHERE PKID = old.device_id;
        END IF;
    END;
$$
DELIMITER ;

/* delete the finger item that the content length is less than four */
DELIMITER $$
USE `lego`$$
DROP FUNCTION IF EXISTS `FNGRPRNT_CONTENT_LENGTH`$$
CREATE FUNCTION `FNGRPRNT_CONTENT_LENGTH`(CONTENT VARCHAR(255)) RETURNS INT(11)
BEGIN 
DECLARE rs INT;
DECLARE PRI_CONTENT VARCHAR(255);
DECLARE SUB_CONTENT VARCHAR(255);
DECLARE C_INDEX  INT;
SET SUB_CONTENT = CONTENT;
SET C_INDEX = 10;
SET rs =LENGTH(SUB_CONTENT);
WHILE C_INDEX > 0 DO
	SET C_INDEX = POSITION(';' IN SUB_CONTENT);
	IF C_INDEX >0 THEN
		SET PRI_CONTENT = SUBSTRING_INDEX(SUB_CONTENT,';',1);
	        SET SUB_CONTENT = SUBSTRING(SUB_CONTENT,C_INDEX+1);
	ELSE 
	        SET PRI_CONTENT = SUB_CONTENT;
	END IF;
	IF  LENGTH(PRI_CONTENT) < rs THEN     
		SET rs = LENGTH(PRI_CONTENT);
	END IF;
END WHILE;
RETURN(rs);
END$$
DELIMITER ;

DELETE FROM  t_vsm_zone_tcp_fngrprnt WHERE FNGRPRNT_CONTENT_LENGTH(content)<4 ;
DELETE FROM  t_vsm_zone_udp_user_finger WHERE FNGRPRNT_CONTENT_LENGTH(content)<4 ;
DELETE FROM  t_vsm_zone_icmp_user_finger WHERE FNGRPRNT_CONTENT_LENGTH(content)<4 ;
DELETE FROM  t_vsm_zone_http_fngrprnt WHERE FNGRPRNT_CONTENT_LENGTH(content)<4 ;
DELETE FROM  t_vsm_zone_dns_user_finger WHERE FNGRPRNT_CONTENT_LENGTH(content)<4 ;
DELETE FROM  t_vsm_zone_ip_fngrprnt WHERE FNGRPRNT_CONTENT_LENGTH(content)<4 ;
DROP FUNCTION IF EXISTS `FNGRPRNT_CONTENT_LENGTH`;
/* delete the finger item that the content length is less than four */

 
/* use when UPDATE B029 TO B033 */
USE lego;
DROP TABLE IF EXISTS `t_atic_zombie_relation`;
CREATE TABLE `t_atic_zombie_relation` (`pkid` INT(11) NOT NULL,`bot_id` INT(10) DEFAULT NULL,`bot_name` VARCHAR(255) DEFAULT NULL,PRIMARY KEY (`pkid`)) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (1,18,'Net.Sasser.g');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (2,22,'Net.Viking.a');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (3,23,'Net.WhBoy');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (4,123,'Net-Worm.CodeRed');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (5,137,'Net-Worm.Slammer');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (6,156,'Net-Worm.Win32.Nimda');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (7,2049,'Rejoice');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (8,2051,'GrayPigeon');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (9,2069,'Boer_Rat');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (10,2113,'DarkShell');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (11,2142,'Gh0st_Family');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (12,2313,'Platinum_Rat');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (13,2477,'BlackEnergy');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (14,2565,'CyberGate');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (15,2566,'DarkComet');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (16,2567,'Apocalypse');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (17,2590,'Warbot');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (18,2594,'NOPE_Bot');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (19,2597,'SpyEye');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (20,2598,'Xtreme_Rat2.8');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (21,2600,'IMDDOS');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (22,2900,'Agobot/Phatbot/Forbot/Xtrembot');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (23,2901,'Sdbot/Rxbot/Reptile/Ri0t');
INSERT  INTO `t_atic_zombie_relation`(`pkid`,`bot_id`,`bot_name`) VALUES (24,3399,'Trojan.Win32.AldiBot.cf67');

delete from T_operation_r_role where opt_id = 4085;
delete from T_operation_r_role where opt_id = 4086;

delete from T_operations where opt_id = 4085;
delete from T_operations where opt_id = 4086;

DELETE FROM lego.T_operation_r_role WHERE role_id = 1 AND opt_id = 2360;
DELETE FROM lego.T_operation_r_role WHERE role_id = 2 AND opt_id = 2360;
DELETE FROM lego.T_operation_r_role WHERE role_id = 1 AND opt_id = 2361;
DELETE FROM lego.T_operation_r_role WHERE role_id = 2 AND opt_id = 2361;

DELETE FROM lego.T_operations WHERE opt_id = 2360;
DELETE FROM lego.T_operations WHERE opt_id = 2361;

INSERT INTO  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2360, 'atic.analysis.bot', '/atic/analysis/showBotAnalysisReport.do', '', 0, '7100-100-40');
INSERT INTO lego.T_operation_r_role (role_id, opt_id) VALUES (1, 2360);
INSERT INTO lego.T_operation_r_role (role_id, opt_id) VALUES (2, 2360);
INSERT INTO  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) VALUES(2361, 'atic.analysis.bot.scan', '', '', 1, '7100-100-40-5');
INSERT INTO lego.T_operation_r_role (role_id, opt_id) VALUES (1, 2361);
INSERT INTO lego.T_operation_r_role (role_id, opt_id) VALUES (2, 2361);

UPDATE T_operations SET opt_name='lego.report' WHERE opt_id=4083;
UPDATE T_operations SET opt_name='atic.report' WHERE opt_id=4084;

UPDATE T_operations SET serial_number='7100-100-50' WHERE opt_id=2270;
UPDATE T_operations SET serial_number='7100-100-50-5' WHERE opt_id=2271;
UPDATE T_operations SET serial_number='7100-100-60' WHERE opt_id=2280;
UPDATE T_operations SET serial_number='7100-100-60-5' WHERE opt_id=2281;
UPDATE T_operations SET serial_number='7100-100-70' WHERE opt_id=2290;
UPDATE T_operations SET serial_number='7100-100-70-5' WHERE opt_id=2291;
UPDATE T_operations SET serial_number='7100-100-70-10' WHERE opt_id=2292;
UPDATE T_operations SET serial_number='7100-100-70-15' WHERE opt_id=2293;
UPDATE T_operations SET serial_number='7100-100-70-20' WHERE opt_id=2296;
UPDATE T_operations SET serial_number='7100-100-70-25' WHERE opt_id=2294;
UPDATE T_operations SET serial_number='7100-100-70-30' WHERE opt_id=2295;
UPDATE T_operations SET serial_number='7100-100-80' WHERE opt_id=2300;
UPDATE T_operations SET serial_number='7100-100-80-5' WHERE opt_id=2301;
UPDATE T_operations SET serial_number='7100-100-80-10' WHERE opt_id=2302;
UPDATE T_operations SET serial_number='7100-100-80-15' WHERE opt_id=2304;

delete from lego.T_operation_r_role where opt_id = 71;
delete from lego.T_operation_r_role where opt_id = 72;
delete from lego.T_operation_r_role where opt_id = 205;
delete from lego.T_operation_r_role where opt_id = 206;
delete from lego.T_operation_r_role where opt_id = 207;
delete from lego.T_operation_r_role where opt_id = 208;
delete from lego.T_operation_r_role where opt_id = 2014;
delete from lego.T_operation_r_role where opt_id = 2015;
delete from lego.T_operation_r_role where opt_id = 2016;

delete from lego.T_operations where opt_id = 71;
delete from lego.T_operations where opt_id = 72;
delete from lego.T_operations where opt_id = 205;
delete from lego.T_operations where opt_id = 206;
delete from lego.T_operations where opt_id = 207;
delete from lego.T_operations where opt_id = 208;
delete from lego.T_operations where opt_id = 2014;
delete from lego.T_operations where opt_id = 2015;
delete from lego.T_operations where opt_id = 2016;
ALTER TABLE t_vsm_zone_baseline_study  DROP COLUMN  is_study_indefend;
ALTER TABLE t_vsm_zone_baseline_study  ADD COLUMN `effect_mode` BIT(1) NOT NULL DEFAULT 0 AFTER `auto_inure`;

/*bandwidth limit */
alter table `lego`.`t_vsm_zone_ddos_policy`  add column `zone_limit_enable` bit(1) NULL after `zone_desc`, add column `zone_limit_rate` int(11) NULL after `zone_limit_enable`;

/* http-auth */
ALTER TABLE t_vsm_zone_httpflood  ADD COLUMN `http_after_auth_enable` BIT(1) DEFAULT FALSE AFTER `http_user_finger_enable`;
ALTER TABLE t_vsm_zone_httpflood  ADD COLUMN `after_auth_rate` int(11) DEFAULT 8000 AFTER `http_after_auth_enable`;
ALTER TABLE t_vsm_zone_httpflood  ADD COLUMN `after_auth_action` int(11) DEFAULT 0 AFTER `after_auth_rate`;
ALTER TABLE t_vsm_zone_httpflood  ADD COLUMN `illegal_minnum` int(11) DEFAULT 10 AFTER `illegal_ratio_interval`;
ALTER TABLE t_vsm_zone_httpflood  ADD COLUMN `detect_minnum` int(11) DEFAULT 10 AFTER `detect_interval`;

/* tcp-ratio */
ALTER TABLE t_vsm_zone_tcpflood  ADD COLUMN `tcp_ratio_enable` bit(1) DEFAULT FALSE AFTER `fin_rst_flood_alert_rate`;
ALTER TABLE t_vsm_zone_tcpflood  ADD COLUMN `tcp_ratio_protion` int(11) DEFAULT 20 AFTER `tcp_ratio_enable`;
ALTER TABLE t_vsm_zone_tcpflood  ADD COLUMN `tcp_ratio_ip_range` int(11) DEFAULT 1 AFTER `tcp_ratio_protion`;
ALTER TABLE t_vsm_zone_tcpflood  ADD COLUMN `tcp_ratio_action` int(11) DEFAULT 1 AFTER `tcp_ratio_ip_range`;
ALTER TABLE t_vsm_zone_tcpflood  ADD COLUMN `tcp_ratio_limit_rate` int(11) DEFAULT 3 AFTER `tcp_ratio_action`;

/* udp-finger+udp-contentchec */
ALTER TABLE t_vsm_zone_udpflood  ADD COLUMN `udp_check_enable` bit(1) DEFAULT FALSE AFTER `alert_speed`;
ALTER TABLE t_vsm_zone_udpflood  ADD COLUMN `udp_fingerlearn_enable` bit(1) DEFAULT FALSE AFTER `udp_check_enable`;
ALTER TABLE t_vsm_zone_udpflood  ADD COLUMN `frag_check_enable` bit(1) DEFAULT FALSE AFTER `udp_fingerlearn_enable`;
ALTER TABLE t_vsm_zone_udpflood  ADD COLUMN `frag_fingerlearn_enable` bit(1) DEFAULT FALSE AFTER `frag_check_enable`;

/* other-finger-learn */
ALTER TABLE t_vsm_zone_otherflood  ADD COLUMN `other_defence_enable` bit(1) DEFAULT FALSE AFTER `car_alert_rate`;
ALTER TABLE t_vsm_zone_otherflood  ADD COLUMN `finger_learn_enable` bit(1) DEFAULT FALSE AFTER `other_defence_enable`;
ALTER TABLE t_vsm_zone_otherflood  ADD COLUMN `finger_alert` int(11) DEFAULT 50 AFTER `finger_learn_enable`;
ALTER TABLE t_vsm_zone_otherflood  ADD COLUMN `learn_mode` int(11) DEFAULT 0  AFTER `finger_alert`;
ALTER TABLE t_vsm_zone_otherflood  ADD COLUMN `offset` int(11) DEFAULT 0 AFTER `learn_mode`;
ALTER TABLE t_vsm_zone_otherflood  ADD COLUMN `finger_length` int(11) DEFAULT 8  AFTER `offset`;

/* tcp-finger */
ALTER  TABLE t_vsm_zone_tcp_fngrprnt ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_tcp_fngrprnt SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* udp-finger */
ALTER  TABLE t_vsm_zone_udp_user_finger ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_udp_user_finger SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* icmp-finger */
ALTER  TABLE t_vsm_zone_icmp_user_finger ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_icmp_user_finger SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* http-finger */
ALTER  TABLE t_vsm_zone_http_fngrprnt ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_http_fngrprnt SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* https-finger */
ALTER  TABLE t_vsm_zone_https_fngrprnt ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_https_fngrprnt SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* dns-finger */
ALTER  TABLE t_vsm_zone_dns_user_finger ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_dns_user_finger SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* sip-finger */
ALTER  TABLE t_vsm_zone_sip_user_finger ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_sip_user_finger SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* ip-finger */
ALTER  TABLE t_vsm_zone_ip_fngrprnt ADD (`dev_id` BIGINT(20) DEFAULT NULL,`zone_id` BIGINT(20) DEFAULT NULL,`depth` int(11) DEFAULT NULL,`content_type` int(11) DEFAULT NULL,`match_type` int(11) DEFAULT NULL);
UPDATE t_vsm_zone_ip_fngrprnt SET dev_id  = 0,zone_id=0,depth=0,content_type=2,match_type=1;

/* or quick addZone and filter */
delete from lego.T_operation_r_role where opt_id = 2381;
delete from lego.T_operation_r_role where opt_id = 2382;

delete from lego.T_operations where opt_id = 2381;
delete from lego.T_operations where opt_id = 2382;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2381, 'atic.bis.policy.addZone', '', '', 0, '6500-100-20-6');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2381);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2381);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2382, 'atic.bis.policy.deleteZone', '', '', 0, '6500-100-20-7');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2382);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2382);

delete from lego.T_operation_r_role where opt_id = 2370;
delete from lego.T_operation_r_role where opt_id = 2371;
delete from lego.T_operation_r_role where opt_id = 2372;
delete from lego.T_operation_r_role where opt_id = 2373;
delete from lego.T_operation_r_role where opt_id = 2374;

delete from lego.T_operations where opt_id = 2370;
delete from lego.T_operations where opt_id = 2371;
delete from lego.T_operations where opt_id = 2372;
delete from lego.T_operations where opt_id = 2373;
delete from lego.T_operations where opt_id = 2374;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2370, 'atic.bis.filter', '/vsm/policy/ddos/viewAllFilterTemplate.do', '', 0, '6500-100-70');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2370);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2370);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2371, 'atic.bis.filter.scan', '', '', 1, '6500-100-70-5');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2371);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2371);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2372, 'atic.bis.filter.create', '', '', 0, '6500-100-70-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2372);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2372);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2373, 'atic.bis.filter.delete', '', '', 0, '6500-100-70-15');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2373);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2373);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2374, 'atic.bis.filter.modify', '', '', 0, '6500-100-70-20');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2374);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2374);
/* alert */
UPDATE webnmsdb.extendalert set ALARMPARAM = CONCAT(ALARMPARAM,'-###-###') where ALARMID = '0x0000000803240801';