/*use when UPDATE B061 TO B063*/
USE lego;

/*upgrade for lego from c00 to c01 begin*/

/*file 01_backup_topo_data.sql begin*/
drop table if exists t_T_topo_view;

create table t_T_topo_view select * from T_topo_view;

drop table if exists t_T_topo_ui_element;

create table t_T_topo_ui_element select * from T_topo_ui_element;

drop table if exists t_T_view_r_ui_ele;

create table t_T_view_r_ui_ele select * from T_view_r_ui_ele;


drop table if exists t_T_topo_ui_style;

create table t_T_topo_ui_style select * from T_topo_ui_style;


drop table if exists t_T_topo_ui_ele_r_style;

create table t_T_topo_ui_ele_r_style select * from T_topo_ui_ele_r_style;


drop table if exists t_T_topo_view_r_style;

create table t_T_topo_view_r_style select * from T_topo_view_r_style;

drop table if exists T_view_r_ui_ele;

drop table if exists T_topo_ui_ele_r_style;

drop table if exists T_topo_view_r_style;

drop table if exists T_topo_ui_style;

drop table if exists T_topo_view;

drop table if exists T_topo_ui_element;


/*file 02_create_topo_table.sql begin*/
drop table if exists T_topo_ele_r_style;


drop table if exists T_topo_style;


drop table if exists T_topo_view;


drop table if exists T_topo_uiele;


drop table if exists T_topo_ele;


CREATE TABLE t_topo_ele ( 
    ele_id       	bigint(20) AUTO_INCREMENT NOT NULL,
    discriminator	varchar(255) NOT NULL,
    dis_name     	varchar(255) NULL,
    parent_id    	bigint(20) NULL,
    PRIMARY KEY(ele_id)
);

ALTER TABLE t_topo_ele
    ADD CONSTRAINT FKF4C204245F90FFD4
	FOREIGN KEY(parent_id)
	REFERENCES t_topo_ele(ele_id)
	ON DELETE RESTRICT 
	ON UPDATE RESTRICT ;


CREATE TABLE t_topo_uiele ( 
    ele_id       	bigint(20) NOT NULL,
    ele_type     	bigint(20) NULL,
    ele_main_type	varchar(255) NULL,
    ele_sub_type 	varchar(255) NULL,
    entity_id    	varchar(255) NULL,
    alias_name   	varchar(255) NULL,
    appendix_info	varchar(255) NULL,
    PRIMARY KEY(ele_id)
);


ALTER TABLE t_topo_uiele
    ADD CONSTRAINT FKCD31B3902CF0E1E6
	FOREIGN KEY(ele_id)
	REFERENCES t_topo_ele(ele_id)
	ON DELETE CASCADE 
	ON UPDATE RESTRICT ;



CREATE TABLE t_topo_view ( 
    ele_id     	bigint(20) NOT NULL,
    parent_id  	bigint(20) NULL,
    description	varchar(1024) NULL,
    view_type  	varchar(255) NULL,
    view_icon  	varchar(255) NULL,
    op_id      	varchar(255) NULL,
    view_menu  	varchar(255) NULL,
    layout     	varchar(255) NULL,
    swf_url    	varchar(255) NULL,
    PRIMARY KEY(ele_id)
);


ALTER TABLE t_topo_view
    ADD CONSTRAINT FKA3862FDFBC9003F9
	FOREIGN KEY(ele_id)
	REFERENCES t_topo_ele(ele_id)
	ON DELETE CASCADE 
	ON UPDATE RESTRICT ;


CREATE TABLE t_topo_style ( 
    style_id	bigint(20) AUTO_INCREMENT NOT NULL,
    name    	varchar(255) NULL,
    value   	varchar(255) NULL,
    PRIMARY KEY(style_id)
);



CREATE TABLE t_topo_ele_r_style ( 
    ele_id  	bigint(20) NOT NULL,
    style_id	bigint(20) NOT NULL,
    name    	varchar(255) NOT NULL,
    PRIMARY KEY(ele_id,name)
);


ALTER TABLE t_topo_ele_r_style
    ADD CONSTRAINT FKC1DB2A89E5C01A28
	FOREIGN KEY(style_id)
	REFERENCES t_topo_style(style_id)
	ON DELETE RESTRICT 
	ON UPDATE RESTRICT ;

ALTER TABLE t_topo_ele_r_style
    ADD CONSTRAINT FKC1DB2A8996A50B60
	FOREIGN KEY(ele_id)
	REFERENCES t_topo_ele(ele_id)
	ON DELETE RESTRICT 
	ON UPDATE RESTRICT ;


/*file 03_recover_topo_data.sql begin*/

drop table if exists t_topo_id_map;

create table t_topo_id_map
(
    old_id bigint(20) not null,
    new_id bigint(20) null,
	old_parent_id bigint(20) null,
	new_parent_id bigint(20) null,
	entity_id varchar(255) not NULL
);

alter table t_topo_ele add entity_id varchar(255) NULL;

insert into T_topo_ele (ele_id, discriminator, dis_name, parent_id) 
(select view_id, discriminator, name, parent_id from t_T_topo_view);

insert into T_topo_view (ele_id, parent_id, description, view_type, view_icon, op_id, view_menu, layout, swf_url) 
(select view_id, parent_id, description, view_type, 'viewNode.png', op_id, null, layout, swf_url from t_T_topo_view);

insert into T_topo_ele (discriminator, dis_name, entity_id) 
(select 'UIElement', dis_name, entity_id from t_T_topo_ui_element);

insert into t_topo_id_map (old_id, old_parent_id, entity_id) 
(select ui_ele_id, element_id, entity_id from t_T_topo_ui_element);

update t_topo_id_map idmap,  T_topo_ele src set idmap.new_id = src.ele_id where idmap.entity_id = src.entity_id and src.entity_id is not null;

update t_topo_id_map idmap,  t_topo_id_map src set idmap.new_parent_id = src.new_id where idmap.old_parent_id is not null and idmap.old_parent_id = src.old_id;

update t_topo_id_map target, t_T_view_r_ui_ele src set target.new_parent_id = src.view_id where target.old_id = src.ui_ele_id;

update T_topo_ele target, t_topo_id_map src set target.parent_id = src.new_parent_id where src.new_parent_id is not null and target.entity_id = src.entity_id;

insert into T_topo_uiele (ele_id, ele_type, ele_main_type, ele_sub_type, entity_id, alias_name, appendix_info)
(select idmap.new_id, src.ele_type, src.ele_main_type, src.ele_sub_type, src.entity_id, src.alias_name, src.appendix_info from t_T_topo_ui_element src, t_topo_id_map idmap where src.entity_id = idmap.entity_id);

INSERT INTO T_topo_style (style_id, NAME, VALUE)
(SELECT style_id, NAME, VALUE FROM t_T_topo_ui_style);

insert into T_topo_ele_r_style (ele_id, style_id, name)
(select ui_ele_id, style_id, name from t_T_topo_view_r_style);

insert into T_topo_ele_r_style (ele_id, style_id, name)
(select idmap.new_id, src.style_id, src.name from t_T_topo_ui_ele_r_style src, t_topo_id_map idmap where src.ui_ele_id = idmap.old_id);

alter table t_topo_ele drop column entity_id;

/*file 04_t_managedobject.sql begin*/
drop table if exists t_fk_tbl;

create table t_fk_tbl
(
    fk_name varchar(256) not null,
    tb_name varchar(256) not null,
	tb_col_name varchar(256) not null
);

drop table if exists t_parent_id_rel;

create table t_parent_id_rel select moid, parent_id from T_managedobject;

insert into t_fk_tbl (fk_name, tb_name, tb_col_name) 
(select constraint_name, table_name,  column_name from information_schema.KEY_COLUMN_USAGE where table_name='t_managedobject' and referenced_table_name = 't_managedobject' and referenced_column_name = 'moid');

drop procedure if exists dropFK;
DELIMITER $$
CREATE PROCEDURE dropFK()
begin
declare done int default false;
declare c_tb_name varchar(256);
declare c_fk_name varchar(256);
declare cur cursor for select tb_name, fk_name from lego.t_fk_tbl;
declare continue handler for not found set done = true;
open cur;
read_loop: loop
    fetch cur INTO c_tb_name, c_fk_name;
    IF done THEN
      LEAVE read_loop;
    END IF;
    set @sql_txt = concat('alter table ',c_tb_name,' drop foreign key ',  c_fk_name);
    prepare stmt from @sql_txt;
    execute stmt;
  end loop;
close cur;
END$$
DELIMITER ;

call dropFK();

alter table T_managedobject
drop column parent_id;

alter table T_managedobject
add topo_element_id bigint(20) NULL;

alter table T_managedobject
add perf_type varchar(255) NULL;

alter table T_managedobject
add parent_id bigint(20) NULL;

update T_managedobject a, t_parent_id_rel b set a.parent_id = b.parent_id where a.moid = b.moid;

drop procedure if exists recoverFK;
DELIMITER $$
CREATE PROCEDURE recoverFK()
begin
declare done int default false;
declare c_tb_name varchar(256);
declare c_col_name varchar(256);
declare c_fk_name varchar(256);

declare cur cursor for select tb_name,tb_col_name,fk_name from lego.t_fk_tbl;
declare continue handler for not found set done = true;
open cur;
read_loop: loop
    fetch cur INTO c_tb_name, c_col_name, c_fk_name;
    IF done THEN
      LEAVE read_loop;
    END IF;
    set @sql_txt = concat('alter table ',c_tb_name,' add constraint ',  c_fk_name, ' foreign key( ' , c_col_name,' ) references t_managedobject(moid) on delete restrict on update restrict');
    prepare stmt from @sql_txt;
    execute stmt;
  end loop;
close cur;
END$$
DELIMITER ;

call recoverFK();

/*file 05_modify_other_table.sql begin*/

alter table T_portalconfig add `opt_id` varchar(255) NULL;

alter table T_sysoplog add `has_detail` int NULL;

alter table T_user add `settime` bigint(20) NULL;

alter table T_user_sec_policy add `unseal` int NULL;

alter table T_user_sec_policy add `usefullife` int NULL;

drop table if exists t_T_discoverypolicy;

create table t_T_discoverypolicy select * from T_discoverypolicy;

drop table if exists T_discoverypolicy;

drop table if exists t_T_ip_r_template;

create table t_T_ip_r_template select * from T_ip_r_template;

drop table if exists T_ip_r_template;
/*file 06_update_other_table.sql begin*/
update T_sysoplog set `has_detail` = 0;

alter table T_sysoplog modify column `has_detail` int not NULL;

update T_portalconfig set `opt_id` = 'lego.evtMgr.curtAlarm.scan';

alter table T_portalconfig modify column `opt_id` varchar(255) not NULL;

update T_user set `settime` = 1349764340417;

update T_user_sec_policy set `unseal` = 1, `usefullife` = 360;
/*file 07_update_static_data.sql begin*/

update T_operations set serial_number = '5000-33' where opt_id = 2014;

update T_operations set serial_number = '5000-32' where opt_id = 2015;

delete from T_alarm_faultdefine where mosubtype like 'AMS%';

delete from T_alarm_faultdefine where mosubtype like 'SIG%';

delete from T_alarm_faultdefine where mosubtype like 'SVN3000%';

delete from T_device_type_relation where child_type like 'AMS%';

delete from T_device_type_relation where child_type like 'SIG%';

delete from T_device_type_relation where child_type like 'SVN3000%';

delete from T_sub_device_type where name like 'AMS%';

delete from T_sub_device_type where name like 'SIG%';

delete from T_sub_device_type where name like 'SVN3000%';
/*file 08_update_license_data.sql begin*/
update T_licenseconsume set feature = 'VSMDRM', res_item = 'LVP2DRM05';

update T_licenseconsumepolicy set res_main_type = 'VSM',  res_sub_type = 'VSM';

delete from T_licenseinfo;
/*file 09_drop_useless_table.sql begin*/
/* drop table if exists t_T_view_r_ui_ele;*/

/* drop table if exists t_T_topo_view;*/

/* drop table if exists t_T_topo_ui_element;*/

/* drop table if exists t_T_topo_ui_style;*/

/* drop table if exists t_T_topo_ui_ele_r_style;*/

/* drop table if exists t_T_topo_view_r_style;*/

/* drop table if exists t_T_discoverypolicy;*/

/* drop table if exists t_T_ip_r_template;*/

/* drop table if exists t_topo_id_map;*/

/* drop table if exists t_fk_tbl;*/

/* drop procedure if exists dropFK;*/

/* drop procedure if exists recoverFK;*/

/*upgrade for lego from c00 to c01 end*/

DROP TABLE IF EXISTS `t_atic_report_config`;
CREATE TABLE `t_atic_report_config` (`pkid` INT(11) NOT NULL auto_increment,`report_var` VARCHAR(255) DEFAULT NULL,`report_value` VARCHAR(255) DEFAULT NULL,PRIMARY KEY (`pkid`)) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

/*delete zoneReport */
delete from T_operation_r_role where opt_id = 2280;
delete from T_operation_r_role where opt_id = 2281;

delete from T_operations where opt_id = 2280;
delete from T_operations where opt_id = 2281;

/*add reportConfig */
delete from T_operation_r_role where opt_id = 2390;
delete from T_operation_r_role where opt_id = 2391;
delete from T_operation_r_role where opt_id = 2392;

delete from T_operations where opt_id = 2390;
delete from T_operations where opt_id = 2391;
delete from T_operations where opt_id = 2392;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2390, 'atic.report.reportConfig', '/atic/report/showReportConfig.do', '', 0, '7100-100-45');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2390);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2390);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2391, 'atic.report.reportConfig.scan', '', '', 1, '7100-100-45-5');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2391);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2391);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2392, 'atic.report.reportConfig.modify', '', '', 0, '7100-100-45-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2392);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2392);

/*device syslog table*/
USE lego;
CREATE TABLE IF NOT EXISTS `t_atic_dev_syslog` (
  `pkid` INT(11) NOT NULL AUTO_INCREMENT,
  `log_time` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
  `dev_ip` VARCHAR(64) COLLATE utf8_bin DEFAULT NULL,
  `task` VARCHAR(64) COLLATE utf8_bin DEFAULT NULL,
  `terminal_ip` VARCHAR(64) COLLATE utf8_bin DEFAULT NULL,
  `user` VARCHAR(64) COLLATE utf8_bin DEFAULT NULL,
  `vrf` VARCHAR(64) COLLATE utf8_bin DEFAULT NULL,
  `command` VARCHAR(128) COLLATE utf8_bin DEFAULT NULL,
  `detail` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY  (`pkid`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

/*log hold time table*/
ALTER TABLE t_atic_logholdtime  ADD  COLUMN `devsyslog_Time` INT(11) DEFAULT 90 AFTER `divertDelay_Time`;
UPDATE t_atic_logholdtime  SET devsyslog_Time=90;

/* upgrade for ipv6 begin*/
drop function if exists getIntMask;
DELIMITER $$
CREATE FUNCTION `lego`.`getIntMask`( STRMASK VARCHAR(15))
    RETURNS  INT
    BEGIN
    DECLARE INTMASK INT;
    SELECT (CASE 
    WHEN STRMASK = '0.0.0.0' THEN '0'
    WHEN STRMASK = '128.0.0.0' THEN '1' 
    WHEN STRMASK = '192.0.0.0' THEN '2' 
    WHEN STRMASK = '224.0.0.0' THEN '3' 
    WHEN STRMASK = '240.0.0.0' THEN '4' 
    WHEN STRMASK = '248.0.0.0' THEN '5' 
    WHEN STRMASK = '252.0.0.0' THEN '6' 
    WHEN STRMASK = '254.0.0.0' THEN '7' 
    WHEN STRMASK = '255.0.0.0' THEN '8' 
    WHEN STRMASK = '255.128.0.0' THEN '9' 
    WHEN STRMASK = '255.192.0.0' THEN '10' 
    WHEN STRMASK = '255.224.0.0' THEN '11' 
    WHEN STRMASK = '255.240.0.0' THEN '12' 
    WHEN STRMASK = '255.248.0.0' THEN '13' 
    WHEN STRMASK = '255.252.0.0' THEN '14' 
    WHEN STRMASK = '255.254.0.0' THEN '15' 
    WHEN STRMASK = '255.255.0.0' THEN '16' 
    WHEN STRMASK = '255.255.128.0' THEN '17' 
    WHEN STRMASK = '255.255.192.0' THEN '18' 
    WHEN STRMASK = '255.255.224.0' THEN '19' 
    WHEN STRMASK = '255.255.240.0' THEN '20' 
    WHEN STRMASK = '255.255.248.0' THEN '21' 
    WHEN STRMASK = '255.255.252.0' THEN '22' 
    WHEN STRMASK = '255.255.254.0' THEN '23' 
    WHEN STRMASK = '255.255.255.0' THEN '24' 
    WHEN STRMASK = '255.255.255.128' THEN '25' 
    WHEN STRMASK = '255.255.255.192' THEN '26' 
    WHEN STRMASK = '255.255.255.224' THEN '27' 
    WHEN STRMASK = '255.255.255.240' THEN '28' 
    WHEN STRMASK = '255.255.255.248' THEN '29' 
    WHEN STRMASK = '255.255.255.252' THEN '30' 
    WHEN STRMASK = '255.255.255.254' THEN '31' 
    WHEN STRMASK = '255.255.255.255' THEN '32' 
      END)  INTO INTMASK ;
RETURN INTMASK;
    END$$
DELIMITER ;

ALTER TABLE t_atic_pcap_acl ADD COLUMN src_IpAndMask VARCHAR(255) AFTER rule_id, ADD COLUMN dst_IpAndMask VARCHAR(255) AFTER src_port,ADD COLUMN iptype VARCHAR(16) NOT NULL;

UPDATE t_atic_pcap_acl SET iptype = 'IPV4';

DROP PROCEDURE IF EXISTS handlePcapAcl;
DELIMITER $$
CREATE PROCEDURE handlePcapAcl()
BEGIN
DECLARE done INT DEFAULT FALSE;
DECLARE id INT;
DECLARE srcip VARCHAR(15);
DECLARE srcwildcard VARCHAR(15);
DECLARE dstip VARCHAR(15);
DECLARE dstwildcard VARCHAR(15);
DECLARE cur CURSOR FOR SELECT pkid,src_ip,src_wildcard,dst_ip,dst_wildcard FROM lego.t_atic_pcap_acl;
DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = TRUE;
OPEN cur;
read_loop: LOOP
    FETCH cur INTO id,srcip, srcwildcard, dstip, dstwildcard;
    IF done THEN
      LEAVE read_loop;
    END IF;
    IF srcwildcard IS NOT NULL THEN
    SELECT getIntMask(src_wildcard) INTO srcwildcard FROM lego.t_atic_pcap_acl WHERE pkid = id;
    SET @sql_txt = CONCAT('UPDATE lego.t_atic_pcap_acl SET src_IpAndMask =\'', srcip, '/', srcwildcard, '\' where pkid = ',id);
    PREPARE stmt FROM @sql_txt;
    EXECUTE stmt;
    END IF;
    IF dstwildcard IS NOT NULL THEN   
    SELECT getIntMask(dst_wildcard) INTO dstwildcard FROM lego.t_atic_pcap_acl WHERE pkid = id;
    SET @sql_txt1 = CONCAT('UPDATE lego.t_atic_pcap_acl SET dst_IpAndMask = \'', dstip, '/', dstwildcard, '\' where pkid = ',id);
    PREPARE stmt1 FROM @sql_txt1;
    EXECUTE stmt1;
    END IF; 
  END LOOP;
CLOSE cur;
END$$
DELIMITER;

CALL handlePcapAcl();

ALTER TABLE lego.t_atic_pcap_acl DROP COLUMN src_ip,DROP COLUMN src_wildcard,DROP COLUMN dst_ip,DROP COLUMN dst_wildcard;

drop function if exists getFullIPV4;
DELIMITER $$
CREATE
    FUNCTION `lego`.`getFullIPV4`( inputIp VARCHAR(15))
    RETURNS  VARCHAR(15)
    BEGIN
    DECLARE fullIp VARCHAR(15);
    DECLARE ipbyte1 VARCHAR(3);
    DECLARE ipbyte2 VARCHAR(3);
    DECLARE ipbyte3 VARCHAR(3);
    DECLARE ipbyte4 VARCHAR(3);
    DECLARE tempStr VARCHAR(7);
    SELECT SUBSTRING_INDEX(inputIp, '.', 1) INTO ipbyte1;
    SELECT SUBSTRING_INDEX(inputIp, '.', -1) INTO ipbyte4;
    SELECT SUBSTRING(inputIp FROM LENGTH(ipbyte1)+2 FOR LENGTH(inputIp)-LENGTH(ipbyte1)-LENGTH(ipbyte4)-2) INTO tempStr;
    SELECT SUBSTRING_INDEX(tempStr, '.', 1) INTO ipbyte2;
    SELECT SUBSTRING_INDEX(tempStr, '.', -1) INTO ipbyte3;
    SET ipbyte1 = ELT(LENGTH(ipbyte1), CONCAT('00',ipbyte1), CONCAT('0',ipbyte1), ipbyte1);
    SET ipbyte2 = ELT(LENGTH(ipbyte2), CONCAT('00',ipbyte2), CONCAT('0',ipbyte2), ipbyte2);
    SET ipbyte3 = ELT(LENGTH(ipbyte3), CONCAT('00',ipbyte3), CONCAT('0',ipbyte3), ipbyte3);
    SET ipbyte4 = ELT(LENGTH(ipbyte4), CONCAT('00',ipbyte4), CONCAT('0',ipbyte4), ipbyte4);
    SET fullIp = CONCAT(ipbyte1,'.',ipbyte2,'.',ipbyte3,'.',ipbyte4);
    RETURN fullIp;
    END$$
DELIMITER ;

UPDATE t_atic_divert_tactics SET mask= getIntMask(mask);
ALTER TABLE t_atic_divert_tactics MODIFY COLUMN mask INT,MODIFY COLUMN start_ip VARCHAR(255),MODIFY COLUMN end_ip VARCHAR(255);
UPDATE t_atic_divert_tactics SET start_ip = getFullIPV4(INET_NTOA(start_ip)),end_ip=getFullIPV4(INET_NTOA(end_ip));

UPDATE t_atic_divert_tactics_log SET mask= getIntMask(mask);
ALTER TABLE t_atic_divert_tactics_log MODIFY COLUMN mask INT,MODIFY COLUMN start_ip VARCHAR(255),MODIFY COLUMN end_ip VARCHAR(255);
UPDATE t_atic_divert_tactics_log SET start_ip = getFullIPV4(INET_NTOA(start_ip)),end_ip=getFullIPV4(INET_NTOA(end_ip));
/* upgrade for ipv6 end*/

USE lego;
INSERT  INTO `t_atic_sysconfig`(`pkid`,`sys_var`,`sys_value`,`remark`) VALUES (1,'min_pps_threshol','200','min pps threshold for baseline.');
INSERT  INTO `t_atic_sysconfig`(`pkid`,`sys_var`,`sys_value`,`remark`) VALUES (2,'min_bps_threshol','10','min bps threshold for baseline.');
INSERT  INTO `t_atic_sysconfig`(`pkid`,`sys_var`,`sys_value`,`remark`) VALUES (3,'min_con_threshol','20','min conn threshold for baseline.');

USE lego;
ALTER TABLE `T_VSM_ZONE_BASELINE_STUDY` DROP COLUMN `TOLERANCE`;
ALTER TABLE `T_VSM_NECONF_DNSAGENT` MODIFY COLUMN  `ip_list` VARCHAR(800) DEFAULT NULL;
ALTER TABLE `T_VSM_NECONF_DNSAGENT` MODIFY COLUMN  `deployed_ip_list` VARCHAR(800) DEFAULT NULL;

/* modify by JQ */
USE lego;
/*1.http table*/
ALTER TABLE t_vsm_zone_httpflood   DROP COLUMN  `host_filter_nable`;
ALTER TABLE t_vsm_zone_httpflood   DROP COLUMN  `host_filter_mode`;
ALTER TABLE t_vsm_zone_httpflood   DROP COLUMN  `host_filter_rate`;
ALTER TABLE t_vsm_zone_httpflood   ADD COLUMN  `http_srcstatic_enable` bit(1) default NULL AFTER `http_proxy_enable`;
ALTER TABLE t_vsm_zone_httpflood   ADD COLUMN  `http_srcstatic_rate` INT(11) default NULL AFTER `http_srcstatic_enable`;
ALTER TABLE t_vsm_zone_httpflood   ADD COLUMN  `http_webdetect_enable` bit(1) default NULL AFTER `http_srcstatic_rate`;
ALTER TABLE t_vsm_zone_httpflood   ADD COLUMN  `web_title` VARCHAR(255) default NULL AFTER `http_webdetect_enable`;
DROP TABLE `t_vsm_zone_http_hostfilter` ;

/*2.https table*/
ALTER TABLE t_vsm_zone_httpsflood  ADD COLUMN  `https_srcstatic_enable` bit(1) default NULL AFTER `https_ill_interval`;
ALTER TABLE t_vsm_zone_httpsflood  ADD COLUMN  `https_srcstatic_rate` INT(11)  default NULL AFTER `https_srcstatic_enable`;

/*3.dns table*/
DROP  TABLE `t_vsm_zone_dns_domain_request` ;
DROP  TABLE `t_vsm_zone_dns_domain_response` ;
ALTER TABLE  t_vsm_zone_dnsflood DROP COLUMN  `dns_response_enable`;
ALTER TABLE  t_vsm_zone_dnsflood DROP COLUMN  `response_domain_alert_rate`;
ALTER TABLE  t_vsm_zone_dnsflood DROP COLUMN  `response_domain_enable`;
ALTER TABLE  t_vsm_zone_dnsflood DROP COLUMN  `request_domain_enable`;
ALTER TABLE  t_vsm_zone_dnsflood ADD COLUMN   `format_check_ratio` INT(11)  default NULL AFTER `format_check_enable`;

/*4.black&bypass*/
DROP TABLE `t_vsm_zone_bypass` ;
DROP TABLE `t_vsm_zone_blacklist` ;

/*5.finger*/
DROP TABLE `t_vsm_zone_tcp_fngrprnt` ;
DROP TABLE `t_vsm_zone_udp_user_finger` ;
DROP TABLE `t_vsm_zone_icmp_user_finger` ;
DROP TABLE `t_vsm_zone_http_fngrprnt` ;
DROP TABLE `t_vsm_zone_https_fngrprnt` ;
DROP TABLE `t_vsm_zone_dns_user_finger` ;
DROP TABLE `t_vsm_zone_sip_user_finger` ;
DROP TABLE `t_vsm_zone_ip_fngrprnt` ;
ALTER TABLE t_vsm_zone_tcpflood    DROP COLUMN  `user_finger_print_enable`;
ALTER TABLE t_vsm_zone_icmpflood   DROP COLUMN  `icmp_userfinger_enable`;
ALTER TABLE t_vsm_zone_httpflood   DROP COLUMN  `http_user_finger_enable`;
ALTER TABLE t_vsm_zone_httpsflood  DROP COLUMN  `https_user_finger_enable`;
ALTER TABLE t_vsm_zone_dnsflood    DROP COLUMN  `dns_userfinger_enable`;

/*6.destzone*/
/* modify column name by zk*/
ALTER TABLE t_vsm_destination_zone_defend  CHANGE `zone_id` `service_id` BIGINT(20) DEFAULT NULL AFTER `pkid`;

/* create temp table*/
CREATE TABLE `t_vsm_destination_zone_defend_temp` (
  `pkid` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `service_id` BIGINT(20) DEFAULT NULL,
  `synflood_destzone_enable` BIT(1) DEFAULT NULL,
  `synflood_destzone_alertRate` INT(11) DEFAULT NULL,
  `ackflood_destzone_enable` BIT(1) DEFAULT NULL,
  `ackflood_destzone_mode` INT(11) DEFAULT NULL,
  `ackflood_destzone_alertrate` INT(11) DEFAULT NULL,
  `tcp_ratio_destzone_enable` BIT(1) DEFAULT NULL,
  `tcp_ratio_destzone` INT(11) DEFAULT NULL,
  `dns_flood_destzone_enable` BIT(1) DEFAULT NULL,
  `alert_rate_destzone` INT(11) DEFAULT NULL,
  `reply_flood_destzone_enable` BIT(1) DEFAULT NULL,
  `reply_flood_destzone_alert_rate` INT(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=INNODB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
/* copy data to temp table*/
INSERT INTO `t_vsm_destination_zone_defend_temp` 
(pkid,
service_id,
synflood_destzone_enable,
synflood_destzone_alertRate,
ackflood_destzone_enable,
ackflood_destzone_mode,
ackflood_destzone_alertrate,
tcp_ratio_destzone_enable,
tcp_ratio_destzone,
dns_flood_destzone_enable,
alert_rate_destzone,
reply_flood_destzone_enable,
reply_flood_destzone_alert_rate
)  
SELECT 
pkid,
service_id,
synflood_destzone_enable,
synflood_destzone_alertRate,
ackflood_destzone_enable,
ackflood_destzone_mode,
ackflood_destzone_alertrate,
tcp_ratio_destzone_enable,
tcp_ratio_destzone,
dns_flood_destzone_enable,
alert_rate_destzone,
reply_flood_destzone_enable,
reply_flood_destzone_alert_rate
FROM `t_vsm_destination_zone_defend`;
/* delete data */
DELETE FROM t_vsm_destination_zone_defend;
/* add new data */
INSERT INTO `t_vsm_destination_zone_defend` 
(service_id,
synflood_destzone_enable,
synflood_destzone_alertRate,
ackflood_destzone_enable,
ackflood_destzone_mode,
ackflood_destzone_alertrate,
tcp_ratio_destzone_enable,
tcp_ratio_destzone,
dns_flood_destzone_enable,
alert_rate_destzone,
reply_flood_destzone_enable,
reply_flood_destzone_alert_rate)
SELECT
  z.pkid,
  T.synflood_destzone_enable,
  T.synflood_destzone_alertRate,
  T.ackflood_destzone_enable,
  T.ackflood_destzone_mode,
  T.ackflood_destzone_alertrate,
  T.tcp_ratio_destzone_enable,
  T.tcp_ratio_destzone,
  T.dns_flood_destzone_enable,
  T.alert_rate_destzone,
  T.reply_flood_destzone_enable,
  T.reply_flood_destzone_alert_rate
FROM t_vsm_destination_zone_defend_temp t,
  t_vsm_zone_service z
WHERE t.service_id = z.zone_id
    AND t.service_id IS NOT NULL
    AND z.protocol = 'DEFAULT';
/* delete temp table */
DROP TABLE `t_vsm_destination_zone_defend_temp`;

/*7.divert*/
ALTER TABLE t_atic_divert_tactics ADD COLUMN  `nfa_id` BIGINT(20) default 0 AFTER `divert_status`;

/*8.topn*/
DROP TABLE IF EXISTS `t_vsm_zone_topnstudy`;
CREATE TABLE `t_vsm_zone_topnstudy` (
  `pkid` bigint(20) NOT NULL auto_increment,
  `service_id` bigint(20) default NULL,
  `http_host_enable` bit(1) default NULL,
  `http_host_simple` int(11) default NULL,
  `http_uri_enable` bit(1) default NULL,
  `http_uri_simple` int(11) default NULL,
  `http_srcip_enable` bit(1) default NULL,
  `http_srcip_simple` int(11) default NULL,
  `dns_query_domain_enable` bit(1) default NULL,
  `dns_query_domain_simple` int(11) default NULL,
  `topn_cache_enable` bit(1) default NULL,
  `topn_cache_num` int(11) default NULL,
  `dns_query_srcip_enable` bit(1) default NULL,
  `dns_query_srcip_simple` int(11) default NULL,
  `dns_req_srcip_enable` bit(1) default NULL,
  `dns_req_srcip_simple` int(11) default NULL,
  `https_enable` bit(1) default NULL,
  `https_simple` int(11) default NULL,
  `sip_srcip_enable` bit(1) default NULL,
  `sip_srcip_simple` int(11) default NULL,
  `sip_caller_enable` bit(1) default NULL,
  `sip_caller_simple` int(11) default NULL,
  `sip_callee_enable` bit(1) default NULL,
  `sip_callee_simple` int(11) default NULL,
  `tcp_newconn_enable` bit(1) default NULL,
  `tcp_newconn_simple` int(11) default NULL,
  PRIMARY KEY  (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

/*9.NFA SYSLOG*/
DROP TABLE IF EXISTS `t_atic_nfa_syslog`;
CREATE TABLE `t_atic_nfa_syslog` (
  `pkid` bigint(20) NOT NULL auto_increment,
  `dev_ip` varchar(255) collate utf8_bin default NULL,
  `anomalyId` varchar(255) collate utf8_bin default NULL,
  `creationTime` varchar(255) collate utf8_bin default NULL,
  `updateTime` varchar(255) collate utf8_bin default NULL,
  `type` varchar(255) collate utf8_bin default NULL,
  `subType` varchar(255) collate utf8_bin default NULL,
  `severity` varchar(16) collate utf8_bin default NULL,
  `status` varchar(255) collate utf8_bin default NULL,
  `direction` varchar(255) collate utf8_bin default NULL,
  `resource` varchar(255) collate utf8_bin default NULL,
  `resourceId` varchar(255) collate utf8_bin default NULL,
  `importance` varchar(255) collate utf8_bin default NULL,
  `current` varchar(255) collate utf8_bin default NULL,
  `threshold` varchar(255) collate utf8_bin default NULL,
  `unit` varchar(16) collate utf8_bin default NULL,
  `dstIp1` varchar(255) collate utf8_bin default NULL,
  `dstIp2` varchar(255) collate utf8_bin default NULL,
  `dstIp3` varchar(255) collate utf8_bin default NULL,
  `dstPort1` varchar(16) collate utf8_bin default NULL,
  `dstPort2` varchar(16) collate utf8_bin default NULL,
  `srcIp1` varchar(255) collate utf8_bin default NULL,
  `srcIp2` varchar(255) collate utf8_bin default NULL,
  `srcIp3` varchar(255) collate utf8_bin default NULL,
  `srcPort1` varchar(16) collate utf8_bin default NULL,
  `srcPort2` varchar(16) collate utf8_bin default NULL,
  `protocol` varchar(16) collate utf8_bin default NULL,
  `url` varchar(255) collate utf8_bin default NULL,
  `remark` varchar(255) collate utf8_bin default NULL,
  `detail` text collate utf8_bin,
  PRIMARY KEY  (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

/* end by JQ */

alter table `t_atic_defend_group` add column  `clean_mode` int(11) DEFAULT 0 after `group_name`;
alter table T_telnetpara modify column `user_private_key` varchar(2048) COLLATE utf8_bin DEFAULT NULL;

ALTER TABLE t_atic_zone_ip MODIFY COLUMN `start_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,MODIFY COLUMN  `end_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL;
UPDATE t_atic_zone_ip SET mask = getIntMask(mask);
ALTER TABLE t_atic_zone_ip MODIFY COLUMN `mask` INT(11) NOT NULL;
UPDATE t_atic_zone_ip SET start_ip = getFullIPV4(INET_NTOA(start_ip)),end_ip=getFullIPV4(INET_NTOA(end_ip));
ALTER TABLE t_atic_zone_list_ip MODIFY COLUMN `zone_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,MODIFY COLUMN   `start_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,MODIFY COLUMN   `end_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL;
UPDATE t_atic_zone_list_ip SET int_mask = (CASE WHEN getIntMask(string_mask) IS NOT NULL THEN getIntMask(string_mask) WHEN getIntMask(string_mask) IS NULL THEN string_mask END) WHERE string_mask IS NOT NULL;

/*add http,sip menu*/
delete from lego.T_operation_r_role where opt_id = 2245;
delete from lego.T_operation_r_role where opt_id = 2246;
delete from lego.T_operation_r_role where opt_id = 2255;
delete from lego.T_operation_r_role where opt_id = 2256;

delete from lego.T_operations where opt_id = 2245;
delete from lego.T_operations where opt_id = 2246;
delete from lego.T_operations where opt_id = 2255;
delete from lego.T_operations where opt_id = 2256;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2245, 'atic.analysis.http', 'atic/analysis/showHttpAnalysisReport.do?reportType=atic', '', 0, '7100-100-33');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2245);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2245);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2246, 'atic.analysis.http.scan', '', '', 1, '7100-100-33-5');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2246);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2246);

/*insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2255, 'atic.analysis.sip', '/atic/analysis/showSipAnalysisReport.do?reportType=atic', '', 0, '7100-100-36');*/
/*insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2255);*/
/*insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2255);*/
/*insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2256, 'atic.analysis.sip.scan', '', '', 1, '7100-100-36-5');*/
/*insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2256);*/
/*insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2256);*/

delete from lego.T_operation_r_role where opt_id = 2400;
delete from lego.T_operation_r_role where opt_id = 2401;
delete from lego.T_operation_r_role where opt_id = 2402;
delete from lego.T_operation_r_role where opt_id = 2403;
delete from lego.T_operation_r_role where opt_id = 2404;
delete from lego.T_operation_r_role where opt_id = 2405;
delete from lego.T_operation_r_role where opt_id = 2406;
delete from lego.T_operation_r_role where opt_id = 2407;

delete from lego.T_operations where opt_id = 2400;
delete from lego.T_operations where opt_id = 2401;
delete from lego.T_operations where opt_id = 2402;
delete from lego.T_operations where opt_id = 2403;
delete from lego.T_operations where opt_id = 2404;
delete from lego.T_operations where opt_id = 2405;
delete from lego.T_operations where opt_id = 2406;
delete from lego.T_operations where opt_id = 2407;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2400, 'atic.bis.zone.ip.domain', '/vsm/policy/ddos/listIpDomain.do', '', 0, '6500-100-80');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2400);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2400);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2401, 'atic.destip.domain.scan', '', '', 1, '6500-100-80-5');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2401);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2401);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2402, 'atic.destip.domain.create', '', '', 0, '6500-100-80-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2402);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2402);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2403, 'atic.destip.domain.delete', '', '', 0, '6500-100-80-15');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2403);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2403);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2404, 'atic.destip.domain.modify', '', '', 0, '6500-100-80-20');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2404);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2404);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2405, 'atic.destip.domain.import', '', '', 0, '6500-100-80-25');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2405);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2405);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2406, 'atic.destip.domain.export', '', '', 0, '6500-100-80-30');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2406);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2406);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2407, 'atic.destip.domain.exportAll', '', '', 0, '6500-100-80-35');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2407);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2407);

delete from lego.T_operation_r_role where opt_id = 2380;
delete from lego.T_operation_r_role where opt_id = 2381;
delete from lego.T_operation_r_role where opt_id = 2382;
delete from lego.T_operation_r_role where opt_id = 2383;
delete from lego.T_operation_r_role where opt_id = 2384;
delete from lego.T_operation_r_role where opt_id = 2385;
delete from lego.T_operation_r_role where opt_id = 2386;


delete from lego.T_operations where opt_id = 2380;
delete from lego.T_operations where opt_id = 2381;
delete from lego.T_operations where opt_id = 2382;
delete from lego.T_operations where opt_id = 2383;
delete from lego.T_operations where opt_id = 2384;
delete from lego.T_operations where opt_id = 2385;
delete from lego.T_operations where opt_id = 2386;

insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2380, 'atic.sys.config.backup.recovery', '/atic/system/configBackupList.do', '', 0, '8000-1100-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2380);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2380);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2381, 'atic.sys.config.backup.recovery.scan', '', '', 1, '8000-1100-10-5');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2381);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2381);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2382, 'atic.system.config.backup', '', '', 0, '8000-1100-10-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2382);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2382);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2383, 'atic.system.config.recovery', '', '', 0, '8000-1100-10-15');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2383);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2383);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2384, 'atic.system.config.import', '', '', 0, '8000-1100-10-20');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2384);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2384);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2385, 'atic.system.config.export', '', '', 0, '8000-1100-10-25');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2385);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2385);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2386, 'atic.system.config.delete', '', '', 0, '8000-1100-10-30');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2386);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2386);

delete from lego.T_operation_r_role where opt_id = 2410;
delete from lego.T_operation_r_role where opt_id = 2411;
delete from lego.T_operation_r_role where opt_id = 2412;
delete from lego.T_operation_r_role where opt_id = 2413;
delete from lego.T_operation_r_role where opt_id = 2414;
delete from lego.T_operation_r_role where opt_id = 2415;


delete from lego.T_operations where opt_id = 2410;
delete from lego.T_operations where opt_id = 2411;
delete from lego.T_operations where opt_id = 2412;
delete from lego.T_operations where opt_id = 2413;
delete from lego.T_operations where opt_id = 2414;
delete from lego.T_operations where opt_id = 2415;


insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2410, 'atic.bis.blackholeDivert', '/atic/business/blackholeDivertList.do', '', 0, '6500-100-45');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2410);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2410);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2411, 'atic.bis.blackholeDivert.search', '', '', 1, '6500-100-45-5');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2411);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2411);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2412, 'atic.bis.blackhole.divert.create', '', '', 0, '6500-100-45-10');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2412);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2412);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2413, 'atic.bis.blackhole.divert.delete', '', '', 0, '6500-100-45-15');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2413);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2413);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2414, 'atic.bis.blackhole.divert.enable', '', '', 0, '6500-100-45-20');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2414);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2414);
insert into  T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(2415, 'atic.bis.blackhole.divert.disable', '', '', 0, '6500-100-45-25');
insert into lego.T_operation_r_role (role_id, opt_id) values (1, 2415);
insert into lego.T_operation_r_role (role_id, opt_id) values (2, 2415);

DROP TABLE IF EXISTS `t_atic_blackhole`;

CREATE TABLE `t_atic_blackhole` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `device_id` bigint(20) DEFAULT NULL,
  `black_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `black_mask` int(11) DEFAULT NULL,
  `nexthop_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `enable_time` bigint(20) DEFAULT NULL,
  `enable_status` int(11) DEFAULT NULL,
  `detail` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`),
  UNIQUE KEY `unique` (`device_id`,`black_ip`,`black_mask`,`nexthop_ip`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DROP TABLE IF EXISTS `t_atic_blackhole_conf`;

CREATE TABLE `t_atic_blackhole_conf` (
  `paramName` varchar(255) COLLATE utf8_bin NOT NULL,
  `param_value` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`paramName`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;


insert  into `t_atic_blackhole_conf`(`paramName`,`param_value`) values ('nexthopIp','NULL 0');
/*init topn data,note:this script should filter the sig NE or the R1 Ne for they are not suport topn ,but we do not do for time. do it next by zk*/
INSERT INTO t_vsm_zone_topnstudy(service_id)  SELECT pkid FROM t_vsm_zone_service WHERE protocol = 'DEFAULT';

