/*use when UPDATE V5R1C20B013 TO V5R1C20B015*/
USE `lego`;

CREATE TABLE IF NOT EXISTS `t_atic_divert_tactics_log` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_time` bigint(20) DEFAULT NULL,
  `device_id` bigint(20) DEFAULT NULL,
  `zone_id` bigint(20) DEFAULT NULL,
  `divert_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `mask` int(11) DEFAULT NULL,
  `start_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `end_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `divert_mode` int(11) DEFAULT NULL,
  `oper_type` int(11) DEFAULT NULL,
  `remark` varchar(1024) COLLATE utf8_bin DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `vpn_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `result` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

ALTER TABLE t_atic_divert_tactics_log ADD COLUMN `operator` VARCHAR(255) default '\-\-' AFTER `log_time`;

CREATE TABLE IF NOT EXISTS `t_vsm_filter` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_action` int(11) DEFAULT NULL,
  `filter_alert` int(11) DEFAULT NULL,
  `filter_Id` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id) VALUES ('Wordpress_Amplification','http','3',NULL,60011);

CREATE TABLE IF NOT EXISTS `t_vsm_filter_http` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) DEFAULT NULL,
  `filter_key` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_content` varchar(600) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Wordpress_Amplification'),'user-agent','wordpress');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Wordpress_Amplification'),'user-agent','WordPress');

CREATE TABLE IF NOT EXISTS `t_atic_device` (
  `moid` bigint(20) NOT NULL,
  `name` varchar(100) COLLATE utf8_bin DEFAULT NULL,
  `ip_address` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `device_type` int(11) DEFAULT NULL,
  `device_model` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `version` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `ddos_type` int(11) DEFAULT NULL,
  `cpu_number` int(11) DEFAULT NULL,
  `ftp_type` int(11) DEFAULT NULL,
  `ftp_user` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `ftp_password` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `ftp_port` int(11) DEFAULT NULL,
  `clean_cpu_number` int(11) DEFAULT NULL,
  `detect_cpu_number` int(11) DEFAULT NULL,
  PRIMARY KEY (`moid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

ALTER TABLE t_atic_device ADD COLUMN `spu_slot` VARCHAR(255);







