/*use when UPDATE V5R1C20B016 TO V5R1C20B017*/
USE `lego`;

CREATE TABLE IF NOT EXISTS `t_vsm_filter` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_action` int(11) DEFAULT NULL,
  `filter_alert` int(11) DEFAULT NULL,
  `filter_Id` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id) VALUES ('Microsoft_SQL_Resolution_Service_Amplification','udp','3',NULL,60012);

CREATE TABLE IF NOT EXISTS `t_vsm_filter_http` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) DEFAULT NULL,
  `filter_key` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_content` varchar(600) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Microsoft_SQL_Resolution_Service_Amplification'),'source-port','1434');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Microsoft_SQL_Resolution_Service_Amplification'),'packet-length','256~1500');

/*filter_include_separator ,--> 4 spaces*/
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='cookie' AND t.filter_content LIKE 'include,%';
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='host' AND t.filter_content LIKE 'include,%';
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='referer' AND t.filter_content LIKE 'include,%';
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='uri' AND t.filter_content LIKE 'include,%';
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='user-agent' AND t.filter_content LIKE 'include,%';
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='caller' AND (t.filter_content LIKE 'include,%' OR t.filter_content LIKE 'equal,%');
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='callee' AND (t.filter_content LIKE 'include,%' OR t.filter_content LIKE 'equal,%');
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ',', '    ') WHERE t.filter_key='domain' AND (t.filter_content LIKE 'include,%' OR t.filter_content LIKE 'equal,%');

UPDATE t_vsm_filter_http t SET t.filter_content = 'include    wordpress' WHERE t.filter_id = (SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Wordpress_Amplification') AND t.filter_content='wordpress';
UPDATE t_vsm_filter_http t SET t.filter_content = 'include    WordPress' WHERE t.filter_id = (SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'Wordpress_Amplification') AND t.filter_content='WordPress';

