/*use when UPDATE V5R1C20B017 TO V5R1C20B018*/
USE `lego`;

/*filter_fingerprint_separator ;-->8 spaces*/
UPDATE t_vsm_filter_http t SET t.filter_content =  REPLACE(filter_content, ';', '        ') WHERE t.filter_key='fingerprint' AND t.filter_content LIKE '%;%';

CREATE TABLE IF NOT EXISTS `t_vsm_filter` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_action` int(11) DEFAULT NULL,
  `filter_alert` int(11) DEFAULT NULL,
  `filter_Id` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id) VALUES ('RIPV1_Amplification_Attack','udp','3',NULL,60013);

CREATE TABLE IF NOT EXISTS `t_vsm_filter_http` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) DEFAULT NULL,
  `filter_key` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `filter_content` varchar(600) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'RIPV1_Amplification_Attack'),'source-port','520');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'RIPV1_Amplification_Attack'),'packet-length','256~1500');

CREATE TABLE IF NOT EXISTS `t_fault` (
  `fault_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `fault_define_id` varchar(32) COLLATE utf8_bin NOT NULL,
  `severity` tinyint(4) NOT NULL,
  `source_type` tinyint(4) NOT NULL,
  `mo_id` bigint(20) NOT NULL,
  `extend_mo_id` bigint(20) DEFAULT NULL,
  `source` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  `create_time` datetime DEFAULT NULL,
  `mod_time` datetime DEFAULT NULL,
  `count` int(11) DEFAULT NULL,
  `clear_status` tinyint(4) DEFAULT NULL,
  `clear_time` datetime DEFAULT NULL,
  `clear_user` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `confirm_status` tinyint(4) DEFAULT NULL,
  `confirm_time` datetime DEFAULT NULL,
  `confirm_user` varchar(32) COLLATE utf8_bin DEFAULT NULL,
  `fault_param` varchar(512) COLLATE utf8_bin DEFAULT NULL,
  `param_sha_code` varchar(64) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`fault_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

DELIMITER $$

USE `lego`$$

DROP TRIGGER /*!50032 IF EXISTS */ `td_t_fault`$$

CREATE
    
    TRIGGER `td_t_fault` AFTER DELETE ON `t_fault` 
    FOR EACH ROW BEGIN
    	DELETE FROM t_fault_detail WHERE fault_id = old.fault_id;
    END;
$$

DELIMITER ;

CREATE TABLE IF NOT EXISTS `t_atic_divert_tactics_log` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `log_time` bigint(20) DEFAULT NULL,
  `device_id` bigint(20) DEFAULT NULL,
  `zone_id` bigint(20) DEFAULT NULL,
  `divert_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `mask` int(11) DEFAULT NULL,
  `start_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `end_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `divert_mode` int(11) DEFAULT NULL,
  `oper_type` int(11) DEFAULT NULL,
  `remark` varchar(1024) COLLATE utf8_bin DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `vpn_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `result` int(11) DEFAULT NULL,
  `operator` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

ALTER TABLE t_atic_divert_tactics ADD COLUMN client_ip varchar(255);
