/*use when UPDATE V500R001C20B068 TO V500R001C20B069*/
USE `lego`;

UPDATE t_vsm_zone_tcpflood SET synflood_mode = 1 WHERE PKID IN (
SELECT children_id FROM t_vsm_zone_template_items WHERE TYPE = 'TCP' AND template_id IN (SELECT pkid FROM t_vsm_zone_template));

UPDATE `t_vsm_neconf_abnormaldfn` SET params = REPLACE ( params, 'IP_SPOOFING:1:-:-:-:-,', '' ); 

CREATE TABLE IF NOT EXISTS `t_vsm_zone_udpflood` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `service_id` bigint(20) DEFAULT NULL,
  `udp_block` bit(1) DEFAULT NULL,
  `udp_defend_enable` bit(1) DEFAULT NULL,
  `alert_speed_enable` bit(1) DEFAULT NULL,
  `alert_speed` int(11) DEFAULT NULL,
  `udp_check_enable` bit(1) DEFAULT NULL,
  `udp_fingerlearn_enable` bit(1) DEFAULT NULL,
  `frag_alert_speed_enable` bit(1) DEFAULT NULL,
  `frag_alert_speed` int(11) DEFAULT NULL,
  `frag_check_enable` bit(1) DEFAULT NULL,
  `frag_fingerlearn_enable` bit(1) DEFAULT NULL,
  `packet_length_learn` int(11) DEFAULT NULL,
  `learn_mode` int(11) DEFAULT NULL,
  `offset` int(11) DEFAULT NULL,
  `fingerprint_length` int(11) DEFAULT NULL,
  `udp_limit_enable` bit(1) DEFAULT NULL,
  `udp_max_speed_enable` bit(1) DEFAULT NULL,
  `udp_max_speed` int(11) DEFAULT NULL,
  `udp_frag_max_speed_enable` bit(1) DEFAULT NULL,
  `udp_frag_max_speed` int(11) DEFAULT NULL,
  `udp_userfinger_enable` bit(1) DEFAULT NULL,
  `udp_rel_service_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `upd_rel_service_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `udp_rel_service_alert_rate` int(11) DEFAULT NULL,
  `udp_rel_service_enable` bit(1) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
ALTER TABLE t_vsm_zone_udpflood ADD udp_new_destsession_limit_enable BIT(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_udpflood ADD udp_new_destsession_limit BIGINT(20) DEFAULT NULL;

CREATE TABLE IF NOT EXISTS `t_vsm_zone_icmpflood` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `service_id` bigint(20) DEFAULT NULL,
  `icmp_block_enable` bit(1) DEFAULT NULL,
  `icmp_defend_enable` bit(1) DEFAULT NULL,
  `icmp_max_speed_enable` bit(1) DEFAULT NULL,
  `icmp_max_speed` int(11) DEFAULT NULL,
  `icmp_userfinger_enable` bit(1) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
ALTER TABLE t_vsm_zone_icmpflood ADD icmp_new_destsession_limit_enable BIT(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_icmpflood ADD icmp_new_destsession_limit BIGINT(20) DEFAULT NULL;
ALTER TABLE t_vsm_zone_icmpflood ADD icmp_limitsub_enable BIT(1) DEFAULT NULL;
UPDATE t_vsm_zone_icmpflood SET icmp_limitsub_enable = TRUE WHERE icmp_max_speed_enable = TRUE;


CREATE TABLE IF NOT EXISTS `t_vsm_zone_otherflood` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `service_id` bigint(20) DEFAULT NULL,
  `other_block` bit(1) DEFAULT NULL,
  `other_defend_enable` bit(1) DEFAULT NULL,
  `other_alert_rate` int(11) DEFAULT NULL,
  `car_defence_enable` bit(1) DEFAULT NULL,
  `car_alert_rate` int(11) DEFAULT NULL,
  `other_defence_enable` bit(1) DEFAULT NULL,
  `finger_learn_enable` bit(1) DEFAULT NULL,
  `finger_alert` int(11) DEFAULT NULL,
  `learn_mode` int(11) DEFAULT NULL,
  `offset` int(11) DEFAULT NULL,
  `finger_length` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
ALTER TABLE t_vsm_zone_otherflood ADD other_new_destsession_limit_enable BIT(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_otherflood ADD other_new_destsession_limit BIGINT(20) DEFAULT NULL;
ALTER TABLE t_vsm_zone_otherflood ADD other_limitsub_enable BIT(1) DEFAULT NULL;
update t_vsm_zone_otherflood set other_limitsub_enable = true where other_defend_enable = true;

UPDATE t_vsm_zone_template SET device_type = 'AntiDDoS_V100R001' WHERE template_name IN ('General-Server-V100R001','WEB-Server-V100R001','DNS-Caching-Server-V100R001','DNS-Authoritative-Server-V100R001');
UPDATE t_vsm_zone_tcpflood SET syn_ratio_enable=NULL WHERE pkid IN (SELECT children_id FROM t_vsm_zone_template_items WHERE TYPE = 'TCP' AND template_id IN (
SELECT pkid FROM t_vsm_zone_template WHERE template_name IN ('General-Server-V100R001','WEB-Server-V100R001','DNS-Caching-Server-V100R001','DNS-Authoritative-Server-V100R001')));

