USE `lego`;

insert into T_operations (opt_id, opt_name, opt_url, opt_description, ismaster, serial_number) values(5010, 'lego.sys.nfaCollect', '/atic/system/nfaCollect.do', '', 0, '8000-600-15');
insert into T_operation_r_role (role_id, opt_id) values (1, 5010);
insert into T_operation_r_role (role_id, opt_id) values (2, 5010);

ALTER TABLE t_atic_device_nfa_cluster ADD COLUMN `outbound_enable` bit(1) DEFAULT false AFTER dev_type;


ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN `tcp_enable` bit(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN `tcp_lower_limit` INT(11) DEFAULT NULL;
ALTER TABLE t_vsm_zone_tcpflood ADD COLUMN `tcp_upper_limit` INT(11) DEFAULT NULL;

ALTER TABLE t_vsm_zone_udpflood ADD COLUMN `udp_enable` bit(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_udpflood ADD COLUMN `udp_upper_limit` INT(11) DEFAULT NULL;

ALTER TABLE t_vsm_zone_icmpflood ADD COLUMN `icmp_enable` bit(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_icmpflood ADD COLUMN `icmp_upper_limit` INT(11) DEFAULT NULL;

ALTER TABLE t_vsm_zone_dnsflood ADD COLUMN `dns_enable` bit(1) DEFAULT NULL;
ALTER TABLE t_vsm_zone_dnsflood ADD COLUMN `dns_lower_limit` INT(11) DEFAULT NULL;
ALTER TABLE t_vsm_zone_dnsflood ADD COLUMN `dns_upper_limit` INT(11) DEFAULT NULL;

ALTER TABLE `t_vsm_zone_tcpflood` ADD COLUMN `syn_auth_enable` bit(1) DEFAULT NULL;
ALTER TABLE `t_vsm_zone_tcpflood` ADD COLUMN `synfirst_packet_check_enable` bit(1) DEFAULT NULL;
ALTER TABLE `t_vsm_zone_udpflood` ADD COLUMN `udp_abnormal_enable` bit(1) DEFAULT NULL;
ALTER TABLE `t_vsm_zone_udpflood` ADD COLUMN `udp_abnormal_alert_rate` INT(11) DEFAULT NULL;

/*start procedure to opt_firstpacketcheck*/
DELIMITER $$

DROP PROCEDURE IF EXISTS `opt_firstpacketcheck`$$

CREATE PROCEDURE `opt_firstpacketcheck`()
 BEGIN
   DECLARE pkid1 BIGINT(20);
   DECLARE service_id1 BIGINT(20);
   DECLARE syn_enable1 BIT(1);
   DECLARE syn_lower_limit1 INT(11);
   DECLARE syn_upper_limit1 INT(11);
   DECLARE tcp_enable1 BIT(1);
   DECLARE tcp_lower_limit1 INT(11);
   DECLARE tcp_upper_limit1 INT(11);
   DECLARE udp_enable1 BIT(1);
   DECLARE udp_upper_limit1 INT(11);
   DECLARE dns_enable1 BIT(1);
   DECLARE dns_lower_limit1 INT(11);
   DECLARE dns_upper_limit1 INT(11);
   DECLARE icmp_enable1 BIT(1);
   DECLARE icmp_upper_limit1 INT(11);
   
   DECLARE tcp_block1 BIT(1);
   DECLARE tcp_synflood_enable1 BIT(1);
   DECLARE dns_cache_server_enable1 BIT(1);
   DECLARE dns_auth_server_enable1 BIT(1);
   
   DECLARE id BIGINT(20);
   
   DECLARE s INT DEFAULT 0; 
   
   DECLARE  cur_firstcheck CURSOR FOR SELECT pkid,service_id,syn_enable,syn_lower_limit,syn_upper_limit,tcp_enable,tcp_lower_limit,tcp_upper_limit,
	udp_enable,udp_upper_limit,dns_enable,dns_lower_limit,dns_upper_limit,icmp_enable,icmp_upper_limit FROM t_vsm_zone_firstpacketcheck;
   
   DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET s=1; 

   OPEN cur_firstcheck;

	   WHILE s <> 1 DO
	   	
	   	FETCH cur_firstcheck INTO pkid1,service_id1,syn_enable1,syn_lower_limit1,syn_upper_limit1,tcp_enable1,tcp_lower_limit1,tcp_upper_limit1,
		  udp_enable1,udp_upper_limit1,dns_enable1,dns_lower_limit1,dns_upper_limit1,icmp_enable1,icmp_upper_limit1;
		/*对防护对象策略中的首包检查进行移植*/
		IF service_id1 IS NOT NULL THEN
			/*TCP协议*/
			IF syn_enable1 IS NOT NULL THEN
				SET tcp_synflood_enable1 = (SELECT synflood_enable FROM t_vsm_zone_tcpflood WHERE service_id = service_id1);
				IF tcp_synflood_enable1 IS NOT NULL THEN 
					UPDATE t_vsm_zone_tcpflood SET synfirst_packet_check_enable=TRUE,first_packet_check_lower_limit=syn_lower_limit1,first_packet_check_upper_limit=syn_upper_limit1 WHERE service_id=service_id1;
				END IF;
			END IF;
			IF tcp_enable1 IS NOT NULL THEN
				SET tcp_block1 = (SELECT tcp_block FROM t_vsm_zone_tcpflood WHERE service_id = service_id1);
				IF tcp_block1 IS NULL THEN 
					UPDATE t_vsm_zone_tcpflood SET tcp_defend_enable=TRUE,tcp_enable=TRUE,tcp_lower_limit=tcp_lower_limit1,tcp_upper_limit=tcp_upper_limit1 WHERE service_id=service_id1;
				END IF;
			END IF;
			/*DNS协议*/
			IF dns_enable1 IS NOT NULL THEN
				SET dns_cache_server_enable1 = (SELECT dns_cache_server_enable FROM t_vsm_zone_dnsflood WHERE service_id = service_id1);
				SET dns_auth_server_enable1 = (SELECT dns_auth_server_enable FROM t_vsm_zone_dnsflood WHERE service_id = service_id1);
				IF dns_cache_server_enable1 IS NOT NULL OR dns_auth_server_enable1 IS NOT NULL THEN
					UPDATE t_vsm_zone_dnsflood SET dns_enable=TRUE,dns_lower_limit=dns_lower_limit1,dns_upper_limit=dns_upper_limit1 WHERE service_id=service_id1;
				END IF;
			END IF;
		END IF;
		
	    /*对策略模板中的首包检查进行移植*/
		IF service_id1 IS NULL THEN
			/*TCP协议*/
			SET id = (SELECT item.`children_id` FROM `t_vsm_zone_template_items` item WHERE item.`type`='TCP' AND item.`template_id`=(SELECT item1.`template_id` FROM `t_vsm_zone_template_items` item1 WHERE item1.`type`='FIRSTPACKETCHECK' AND item1.`children_id`=pkid1 AND item1.`template_id` IS NOT NULL));
			IF id IS NOT NULL THEN
				IF syn_enable1 IS NOT NULL THEN
					SET tcp_synflood_enable1 = (SELECT synflood_enable FROM t_vsm_zone_tcpflood WHERE pkid=id);
					IF tcp_synflood_enable1 IS NOT NULL THEN 
						UPDATE t_vsm_zone_tcpflood SET synfirst_packet_check_enable=TRUE,first_packet_check_lower_limit=syn_lower_limit1,first_packet_check_upper_limit=syn_upper_limit1 WHERE pkid=id;
					END IF;
				END IF;
			    IF tcp_enable1 IS NOT NULL THEN
					SET tcp_block1 = (SELECT tcp_block FROM t_vsm_zone_tcpflood WHERE pkid = id);
					IF tcp_block1 IS NULL THEN 
						UPDATE t_vsm_zone_tcpflood SET tcp_defend_enable=TRUE,tcp_enable=TRUE,tcp_lower_limit=tcp_lower_limit1,tcp_upper_limit=tcp_upper_limit1 WHERE pkid=id;
					END IF;
				END IF;
			END IF;
			/*DNS协议*/
			SET id = (SELECT item.`children_id` FROM t_vsm_zone_template_items item WHERE item.`type`='DNS' AND item.`template_id`=(SELECT item1.`template_id` FROM t_vsm_zone_template_items item1 WHERE item1.`type`='FIRSTPACKETCHECK' AND item1.`children_id`=pkid1 AND item1.`template_id` IS NOT NULL));
			IF id IS NOT NULL THEN   
				IF dns_enable1 IS NOT NULL THEN
					SET dns_cache_server_enable1 = (SELECT dns_cache_server_enable FROM t_vsm_zone_dnsflood WHERE pkid=id);
					SET dns_auth_server_enable1 = (SELECT dns_auth_server_enable FROM t_vsm_zone_dnsflood WHERE pkid=id);
					IF dns_cache_server_enable1 IS NOT NULL OR dns_auth_server_enable1 IS NOT NULL THEN
						UPDATE t_vsm_zone_dnsflood SET dns_enable=TRUE,dns_lower_limit=dns_lower_limit1,dns_upper_limit=dns_upper_limit1 WHERE pkid=id;
					END IF;
				END IF;
			END IF;
		END IF;
	END WHILE;
  CLOSE cur_firstcheck;
 END$$
 
DELIMITER ;
CALL opt_firstpacketcheck();
DROP PROCEDURE IF EXISTS `opt_firstpacketcheck`;
/*end procedure to opt_firstpacketcheck*/

DROP TABLE t_vsm_zone_firstpacketcheck;
DELETE FROM t_vsm_zone_template_items WHERE TYPE = 'FIRSTPACKETCHECK';
DELETE FROM t_vsm_zone_feature_status WHERE feature_type='FirstPacketCheckForm';

ALTER TABLE lego.t_vsm_zone_template ADD COLUMN `direction` INT(11) DEFAULT 1;

/*DTS2018022404616 V2R1C00SPC800-》V5R1C20SPC800-》V5R1C50SPC501 此单回归时发现service_id被删掉了导致*/
DELETE FROM lego.t_vsm_zone_template_items WHERE type ='IPv4' or type = 'WILD';

DELETE FROM lego.t_vsm_ip_finger_defend WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_dnsflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_httpflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_httpsflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_icmpflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_otherflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_sip_srciplimit;
DELETE FROM lego.t_vsm_zone_sipflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_tcpflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_udpflood WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));
DELETE FROM lego.t_vsm_zone_topnstudy WHERE pkid IN (select children_id from lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001'));

DELETE FROM lego.t_vsm_zone_template_items WHERE template_id in ( SELECT pkid FROM  t_vsm_zone_template WHERE device_type = 'AntiDDoS_V100R001');
DELETE FROM lego.t_vsm_zone_template  WHERE device_type = 'AntiDDoS_V100R001';

update lego.t_vsm_zone_template set template_name = 'General-Server' where template_name = 'General-Server-V500R001';
update lego.t_vsm_zone_template set template_name = 'WEB-Server' where template_name = 'WEB-Server-V500R001';
update lego.t_vsm_zone_template set template_name = 'DNS-Caching-Server' where template_name = 'DNS-Caching-Server-V500R001';
update lego.t_vsm_zone_template set template_name = 'DNS-Authoritative-Server' where template_name = 'DNS-Authoritative-Server-V500R001';

update lego.t_vsm_zone_template set device_type = 'AntiDDoS' where device_type = 'AntiDDoS_V500R001';

UPDATE lego.t_vsm_zone_tcpflood SET tcp_abnormal_alert_rate = 1000, syn_max_packets = 30,fin_rst_flood_alert_rate = 2000 WHERE pkid = 5;
UPDATE lego.t_vsm_zone_otherflood SET other_defend_enable = 1, other_limitsub_enable = 1, other_alert_rate = 5 WHERE pkid = 5;

UPDATE lego.t_vsm_zone_tcpflood SET tcp_abnormal_alert_rate = 1000, syn_max_packets = 30,fin_rst_flood_alert_rate = 2000 WHERE pkid = 6;
UPDATE lego.t_vsm_zone_otherflood SET other_defend_enable = 1, other_limitsub_enable = 1, other_alert_rate = 5 WHERE pkid = 6;
UPDATE lego.t_vsm_zone_httpflood SET http_srcstatic_rate = 10, http_src_qps_rate = 10, http_first_packet_enable = 1, http_lower_limit = 0, http_upper_limit = 4 WHERE pkid = 6;
UPDATE lego.t_vsm_zone_httpsflood SET https_srcstatic_enable = 0 WHERE pkid = 6;
UPDATE lego.t_vsm_zone_topnstudy SET http_host_enable = 0,http_uri_enable = 0,http_srcip_enable = 0 WHERE pkid = 6;

UPDATE lego.t_vsm_zone_tcpflood SET tcp_defend_enable = 0, tcp_basic_enable = 0, synflood_enable = 0, ack_flood_enable = 0, tcp_frag_enable = 0, fin_rst_flood_enable = 0,
tcp_abnormal_enable =0, ack_session_check_enable = 0, syn_ratio_enable = 0 ,tcp_limit_enable = 1,tcp_limit_sub_enable = 1,tcp_frag_limit_enable = 1,max_speed = 10, frag_max_speed = 5 WHERE pkid = 7;
UPDATE lego.t_vsm_zone_udpflood SET udp_max_speed = 10, udp_frag_max_speed_enable = 0 WHERE pkid = 7;
UPDATE lego.t_vsm_zone_otherflood SET other_defend_enable = 1, other_limitsub_enable = 1, other_alert_rate = 5 WHERE pkid = 7;
UPDATE lego.t_vsm_zone_dnsflood SET no_such_name_check_enable = 0 , format_check_ratio = 500 , dns_request_len_enable = 0, dns_response_len_enable = 0 WHERE pkid = 7;
UPDATE lego.t_vsm_zone_topnstudy SET dns_query_domain_enable = 0,dns_query_srcip_enable = 0,dns_req_srcip_enable = 0 WHERE pkid = 7;

UPDATE lego.t_vsm_zone_tcpflood SET tcp_abnormal_alert_rate = 1000, syn_max_packets = 30,fin_rst_flood_alert_rate = 2000 ,ack_flood_alert_rate = 20000,tcp_frag_alert_rate = 2000, synflood_alert_rate = 2000,syn_auth_enable = 1 WHERE pkid = 8;
UPDATE lego.t_vsm_zone_udpflood SET udp_max_speed = 10, udp_frag_max_speed_enable = 0 WHERE pkid = 8;
UPDATE lego.t_vsm_zone_otherflood SET other_defend_enable = 1, other_limitsub_enable = 1, other_alert_rate = 5 WHERE pkid = 8;
UPDATE lego.t_vsm_zone_dnsflood SET no_such_name_check_enable = 0 , format_check_ratio = 500 , dns_request_len_enable = 0, dns_response_len_enable = 0 WHERE pkid = 8;

UPDATE lego.t_vsm_filter SET filter_action = 5, filter_alert = 500 WHERE filter_name = 'DNS_Amplification';


