/*use when UPDATE V500R001C50B166 TO V500R001C50B167*/
USE `lego`;

UPDATE t_vsm_zone_tcpflood SET tcp_ratio_enable = NULL,tcp_ratio_protion = NULL,tcp_ratio_limit_mode = NULL,tcp_ratio_limit_rate = NULL,slow_con_dectect_enable = NULL;
UPDATE t_vsm_zone_dnsflood SET defend_mode = 2 WHERE defend_mode =0 and dns_auth_server_enable=true;
UPDATE t_vsm_zone_dnsflood SET defend_mode = 0 WHERE defend_mode =2 and dns_cache_server_enable=true;

ALTER TABLE lego.T_sysoplog MODIFY COLUMN operation_detail_para VARCHAR(1024);

UPDATE t_sysoplog SET operation_module_name = 'lego.dic.module.restful' WHERE operation_module_name = 'atic.restful.module';

CREATE TABLE IF NOT EXISTS `t_atic_zone_port_map_status_info` (
  `pkid` BIGINT(20) NOT NULL AUTO_INCREMENT,
  `portmap_id` BIGINT(20) DEFAULT NULL,
  `device_id` BIGINT(20) DEFAULT NULL,
  `deploy_state` BIT(1) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

CREATE TABLE IF NOT EXISTS `t_atic_zone_ip_status_info` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `device_id` bigint(20) DEFAULT NULL,
  `ip_id` bigint(20) DEFAULT NULL,
  `deploy_state` bit(1) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

/*start procedure to opt_zoneIpStatusInfo*/
DELIMITER $$

DROP PROCEDURE IF EXISTS `opt_zoneIpStatusInfo`$$

CREATE PROCEDURE `opt_zoneIpStatusInfo`()
 BEGIN
   DECLARE zone_id1 BIGINT(20);
   DECLARE pkid1 BIGINT(20);
   DECLARE device_id1 BIGINT(20);
   DECLARE pkid2 BIGINT(20);
 
   DECLARE s INT DEFAULT 0;  
   
   DECLARE cur_zoneDdosPolicy CURSOR FOR SELECT zone_id FROM t_vsm_zone_ddos_policy WHERE deploy_state='SUCCESS';
   DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET s=1;

   OPEN cur_zoneDdosPolicy;   
   WHILE s <> 1 DO
   FETCH cur_zoneDdosPolicy INTO zone_id1;
   BEGIN
        DECLARE s1 INT DEFAULT 0;
        DECLARE cur_zoneDevice CURSOR FOR SELECT DISTINCT zd.device_id FROM t_vsm_zone_device zd LEFT JOIN t_atic_device d ON zd.device_id=d.moid WHERE d.device_type=1 AND zd.zone_id=zone_id1;
        DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET s1=1;
	   
	OPEN cur_zoneDevice;
	WHILE s1 <> 1 DO
	FETCH cur_zoneDevice INTO device_id1;
	BEGIN
		DECLARE s2 INT DEFAULT 0;
		DECLARE cur_aticZoneListIp CURSOR FOR SELECT DISTINCT pkid FROM t_atic_zone_list_ip WHERE deploy_state=1 AND ip_type=0 AND zone_id=zone_id1;
		DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET s2=1; 
		
		OPEN cur_aticZoneListIp;
		WHILE s2 <> 1 DO
		FETCH cur_aticZoneListIp INTO pkid1;
		IF pkid1 IS NOT NULL THEN
		BEGIN
			SET pkid2 = (SELECT pkid FROM t_atic_zone_ip_status_info WHERE device_id = device_id1 AND ip_id=pkid1);
			IF pkid2 IS NULL THEN
				INSERT INTO t_atic_zone_ip_status_info(device_id,ip_id,deploy_state)VALUES(device_id1,pkid1,TRUE);
			END IF;
		END;
		END IF;
		END WHILE;
		CLOSE cur_aticZoneListIp;
	END;
	END WHILE;
	CLOSE cur_zoneDevice;
   END;	
   END WHILE;
   CLOSE cur_zoneDdosPolicy;
 END$$
 
DELIMITER ;
CALL opt_zoneIpStatusInfo();
DROP PROCEDURE IF EXISTS `opt_zoneIpStatusInfo`;
/*end procedure to opt_zoneIpStatusInfo*/

