/*use when UPDATE V500R001C50B168 TO V500R005C00*/
USE `lego`;

/*DTS2018022404616 V2R1C00SPC800-》V5R1C20SPC800-》V5R1C50SPC501 此单回归时发现service_id被删掉了导致*/
DELETE FROM lego.t_vsm_zone_template_items WHERE type ='IPv4';

ALTER TABLE lego.t_vsm_neconf_abnormaldfn ADD COLUMN `ssl_decryption` INT(11) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `https_decrypt_enable` BIT(1) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `https_decrypt_alert_rate` INT(11) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `server_code_enable` BIT(1) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `server_code_period` INT(11) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `server_code_times` INT(11) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `finger_learn_enable` BIT(1) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `learn_period` INT(11) DEFAULT NULL;
ALTER TABLE lego.t_vsm_zone_httpsflood ADD COLUMN `match_times` INT(11) DEFAULT NULL;
ALTER TABLE t_atic_pcap ADD forward_status INT DEFAULT 0;

DROP PROCEDURE IF EXISTS delete_template_protocol;
DELIMITER //
CREATE PROCEDURE delete_template_protocol()
BEGIN
	DECLARE pkidx BIGINT;
	DECLARE protocolx VARCHAR(64);
	DECLARE childrenid BIGINT;
	
	DECLARE done INT DEFAULT 0;  /*用于判断是否结束循环*/

	DECLARE cur CURSOR FOR (SELECT template.pkid AS pkid, template.protocol AS protocol, items.children_id AS children_id 
		FROM t_vsm_zone_template template INNER JOIN t_vsm_zone_template_items items ON items.template_id = template.pkid WHERE protocol != "DEFAULT" AND device_type = "AntiDDoS" AND direction=1);
		
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;
	
	
		OPEN cur;  /*打开游标*/
			REPEAT
				FETCH cur INTO pkidx, protocolx, childrenid;
					SELECT pkidx FROM DUAL;
					IF NOT done THEN
					    IF protocolx = 'TCP' THEN 
						DELETE FROM t_vsm_zone_tcpflood WHERE `pkid` = childrenid; 
					    ELSEIF (protocolx = 'UDP') THEN
						DELETE FROM t_vsm_zone_udpflood WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'HTTP') THEN
					    DELETE FROM t_vsm_zone_http_uri WHERE `http_defend_id` in (SELECT pkid FROM t_vsm_zone_httpflood WHERE `pkid` = childrenid);
						DELETE FROM t_vsm_zone_httpflood WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'HTTPS') THEN
						DELETE FROM t_vsm_zone_httpsflood WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'SIP') THEN
					    DELETE FROM t_vsm_zone_sip_srciplimit WHERE `sip_flood_id` in (SELECT pkid FROM t_vsm_zone_sipflood WHERE `pkid` = childrenid);
						DELETE FROM t_vsm_zone_sipflood WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'TOPNSTUDY') THEN
						DELETE FROM t_vsm_zone_topnstudy WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'ICMP') THEN
						DELETE FROM t_vsm_zone_icmpflood WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'UDP_DNS') THEN
					    
					    DELETE FROM t_vsm_zone_dns_cache WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_domain_defend WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_sourceip_request WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_sourceip_response WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_staticfinger_request WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_staticfinger_response WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_statistic WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    
						DELETE FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'TCP_DNS') THEN
						DELETE FROM t_vsm_zone_tcpflood WHERE `pkid` = childrenid;
					    ELSEIF (protocolx = 'DNS') THEN
					    
					    DELETE FROM t_vsm_zone_dns_cache WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_domain_defend WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_sourceip_request WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_sourceip_response WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_staticfinger_request WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_staticfinger_response WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    DELETE FROM t_vsm_zone_dns_statistic WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid);
					    
						DELETE FROM t_vsm_zone_dnsflood WHERE `pkid` = childrenid;
					    ELSE  
						DELETE FROM t_vsm_zone_otherflood WHERE `pkid` = childrenid;
					    END IF;
					END IF;
			UNTIL done END REPEAT;

		CLOSE cur;  /*关闭游标*/
END
//
DELIMITER ;

CALL delete_template_protocol();

-- 删除主表
DELETE FROM t_vsm_zone_template_items WHERE template_id IN ( SELECT temp.pkid FROM t_vsm_zone_template temp WHERE temp.protocol != "DEFAULT" AND temp.device_type = "AntiDDoS" AND temp.direction = 1 );
DELETE FROM t_vsm_zone_template WHERE protocol != "DEFAULT" AND device_type = "AntiDDoS" AND direction=1;


-- 2. 防护对象，删除自定义服务
/* 删除inbound策略的网络信息从表*/
DROP PROCEDURE IF EXISTS delete_zone_inbonds_protocol;
DELIMITER //
CREATE PROCEDURE delete_zone_inbonds_protocol()
BEGIN
	DECLARE pkidz INT;
	DECLARE protocol VARCHAR(64);
	
	DECLARE done INT DEFAULT 0;  /*用于判断是否结束循环*/
	DECLARE pkid_pro_cur CURSOR FOR SELECT vzs.pkid, vzs.protocol FROM t_vsm_zone_service vzs WHERE vzs.protocol != 'DEFAULT' AND direction = 1;
	DECLARE CONTINUE HANDLER FOR NOT FOUND SET done = 1;
	
	
		OPEN pkid_pro_cur;  /*打开游标*/
			REPEAT
				FETCH pkid_pro_cur INTO pkidz, protocol;
					IF NOT done THEN
					    IF protocol = 'TCP' THEN 
						DELETE FROM t_vsm_zone_tcpflood WHERE service_id = pkidz; 
					    ELSEIF (protocol = 'UDP') THEN
						DELETE FROM t_vsm_zone_udpflood WHERE service_id = pkidz;
					    ELSEIF (protocol = 'HTTP') THEN
					    DELETE FROM t_vsm_zone_http_uri WHERE `http_defend_id` in (SELECT `pkid` FROM t_vsm_zone_httpflood WHERE service_id = pkidz);
						DELETE FROM t_vsm_zone_httpflood WHERE service_id = pkidz;
					    ELSEIF (protocol = 'HTTPS') THEN
						DELETE FROM t_vsm_zone_httpsflood WHERE service_id = pkidz;
					    ELSEIF (protocol = 'SIP') THEN
					    DELETE FROM t_vsm_zone_sip_srciplimit WHERE `sip_flood_id` in (SELECT `pkid` FROM t_vsm_zone_sipflood WHERE service_id = pkidz);
						DELETE FROM t_vsm_zone_sipflood WHERE service_id = pkidz;
					    ELSEIF (protocol = 'TOPNSTUDY') THEN
						DELETE FROM t_vsm_zone_topnstudy WHERE service_id = pkidz;
					    ELSEIF (protocol = 'ICMP') THEN
						DELETE FROM t_vsm_zone_icmpflood WHERE service_id = pkidz;
					    ELSEIF (protocol = 'UDP_DNS') THEN
					    
					    DELETE FROM t_vsm_zone_dns_cache WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE service_id = pkidz);
					    DELETE FROM t_vsm_zone_dns_domain_defend WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE service_id = pkidz);
					    DELETE FROM t_vsm_zone_dns_sourceip_request WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE service_id = pkidz);
					    DELETE FROM t_vsm_zone_dns_sourceip_response WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE service_id = pkidz);
					    DELETE FROM t_vsm_zone_dns_staticfinger_request WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE service_id = pkidz);
					    DELETE FROM t_vsm_zone_dns_staticfinger_response WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE service_id = pkidz);
					    DELETE FROM t_vsm_zone_dns_statistic WHERE `dns_flood_id` in (SELECT `pkid` FROM t_vsm_zone_dnsflood WHERE service_id = pkidz);
					    
						DELETE FROM t_vsm_zone_dnsflood WHERE service_id = pkidz;
					    ELSEIF (protocol = 'TCP_DNS') THEN
						DELETE FROM t_vsm_zone_tcpflood WHERE service_id = pkidz;
					    ELSE  
						DELETE FROM t_vsm_zone_otherflood WHERE service_id = pkidz;
					    END IF;
					END IF;
			UNTIL done END REPEAT;

		CLOSE pkid_pro_cur;  /*关闭游标*/
END
//
DELIMITER ;

/* 删除inbound防御策略主表*/
DROP PROCEDURE IF EXISTS delete_zone_service_protocol;
DELIMITER //
CREATE PROCEDURE delete_zone_service_protocol()
BEGIN
	DELETE FROM t_vsm_zone_service WHERE protocol <> 'DEFAULT' AND direction = 1;
END
//
DELIMITER ;

/* 删除zone_service_status 部署后的状态信息*/
DROP PROCEDURE IF EXISTS delete_zone_service_status_protocol;
DELIMITER //
CREATE PROCEDURE delete_zone_service_status_protocol()
BEGIN
	DELETE FROM t_vsm_zone_service_status WHERE protocol <> 'DEFAULT';
END
//
DELIMITER ;

CALL delete_zone_inbonds_protocol();
CALL delete_zone_service_protocol();
CALL delete_zone_service_status_protocol();