USE `lego`;

/*点分需求升级脚本*/
DROP PROCEDURE IF EXISTS update_tcpfloodAndHttpsflood;
DELIMITER //
CREATE PROCEDURE update_tcpfloodAndHttpsflood() 
	BEGIN
		#https
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_httpsflood' AND column_name='https_nego_check_enable')
		THEN
			ALTER TABLE t_vsm_zone_httpsflood  ADD COLUMN  `https_nego_check_enable` BIT(1) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_httpsflood' AND column_name='https_session_check_enable')
		THEN
			ALTER TABLE t_vsm_zone_httpsflood  ADD COLUMN  `https_session_check_enable` BIT(1) DEFAULT NULL;
		END IF;
		
		#tcp
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='syn_ratio_limit_packets')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `syn_ratio_limit_packets` INT(11) DEFAULT NULL AFTER `syn_ratio_limit_rate`;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='syn_blacklist_enable')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `syn_blacklist_enable` BIT(1) DEFAULT NULL AFTER `syn_max_packets_duration`;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='syn_exception_times')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `syn_exception_times` INT(11) DEFAULT NULL AFTER `syn_blacklist_enable`;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='syn_total_check_times')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `syn_total_check_times` INT(11) DEFAULT NULL AFTER `syn_exception_times`;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='session_check_enable')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `session_check_enable` BIT(1) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='session_conn_rate')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `session_conn_rate` INT(11) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='session_check_duration')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `session_check_duration` INT(11) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='ack_check_enable')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `ack_check_enable` BIT(1) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='ack_min_packets_num')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `ack_min_packets_num` INT(11) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='big_packet_length')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `big_packet_length` INT(11) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='big_packet_ratio')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `big_packet_ratio` INT(11) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='syn_check_enable')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `syn_check_enable` BIT(1) DEFAULT NULL;
		END IF;
		
		IF NOT EXISTS(SELECT * FROM INFORMATION_SCHEMA.Columns WHERE table_name='t_vsm_zone_tcpflood' AND column_name='syn_packets_num')
		THEN
			ALTER TABLE t_vsm_zone_tcpflood  ADD  COLUMN `syn_packets_num` INT(11) DEFAULT NULL;
		END IF;
		
	END;
//	  
DELIMITER ;
CALL update_tcpfloodAndHttpsflood();