USE `lego`;

UPDATE t_atic_streamonitor_rule SET RULENAME='ACK Defense Leakage Check',DESCRIPTION='Checks the configuration and application of ACK defense' WHERE PKID='1';
UPDATE t_atic_streamonitor_rule SET RULENAME='SYN Defense Leakage Check',DESCRIPTION='Checks the configuration and application of SYN defense' WHERE PKID='2';
UPDATE t_atic_streamonitor_rule SET RULENAME='TCP Defense Leakage Check',DESCRIPTION='Checks the configuration and application of TCP defense' WHERE PKID='3';
UPDATE t_atic_streamonitor_rule SET RULENAME='HTTP Defense Leakage Check',DESCRIPTION='Checks the configuration and application of HTTP defense' WHERE PKID='4';
UPDATE t_atic_streamonitor_rule SET RULENAME='UDP Defense Leakage Check',DESCRIPTION='Checks the configuration and application of UDP defense' WHERE PKID='5';
UPDATE t_atic_streamonitor_rule SET RULENAME='DNS Defense Leakage Check',DESCRIPTION='Checks the configuration and application of DNS defense' WHERE PKID='6';
UPDATE t_atic_streamonitor_rule SET RULENAME='SYN Defense Negative Check',DESCRIPTION='Checks the application of SYN defense' WHERE PKID='7';
UPDATE t_atic_streamonitor_rule SET RULENAME='ACK Defense Negative Check',DESCRIPTION='Checks the application of ACK defense' WHERE PKID='8';
UPDATE t_atic_streamonitor_rule SET RULENAME='TCP NewCurConDefense Negative Check',DESCRIPTION='Checks the application of TCP defense' WHERE PKID='9';
UPDATE t_atic_streamonitor_rule SET RULENAME='HTTP Defense Negative Check',DESCRIPTION='Checks the application of HTTP defense' WHERE PKID='10';
UPDATE t_atic_streamonitor_rule SET RULENAME='UDP Defense Negative Check',DESCRIPTION='Checks the application of UDP defense' WHERE PKID='11';
UPDATE t_atic_streamonitor_rule SET RULENAME='DNS ReqDefense Negative Check',DESCRIPTION='Checks the application of DNS defense' WHERE PKID='12';

UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='1',measureName='ackPps',operator='0',targetValue='5000',groupId='1',conditionInGroupId='1',logicOperator='0',TYPE='0' WHERE pkid = '2';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='1',measureName='tcpConcurCon',operator='0',targetValue='1000',groupId='2',conditionInGroupId='1',logicOperator='0',TYPE='0' WHERE pkid = '3';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='1',measureName='synAckRatio',operator='1',targetValue='20',groupId='2',conditionInGroupId='2',logicOperator='1',TYPE='0' WHERE pkid = '4';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='1',measureName='srcAckKbps',operator='0',targetValue='5000',groupId='2',conditionInGroupId='3',logicOperator='1',TYPE='0'WHERE pkid = '5';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='2',measureName='synPps',operator='0',targetValue='10000',groupId='1',conditionInGroupId='1',logicOperator='0',TYPE='0' WHERE pkid = '7';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='2',measureName='synAckRatio',operator='0',targetValue='40',groupId='2',conditionInGroupId='1',logicOperator='0',TYPE='0' WHERE pkid = '8';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='2',measureName='tcpConcurCon',operator='0',targetValue='5000',groupId='2',conditionInGroupId='2',logicOperator='1',TYPE='0' WHERE pkid = '9';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='2',measureName='srcSynPps',operator='0',targetValue='5000',groupId='2',conditionInGroupId='3',logicOperator='1',TYPE='0' WHERE pkid = '10';
UPDATE t_atic_streamonitor_ruleconditionrelationship SET ruleId='4',measureName='httpQps',operator='0',targetValue='5000',groupId='1',conditionInGroupId='1',logicOperator='0',TYPE='0' WHERE pkid = '15';
DELETE FROM t_atic_streamonitor_ruleconditionrelationship WHERE pkid = '1';
DELETE FROM t_atic_streamonitor_ruleconditionrelationship WHERE pkid = '6';
DELETE FROM t_atic_streamonitor_ruleconditionrelationship WHERE pkid = '16';
DELETE FROM t_atic_streamonitor_ruleconditionrelationship WHERE pkid = '17';
DELETE FROM t_atic_streamonitor_ruleconditionrelationship WHERE pkid = '18';

-- Add filter mould
INSERT INTO t_vsm_filter(filter_name,filter_type,filter_action,filter_alert,filter_Id,device_type,filter_mode) VALUES ('IPMI_Amplification_Attack','udp','3',NULL,60019,'ALL','0');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'IPMI_Amplification_Attack'),'packet-length','58~1500');
INSERT INTO t_vsm_filter_http(filter_id,filter_key,filter_content) VALUES ((SELECT PKID FROM T_VSM_FILTER WHERE filter_name = 'IPMI_Amplification_Attack'),'source-port','623~623');


-- 防护对象黑白名单配置表
DROP TABLE IF EXISTS  `t_vsm_zone_black_white_list`;
CREATE TABLE IF NOT EXISTS `t_vsm_zone_black_white_list` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) NOT NULL DEFAULT '0',
  `black_white_type` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `mask` int(11) DEFAULT NULL,
  `delete_flag` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- 防护对象黑白名单部署表
DROP TABLE IF EXISTS  `t_vsm_zone_black_white_status`;
CREATE TABLE IF NOT EXISTS `t_vsm_zone_black_white_status` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `device_id` bigint(20) DEFAULT NULL,
  `zone_id` bigint(20) DEFAULT NULL,
  `black_white_type` int(11) DEFAULT NULL,
  `ip_address` varchar(50) COLLATE utf8_bin DEFAULT NULL,
  `mask` int(11) DEFAULT NULL,
  `deploy_state` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

-- NP过滤器预置模板
CREATE TABLE `t_vsm_np_filter` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_name` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `protocol_type` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `protocol_number` int(11) DEFAULT NULL,
  `filter_action` int(11) DEFAULT NULL,
  `filter_alert` bigint(20) DEFAULT NULL,
  `filter_index` int(11) DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_bin; 
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(1,'Chargen_Amplification_Attack','UDP',NULL,0,0,1);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(2,'SNMP_Amplification_Attack','UDP',NULL,0,0,2);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(3,'TFTP_Amplification_Attack','UDP',NULL,0,0,3);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(4,'NTP_Amplification_Attack','UDP',NULL,0,0,4);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(5,'NetBIOS_Amplification_Attack','UDP',NULL,0,0,5);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(6,'SSDP_Amplification_Attack','UDP',NULL,0,0,6);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(7,'QOTD_Amplification_Attack','UDP',NULL,0,0,7);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(8,'Quake_Network_Protocol_Amplification_Attack','UDP',NULL,0,0,8);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(9,'Steam_Protocol_Amplification_Attack','UDP',NULL,0,0,9);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(10,'Portmapper_Amplification_Attack','UDP',NULL,0,0,10);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(11,'Microsoft_SQL_Resolution_Service_Amplification_Attack','UDP',NULL,0,0,11);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(12,'RIPV1_Amplification_Attack','UDP',NULL,0,0,12);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(13,'Sentinel_Amplification_Attack','UDP',NULL,0,0,13);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(14,'LDAP_Amplification_Attack','UDP',NULL,0,0,14);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(15,'QUIC_Amplification_Attack','UDP',NULL,0,0,15);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(16,'mDNS_Amplification_Attack','UDP',NULL,0,0,16);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(17,'Memcached_Amplification_Attack','UDP',NULL,0,0,17);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(18,'SYN_ACK_Amplification_Attack','TCP',NULL,0,0,18);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(19,'SYN_Large_Amplification_Attack','TCP',NULL,0,0,19);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(20,'SYN_Short_Amplification_Attack','TCP',NULL,0,0,20);
insert into `t_vsm_np_filter` (`pkid`, `filter_name`, `protocol_type`, `protocol_number`, `filter_action`, `filter_alert`, `filter_index`) values(21,'IPMI_Amplification_Attack','UDP',NULL,0,0,21);

CREATE TABLE `t_vsm_np_filter_rule` (
  `pkid` bigint(20) NOT NULL AUTO_INCREMENT,
  `filter_id` bigint(20) DEFAULT NULL,
  `destination_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `destination_mask` int(11) DEFAULT NULL,
  `destination_port` int(11) DEFAULT NULL,
  `destination_start_port` int(11) DEFAULT NULL,
  `destination_end_port` int(11) DEFAULT NULL,
  `source_ip` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `source_mask` int(11) DEFAULT NULL,
  `source_port` int(11) DEFAULT NULL,
  `source_start_port` int(11) DEFAULT NULL,
  `source_end_port` int(11) DEFAULT NULL,
  `packet_start_len` int(11) DEFAULT NULL,
  `packet_end_len` int(11) DEFAULT NULL,
  `tcp_flag` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`pkid`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_bin; 
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(1,1,NULL,NULL,NULL,19,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(2,2,NULL,NULL,NULL,161,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(3,3,NULL,NULL,NULL,69,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(4,4,NULL,NULL,NULL,123,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(5,5,NULL,NULL,NULL,137,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(6,6,NULL,NULL,NULL,1900,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(7,7,NULL,NULL,NULL,17,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(8,8,NULL,NULL,NULL,27960,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(9,9,NULL,NULL,NULL,27015,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(10,10,NULL,NULL,NULL,111,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(11,11,NULL,NULL,NULL,1434,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(12,12,NULL,NULL,NULL,520,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(13,13,NULL,NULL,NULL,5093,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(14,14,NULL,NULL,NULL,389,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(15,15,NULL,80,NULL,NULL,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(16,16,NULL,NULL,NULL,5353,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(17,17,NULL,NULL,NULL,11211,256,1500,NULL);
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(18,18,NULL,NULL,NULL,NULL,NULL,NULL,'syn-ack');
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(19,19,NULL,NULL,NULL,NULL,68,1500,'syn');
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(20,20,NULL,NULL,NULL,NULL,0,40,'syn');
insert into `t_vsm_np_filter_rule` (`pkid`, `filter_id`, `destination_ip`, `destination_port`, `source_ip`, `source_port`, `packet_start_len`, `packet_end_len`, `tcp_flag`) values(21,21,NULL,NULL,NULL,623,58,65535,NULL);
