USE `lego`;

INSERT INTO t_operations(opt_id,opt_name,opt_url,opt_description,ismaster,serial_number) VALUES(211,'atic.server.restful','/nem/fault/showrestfulserver.do','',FALSE,'8000-1000-40');
INSERT INTO t_operations(opt_id,opt_name,opt_url,opt_description,ismaster,serial_number) VALUES(212,'atic.server.restful.scan','','',TRUE,'8000-1000-40-5');
INSERT INTO t_operations(opt_id,opt_name,opt_url,opt_description,ismaster,serial_number) VALUES(213,'atic.server.restful.serverEdit','','',FALSE,'8000-1000-40-10');

DROP PROCEDURE IF EXISTS add_zoneId;
DELIMITER //
CREATE PROCEDURE add_zoneId()
  BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_atic_blackhole' AND column_name ='zone_id') THEN
		ALTER TABLE t_atic_blackhole ADD COLUMN zone_id bigint(20);
    	
    END IF;	   
  END;
//
DELIMITER ;
CALL add_zoneId();
DROP PROCEDURE IF EXISTS add_zoneId;

DROP PROCEDURE IF EXISTS add_blackhole_mode;
DELIMITER //
CREATE PROCEDURE add_blackhole_mode()
  BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_zone_ddos_policy' AND column_name ='blackhole_mode') THEN
		ALTER TABLE t_vsm_zone_ddos_policy ADD COLUMN blackhole_mode INT(11) DEFAULT '1';
    	
    END IF;	   
  END;
//
DELIMITER ;
CALL add_blackhole_mode();
DROP PROCEDURE IF EXISTS add_blackhole_mode;

DROP PROCEDURE IF EXISTS add_blackhole_notify;
DELIMITER //
CREATE PROCEDURE add_blackhole_notify()
  BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_vsm_zone_ddos_policy' AND column_name ='blackhole_notify') THEN
		ALTER TABLE t_vsm_zone_ddos_policy ADD COLUMN blackhole_notify INT(11) DEFAULT '2';
    	
    END IF;	   
  END;
//
DELIMITER ;
CALL add_blackhole_notify();
DROP PROCEDURE IF EXISTS add_blackhole_notify;

DROP PROCEDURE IF EXISTS create_nexthop;
DELIMITER //
CREATE PROCEDURE create_nexthop()
  BEGIN
    IF EXISTS(SELECT * FROM information_schema.TABLES WHERE table_name = 't_atic_device_nexthop' AND table_schema = 'lego') THEN
		ALTER TABLE t_atic_device_nexthop ADD COLUMN `jyqx_ipv6` VARCHAR(255);
		ALTER TABLE t_atic_device_nexthop ADD COLUMN `jmdqx_ipv6` VARCHAR(255);
    ELSE
    	CREATE TABLE `t_atic_device_nexthop` (
		  `moId` BIGINT(20) NOT NULL,
		  `jyqx_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
		  `jmdqx_ip` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
		  `jyqx_ipv6` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
		  `jmdqx_ipv6` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL,
		  PRIMARY KEY (`moId`)
		) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE=utf8_bin;
    	
    END IF;	   
  END;
//
DELIMITER ;
CALL create_nexthop();
DROP PROCEDURE IF EXISTS create_nexthop;



ALTER TABLE t_atic_blackhole_np_config MODIFY COLUMN `black_hole_threshold` int(11);

ALTER TABLE t_atic_device_router MODIFY COLUMN sample_ratio VARCHAR(20);

ALTER TABLE t_atic_device MODIFY COLUMN `log_password` TEXT;
ALTER TABLE t_atic_device_nfa MODIFY COLUMN `api_key` TEXT;
ALTER TABLE t_atic_device_router MODIFY COLUMN `sample_ratio` VARCHAR(20);
ALTER TABLE t_atic_homepage_entity MODIFY COLUMN `statistic_type` INT(1);
ALTER TABLE t_atic_homepage_entity  CHANGE  `DIRECTION` `direction` INT(1) UNSIGNED NOT NULL DEFAULT '1';
ALTER TABLE t_discoverypolicy MODIFY COLUMN `param_html` TEXT;
ALTER TABLE t_discoverypolicy MODIFY COLUMN `param_values_str` TEXT;
DROP TABLE IF EXISTS  `t_backtask`;
DROP TABLE IF EXISTS  `t_custom`;
DROP TABLE IF EXISTS  `t_ldap_server`;
DROP TABLE IF EXISTS  `t_licenseinfo`;
DROP TABLE IF EXISTS  `t_licenserevoke`;
DROP TABLE IF EXISTS  `t_localnmsinfo`;
DROP TABLE IF EXISTS  `t_nmsconfginfo`;
DROP TABLE IF EXISTS  `t_northnmsinfo`;
DROP TABLE IF EXISTS  `t_portal`;

DROP PROCEDURE IF EXISTS drop_bundle_name;
DELIMITER //
CREATE PROCEDURE drop_bundle_name()
  BEGIN
    IF EXISTS(SELECT * FROM information_schema.columns
           WHERE TABLE_SCHEMA='lego' AND table_name = 't_task' AND column_name ='bundle_name') THEN
      ALTER TABLE t_task DROP COLUMN bundle_name;
    END IF;	   
  END;
//
DELIMITER ;
CALL drop_bundle_name();
DROP PROCEDURE IF EXISTS drop_bundle_name;

ALTER TABLE `t_vsm_neconf_abnormaldfn` MODIFY COLUMN `domain_error_msg_key` LONGTEXT;
ALTER TABLE `t_vsm_neconf_domain_whitelist` MODIFY COLUMN `pkid` BIGINT(20) NOT NULL AUTO_INCREMENT;
ALTER TABLE `t_vsm_zone_black_white_status` MODIFY COLUMN `ip_address` VARCHAR(255) COLLATE utf8_bin DEFAULT NULL;
ALTER TABLE t_atic_device_nfa MODIFY COLUMN `local_as` BIGINT(20) DEFAULT NULL;

ALTER TABLE t_alarm_smsserver MODIFY COLUMN `password` VARCHAR(1024);
ALTER TABLE t_alarm_smsserver MODIFY COLUMN `proxypassword` VARCHAR(1024);

ALTER TABLE `t_atic_blackhole` MODIFY COLUMN `blackhole_type` INT(11) DEFAULT null ;

ALTER TABLE `t_atic_blackhole_api_config` MODIFY COLUMN `defend_scope` VARCHAR(255);

ALTER TABLE `t_atic_cloudclean_config` MODIFY COLUMN `public_key` text;
ALTER TABLE `t_atic_cloudclean_config` MODIFY COLUMN `private_key` text;
ALTER TABLE `t_atic_cloudclean_config` MODIFY COLUMN `ip_white_list` text;

DROP PROCEDURE IF EXISTS modify_primary_location_ip;
DELIMITER //
CREATE PROCEDURE modify_primary_location_ip()
  BEGIN
    IF NOT EXISTS(SELECT * FROM information_schema.TABLE_CONSTRAINTS WHERE table_name = 't_atic_location_ip' AND table_schema = 'lego' AND constraint_name = 'primary') THEN
      ALTER TABLE `t_atic_location_ip` ADD PRIMARY KEY ( `location_id` );
    END IF;	   
  END;
//
DELIMITER ;
CALL modify_primary_location_ip();
DROP PROCEDURE IF EXISTS modify_primary_location_ip;

ALTER TABLE t_atic_streamonitor_ruleconditionrelationship add constraint RULE_ID foreign key(`ruleId`) REFERENCES `t_atic_streamonitor_rule` (`pkid`);

ALTER TABLE t_vsm_zone_device_status MODIFY COLUMN error_param TEXT DEFAULT NULL;

