/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.lego.core.base.dataprotect.service.DataProtectService;
import com.hs.lego.core.sdk.base.dataprotect.service.IDataProtectService;
import java.util.logging.Logger;

public abstract class DataProtectServiceConst {
    private static final Logger LOGGER = Logger.getLogger(DataProtectServiceConst.class.toString());
    private static volatile IDataProtectService dataProtectService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IDataProtectService getDataProtectService() {
        if (null != dataProtectService) return dataProtectService;
        Class<DataProtectServiceConst> clazz = DataProtectServiceConst.class;
        synchronized (DataProtectServiceConst.class) {
            if (null != dataProtectService) return dataProtectService;
            dataProtectService = new DataProtectService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return dataProtectService;
        }
    }

    public static String sdpEncryptInitData(String pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpEncryptInitData(pucCipherText);
        return result;
    }

    public static void main(String[] args) {
        String a = "000000010000000100000000000000050000000100000001B0391F60068C71BC3FB98413EDF1DBC2F2461BC5DE7882211BAB9C8748E34D05000000100000000000000000E159C65B40DF92795A117A4405E4762100000001000000000000080400000001000000015BABD1B21F34911A74E0EFCCF2A590B30000000000000000E729D0F06961530C0C852401FF34518D8E47755E386CAF04E26AE269C46F2314";
        String r = DataProtectServiceConst.sdpDecryptLocal(a);
        System.out.println(r);
    }

    public static String sdpDecryptInitData(String pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpDecryptInitData(pucCipherText);
        return result;
    }

    public static String sdpEncryptInitData(StringBuffer pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpEncryptInitData(pucCipherText);
        return result;
    }

    public static StringBuffer sdpDecryptInitDataBuffer(String pucCipherText) {
        StringBuffer result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpDecryptInitDataByte(pucCipherText);
        return result;
    }

    public static String sdpEncryptLocal(String pucPlainText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpEncryptLocal getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpEncrypt(0L, pucPlainText);
        return result;
    }

    public static String sdpDecryptLocal(String pucCipherText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpDecryptLocal getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpDecrypt(0L, pucCipherText);
        return result;
    }

    public static String sdpEncryptLocal(StringBuffer pucPlainText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpEncryptLocal getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpEncrypt(0L, pucPlainText);
        return result;
    }

    public static StringBuffer sdpDecryptLocalBuffer(String pucCipherText) {
        StringBuffer result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "DataProtectServiceConst.sdpDecryptLocal getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpDecrypt(pucCipherText, 0L);
        return result;
    }

    public static String sdpProtectPwdLocal(StringBuffer pucPlainText) {
        String result = null;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpProtectPwd(pucPlainText);
        return result;
    }

    public static boolean sdpVerifyPwdLocal(StringBuffer pucPlainText, String pucCipherText) {
        boolean result = false;
        IDataProtectService srv = DataProtectServiceConst.getDataProtectService();
        if (null == srv) {
            String errorMsg = "getDataProtectService fail";
            LOGGER.info(errorMsg);
            throw new RuntimeException(errorMsg);
        }
        result = srv.sdpVerifyPwd(pucPlainText, pucCipherText);
        return result;
    }

    public static void setDataProtectService(IDataProtectService dataProtectService) {
        DataProtectServiceConst.dataProtectService = dataProtectService;
    }
}

