/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.sdk.base.dataprotect.util;

import com.hs.lego.core.sdk.base.dataprotect.DataProtector;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.hs.lego.core.sdk.base.dataprotect.util.DataProtectConfigHelper;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;

public abstract class LegoDataProtector {
    private static final Logger LOGGER = Logger.getLogger(LegoDataProtector.class.toString());
    private static final Object LOCK = new Object();
    private static DataProtector dataProtector = null;
    private static DataProtector dataProtectorInit = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataProtector getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == dataProtector) {
                String libFolderPath = DataProtectConfigHelper.getKmclibPath();
                String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
                String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
                String dhP = DataProtectConfigHelper.getConfigValue("dh_p");
                byte[] dhPBytes = new byte[]{};
                try {
                    dhPBytes = dhP.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e1) {
                    LOGGER.info("DataProtector: " + e1.getMessage());
                }
                String dhG = DataProtectConfigHelper.getConfigValue("dh_g");
                byte[] dhGBytes = new byte[]{};
                try {
                    dhGBytes = dhG.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.info("DataProtector: " + e.getMessage());
                }
                String keyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreFile");
                String keyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreBakFile");
                String kmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgFile");
                String kmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgBakFile");
                KmcFiles kf = new KmcFiles();
                kf.setKeyStoreFile(keyStoreFile);
                kf.setKeyStoreBakFile(keyStoreBakFile);
                kf.setKmcCfgFile(kmcCfgFile);
                kf.setKmcCfgBakFile(kmcCfgBakFile);
                kf.setLogConfigFile(kmcLogConfigFile);
                dataProtector = new DataProtector(libFolderPath, kf, dhPBytes, dhGBytes);
            }
            return dataProtector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataProtector getInitInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == dataProtectorInit) {
                String libFolderPath = DataProtectConfigHelper.getKmclibPath();
                LOGGER.info("getKmclibPath success");
                String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
                LOGGER.info("getKmcConfigRootPath success");
                String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
                LOGGER.info("kmcLogConfigFile success");
                String dhP = DataProtectConfigHelper.getConfigValue("dh_p");
                byte[] dhPBytes = new byte[]{};
                try {
                    dhPBytes = dhP.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.info("DataProtector: " + e.getMessage());
                }
                LOGGER.info("dhP=" + dhP);
                String dhG = DataProtectConfigHelper.getConfigValue("dh_g");
                byte[] dhGBytes = new byte[]{};
                try {
                    dhGBytes = dhG.getBytes("utf-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.info("DataProtector:" + e.getMessage());
                }
                LOGGER.info("dhG=" + dhG);
                String initkeyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreFile");
                String initkeyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreBakFile");
                LOGGER.info("initkeyStoreFile success");
                String initkmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgFile");
                LOGGER.info("initkeyStoreBakFile success");
                String initkmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgBakFile");
                LOGGER.info("initkmcCfgFile success");
                KmcFiles kfInit = new KmcFiles();
                kfInit.setKeyStoreFile(initkeyStoreFile);
                kfInit.setKeyStoreBakFile(initkeyStoreBakFile);
                kfInit.setKmcCfgFile(initkmcCfgFile);
                kfInit.setKmcCfgBakFile(initkmcCfgBakFile);
                kfInit.setLogConfigFile(kmcLogConfigFile);
                dataProtectorInit = new DataProtector(libFolderPath, kfInit, dhPBytes, dhGBytes);
            }
            return dataProtectorInit;
        }
    }

    public static String sdpEncrypt(long domainId, String pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(domainId, pucPlainText);
    }

    public static String sdpEncryptLocal(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpEncryptInitData(String pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpDecrypt(long domainId, String pucCipherText) {
        String plainText = LegoDataProtector.getInstance().sdpDecrypt(domainId, pucCipherText);
        if (null == plainText) {
            LOGGER.info("sdpDecrypt fail,try sdpDecryptInitData.");
            plainText = LegoDataProtector.sdpDecryptInitData(pucCipherText);
            if (null == plainText) {
                LOGGER.info("sdpDecrypt try decrypt init data fail.");
            }
        }
        return plainText;
    }

    public static String sdpDecryptLocal(String pucCipherText) {
        return LegoDataProtector.sdpDecrypt(0L, pucCipherText);
    }

    public static String sdpDecryptInitData(String pucCipherText) {
        String plainText = LegoDataProtector.getInitInstance().sdpDecrypt(0L, pucCipherText);
        if (null == plainText) {
            LOGGER.info("sdpDecryptInitData fail.");
        }
        return plainText;
    }

    public static String sdpProtectPwd(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpProtectPwd(pucPlainText);
    }

    public static String sdpProtectPwdInitData(String pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpProtectPwd(pucPlainText);
    }

    public static boolean sdpVerifyPwd(String pucPlainText, String pucCipherText) {
        boolean result = LegoDataProtector.getInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        if (!result) {
            result = LegoDataProtector.getInitInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        }
        return result;
    }

    public static String sdpHmac(String pucPlainText) {
        return LegoDataProtector.getInstance().sdpHmac(pucPlainText);
    }

    public static String sdpEncrypt(long domainId, byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(domainId, pucPlainText);
    }

    public static String sdpEncryptLocal(byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static String sdpEncryptInitData(byte[] pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpEncrypt(0L, pucPlainText);
    }

    public static byte[] sdpDecrypt(String pucCipherText, long domainId) {
        byte[] plainText = LegoDataProtector.getInstance().sdpDecrypt(pucCipherText, domainId);
        if (0 == plainText.length) {
            LOGGER.info("sdpDecrypt fail,try sdpDecryptInitData.");
            plainText = LegoDataProtector.sdpDecryptInitDataByte(pucCipherText);
        }
        return plainText;
    }

    public static byte[] sdpDecryptLocalByte(String pucCipherText) {
        return LegoDataProtector.sdpDecrypt(pucCipherText, 0L);
    }

    public static byte[] sdpDecryptInitDataByte(String pucCipherText) {
        byte[] plainText = LegoDataProtector.getInitInstance().sdpDecrypt(pucCipherText, 0L);
        return plainText;
    }

    public static String sdpProtectPwd(byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpProtectPwd(pucPlainText);
    }

    public static String sdpProtectPwdInitData(byte[] pucPlainText) {
        return LegoDataProtector.getInitInstance().sdpProtectPwd(pucPlainText);
    }

    public static boolean sdpVerifyPwd(byte[] pucPlainText, String pucCipherText) {
        boolean result = LegoDataProtector.getInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        if (!result) {
            result = LegoDataProtector.getInitInstance().sdpVerifyPwd(pucPlainText, pucCipherText);
        }
        return result;
    }

    public static String sdpHmac(byte[] pucPlainText) {
        return LegoDataProtector.getInstance().sdpHmac(pucPlainText);
    }
}

