/*
 * Decompiled with CFR 0.152.
 */
package com.hs.atic.rmi;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.NotifyFaultSeverityRuleService;
import com.hs.atic.rmi.ShowCollectorCounterService;
import com.hs.atic.rmi.SysManagerService;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashMap;
import java.util.Map;

public class SecneCollectorRMIProxy
implements Serializable {
    private static final long serialVersionUID = -7353997750449280835L;
    private static Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private transient Map<String, Registry> map = new HashMap<String, Registry>();

    private Registry getCollectorRegistry(String collectorIpStr) {
        logger.info((Object)("collectorIpStr:" + collectorIpStr));
        if (null != this.map.get(collectorIpStr)) {
            return this.map.get(collectorIpStr);
        }
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(collectorIpStr, 11099, (RMIClientSocketFactory)csf);
            this.map.put(collectorIpStr, registry);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)("collectorIpStr:" + collectorIpStr + " have exist in the map"), (Throwable)e);
            return registry;
        }
        catch (Exception e) {
            logger.error((Object)"Regist failed !", (Throwable)e);
            registry = null;
        }
        return registry;
    }

    public ShowCollectorCounterService getShowCollectorCounterService(String collectorIpStr) {
        ShowCollectorCounterService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (ShowCollectorCounterService)registry.lookup("showCollectorCounterService");
            }
            catch (IOException e) {
                logger.error((Object)"Get ShowCollectorCounterService interface object failed !", (Throwable)e);
                service = null;
            }
            catch (NotBoundException e) {
                logger.error((Object)"Get ShowCollectorCounterService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get ShowCollectorCounterService success:" + service));
        }
        return service;
    }

    public SysManagerService getSysManagerService(String collectorIpStr) {
        SysManagerService sysManagerService = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                sysManagerService = (SysManagerService)registry.lookup("sysManagerService");
            }
            catch (Exception e) {
                logger.error((Object)"Get SysManagerService interface object failed !", (Throwable)e);
                sysManagerService = null;
            }
        }
        if (sysManagerService != null) {
            logger.info((Object)("Get sysManagerService success:" + sysManagerService.toString()));
        }
        return sysManagerService;
    }

    public NotifyFaultSeverityRuleService getNotifyFaultSeverityRuleService(String collectorIpStr) {
        NotifyFaultSeverityRuleService service = null;
        Registry registry = this.getCollectorRegistry(collectorIpStr);
        if (null != registry) {
            try {
                service = (NotifyFaultSeverityRuleService)registry.lookup("notifyFaultSeverityRuleService");
            }
            catch (Exception e) {
                logger.error((Object)"Get NotifyFaultSeverityRuleService interface object failed !", (Throwable)e);
                service = null;
            }
        }
        if (service != null) {
            logger.info((Object)("Get NotifyFaultSeverityRuleService success:" + service));
        }
        return service;
    }
}

