/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation.nepoll;

import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.mediation.nepoll.PollPlugin;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.Serializable;
import java.util.HashMap;

public class PingPoll
implements Serializable {
    private static final long serialVersionUID = 312499003263152431L;
    private static final int STATUS_ONLINE = 0;
    private static final int STATUS_OFFLINE = -1;
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private long moId;
    private String moIP;
    private String moName;
    private boolean isFirstTime = true;
    private boolean isOnline = true;

    public PingPoll(long moId, String moIP, String moName) {
        this.moId = moId;
        this.moIP = moIP;
        this.moName = moName;
    }

    public void sendOffLineMsg() {
        try {
            LOGGER.warn((Object)("ping " + this.moIP + " is not reachable."));
            if (this.isOnline) {
                IMessageCenter mc = PollPlugin.getInstance().getMc();
                HashMap<Long, Integer> msg = new HashMap<Long, Integer>();
                msg.put(this.moId, -1);
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(109L);
                mu.setObj(msg);
                mu.setMt(MessageTopic.COMMAND);
                mu.setSourceAppName(this.getClass().getName());
                mc.sendMessage(mu);
                this.isOnline = false;
                this.isFirstTime = false;
                LOGGER.info((Object)("send mo offline message success and generate a offline alarm, moId: " + this.getMoId() + ", moIP: " + this.moIP));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("send mo offline message and generate offline alarm failed, moId: " + this.getMoId() + ", moIP: " + this.moIP), (Throwable)e);
        }
    }

    public void sendOnLineMsg() {
        LOGGER.debug((Object)("ping " + this.moIP + " is reachable."));
        HashMap<Long, Integer> msg = new HashMap<Long, Integer>();
        msg.put(this.getMoId(), 0);
        if (this.isFirstTime) {
            IMessageCenter mc = PollPlugin.getInstance().getMc();
            MessageUnit mu = new MessageUnit();
            mu.setCmdcode(110L);
            mu.setObj(msg);
            mu.setMt(MessageTopic.COMMAND);
            mu.setSourceAppName(this.getClass().getName());
            mc.sendMessage(mu);
            this.isFirstTime = false;
            this.isOnline = true;
            LOGGER.info((Object)("send mo online message and generate a offline restore alarm at first time, moId: " + this.getMoId() + ", moIP: " + this.moIP));
            return;
        }
        try {
            if (!this.isOnline) {
                IMessageCenter mc = PollPlugin.getInstance().getMc();
                MessageUnit mu = new MessageUnit();
                mu.setCmdcode(110L);
                mu.setObj(msg);
                mu.setMt(MessageTopic.COMMAND);
                mu.setSourceAppName(this.getClass().getName());
                mc.sendMessage(mu);
                this.isOnline = true;
                LOGGER.info((Object)("send mo online message and generate a offline restore alarm, moId: " + this.getMoId() + ", moIP: " + this.moIP));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("send mo offline message and generate offline restore alarm failed, moId: " + this.getMoId() + ", moIP: " + this.moIP), (Throwable)e);
        }
    }

    public long getMoId() {
        return this.moId;
    }

    public void setMoId(long moId) {
        this.moId = moId;
    }

    public String getMoIP() {
        return this.moIP;
    }

    public void setMoIP(String moIP) {
        this.moIP = moIP;
    }

    public String getMoName() {
        return this.moName;
    }

    public void setMoName(String moName) {
        this.moName = moName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.moIP == null ? 0 : this.moIP.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        if (!(obj instanceof PingPoll)) {
            return false;
        }
        PingPoll other = (PingPoll)obj;
        return other.getMoId() == this.getMoId();
    }

    public String toString() {
        return new StringBuffer().append("moId: ").append(this.moId).append(", moIP:").append(this.moIP).append(", moName: ").append(this.moName).toString();
    }
}

