/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.core.mediation.nepoll;

import com.hs.atic.util.CrashThreadHandler;
import com.hs.lego.cbb.resource.sdk.service.IDataExplore;
import com.hs.lego.com.south.sdk.ping.PingServiceImpl;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.base.thread.RunnableTask;
import com.hs.lego.core.base.thread.ThreadPoolManager;
import com.hs.lego.core.mediation.IPlugin;
import com.hs.lego.core.mediation.nepoll.InitPollThread;
import com.hs.lego.core.mediation.nepoll.PingPoll;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.hs.lego.core.sdk.base.event.StatusChangedEvent;
import com.hs.lego.core.sdk.base.model.Status;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.nem.webnms.sdk.service.IPingService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class PollPlugin
implements IPlugin,
ServiceStatusChangedListener {
    private static final Object SLOCK = new Object();
    private static final Object LOCK = new Object();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private static PollPlugin sInstance = null;
    private long interval = 30L;
    private int timeout = 5;
    private int retries = 1;
    private int batchCount = 10;
    private int failedRetry = 3;
    private IMessageCenter mc;
    private List<PollTask> pollTaskCache = new ArrayList<PollTask>();
    private IDataExplore dateExplorer = null;
    private IPingService pingService = new PingServiceImpl();

    private PollPlugin() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PollPlugin getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == sInstance) {
                sInstance = new PollPlugin();
                sInstance.init();
            }
            return sInstance;
        }
    }

    public void initDevicePingList() {
        this.dateExplorer = (IDataExplore)ServiceContext.getInstance().getService("deviceDataExplore", IDataExplore.class);
        Thread thread = new Thread(new InitPollThread(this.dateExplorer));
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
        thread.start();
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        try {
            if (event.getStatus() == Status.STATUS_STARTED && event.getEventTarget() instanceof IDataExplore) {
                this.dateExplorer = (IDataExplore)ServiceContext.getInstance().getService("deviceDataExplore", IDataExplore.class);
                Thread thread = new Thread(new InitPollThread(this.dateExplorer));
                thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)CrashThreadHandler.getInstance());
                thread.start();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("look up ResourceApplication/DeviceDataExplore failed in InitPollThread." + e.getMessage()));
        }
    }

    @Override
    public void init() {
        Properties props = new Properties();
        InputStream instream = null;
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            if (null == loader) {
                return;
            }
            instream = loader.getResourceAsStream("poll.properties");
            if (null == instream) {
                return;
            }
            props.load(instream);
            this.interval = Long.parseLong(props.getProperty("poll_interval", "30"));
            this.timeout = Integer.parseInt(props.getProperty("poll_timeout", "3"));
            this.retries = Integer.parseInt(props.getProperty("poll_retries", "3"));
            this.batchCount = Integer.parseInt(props.getProperty("batch_count", "100"));
            this.failedRetry = Integer.parseInt(props.getProperty("failed_retry", "3"));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)"read poll.properties error.", (Throwable)e);
            throw new LegoUncheckedException((Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error((Object)"read poll.properties error.");
            throw new LegoUncheckedException((Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)"read poll.properties error.", (Throwable)e);
            throw new LegoUncheckedException((Throwable)e);
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close InputStream of poll.properties error.");
                }
            }
        }
        LOGGER.info((Object)"PollPlugin in Mediation has started.");
    }

    @Override
    public void destroy() {
    }

    public long getInterval() {
        return this.interval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getRetries() {
        return this.retries;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public IMessageCenter getMc() {
        return this.mc;
    }

    public void setMc(IMessageCenter mc) {
        this.mc = mc;
    }

    public int getFailedRetry() {
        return this.failedRetry;
    }

    public IPingService getPingService() {
        return this.pingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheTask(PollTask task) {
        Object object = SLOCK;
        synchronized (object) {
            if (null != task) {
                this.pollTaskCache.add(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPingPoll(PingPoll pingPoll) {
        Object object = SLOCK;
        synchronized (object) {
            try {
                boolean result = false;
                for (PollTask task : this.pollTaskCache) {
                    if (result || !task.hasSpace()) continue;
                    task.addPingPoll(pingPoll);
                    result = true;
                }
                if (!result) {
                    PollTask newTask = new PollTask();
                    newTask.addPingPoll(pingPoll);
                }
                TimeUnit.MILLISECONDS.sleep(50L);
            }
            catch (Exception e) {
                LOGGER.error((Object)"", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePingPoll(PingPoll pingPoll) {
        Object object = SLOCK;
        synchronized (object) {
            PingPoll oldPoll = null;
            for (PollTask task : this.pollTaskCache) {
                oldPoll = task.getPingPoll(pingPoll.getMoId());
                if (null == oldPoll) continue;
                task.updatePingPoll(pingPoll);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePingPoll(long moId) {
        Object object = SLOCK;
        synchronized (object) {
            Iterator<PollTask> itor = this.pollTaskCache.iterator();
            while (itor.hasNext()) {
                PollTask task = itor.next();
                long taskTimeStamp = task.getTimeStamp();
                task.deletePingPoll(moId);
                if (!task.isEmpty()) continue;
                itor.remove();
                ThreadPoolManager.deleteTask(taskTimeStamp);
            }
        }
    }

    static class PollTask
    extends RunnableTask {
        private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
        private final Object lock = new Object();
        private List<PingPoll> pingPollList = Collections.synchronizedList(new ArrayList());
        private Map<String, Integer> failedPollMap = new HashMap<String, Integer>();
        private long lastExcuteTime = 0L;

        public PollTask() {
            this.setPeriodTask(true);
            PollPlugin.getInstance().cacheTask(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPingPoll(PingPoll pingPoll) {
            Object object = SLOCK;
            synchronized (object) {
                long moId = pingPoll.getMoId();
                String moIP = pingPoll.getMoIP();
                String moName = pingPoll.getMoName();
                PingPoll oldPoll = this.getPingPoll(moId);
                if (null != oldPoll && !oldPoll.getMoIP().equals(moIP)) {
                    String oldIP = oldPoll.getMoIP();
                    oldPoll.setMoIP(moIP);
                    ThreadPoolManager.addTask(this, false);
                    this.logger.info((Object)("update a polltask success, moId: " + moId + ", moName: " + moName + ", moIP: " + moIP + ", oldIP: " + oldIP));
                    return;
                }
                if (this.pingPollList.contains(pingPoll)) {
                    this.logger.info((Object)("find a duplicate polltask, moId: " + moId + ", moName: " + moName + ", moIP: " + moIP));
                    return;
                }
                this.pingPollList.add(pingPoll);
                if (this.pingPollList.size() == 1) {
                    ThreadPoolManager.addTask(this, false);
                }
                this.logger.info((Object)("add a new polltask success, moId: " + moId + ", moName: " + moName + ", moIP: " + moIP));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updatePingPoll(PingPoll pingPoll) {
            Object object = SLOCK;
            synchronized (object) {
                long moId = pingPoll.getMoId();
                String moIP = pingPoll.getMoIP();
                String moName = pingPoll.getMoName();
                PingPoll oldPoll = this.getPingPoll(moId);
                if (null != oldPoll && !oldPoll.getMoIP().equals(moIP)) {
                    String oldIP = oldPoll.getMoIP();
                    oldPoll.setMoIP(moIP);
                    ThreadPoolManager.addTask(this, false);
                    this.logger.info((Object)("update a polltask success, moId: " + moId + ", moName: " + moName + ", moIP: " + moIP + ", oldIP: " + oldIP));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deletePingPoll(long moId) {
            Object object = SLOCK;
            synchronized (object) {
                boolean flag = false;
                Iterator<PingPoll> itor = this.pingPollList.iterator();
                while (itor.hasNext()) {
                    PingPoll poll = itor.next();
                    if (poll.getMoId() != moId) continue;
                    itor.remove();
                    flag = true;
                    this.logger.info((Object)("delete a polltask success, moId: " + moId + ", moName: " + poll.getMoName()));
                }
                if (flag) {
                    ThreadPoolManager.addTask(this, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PingPoll getPingPoll(long moId) {
            Object object = SLOCK;
            synchronized (object) {
                for (PingPoll poll : this.pingPollList) {
                    if (moId != poll.getMoId()) continue;
                    return poll;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = SLOCK;
            synchronized (object) {
                return this.pingPollList.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasSpace() {
            Object object = SLOCK;
            synchronized (object) {
                return this.pingPollList.size() < PollPlugin.getInstance().getBatchCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    if ((System.currentTimeMillis() - this.lastExcuteTime) / 1000L >= PollPlugin.getInstance().getInterval()) {
                        this.lastExcuteTime = System.currentTimeMillis();
                        this.doPingTask();
                    } else {
                        ThreadPoolManager.addTask(this, true);
                    }
                }
                catch (Exception e) {
                    this.logger.error((Object)("Throwable occured when ping " + this.getIpList()), (Throwable)e);
                }
            }
        }

        private void doPingTask() {
            try {
                if (!this.pingPollList.isEmpty()) {
                    ArrayList<String> ipList = new ArrayList<String>();
                    ArrayList<PingPoll> tmpList = new ArrayList<PingPoll>();
                    this.failedPollMap.clear();
                    for (PingPoll pingPoll : this.pingPollList) {
                        tmpList.add(pingPoll);
                        ipList.add(pingPoll.getMoIP());
                        this.logger.debug((Object)("ping device ip:" + pingPoll.getMoIP()));
                    }
                    Boolean[] results = PollPlugin.getInstance().getPingService().batchPing(ipList, PollPlugin.getInstance().getRetries(), PollPlugin.getInstance().getTimeout());
                    for (int i = 0; i < results.length; ++i) {
                        PingPoll pingPoll = (PingPoll)tmpList.get(i);
                        if (results[i].booleanValue()) {
                            pingPoll.sendOnLineMsg();
                            continue;
                        }
                        this.logger.info((Object)("ping device failed, device ip:" + pingPoll.getMoIP() + ",failedTime in Map: 1"));
                        this.failedPollMap.put(pingPoll.getMoIP(), 1);
                    }
                    this.doRetryPingTask();
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("Exception occured when ping " + this.getIpList()), (Throwable)e);
            }
        }

        private PingPoll getCorrectPingPoll(String devIP) {
            if (null == devIP) {
                return null;
            }
            if (!this.pingPollList.isEmpty()) {
                for (PingPoll pingPoll : this.pingPollList) {
                    if (!devIP.equals(pingPoll.getMoIP())) continue;
                    return pingPoll;
                }
            } else {
                return null;
            }
            return null;
        }

        private void doRetryPingTask() {
            if (!this.failedPollMap.isEmpty()) {
                ArrayList<String> ipList = new ArrayList<String>();
                ArrayList<PingPoll> tmpList = new ArrayList<PingPoll>();
                for (String devIP : this.failedPollMap.keySet()) {
                    tmpList.add(this.getCorrectPingPoll(devIP));
                    ipList.add(devIP);
                }
                Boolean[] results = PollPlugin.getInstance().getPingService().batchPing(ipList, PollPlugin.getInstance().getRetries(), PollPlugin.getInstance().getTimeout());
                boolean needRetry = false;
                for (int i = 0; i < results.length; ++i) {
                    PingPoll pingPoll = (PingPoll)tmpList.get(i);
                    if (results[i].booleanValue()) {
                        this.failedPollMap.remove(pingPoll.getMoIP());
                        this.logger.debug((Object)("ping device ip removed:" + pingPoll.getMoIP()));
                        pingPoll.sendOnLineMsg();
                        continue;
                    }
                    Integer failedTime = this.failedPollMap.get(pingPoll.getMoIP());
                    this.logger.info((Object)("ping device failed, device ip:" + pingPoll.getMoIP() + ",failedTime in Map:" + failedTime));
                    if (failedTime < PollPlugin.getInstance().getFailedRetry()) {
                        failedTime = failedTime + 1;
                        this.failedPollMap.put(pingPoll.getMoIP(), failedTime);
                        needRetry = true;
                        continue;
                    }
                    Integer n = failedTime;
                    Integer n2 = failedTime = Integer.valueOf(failedTime + 1);
                    this.failedPollMap.remove(pingPoll.getMoIP());
                    this.logger.info((Object)("ping device failed, device ip:" + pingPoll.getMoIP() + ",failedTime in Map:" + failedTime + ", send offline alarm."));
                    pingPoll.sendOffLineMsg();
                }
                if (needRetry) {
                    this.doRetryPingTask();
                } else {
                    ThreadPoolManager.removeWorkTask(this.getTimeStamp(), this);
                }
            } else {
                ThreadPoolManager.removeWorkTask(this.getTimeStamp(), this);
            }
        }

        private String getIpList() {
            StringBuffer buf = new StringBuffer();
            for (PingPoll pingPoll : this.pingPollList) {
                buf.append(pingPoll.getMoIP());
                buf.append(',');
            }
            return buf.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            if (!(obj instanceof PollTask)) {
                return false;
            }
            PollTask other = (PollTask)obj;
            return other.getTimeStamp() == this.getTimeStamp();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(super.getTimeStamp() ^ super.getTimeStamp() >>> 32);
            return result;
        }
    }
}

