/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.action;

import com.hs.atic.bis.util.BisUtil;
import com.hs.atic.util.AticUtil;
import com.hs.atic.util.LocaleUtil;
import com.hs.lego.cbb.user.sdk.model.User;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.IPUtil;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.huawei.atic.collector.action.ElogBaseAction;
import com.huawei.atic.collector.entity.CollectorInfo;
import com.huawei.atic.collector.service.ICollectorService;
import com.huawei.atic.collector.util.BeanComparator;
import com.huawei.atic.collector.util.CollectorComparator4Ip;
import com.huawei.atic.collector.util.JsonUtils;
import com.huawei.atic.collector.util.Pair;
import com.huawei.atic.collector.util.SysLogCollectorUtil;
import com.huawei.atic.collector.util.UIDevice;
import com.huawei.atic.collector.vo.CollectorVo;
import com.huawei.atic.device.model.Collector;
import com.huawei.atic.secne.sdk.service.ICollectorCounterService;
import com.huawei.atic.util.CommonUtil;
import com.opensymphony.xwork2.ActionContext;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class SysLogCollectorAction
extends ElogBaseAction {
    public static final String DEVICE_COMMON_TYPEID_PROBE = "601";
    public static final String DEVICE_VERSION_PROBE = "60101";
    private static final long serialVersionUID = -6227652334830619730L;
    private static final String COLLECTOR_QUERY = "query";
    private static final String COLLECTOR_SET = "set";
    private static final String COLLECTOR_SHOW_COUNTER = "show";
    private static final String LOG_COLLECOTER_ADD = "common.collector.add";
    private static final String LOG_COLLECOTER_MRG = "lego.dic.module.collectorApp";
    private static final String LOG_COLLECOTER_MOD = "common.collector.mod";
    private static final String LOG_COLLECOTER_DEL = "common.collector.del";
    private static final String COLUMN_IP = "ipAddress";
    private static final String COLUMN_NAME = "name";
    private static final String ORDER_ASC = "asc";
    private static final int COLLECTOR_MAX_NUM = 100;
    private static final Log LOG4J = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private CollectorInfo collInfo = new CollectorInfo();
    private transient CollectorVo collectorVo;
    private String[] logServerIps;
    private String params = null;
    private String parameter;
    private List<CollectorInfo> pageList;
    private String sortField;
    private String sortType;
    private String probleParam;
    private transient List<UIDevice> probeList;
    private String isAdd;
    private String isQuickAdd;
    private String timeout;
    private String helpLanguage = "";
    private String collectorIp = null;
    private ICollectorService collectorService;
    private ICollectorCounterService collectorCounterService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addOrSetCollector() throws LegoCheckedException, NoSuchAlgorithmException, InvalidKeySpecException {
        this.collInfo.setType(3);
        this.getOperateResult().setSuccess(Boolean.TRUE);
        String resModuleKey = LOG_COLLECOTER_MRG;
        SysOptLog sysLog = new SysOptLog();
        try {
            if ("false".equals(this.isAdd)) {
                sysLog.setOperation(LOG_COLLECOTER_MOD);
                LOG4J.info((Object)"modify collector enter back service.");
                ArrayList<Long> moIDList = new ArrayList<Long>();
                moIDList.add(this.collInfo.getId());
                BisUtil.checkUserSecurity(moIDList);
                this.collectorService.modifyCollector(this.collInfo);
                sysLog.setDetail("common.collector.mod.success");
                String colName = "-";
                String colIpAddress = "-";
                if (this.collInfo.getName() != null && !"".equals(this.collInfo.getName())) {
                    colName = this.collInfo.getName();
                }
                if (this.collInfo.getIpAddress() != null && !"".equals(this.collInfo.getIpAddress())) {
                    colIpAddress = this.collInfo.getIpAddress();
                }
                sysLog.setDetailPara(new String[]{colName, colIpAddress});
                LOG4J.info((Object)"modify collector complate!");
            } else if ("true".equals(this.isAdd)) {
                LOG4J.info((Object)"add collector enter back service.");
                if (!this.isAddCollector()) {
                    this.buildErrorMsg((Exception)((Object)new LegoCheckedException(601003L)), new String[0], "collectorError");
                    String moIDList = "jsonResult";
                    return moIDList;
                }
                sysLog.setOperation(LOG_COLLECOTER_ADD);
                ActionContext ctx = ActionContext.getContext();
                HttpServletRequest request = (HttpServletRequest)ctx.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
                User currentUser = (User)request.getSession().getAttribute("currentUser");
                this.collectorService.addCollector(this.collInfo, currentUser.getUserID());
                sysLog.setDetail("common.collector.add.success");
                String colName = "-";
                String colIpAddress = "-";
                if (this.collInfo.getName() != null && !"".equals(this.collInfo.getName())) {
                    colName = this.collInfo.getName();
                }
                if (this.collInfo.getIpAddress() != null && !"".equals(this.collInfo.getIpAddress())) {
                    colIpAddress = this.collInfo.getIpAddress();
                }
                sysLog.setDetailPara(new String[]{colName, colIpAddress});
                this.getOperateResult().setReturnCode(1);
                LOG4J.info((Object)"add collector complate!");
            } else {
                this.getOperateLog().normal(LOG_COLLECOTER_ADD, null, null, false, "common.collector.add.fail", null);
                LOG4J.error((Object)"param:isAdd is error!");
                throw new LegoCheckedException(570505L);
            }
            sysLog.setResult(1);
        }
        catch (LegoCheckedException e) {
            boolean isCollectorError;
            LegoCheckedException legoExcp = e;
            long errCode = legoExcp.getErrorCode();
            sysLog.setDetail("lego.err." + errCode);
            boolean bl = isCollectorError = errCode == 570004L || errCode == 570003L || errCode == 570005L;
            if (isCollectorError) {
                this.collInfo.setTypeStr(SysLogCollectorUtil.getInstance().getPairValueByPairKey(String.valueOf(this.collInfo.getType()), this.getLocale()));
                this.buildErrorMsg((Exception)((Object)legoExcp), new String[]{this.collInfo.getTypeStr()}, "collectorError");
                String string = "jsonResult";
                return string;
            }
            this.buildErrorMsg((Exception)((Object)e), new String[]{this.collInfo.getName()}, "collectorError");
        }
        finally {
            sysLog.setModule(resModuleKey);
            sysLog.setTarget(this.collInfo.getName());
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            this.fillLegoSyslog(sysLog);
        }
        return "jsonResult";
    }

    public boolean processPara() {
        String name = this.collInfo.getName().trim();
        if (CommonUtil.isNull(name) || name.length() > 32) {
            return false;
        }
        String nameRegex = "^(?!(?i)null$)[a-zA-Z_\u4e00-\u9fa5]{1}[\\w\\-\u4e00-\u9fa5]*$";
        if (!name.matches(nameRegex)) {
            return false;
        }
        String ip = this.collInfo.getIpAddress();
        if (CommonUtil.isNull(ip)) {
            return false;
        }
        return IPUtil.isIpv4((String)ip);
    }

    public boolean checkIsAdd() {
        return null == this.isAdd || this.isAdd.equalsIgnoreCase("true") || this.isAdd.equalsIgnoreCase("false");
    }

    public String showAddLogCollector() {
        Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
        if ("zh".equalsIgnoreCase(locale.getLanguage())) {
            this.setHelpLanguage("zh_cn");
        } else {
            this.setHelpLanguage("en");
        }
        if (!"true".equals(this.isAdd)) {
            LOG4J.error((Object)"param:isAdd is error!");
            throw new LegoCheckedException(570505L);
        }
        this.setIsAdd(String.valueOf(Boolean.TRUE));
        this.getRequest().setAttribute("isQuickAdd", (Object)this.isQuickAdd);
        return COLLECTOR_SET;
    }

    public String showSetLogCollector() {
        Locale locale = LocaleUtil.INSTANCE.getCurrentUserLocale();
        if ("zh".equalsIgnoreCase(locale.getLanguage())) {
            this.setHelpLanguage("zh_cn");
        } else {
            this.setHelpLanguage("en");
        }
        if ("false".equals(this.isAdd)) {
            this.collInfo = this.collectorService.getCollectorInfo(this.collInfo.getId());
            if (this.collInfo == null) {
                throw new LegoCheckedException(570011L);
            }
        } else {
            LOG4J.error((Object)"param:isAdd is error!");
            throw new LegoCheckedException(570505L);
        }
        ArrayList<Long> moIDList = new ArrayList<Long>();
        moIDList.add(this.collInfo.getId());
        BisUtil.checkUserSecurity(moIDList);
        this.collectorVo = new CollectorVo();
        this.collectorVo.setCollectorId(this.collInfo.getId());
        this.collectorVo.setCollectorIp(this.collInfo.getIpAddress());
        this.collectorVo.setCollectorName(this.collInfo.getName());
        this.collectorVo.setCollectorType(this.collInfo.getType());
        this.collectorVo.setEncrypKey(this.collInfo.getEncrypKey());
        this.setIsAdd(String.valueOf(Boolean.FALSE));
        this.getRequest().setAttribute("isAdd", (Object)false);
        this.getRequest().setAttribute("isQuickAdd", (Object)this.isQuickAdd);
        return COLLECTOR_SET;
    }

    public String deleteLogCollector() {
        String resModuleKey = LOG_COLLECOTER_MRG;
        if (this.collInfo.getType() == 3) {
            resModuleKey = LOG_COLLECOTER_MRG;
        }
        SysOptLog sysLog = new SysOptLog();
        sysLog.setOperation(LOG_COLLECOTER_DEL);
        LOG4J.info((Object)("delete collector enter back service :" + this.collInfo));
        ArrayList<Long> moIDList = new ArrayList<Long>();
        moIDList.add(this.collInfo.getId());
        BisUtil.checkUserSecurity(moIDList);
        CollectorInfo collectorInfo = this.collectorService.deleteCollector(this.collInfo.getId());
        sysLog.setDetail("common.collector.delete.success");
        sysLog.setDetailPara(new String[]{collectorInfo.getName(), collectorInfo.getIpAddress()});
        LOG4J.info((Object)"delete collector complate!");
        sysLog.setResult(1);
        sysLog.setModule(resModuleKey);
        sysLog.setTarget(collectorInfo.getName());
        sysLog.setLevel(SysoplogLevel.normal.getValue());
        this.fillLegoSyslog(sysLog);
        return "jsonResult";
    }

    public boolean validateParams() {
        try {
            List list = JsonUtils.getInstance().jsonStringToObject(this.params, List.class);
            if (null == list) {
                return false;
            }
            for (LinkedHashMap map : list) {
                if (Long.parseLong((String)map.get("id")) < 0L) {
                    return false;
                }
                if (AticUtil.isNull((String)((String)map.get(COLUMN_NAME)))) {
                    return false;
                }
                if (((String)map.get(COLUMN_NAME)).trim().equalsIgnoreCase("null")) {
                    return false;
                }
                String nameRegex = "^(?!null$)[a-zA-Z_\u4e00-\u9fa5]{1}[\\w-\u4e00-\u9fa5]*$";
                if (!((String)map.get(COLUMN_NAME)).matches(nameRegex)) {
                    return false;
                }
                if (AticUtil.isNull((String)((String)map.get(COLUMN_IP)))) {
                    return false;
                }
                if (IPUtil.isIpv4((String)((String)map.get(COLUMN_IP))) || IPUtil.isIpv6((String)((String)map.get(COLUMN_IP)))) continue;
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public void batchDeleteCollector() {
        ArrayList<BatchOperation> batchOperationList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int recordCount = 0;
        if (null != this.params && !this.params.isEmpty()) {
            List list = JsonUtils.getInstance().jsonStringToObject(this.params, List.class);
            if (null == list) {
                LOG4J.error((Object)"list is null");
                return;
            }
            recordCount = list.size();
            String resModuleKey = LOG_COLLECOTER_MRG;
            for (LinkedHashMap map : list) {
                resModuleKey = LOG_COLLECOTER_MRG;
                ArrayList<BatchOperation> boList = new ArrayList<BatchOperation>();
                BatchOperation bo = new BatchOperation();
                bo.setTargetId(Long.parseLong((String)map.get("id")));
                ArrayList<Long> moIDList = new ArrayList<Long>();
                moIDList.add(bo.getTargetId());
                BisUtil.checkUserSecurity(moIDList);
                bo.setTargetName((String)map.get(COLUMN_NAME));
                bo.setDetailParam(new String[]{(String)map.get(COLUMN_NAME), (String)map.get(COLUMN_IP)});
                boList.add(bo);
                if (null != this.collectorService) {
                    BatchOperationResult boResult = this.collectorService.batchDeleteCollector(boList);
                    BatchOperation tempbo = (BatchOperation)boResult.getResult().get(0);
                    if (tempbo.getErrorCode() != 0L) {
                        ++failCount;
                    }
                    batchOperationList.add(tempbo);
                }
                this.getOperateLog().normal(LOG_COLLECOTER_DEL, resModuleKey, (String)map.get(COLUMN_NAME));
            }
        }
        this.batchOperationResult = new BatchOperationResult();
        this.batchOperationResult.setFailCount(failCount);
        this.batchOperationResult.setTotalCount(recordCount);
        this.batchOperationResult.setSucceedCount(recordCount - failCount);
        this.batchOperationResult.setResult(batchOperationList);
        this.bathResult(this.batchOperationResult);
    }

    public String queryLogCollector() {
        BeanComparator comparator;
        HashMap<String, String> queryMap = new HashMap<String, String>();
        User currentUser = (User)this.getSession().getAttribute("currentUser");
        if (null != currentUser) {
            queryMap.put("currentUserId", String.valueOf(currentUser.getUserID()));
            queryMap.put("currentUserIsAdmin", currentUser.getIsAdmin());
        }
        ArrayList<CollectorInfo> allCollList = new ArrayList<CollectorInfo>();
        List<CollectorInfo> aticList = null;
        LOG4J.info((Object)("queryLogCollector method ICollectorService : " + this.collectorService));
        if (null != this.collectorService) {
            aticList = this.collectorService.listCollector(queryMap);
        }
        if (null != aticList) {
            allCollList.addAll(aticList);
        }
        if (this.sortField != null && !this.sortField.isEmpty()) {
            if (this.sortField.equalsIgnoreCase(COLUMN_IP)) {
                Collections.sort(allCollList, new CollectorComparator4Ip(this.sortType));
            } else if (null != this.sortType) {
                comparator = new BeanComparator(BeanComparator.SortTypeEnum.valueOf(this.sortType.toUpperCase(Locale.getDefault())), this.sortField);
                Collections.sort(allCollList, comparator);
            }
        } else {
            comparator = new BeanComparator(BeanComparator.SortTypeEnum.valueOf(ORDER_ASC.toUpperCase(Locale.getDefault())), COLUMN_NAME);
            Collections.sort(allCollList, comparator);
        }
        List<CollectorInfo> list = this.page(allCollList);
        this.conv(list);
        this.setPageList(list);
        return COLLECTOR_QUERY;
    }

    public String showCollectorCounter() {
        HttpServletRequest request = this.getRequest();
        if (null == this.collectorCounterService) {
            this.collectorCounterService = (ICollectorCounterService)ServiceContext.getInstance().getService("collectorCounterService", ICollectorCounterService.class);
        }
        String packetReceviceRate = this.collectorCounterService.getPacketReceiveRate(this.collectorIp);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        long lastTime = this.collectorCounterService.getPacketReceviedLastTime(this.collectorIp);
        String packetReceviedLastTime = "";
        if (0L == lastTime) {
            packetReceviedLastTime = String.valueOf(lastTime);
            packetReceviedLastTime = "--";
        } else {
            packetReceviedLastTime = format.format(lastTime);
        }
        int unResoledFlowPacketCount = this.collectorCounterService.getUnresoledFlowPacketCount(this.collectorIp);
        int unResolvedCapturePacketCount = this.collectorCounterService.getUnresolvedCapturePacketCount(this.collectorIp);
        int allIpsNum = this.collectorCounterService.getAllIpsNum(this.collectorIp);
        String maxJVMMemory = this.collectorCounterService.getMaxJVMMemory(this.collectorIp);
        String usedJVMMemory = this.collectorCounterService.getUsedJVMMemory(this.collectorIp);
        String freeJVMMemory = this.collectorCounterService.getFreeJVMMemory(this.collectorIp);
        int receiveCount = this.collectorCounterService.getReceiveCount(this.collectorIp);
        long beginTime = this.collectorCounterService.getBeginCountTime(this.collectorIp);
        String beginCountTime = "";
        if (0L == beginTime) {
            beginCountTime = String.valueOf(beginTime);
            beginCountTime = "--";
        } else {
            beginCountTime = format.format(beginTime);
        }
        request.setAttribute("packetReceviceRate", (Object)packetReceviceRate);
        request.setAttribute("beginCountTime", (Object)beginCountTime);
        request.setAttribute("packetReceviedLastTime", (Object)packetReceviedLastTime);
        request.setAttribute("unResoledFlowPacketCount", (Object)unResoledFlowPacketCount);
        request.setAttribute("unResolvedCapturePacketCount", (Object)unResolvedCapturePacketCount);
        request.setAttribute("allIpsNum", (Object)allIpsNum);
        request.setAttribute("maxJVMMemory", (Object)maxJVMMemory);
        request.setAttribute("usedJVMMemory", (Object)usedJVMMemory);
        request.setAttribute("freeJVMMemory", (Object)freeJVMMemory);
        request.setAttribute("receiveCount", (Object)receiveCount);
        request.setAttribute("collectorIp", (Object)this.collectorIp);
        return COLLECTOR_SHOW_COUNTER;
    }

    private void conv(List<CollectorInfo> colls) {
        if (colls == null) {
            return;
        }
        Locale locale = this.getLocale();
        for (CollectorInfo coll : colls) {
            coll.setTypeStr(SysLogCollectorUtil.getInstance().getPairValueByPairKey(String.valueOf(coll.getType()), locale));
            LOG4J.info((Object)("call conv method,memoryUsed: " + coll.getMemoryUsed() + " ,cpuUsed: " + coll.getCpuUsed() + " ,diskInfo: " + coll.getDiskInfo()));
        }
    }

    private List<CollectorInfo> page(List<CollectorInfo> allCollList) {
        this.total = allCollList.size();
        int end = this.start + this.pageSize;
        if (end > this.total) {
            end = this.total;
        }
        return allCollList.subList(this.start, end);
    }

    public List<Pair<String, String>> getCollectorType() {
        LOG4J.info((Object)"getCollectorType method collectorTypeList enter");
        List<Pair<String, String>> collectorTypeList = SysLogCollectorUtil.getInstance().getCollectorType(this.getLocale());
        LOG4J.info((Object)("getCollectorType method collectorTypeList :" + collectorTypeList));
        return collectorTypeList;
    }

    public String checkLogin() {
        if (null != this.collectorService) {
            this.getOperateResult().setReturnCode(this.collectorService.validateLogin(this.collInfo));
            SysOptLog sysLog = new SysOptLog();
            sysLog.setLevel(SysoplogLevel.normal.getValue());
            sysLog.setOperation("vsm.secne.ddos.ip.address.test");
            sysLog.setModule("elog.menu.common.collector.manage");
            sysLog.setResult(this.collectorService.validateLogin(this.collInfo));
            sysLog.setTarget(this.collInfo.getIpAddress());
            this.fillLegoSyslog(sysLog);
        }
        return "jsonResult";
    }

    public boolean validateCollInfoIp() {
        String ip = this.collInfo.getIpAddress();
        if (CommonUtil.isNull(ip)) {
            return false;
        }
        return IPUtil.isIpv4((String)ip);
    }

    public boolean validateCollectorIp() {
        if (CommonUtil.isNull(this.collectorIp)) {
            return false;
        }
        return IPUtil.isIpv4((String)this.collectorIp);
    }

    public CollectorInfo getCollInfo() {
        return this.collInfo;
    }

    public void setCollInfo(CollectorInfo collInfo) {
        this.collInfo = collInfo;
    }

    public String getParams() {
        return this.params;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public List<CollectorInfo> getPageList() {
        return this.pageList;
    }

    public void setPageList(List<CollectorInfo> pageList) {
        this.pageList = pageList;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = sortType;
    }

    public String getProbleParam() {
        return this.probleParam;
    }

    public void setProbleParam(String probleParam) {
        this.probleParam = probleParam;
    }

    public List<UIDevice> getProbeList() {
        return this.probeList;
    }

    public void setProbeList(List<UIDevice> probeList) {
        this.probeList = probeList;
    }

    public String getIsAdd() {
        return this.isAdd;
    }

    public void setIsAdd(String isAdd) {
        this.isAdd = isAdd;
    }

    public String getParameter() {
        return this.parameter;
    }

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public String getIsQuickAdd() {
        return this.isQuickAdd;
    }

    public void setIsQuickAdd(String isQuickAdd) {
        this.isQuickAdd = isQuickAdd;
    }

    public CollectorVo getCollectorVo() {
        return this.collectorVo;
    }

    public void setCollectorVo(CollectorVo collectorVo) {
        this.collectorVo = collectorVo;
    }

    public String[] getLogServerIps() {
        if (null != this.logServerIps) {
            return (String[])this.logServerIps.clone();
        }
        return new String[0];
    }

    public void setLogServerIps(String[] logServerIps) {
        this.logServerIps = null != logServerIps ? (String[])logServerIps.clone() : null;
    }

    private boolean isAddCollector() {
        List<Collector> listCollectot = this.collectorService.getAllCollector();
        if (!listCollectot.isEmpty() && listCollectot.size() >= 100) {
            LOG4J.warn((Object)"Collector has hit the maximum total 100, cannot be created.");
            return false;
        }
        return true;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getHelpLanguage() {
        return this.helpLanguage;
    }

    public void setHelpLanguage(String helpLanguage) {
        this.helpLanguage = helpLanguage;
    }

    public String getCollectorIp() {
        return this.collectorIp;
    }

    public void setCollectorIp(String collectorIp) {
        this.collectorIp = collectorIp;
    }

    public ICollectorService getCollectorService() {
        return this.collectorService;
    }

    public void setCollectorService(ICollectorService collectorService) {
        this.collectorService = collectorService;
    }

    public ICollectorCounterService getCollectorCounterService() {
        return this.collectorCounterService;
    }

    public void setCollectorCounterService(ICollectorCounterService collectorCounterService) {
        this.collectorCounterService = collectorCounterService;
    }
}

