/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.collector.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 7361809615594405086L;
    private SortTypeEnum sortType;
    private String fieldName;

    public BeanComparator() {
        this.setSortType(SortTypeEnum.ASC);
    }

    public BeanComparator(String field) {
        this.fieldName = field;
        this.setSortType(SortTypeEnum.ASC);
    }

    public BeanComparator(SortTypeEnum sortType, String field) {
        this.fieldName = field;
        this.setSortType(sortType);
    }

    @Override
    public int compare(Object o1, Object o2) {
        try {
            Object v1 = PropertyUtils.getProperty((Object)o1, (String)this.fieldName);
            Object v2 = PropertyUtils.getProperty((Object)o2, (String)this.fieldName);
            int rs = 0;
            rs = v1 instanceof Integer && v2 instanceof Integer ? (Integer)v1 - (Integer)v2 : Collator.getInstance(Locale.CHINESE).compare(v1.toString(), v2.toString());
            if (this.sortType == SortTypeEnum.DESC) {
                return -rs;
            }
            return rs;
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public SortTypeEnum getSortType() {
        return this.sortType;
    }

    public void setSortType(SortTypeEnum sortType) {
        this.sortType = sortType;
    }

    public static enum SortTypeEnum {
        DESC,
        ASC;

    }
}

