/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.comm.south.telnet;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoCheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.comm.south.util.SouthUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.net.telnet.TelnetClient;

public class TelnetConnector {
    public static final String CHARSET_NAME_GB2312 = "GB2312";
    public static final int PARAM_ERROR = 570505;
    private static final int MILLISSECOND2SECOND = 1000;
    private static final int SLEEPTIME = 500;
    private static final String SUCCESS = "success";
    private static final String LOGIN_FAIL = "Login failed";
    private static final String LOGIN_FAIL_EXT = "Failed to authenticate";
    private static final String LOGIN_FAIL_PASSWD_ERROR = "Authentication fail";
    private static final String LOGIN_VTY_MAX = "All user interfaces are used, please try later!";
    private static final String LOGIN_MODE_ERROR = "No supported authentication methods available";
    private static final String LOGIN_PASSKEY_NOT_SET = "Login password has not been set";
    private static final String MORE = "---- More ----";
    private static final String MORE_FLAG = "[42D";
    private static final String DEVICE_WRAP_FLAG = "\u001b[1D";
    private static final String MORE_BLANK_WRAP_FLAG = " \u001b[1D";
    private static final Log LOG = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private String userViewEndPrompt = ">";
    private String systemViewEndPrompt = "]";
    private List<String> cliPromptRegexs = null;
    private InetAddress hostAddress = null;
    private int port = 23;
    private String username = "";
    private StringBuffer passkey = new StringBuffer();
    private boolean connected = false;
    private TelnetClient tc = new TelnetClient();
    private OutputStream out = null;
    private InputStream in = null;
    private BufferedReader reader = null;
    private PrintWriter writer = null;
    private int connectTimeout = 4000;
    private int soTimeout = 5000;
    private int loginMode = 1;
    private String currentCharsetName = null;

    public void connect(String hostIp, String userAccount, StringBuffer userPassword) throws LegoCheckedException, Exception {
        try {
            this.connect(hostIp, this.port, userAccount, userPassword);
        }
        catch (SocketTimeoutException e) {
            LOG.error((Object)"SocketTimeoutException", (Throwable)e);
            throw new LegoCheckedException(517L);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception", (Throwable)e);
            throw e;
        }
    }

    public void connect(String hostIp, int hostPort, String userAccount, StringBuffer userPassword, long loginTimeOut, long respTimeout) throws LegoCheckedException, Exception {
        this.connectTimeout = (int)loginTimeOut * 1000;
        this.soTimeout = (int)respTimeout * 1000;
        this.connect(hostIp, hostPort, userAccount, userPassword);
    }

    public void connect(String hostIp, int hostPort, int loginModes, String userAccount, StringBuffer userPassword, long loginTimeOut, long respTimeout) throws LegoCheckedException, Exception {
        this.loginMode = loginModes;
        this.connectTimeout = (int)loginTimeOut * 1000;
        this.soTimeout = (int)respTimeout * 1000;
        this.connect(hostIp, hostPort, userAccount, userPassword);
    }

    public void connect(String hostIp, int hostPort, String userAccount, StringBuffer userPassword) throws LegoCheckedException, Exception {
        this.connected = false;
        String[] ips = hostIp.split("\\.");
        if (ips.length != 4) {
            throw new LegoCheckedException(570505L);
        }
        byte[] ipb = new byte[4];
        for (int i = 0; i < ips.length; ++i) {
            try {
                ipb[i] = Integer.valueOf(ips[i]).byteValue();
                continue;
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("parameter host is invalid");
            }
        }
        this.hostAddress = InetAddress.getByAddress(hostIp, ipb);
        this.port = hostPort;
        this.username = userAccount;
        this.passkey = userPassword;
        String result = this.connect();
        if (!result.equals(SUCCESS)) {
            this.connected = false;
            if (result.contains(LOGIN_FAIL)) {
                throw new LegoCheckedException(514L);
            }
            if (result.contains(LOGIN_VTY_MAX)) {
                throw new LegoCheckedException(518L);
            }
            if (result.contains(LOGIN_MODE_ERROR)) {
                throw new LegoCheckedException(526L);
            }
            if (result.contains(LOGIN_PASSKEY_NOT_SET)) {
                throw new LegoCheckedException(528L);
            }
            if (result.contains("The password needs to be changed")) {
                throw new LegoCheckedException(529L);
            }
            throw new LegoCheckedException(517L);
        }
        this.connected = true;
    }

    public void reConnect() throws LegoCheckedException {
        String result;
        if (this.connected) {
            this.close();
            this.connected = false;
        }
        if (!(result = this.connect()).equals(SUCCESS)) {
            throw new LegoCheckedException(517L);
        }
    }

    public void reConnectOneKeyCollect() throws LegoCheckedException {
        LOG.info((Object)"step in reConnectOneKeyCollect.");
        this.close();
        this.connected = false;
        String result = this.connect();
        if (!result.equals(SUCCESS)) {
            throw new LegoCheckedException(517L);
        }
    }

    private String connect() {
        String result = "";
        for (int i = 0; !(i >= 2 || (result = this.connectOneTime()).equals(SUCCESS) || result.equals(LOGIN_FAIL) || result.equals(LOGIN_MODE_ERROR) || result.equals(LOGIN_VTY_MAX) || result.equals("The password needs to be changed")); ++i) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                LOG.error((Object)"InterruptedException", (Throwable)e);
            }
        }
        return result;
    }

    private String connectOneTime() {
        try {
            this.tc.setConnectTimeout(this.connectTimeout);
            this.tc.connect(this.hostAddress, this.port);
            this.tc.setTcpNoDelay(true);
            this.tc.setSoTimeout(this.soTimeout);
            this.in = this.tc.getInputStream();
            this.out = new PrintStream(this.tc.getOutputStream(), false, System.getProperty("file.encoding"));
            this.reader = null != this.currentCharsetName ? new BufferedReader(new InputStreamReader(this.in, this.currentCharsetName)) : new BufferedReader(new InputStreamReader(this.in, System.getProperty("file.encoding")));
            this.writer = new PrintWriter(new OutputStreamWriter(this.out, System.getProperty("file.encoding")));
            String result = this.getResult(false);
            if ("".equals(result)) {
                return LOGIN_FAIL;
            }
            if (result.endsWith(this.userViewEndPrompt) ? this.loginMode != 0 : (result.toLowerCase(Locale.getDefault()).endsWith("username:") ? this.loginMode != 1 : result.toLowerCase(Locale.getDefault()).endsWith("password:") && this.loginMode != 2)) {
                return LOGIN_MODE_ERROR;
            }
            if (result.toLowerCase(Locale.getDefault()).endsWith("username:")) {
                this.executeCommand(this.username);
                result = this.executeConnectCommandExt(this.passkey.toString());
                if (result.indexOf(LOGIN_FAIL) > -1 || result.indexOf(LOGIN_FAIL_EXT) > -1 || result.indexOf(LOGIN_FAIL_PASSWD_ERROR) > -1) {
                    this.close();
                    return LOGIN_FAIL;
                }
            } else if (result.toLowerCase(Locale.getDefault()).endsWith("password:") && ((result = this.executeConnectCommandExt(this.passkey.toString())).indexOf(LOGIN_FAIL) > -1 || result.indexOf(LOGIN_FAIL_EXT) > -1 || result.indexOf(LOGIN_FAIL_PASSWD_ERROR) > -1)) {
                this.close();
                return LOGIN_FAIL;
            }
            if (result.equals("The password needs to be changed")) {
                return "The password needs to be changed";
            }
            return SUCCESS;
        }
        catch (SocketTimeoutException e) {
            LOG.error((Object)"Exception", (Throwable)e);
            this.close();
            return e.getMessage();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
            this.close();
            return e.getMessage();
        }
    }

    public void executeNoResultCommand(String command) {
        this.writer.print(command + "\n");
        this.writer.flush();
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException e) {
            LOG.error((Object)"InterruptedException", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
    }

    public String executeCommand(String command) throws IOException {
        return this.executeCommand(command, null);
    }

    public String executeCommand(String command, List<String> cliPromptRegexss) throws IOException {
        this.setCliPromptRegexs(cliPromptRegexss);
        String[] commands = command.split("\r\n");
        return this.executeCommand(commands);
    }

    public String executeCommand4OneKeyCollect(String command, List<String> cliPromptRegexss) throws IOException {
        this.setCliPromptRegexs(cliPromptRegexss);
        String[] commands = command.split("\r\n");
        return this.executeCommand4OneKeyCollect(commands);
    }

    public String executeConnectCommand(String command, List<String> cliPromptRegexss) throws IOException {
        this.setCliPromptRegexs(cliPromptRegexss);
        String[] commands = command.split("\r\n");
        return this.executeConnectCommand(commands);
    }

    private String executeCommand(String[] commands) throws IOException {
        StringBuilder result = new StringBuilder();
        String[] stringArray = commands;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String commandTemp;
            String command = commandTemp = stringArray[i];
            command = command.trim();
            String resp = "";
            resp = this.executeOneCommand(command);
            result.append(resp);
        }
        return result.toString();
    }

    private String executeCommand4OneKeyCollect(String[] commands) throws IOException {
        StringBuilder result = new StringBuilder();
        String[] stringArray = commands;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String commandTemp;
            String command = commandTemp = stringArray[i];
            command = command.trim();
            String resp = "";
            resp = this.executeOneCommand4OneKeyCollect(command);
            result.append(resp);
        }
        return result.toString();
    }

    private String executeConnectCommand(String[] commands) throws IOException {
        StringBuilder result = new StringBuilder();
        String[] stringArray = commands;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String commandTemp;
            String command = commandTemp = stringArray[i];
            command = command.trim();
            String resp = "";
            resp = this.executeOneConnect(command);
            result.append(resp);
        }
        return result.toString();
    }

    public String executeCommandExt(String command) throws IOException {
        return this.executeCommand(command, null);
    }

    public String executeConnectCommandExt(String command) throws IOException {
        return this.executeConnectCommand(command, null);
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    private String executeOneCommand(String command) throws IOException {
        String result = "";
        String reComd = "";
        try {
            command = command.trim();
            reComd = command.contains("anti-ddos packet-capture key") ? this.getcleanedMessage(command.substring(0, command.indexOf("anti-ddos packet-capture key"))) + "anti-ddos packet-capture key ***" : this.getcleanedMessage(command);
            LOG.debug((Object)("hostAddress=" + this.hostAddress + "; command=" + reComd));
            this.writer.print(command + "\n");
            this.writer.flush();
            boolean isUpdateLoc = false;
            if (command.contains("update local")) {
                isUpdateLoc = true;
            }
            result = this.getResult(isUpdateLoc);
        }
        catch (IOException e) {
            LOG.error((Object)("hostAddress=" + this.hostAddress + "; port=" + this.port + "; username=" + this.username + "; command=" + reComd), (Throwable)e);
            this.close();
            throw e;
        }
        return result.trim();
    }

    private String executeOneCommand4OneKeyCollect(String command) throws IOException {
        String result = "";
        String reComd = "";
        try {
            command = command.trim();
            reComd = command.contains("anti-ddos packet-capture key") ? this.getcleanedMessage(command.substring(0, command.indexOf("anti-ddos packet-capture key"))) + "anti-ddos packet-capture key ***" : this.getcleanedMessage(command);
            long start = System.currentTimeMillis();
            LOG.debug((Object)("hostAddress=" + this.hostAddress + "; command=" + reComd));
            this.writer.print(command + "\n");
            this.writer.flush();
            boolean isUpdateLoc = false;
            if (command.contains("update local")) {
                isUpdateLoc = true;
            }
            result = this.getResult4Onekey(isUpdateLoc);
            LOG.info((Object)("====exec command : [" + command + "] use" + (System.currentTimeMillis() - start)));
            LOG.info((Object)("====exec command sotimeout : " + this.soTimeout + " , result length : " + result.length()));
        }
        catch (IOException e) {
            LOG.error((Object)("hostAddress=" + this.hostAddress + "; port=" + this.port + "; username=" + this.username + "; command=" + reComd), (Throwable)e);
            this.close();
            throw e;
        }
        return result.trim();
    }

    private String executeOneConnect(String command) throws IOException {
        String result = "";
        try {
            command = command.trim();
            LOG.debug((Object)("hostAddress=" + this.hostAddress + "; command= ******"));
            this.writer.print(command + "\n");
            this.writer.flush();
            boolean isUpdateLoc = false;
            if (command.contains("update local")) {
                isUpdateLoc = true;
            }
            result = this.getResult(isUpdateLoc);
        }
        catch (IOException e) {
            LOG.error((Object)("hostAddress=" + this.hostAddress + "; port=" + this.port + "; username=" + this.getcleanedMessage(this.username) + "; command=******"), (Throwable)e);
            this.close();
            throw e;
        }
        return result.trim();
    }

    public String executeCommand(String command, long timeout) throws IOException {
        this.setSoTimeout((int)timeout * 1000);
        this.tc.setSoTimeout(this.soTimeout);
        return this.executeCommand(command);
    }

    public String executeCommand(String command, List<String> cliPromptRegexss, long timeout) throws IOException {
        this.setSoTimeout((int)timeout * 1000);
        this.tc.setSoTimeout(this.soTimeout);
        String resp = this.executeCommand(command, cliPromptRegexss);
        return resp;
    }

    public void setConnectTimeout(int timeout) {
        if (timeout >= 0) {
            this.connectTimeout = timeout;
        }
    }

    public void setSoTimeout(int timeout) {
        if (timeout >= 0) {
            this.soTimeout = timeout;
        }
    }

    private String getResult4Onekey(boolean isUpdateLoc) throws IOException {
        String result = "";
        StringBuffer buffer = new StringBuffer();
        char[] buf = new char[1024];
        String tmp = "";
        boolean isMore = false;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.reader.ready()) {
                startTime = System.currentTimeMillis();
                int read = this.reader.read(buf);
                if (read == -1) {
                    throw new IOException(result);
                }
                tmp = new String(buf).substring(0, read);
                buffer.append(tmp);
                if (buffer.length() >= 1000000) {
                    try {
                        result = result.replace(MORE_FLAG, "");
                        result = result.replace(MORE, "");
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception error", (Throwable)e);
                    }
                    LOG.info((Object)("collect command output length too long : " + buffer.length()));
                    break;
                }
                result = buffer.toString();
                String lastLine = SouthUtil.getLastNotEmptyLine(result);
                if (null == lastLine) continue;
                if (isUpdateLoc) {
                    boolean failMark;
                    LOG.info((Object)("isUpdateLoc result : " + result));
                    String lastTwoLines = SouthUtil.getLastTwoLine(result);
                    if (lastTwoLines.toLowerCase(Locale.getDefault()).contains("the target version is in use")) {
                        result = result.replace("Error", "Info");
                    }
                    boolean sucMark = lastTwoLines.toLowerCase(Locale.getDefault()).contains("update succeeded") || result.contains("Update location identification signature database success");
                    boolean bl = failMark = lastTwoLines.toLowerCase(Locale.getDefault()).startsWith("error") || result.contains("no need update") || result.contains("the same as current database") || result.contains("remain space of CF card is less than") || result.contains("the target version is in use");
                    if (sucMark || failMark) {
                        LOG.info((Object)("update finished : " + result));
                        break;
                    }
                    LOG.info((Object)("waiting for update finished : " + result));
                    continue;
                }
                if (0 == SouthUtil.getEndTag(lastLine) && this.isEndSpec(lastLine)) {
                    LOG.info((Object)("getOnekeyResult  lastLine : " + lastLine));
                    break;
                }
                if (2 == SouthUtil.getEndTag(lastLine)) {
                    result = "The password needs to be changed";
                    LOG.info((Object)"getOnekeyResult  PASSWORD_IS_EXPIRE : 2");
                    break;
                }
                if (!this.isConnected() && (result.contains(LOGIN_FAIL) || result.contains(LOGIN_FAIL_EXT))) {
                    LOG.info((Object)"getOnekeyResult  LOGIN_FAIL : Login failed");
                    break;
                }
                if (result.trim().endsWith(MORE)) {
                    isMore = true;
                    result = this.cutLastLine(result);
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)"Exception error", (Throwable)e);
                    }
                    this.writer.print(" ");
                    this.writer.flush();
                    LOG.info((Object)"getOnekeyResult  flush : ");
                    continue;
                }
                if (!SouthUtil.isRegexMatched(lastLine, this.cliPromptRegexs) || !this.isEndSpec(lastLine)) continue;
                LOG.info((Object)("getOnekeyResult  cliPromptRegexs end : " + this.cliPromptRegexs));
                break;
            }
            if (System.currentTimeMillis() - startTime > (long)this.soTimeout) {
                if (!result.trim().equals("")) {
                    LOG.info((Object)("collect command output timeout, the result length :" + result.length() + "soTimeout is :" + this.soTimeout));
                    break;
                }
                throw new SocketTimeoutException("Connect timed out");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Exception error", (Throwable)e);
            }
        }
        if (isMore) {
            int index1 = result.indexOf(MORE_FLAG);
            try {
                while (index1 > 0) {
                    tmp = result.substring(0, index1 - 1);
                    int index2 = result.indexOf(MORE_FLAG, index1 + MORE_FLAG.length());
                    if (index2 > index1) {
                        result = tmp + result.substring(index2 + MORE_FLAG.length());
                    }
                    index1 = result.indexOf(MORE_FLAG);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception error", (Throwable)e);
            }
        }
        try {
            result = result.replace(MORE_FLAG, "");
            result = result.replace(MORE, "");
            result = result.replace(MORE_BLANK_WRAP_FLAG, "");
            result = result.replace(DEVICE_WRAP_FLAG, "");
        }
        catch (Exception e) {
            LOG.error((Object)"Exception error", (Throwable)e);
        }
        LOG.info((Object)"getOnekeyResult end!");
        return result;
    }

    private boolean isEndSpec(String lastLine) {
        return !lastLine.contains("-->") && !lastLine.contains("<--") && !lastLine.contains("->") && !lastLine.contains("<-");
    }

    private String getResult(boolean isUpdateLoc) throws IOException {
        String result = "";
        StringBuffer buffer = new StringBuffer();
        char[] buf = new char[1024];
        String tmp = "";
        boolean isMore = false;
        long startTime = System.currentTimeMillis();
        while (true) {
            if (this.reader.ready()) {
                startTime = System.currentTimeMillis();
                int read = this.reader.read(buf);
                if (read == -1) {
                    throw new IOException(result);
                }
                tmp = new String(buf).substring(0, read);
                buffer.append(tmp);
                if (buffer.length() >= 1000000) {
                    try {
                        result = result.replace(MORE_FLAG, "");
                        result = result.replace(MORE, "");
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception error", (Throwable)e);
                    }
                    LOG.info((Object)("getResult : collect command output length too long : " + buffer.length()));
                    break;
                }
                result = buffer.toString();
                String lastLine = SouthUtil.getLastNotEmptyLine(result);
                if (null == lastLine) continue;
                if (isUpdateLoc) {
                    boolean failMark;
                    LOG.info((Object)("isUpdateLoc result : " + result));
                    String lastTwoLines = SouthUtil.getLastTwoLine(result);
                    if (lastTwoLines.toLowerCase(Locale.getDefault()).contains("the target version is in use")) {
                        result = result.replace("Error", "Info");
                    }
                    boolean sucMark = lastTwoLines.toLowerCase(Locale.getDefault()).contains("update succeeded") || result.contains("Update location identification signature database success");
                    boolean bl = failMark = lastTwoLines.toLowerCase(Locale.getDefault()).startsWith("error") || result.contains("no need update") || result.contains("the same as current database") || result.contains("remain space of CF card is less than") || result.contains("the target version is in use");
                    if (sucMark || failMark) {
                        LOG.info((Object)("update finished : " + result));
                        break;
                    }
                    LOG.info((Object)("waiting for update finished : " + result));
                    continue;
                }
                if (0 == SouthUtil.getEndTag(lastLine) && this.isEndSpec(lastLine)) {
                    LOG.info((Object)("getResult  lastLine : " + lastLine));
                    break;
                }
                if (2 == SouthUtil.getEndTag(lastLine)) {
                    result = "The password needs to be changed";
                    break;
                }
                if (!this.isConnected() && (result.contains(LOGIN_FAIL) || result.contains(LOGIN_FAIL_EXT))) break;
                if (result.trim().endsWith(MORE)) {
                    isMore = true;
                    result = this.cutLastLine(result);
                    try {
                        TimeUnit.MILLISECONDS.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Object)"Exception error", (Throwable)e);
                    }
                    this.writer.print(" ");
                    this.writer.flush();
                    continue;
                }
                if (!SouthUtil.isRegexMatched(lastLine, this.cliPromptRegexs) || !this.isEndSpec(lastLine)) continue;
                break;
            }
            if (System.currentTimeMillis() - startTime > (long)this.soTimeout) {
                if (!result.trim().equals("")) {
                    LOG.info((Object)("getResult : collect command output soTimeout : " + buffer.length() + " length :" + this.soTimeout));
                }
                throw new SocketTimeoutException("Connect timed out");
            }
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Exception error", (Throwable)e);
            }
        }
        if (isMore) {
            int index1 = result.indexOf(MORE_FLAG);
            while (index1 > 0) {
                tmp = result.substring(0, index1 - 1);
                int index2 = result.indexOf(MORE_FLAG, index1 + MORE_FLAG.length());
                if (index2 > index1) {
                    result = tmp + result.substring(index2 + MORE_FLAG.length());
                }
                index1 = result.indexOf(MORE_FLAG);
            }
            try {
                result = result.replace("---- More ----  ", "");
                result = result.replace(MORE, "");
            }
            catch (Exception e) {
                LOG.error((Object)"Exception error", (Throwable)e);
            }
        }
        return result;
    }

    private String cutLastLine(String input) {
        int index = input.lastIndexOf("\n");
        if (index != -1) {
            input = input.substring(0, index + 1);
        }
        return input;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getPrompt() {
        int read;
        char[] buf = new char[1024];
        this.writer.print("\n");
        this.writer.flush();
        String result = "";
        do {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.error((Object)"InterruptedException", (Throwable)e);
            }
            read = 0;
            try {
                read = this.reader.read(buf);
            }
            catch (IOException e) {
                LOG.error((Object)"IOException error");
            }
        } while ((result = read > 0 ? result + new String(buf).substring(0, read).trim() : null) != null && result.indexOf(this.userViewEndPrompt) == -1 && result.indexOf(this.systemViewEndPrompt) == -1);
        return result;
    }

    private void setCliPromptRegexs(List<String> cliPromptRegexs) {
        this.cliPromptRegexs = cliPromptRegexs;
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException error");
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException e) {
            LOG.error((Object)"IOException error");
        }
        try {
            if (this.connected) {
                this.tc.disconnect();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        this.connected = false;
    }

    public void setCurrentCharsetName(String charsetName) {
        this.currentCharsetName = charsetName;
    }

    public String getCurrentCharsetName() {
        return this.currentCharsetName;
    }

    public String getUsername() {
        return this.username;
    }

    public StringBuffer getPasskey() {
        return this.passkey;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(InetAddress hostAddress) {
        this.hostAddress = hostAddress;
    }
}

