/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.common.snmp;

import com.huawei.atic.common.snmp.SnmpParameter;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.smi.OctetString;
import org.snmp4j.util.DefaultPDUFactory;

public class SnmpV3TablePDUFactory
extends DefaultPDUFactory {
    private OctetString contextEngineId = null;
    private OctetString contextName = null;

    public SnmpV3TablePDUFactory(int pduType, SnmpParameter snmpPara) {
        super(pduType);
        if (snmpPara.getContextName() != null) {
            this.contextName = SnmpV3TablePDUFactory.getOctString(snmpPara.getContextName());
        }
        if (snmpPara.getContextEngineId() != null) {
            this.contextEngineId = SnmpV3TablePDUFactory.getOctString(snmpPara.getContextEngineId());
        }
    }

    private static OctetString getOctString(String value) {
        if (value != null) {
            return new OctetString(value);
        }
        return null;
    }

    public PDU createPDU(Target target) {
        PDU pdu = super.createPDU(target);
        if (target.getVersion() == 3) {
            if (null != this.contextEngineId) {
                ((ScopedPDU)pdu).setContextEngineID(this.contextEngineId);
            }
            if (null != this.contextName) {
                ((ScopedPDU)pdu).setContextName(this.contextName);
            }
        }
        return pdu;
    }
}

