/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.init.thread.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.device.model.AticDeviceRouter;
import com.huawei.atic.sdk.perfmonitor.model.CpuMemUsage;
import com.huawei.atic.sdk.perfmonitor.service.ICpuMemUsageService;
import com.huawei.atic.secne.sdk.service.IAticDeviceRouterService;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import com.huawei.atic.util.DevCpuDescrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TableEvent;

public class MonitorCpuMemUsage {
    private static final int MAX_ERROR_TIMES = 3;
    private static Map<Long, Map<Integer, Integer>> deviceIdCpuIndex2ErrorTimes = new HashMap<Long, Map<Integer, Integer>>();
    private static Map<Long, List<Integer>> deviceId2CpuIndex = new HashMap<Long, List<Integer>>();
    private static Map<Long, Boolean> syncDevice = new HashMap<Long, Boolean>();
    private static Map<Long, String> deviceSlot = new HashMap<Long, String>();
    private Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private ICpuMemUsageService iCpuMemUsageService;

    public void monitor() {
        List<AticDevice> deviceList = this.getAticDeviceList();
        if (null != deviceList) {
            for (AticDevice aticDevice : deviceList) {
                String slot = deviceSlot.get(aticDevice.getMoId());
                if (null == slot || !aticDevice.getSpuSlot().equals(slot)) {
                    this.logger.info((Object)"~~~~~~~~~~~~~~~~~~~init params.");
                    syncDevice.put(aticDevice.getMoId(), true);
                    deviceSlot.put(aticDevice.getMoId(), aticDevice.getSpuSlot());
                    deviceIdCpuIndex2ErrorTimes.put(aticDevice.getMoId(), new HashMap());
                    deviceId2CpuIndex.put(aticDevice.getMoId(), new ArrayList());
                    continue;
                }
                syncDevice.put(aticDevice.getMoId(), false);
            }
            for (AticDevice aticDevice : deviceList) {
                try {
                    Integer errorTimes;
                    List<CpuMemUsage> cpuMemList = this.getDevCpuMemUsage(aticDevice);
                    List<Integer> list = deviceId2CpuIndex.get(aticDevice.getMoId());
                    for (CpuMemUsage cpuMemUsage : cpuMemList) {
                        if (list.contains(cpuMemUsage.getCpuIndex())) continue;
                        this.logger.info((Object)"~~~~~~~list don't contains this cpu.");
                        list.add(cpuMemUsage.getCpuIndex());
                    }
                    boolean existsZero = false;
                    boolean existsAllCpu = true;
                    for (Integer cpuIndex : list) {
                        Object map;
                        boolean existsThisCpu = false;
                        for (CpuMemUsage cpuMemUsage : cpuMemList) {
                            if (cpuMemUsage.getCpuUsage() == 0 && cpuIndex.equals(cpuMemUsage.getCpuIndex())) {
                                existsZero = true;
                                map = deviceIdCpuIndex2ErrorTimes.get(cpuMemUsage.getDeviceId());
                                this.logger.info((Object)("~~~~~~~~~existsZero deviceIdCpuIndex2ErrorTimes : " + map));
                                errorTimes = (Integer)map.get(cpuMemUsage.getCpuIndex());
                                if (null == errorTimes) {
                                    errorTimes = 0;
                                }
                                Integer n = errorTimes;
                                Integer n2 = errorTimes = Integer.valueOf(errorTimes + 1);
                                this.logger.warn((Object)("device id : " + aticDevice.getMoId() + " ,error Msg : " + cpuMemList));
                                map.put(cpuMemUsage.getCpuIndex(), errorTimes);
                            }
                            if (!syncDevice.get(aticDevice.getMoId()).booleanValue()) {
                                if (cpuMemUsage.getCpuIndex() != cpuIndex.intValue()) continue;
                                existsThisCpu = true;
                                break;
                            }
                            existsThisCpu = true;
                            break;
                        }
                        if (existsThisCpu) continue;
                        existsAllCpu = false;
                        Map<Integer, Integer> map2 = deviceIdCpuIndex2ErrorTimes.get(aticDevice.getMoId());
                        Integer errorTimes2 = map2.get(cpuIndex);
                        if (null == errorTimes2) {
                            errorTimes2 = 0;
                        }
                        map = errorTimes2;
                        errorTimes = errorTimes2 = Integer.valueOf(errorTimes2 + 1);
                        this.logger.warn((Object)("device id : " + aticDevice.getMoId() + " ,error Msg : " + cpuMemList));
                        map2.put(cpuIndex, errorTimes2);
                        deviceIdCpuIndex2ErrorTimes.put(aticDevice.getMoId(), map2);
                    }
                    if (existsZero || !existsAllCpu) {
                        boolean overTimes = false;
                        block7: for (Map.Entry<Long, Map<Integer, Integer>> entry : deviceIdCpuIndex2ErrorTimes.entrySet()) {
                            Map<Integer, Integer> value = entry.getValue();
                            for (Map.Entry<Integer, Integer> cpuIndex2ErrorTimes : value.entrySet()) {
                                errorTimes = cpuIndex2ErrorTimes.getValue();
                                this.logger.info((Object)("~~~~~~~~~~~errorTimes : " + errorTimes));
                                if (null == errorTimes) {
                                    errorTimes = 0;
                                }
                                if (errorTimes < 3) {
                                    this.logger.warn((Object)("some cpu usage is 0. deviceId : " + entry.getKey() + "cpu index is " + cpuIndex2ErrorTimes.getKey() + " error time is " + errorTimes));
                                    continue;
                                }
                                errorTimes = 0;
                                value.put(cpuIndex2ErrorTimes.getKey(), errorTimes);
                                deviceIdCpuIndex2ErrorTimes.put(entry.getKey(), value);
                                overTimes = true;
                                break block7;
                            }
                        }
                        if (!overTimes) continue;
                    }
                    Map<Integer, Integer> map = deviceIdCpuIndex2ErrorTimes.get(aticDevice.getMoId());
                    map.clear();
                    deviceIdCpuIndex2ErrorTimes.put(aticDevice.getMoId(), map);
                    if (null == this.iCpuMemUsageService) {
                        this.iCpuMemUsageService = (ICpuMemUsageService)ServiceContext.getInstance().getService("iCpuMemUsageService", ICpuMemUsageService.class);
                    }
                    this.iCpuMemUsageService.saveCpuMemUsage(cpuMemList);
                }
                catch (Exception e) {
                    this.logger.error((Object)("When monitor decvice(" + aticDevice.getIpAddress() + ") cpu and memory,some errors happened."), (Throwable)e);
                }
            }
        }
    }

    private List<AticDevice> getAticDeviceList() {
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
        List<AticDevice> aticDeviceList = aticDeviceService.getNeedMonitorDevice();
        return aticDeviceList;
    }

    private AticDeviceRouter getRouteDeviceOid(Long moId) {
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceRouterService aticDeviceRouteService = (IAticDeviceRouterService)context.getService("aticDeviceRouterService", IAticDeviceRouterService.class);
        AticDeviceRouter aticDeviceRouter = new AticDeviceRouter();
        if (null != aticDeviceRouteService) {
            aticDeviceRouter = aticDeviceRouteService.findByMoId(moId);
        }
        return aticDeviceRouter;
    }

    private List<CpuMemUsage> getDevCpuMemUsage(AticDevice aticDevice) {
        ServiceContext context = ServiceContext.getInstance();
        IAticDeviceService aticDeviceService = (IAticDeviceService)context.getService("aticDeviceService", IAticDeviceService.class);
        ArrayList<CpuMemUsage> resultList = new ArrayList<CpuMemUsage>();
        List<TableEvent> usageList = null;
        if (aticDevice.getDeviceModel().toLowerCase(Locale.getDefault()).contains("antiddos1")) {
            String[] usageOid = new String[]{".1.3.6.1.4.1.2011.5.25.31.1.1.1.1.5", ".1.3.6.1.4.1.2011.5.25.31.1.1.1.1.7"};
            usageList = aticDeviceService.snmpGetTableOrigial(usageOid, aticDevice.getMoId());
            if (null == usageList || usageList.isEmpty()) {
                return null;
            }
            for (TableEvent item : usageList) {
                VariableBinding[] vb = item.getColumns();
                int cpuUsage = vb[0].getVariable().toInt();
                int memoryUsage = vb[1].getVariable().toInt();
                if (cpuUsage <= 0) continue;
                CpuMemUsage usageObj = new CpuMemUsage();
                usageObj.setMonitorTime(System.currentTimeMillis());
                usageObj.setDeviceId(aticDevice.getMoId());
                usageObj.setCpuIndex(0);
                usageObj.setCpuUsage(cpuUsage);
                usageObj.setMemUsage(memoryUsage);
                resultList.add(usageObj);
                break;
            }
        } else if (aticDevice.getDeviceType() == 6) {
            AticDeviceRouter aticRouter = this.getRouteDeviceOid(aticDevice.getMoId());
            if (null == aticRouter) {
                return null;
            }
            String cpuOid = aticRouter.getCpuOid();
            String memeryOid = aticRouter.getMemeryOid();
            if (cpuOid.isEmpty() && memeryOid.isEmpty()) {
                return null;
            }
            CpuMemUsage usageObj = new CpuMemUsage();
            usageObj.setMonitorTime(System.currentTimeMillis());
            usageObj.setDeviceId(aticDevice.getMoId());
            usageObj.setCpuIndex(0);
            ArrayList<String> routeOids = new ArrayList<String>();
            routeOids.add(cpuOid);
            routeOids.add(memeryOid);
            List<String> usageResult = aticDeviceService.snmpGet(routeOids, aticDevice.getMoId());
            if (null == usageResult || usageResult.isEmpty()) {
                return null;
            }
            try {
                usageObj.setCpuUsage(Integer.parseInt(usageResult.get(0)));
            }
            catch (Exception e) {
                usageObj.setCpuUsage(0);
            }
            try {
                usageObj.setMemUsage(Integer.parseInt(usageResult.get(1)));
            }
            catch (Exception e) {
                usageObj.setMemUsage(0);
            }
            resultList.add(usageObj);
        } else if (aticDevice.getDeviceType() == 5) {
            String[] usageOid = new String[]{"1.3.6.1.4.1.2011.5.25.31.1.1.1.1.5", "1.3.6.1.4.1.2011.5.25.31.1.1.1.1.7"};
            usageList = aticDeviceService.snmpGetTableOrigial(usageOid, aticDevice.getMoId());
            if (null == usageList || usageList.isEmpty()) {
                return null;
            }
            for (TableEvent item : usageList) {
                VariableBinding[] vb = item.getColumns();
                double cpuUsage = Double.valueOf(vb[0].getVariable().toString());
                double memoryUsage = Double.valueOf(vb[1].getVariable().toString());
                if (!(cpuUsage > 0.0)) continue;
                CpuMemUsage usageObj = new CpuMemUsage();
                usageObj.setMonitorTime(System.currentTimeMillis());
                usageObj.setDeviceId(aticDevice.getMoId());
                usageObj.setCpuIndex(0);
                usageObj.setCpuUsage((int)cpuUsage);
                usageObj.setMemUsage((int)memoryUsage);
                resultList.add(usageObj);
                break;
            }
        } else {
            String[] usageOid = new String[]{".1.3.6.1.4.1.2011.6.3.4.1.3", ".1.3.6.1.4.1.2011.6.3.5.1.1.2", ".1.3.6.1.4.1.2011.6.3.5.1.1.3"};
            usageList = aticDeviceService.snmpGetTableOrigial(usageOid, aticDevice.getMoId());
            if (null == usageList || usageList.isEmpty()) {
                return null;
            }
            CpuMemUsage devUsage = new CpuMemUsage();
            long systemTime = System.currentTimeMillis();
            devUsage.setMonitorTime(systemTime);
            devUsage.setDeviceId(aticDevice.getMoId());
            devUsage.setCpuIndex(0);
            resultList.add(devUsage);
            int cpuUsageSize = usageList.size();
            for (TableEvent item : usageList) {
                VariableBinding[] vb = item.getColumns();
                CpuMemUsage usageObj = new CpuMemUsage();
                if (null == item.getIndex()) continue;
                int[] indexArr = item.getIndex().toIntArray();
                int cpuIndex = indexArr[1];
                if (!DevCpuDescrUtil.checkSpuSlot(aticDevice, cpuIndex)) {
                    --cpuUsageSize;
                    continue;
                }
                int cpuUsage = vb[0].getVariable().toInt();
                long memorySize = vb[1].getVariable().toLong();
                long memoryFree = vb[2].getVariable().toLong();
                long memoryUsed = memorySize - memoryFree;
                usageObj.setMonitorTime(systemTime);
                usageObj.setDeviceId(aticDevice.getMoId());
                usageObj.setCpuIndex(cpuIndex);
                usageObj.setCpuUsage(cpuUsage);
                usageObj.setMemUsage((int)(memoryUsed * 100L / memorySize));
                resultList.add(usageObj);
                devUsage.setCpuUsage(cpuUsage + devUsage.getCpuUsage());
                devUsage.setMemSize(memorySize + devUsage.getMemSize());
                devUsage.setMemUsed(memoryUsed + devUsage.getMemUsed());
            }
            if (cpuUsageSize > 0) {
                devUsage.setCpuUsage(devUsage.getCpuUsage() / cpuUsageSize);
            }
            if (devUsage.getMemSize() > 0L) {
                devUsage.setMemUsage((int)(devUsage.getMemUsed() * 100L / devUsage.getMemSize()));
            }
        }
        return resultList;
    }
}

