/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.mediation.synchronize;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.mediation.synchronize.ISynchronizer;
import com.huawei.atic.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.atic.mediation.synchronize.util.SynchronizeUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class AbstractSynchronizer
implements ISynchronizer {
    public static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private XmlSynchronizeContext neSyncMapping = null;

    public final XmlSynchronizeContext getNeSyncMapping() {
        return this.neSyncMapping;
    }

    public final void setNeSyncMapping(XmlSynchronizeContext neSyncMapping) {
        this.neSyncMapping = neSyncMapping;
    }

    protected final void populateMoPropertyValue(String propertyValue, String propertyType, String propertyName, ManagedObject managedObject) {
        Class<?> moClass = managedObject.getClass();
        Class<Object> propertyTypeClass = null;
        Object parsedValue = null;
        try {
            if ((propertyType.equals("int") || propertyType.equals("java.lang.Integer") || propertyType.equals("long") || propertyType.equals("java.lang.Long") || propertyType.equals("boolean") || propertyType.equals("java.lang.Boolean")) && propertyValue != null && propertyValue.contains("(")) {
                LOGGER.info((Object)("the original propertyValue is : " + propertyValue));
                int beginIndex = propertyValue.indexOf("(");
                int endIndex = propertyValue.indexOf(")");
                propertyValue = propertyValue.subSequence(beginIndex + 1, endIndex).toString();
                LOGGER.info((Object)("parsed mib propertyValue is : " + propertyValue));
            }
            if (propertyType.equals("int")) {
                propertyTypeClass = Integer.TYPE;
                parsedValue = Integer.parseInt(propertyValue);
            } else if (propertyType.equals("java.lang.Integer")) {
                propertyTypeClass = Integer.class;
                parsedValue = Integer.parseInt(propertyValue);
            } else if (propertyType.equals("long")) {
                propertyTypeClass = Long.TYPE;
                parsedValue = Long.parseLong(propertyValue);
            } else if (propertyType.equals("java.lang.Long")) {
                propertyTypeClass = Long.class;
                parsedValue = Long.parseLong(propertyValue);
            } else if (propertyType.equals("boolean")) {
                propertyTypeClass = Boolean.TYPE;
                parsedValue = propertyValue;
            } else if (propertyType.equals("java.lang.Boolean")) {
                propertyTypeClass = Boolean.class;
                parsedValue = propertyValue;
            } else {
                propertyTypeClass = String.class;
                parsedValue = propertyValue;
            }
            Method fieldMethod = moClass.getMethod("set" + SynchronizeUtil.getInstance().formatPropertyName(propertyName), propertyTypeClass);
            fieldMethod.invoke((Object)managedObject, parsedValue);
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)e);
        }
        catch (SecurityException e) {
            LOGGER.error((Object)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error((Object)e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("exception when populateMoPropertyValue, mibValue is : " + propertyValue + ", propertyName is : " + propertyName + ", propertyType is : " + propertyType + ", managedObject is : " + managedObject), (Throwable)e);
        }
    }
}

