/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.service.impl;

import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.system.syslog.sdk.model.SysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogLevel;
import com.hs.lego.core.system.syslog.sdk.service.SysoplogResultLevel;
import com.huawei.atic.nem.discover.model.DiscoveryPolicy;
import com.huawei.atic.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.atic.nem.discover.sdk.service.INodeEditor;
import com.huawei.atic.nem.discover.service.impl.AbstractDiscoveryThread;
import com.huawei.atic.nem.discover.util.WatchUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class AutoDiscoveryThread
extends AbstractDiscoveryThread {
    private IDiscoveryService service;

    public AutoDiscoveryThread(DiscoveryPolicy policy) {
        super(policy);
    }

    public AutoDiscoveryThread(DiscoveryPolicy policy, List<INodeEditor> nodeEditorList) {
        super(policy);
        this.nodelist = nodeEditorList;
    }

    @Override
    public void run() {
        Map<String, String> ipRangeMap = super.getPolicy().getIpRangeMap();
        for (Map.Entry<String, String> entrySet : ipRangeMap.entrySet()) {
            if (super.isCancel()) break;
            String startIp = entrySet.getKey();
            String endIp = entrySet.getValue();
            long startIpLong = WatchUtil.getInstance().getAddrLong(startIp);
            long endIpLong = WatchUtil.getInstance().getAddrLong(endIp);
            long ipCount = endIpLong + 1L - startIpLong;
            for (long j = 0L; !super.isCancel() && j < ipCount; ++j) {
                String ip = WatchUtil.getInstance().convertAddr(startIpLong + j);
                super.snmpDiscovery(ip, super.getPolicy().getDeviceName());
            }
        }
        SysOptLog oOptLog = new SysOptLog();
        Date date = new Date();
        oOptLog.setDate(date);
        oOptLog.setTarget(this.getPolicy().getIpRangeString());
        oOptLog.setLevel(SysoplogLevel.normal.getValue());
        oOptLog.setModule("lego.dic.module.ResourceApplication");
        if (super.isCancel()) {
            oOptLog.setOperation("lego.lab.discovery.stoppolicy");
        } else {
            oOptLog.setOperation("lego.lab.discovery.disdetail");
        }
        if (null != this.service) {
            DiscoveryPolicy po = this.service.getDiscoveryPolicy(this.getPolicy().getDiscoveryPolicyId());
            oOptLog.setDetail("lego.lab.discovery.ver.discoveryresult");
            long failureNum = po.getTotalIpCount() - (long)po.getDiscoveredDeviceCount().intValue();
            String[] para = new String[]{po.getDiscoveredDeviceCount().toString(), failureNum + ""};
            oOptLog.setDetailPara(para);
            if (failureNum > 0L) {
                oOptLog.setResult(SysoplogResultLevel.failed.getValue());
            } else {
                oOptLog.setResult(SysoplogResultLevel.success.getValue());
            }
            oOptLog.setOperator(this.getPolicy().getOperator());
            oOptLog.setTerminalIp(this.getPolicy().getTerminalIp());
            ISysOptLog sysOpLog = (ISysOptLog)ServiceContext.getInstance().getService("sysLogService", ISysOptLog.class);
            sysOpLog.writeOptLog(oOptLog);
        }
    }

    public void setService(IDiscoveryService service) {
        this.service = service;
    }
}

