/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.service.impl;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ICacheService;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.nem.discover.model.DiscoveryPolicy;
import com.huawei.atic.nem.discover.service.impl.AbstractDiscoveryThread;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class CleanDiscoveryCacheThread
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private Map<Long, AbstractDiscoveryThread> activeDiscoveryThreadMap;
    private ICacheService<String, Object> cacheService = null;
    private List<Long> policyIdList = new ArrayList<Long>();

    public CleanDiscoveryCacheThread(Map<Long, AbstractDiscoveryThread> activeDiscoveryThreadMap, ICacheService<String, Object> cacheService) {
        this.activeDiscoveryThreadMap = activeDiscoveryThreadMap;
        this.cacheService = cacheService;
    }

    @Override
    public void run() {
        while (true) {
            this.policyIdList.clear();
            long currentTimeLong = System.currentTimeMillis();
            try {
                long maxWaitTime = 30L;
                for (Map.Entry<Long, AbstractDiscoveryThread> entry : this.activeDiscoveryThreadMap.entrySet()) {
                    long endTimeLong;
                    long timeIntervalInMinutes;
                    DiscoveryPolicy policy;
                    Timestamp endDiscoveryTime;
                    AbstractDiscoveryThread discoveryThread = entry.getValue();
                    if (!discoveryThread.isCancel() || (endDiscoveryTime = (policy = discoveryThread.getPolicy()).getEndDiscoveryTime()) == null || (timeIntervalInMinutes = (currentTimeLong - (endTimeLong = endDiscoveryTime.getTime())) / 1000L / 60L) < 30L) continue;
                    this.policyIdList.add(policy.getDiscoveryPolicyId());
                }
                for (Long policyId : this.policyIdList) {
                    LOGGER.info((Object)("the discovery caceh will be cleaned, policyId is : " + policyId));
                    this.activeDiscoveryThreadMap.remove(policyId);
                    this.cacheService.remove((Object)("discoveryPolicyId_" + policyId));
                }
                TimeUnit.SECONDS.sleep(30000L);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)"exception in CleanDiscoveryCacheThread", (Throwable)e);
                try {
                    TimeUnit.SECONDS.sleep(10000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    LOGGER.error((Object)"exception when sleep", (Throwable)e1);
                    continue;
                }
            }
            break;
        }
    }
}

