/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.nem.discover.util;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class PropertyUtil {
    private static final String MAX_IMPORTED_ROW = "5000";
    private static final String MAX_NE_COUNT = "1500";
    private static final String ATIC_NEW_VERSION = "";
    private static PropertyUtil instance = new PropertyUtil();
    private static final Properties PROPS = new Properties();
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    public String getMaxImportedRow() {
        String value = PROPS.getProperty("maxImportedRow");
        if (!StringUtils.hasText((String)value)) {
            LOGGER.error((Object)"can not get the value of maxImportedRow!!!");
            value = MAX_IMPORTED_ROW;
        }
        return value;
    }

    public String getMaxNECount() {
        String value = PROPS.getProperty("maxNECount");
        if (!StringUtils.hasText((String)value)) {
            LOGGER.error((Object)"can not get the value of maxNECount!!!");
            value = MAX_NE_COUNT;
        }
        return value;
    }

    public String getAticVersion() {
        String value = PROPS.getProperty("aticNewVersion");
        if (!StringUtils.hasText((String)value)) {
            LOGGER.error((Object)"can not get the value of ATIC_NEW_VERSION !!!");
            value = ATIC_NEW_VERSION;
        }
        return value;
    }

    public static PropertyUtil getInstance() {
        return instance;
    }

    static {
        InputStream instream = null;
        try {
            ClassLoader loader = PropertyUtil.class.getClassLoader();
            if (null != loader && null != (instream = loader.getResourceAsStream("discover.properties"))) {
                PROPS.load(instream);
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)"read discover.properties failed.");
        }
        finally {
            if (null != instream) {
                try {
                    instream.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close InputStream of discover.properties fail");
                }
            }
        }
    }
}

