/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.resource.messagesubscriber;

import com.hs.lego.cbb.resource.sdk.model.ManagedObject;
import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.cbb.resource.dao.IResourceDao;
import com.huawei.atic.cbb.resource.util.DaoFactory;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class MoOffLineMessageSubscriber
extends MessageTaskManager
implements InitializingBean {
    private static final Log LOGGER = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    private IMessageCenter messageCenter = null;

    public void afterPropertiesSet() {
        this.messageCenter.addSubscriberTo((MessageTaskManager)this);
    }

    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters((int)1);
        mrs[0].setMessageTopic(MessageTopic.COMMAND);
        mrs[0].addMessageCode(109L);
        return mrs;
    }

    public void onMessage(MessageUnit mu) {
        if (109L == mu.getCmdcode()) {
            Object obj = mu.getObj();
            LOGGER.info((Object)("MoOffLineMessage body is : " + obj));
            if (!(obj instanceof Map)) {
                LOGGER.error((Object)"error message body in MoOffLineMessageSubscriber!!!");
                return;
            }
            Map map = (Map)obj;
            if (map.isEmpty()) {
                LOGGER.error((Object)"error message body in MoOffLineMessageSubscriber!!!");
                return;
            }
            Long moId = (Long)map.keySet().iterator().next();
            Integer status = (Integer)map.values().iterator().next();
            LOGGER.info((Object)("mo offline is arrived, moId is : " + moId));
            IResourceDao dao = DaoFactory.getInstance().getResourceDao();
            ManagedObject mo = dao.getMoByIdAndType(ManagedObject.class, moId, null);
            if (mo == null) {
                LOGGER.warn((Object)("in mo offline, mo is nullllllllllll, moid is : " + moId));
                return;
            }
            if (mo.getStatus() != null && mo.getStatus() == -1) {
                return;
            }
            mo.setStatus(status);
            dao.updateMoWithoutMsg(mo);
        }
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }
}

