/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.rmi.impl;

import com.hs.atic.collector.entity.alarm.CycleAlarmEntity;
import com.hs.atic.collector.entity.alarm.DbTableAlarmEntity;
import com.hs.atic.collector.entity.alarm.DiskSpaceAlarmEntity;
import com.hs.atic.collector.entity.alarm.DropLogAlarmEntity;
import com.hs.atic.collector.entity.alarm.MemoryAlarmEntity;
import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.ServerSocketFactory;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.base.ServiceContext;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.alarm.service.ISecneCollectorRmiProxyService;
import com.huawei.atic.alarm.service.SecneAlarmEntryBuffer;
import com.huawei.atic.rmi.SecneNotifyAlarmService;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;

public class SecneNotifyAlarmServiceImpl
extends UnicastRemoteObject
implements SecneNotifyAlarmService {
    private static final long serialVersionUID = -219114081575005914L;
    transient SecneAlarmEntryBuffer buffer;
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    protected SecneNotifyAlarmServiceImpl() throws RemoteException {
    }

    public SecneNotifyAlarmServiceImpl(int port, ClientSocketFactory csf, ServerSocketFactory ssf) throws RemoteException {
        super(port, (RMIClientSocketFactory)csf, (RMIServerSocketFactory)ssf);
        ISecneCollectorRmiProxyService proxyService = (ISecneCollectorRmiProxyService)ServiceContext.getInstance().getService("secneCollectorRmiProxyService", ISecneCollectorRmiProxyService.class);
        this.buffer = proxyService.getAlarmEntityBuffer();
    }

    @Override
    public void notifyDbTableAlert(List<DbTableAlarmEntity> dbTableAlarmEntity) throws RemoteException {
        if (null == dbTableAlarmEntity || dbTableAlarmEntity.isEmpty()) {
            this.logger.info((Object)"notifyDbTableAlert dbTableAlarmEntity is null");
            return;
        }
        this.logger.info((Object)("notifyDbTableAlert data size : " + dbTableAlarmEntity.size()));
        if (dbTableAlarmEntity.size() > 10000) {
            this.logger.info((Object)"notifyDbTableAlert data size to long");
            return;
        }
        try {
            this.buffer.addDbTableAlarmList(dbTableAlarmEntity);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyDbTableAlert error ", (Throwable)e);
        }
    }

    @Override
    public void notifyDiskSpaceAlert(List<DiskSpaceAlarmEntity> diskSpaceAlarmEntity) throws RemoteException {
        if (null == diskSpaceAlarmEntity || diskSpaceAlarmEntity.isEmpty()) {
            this.logger.info((Object)"notifyDiskSpaceAlert diskSpaceAlarmEntity is null");
            return;
        }
        this.logger.info((Object)("notifyDiskSpaceAlert data size : " + diskSpaceAlarmEntity.size()));
        if (diskSpaceAlarmEntity.size() > 10000) {
            this.logger.info((Object)"notifyDiskSpaceAlert data size to long");
            return;
        }
        try {
            this.buffer.addDiskSpaceAlarmList(diskSpaceAlarmEntity);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyDiskSpaceAlert error ", (Throwable)e);
        }
    }

    @Override
    public void notifyCycleAlert(List<CycleAlarmEntity> cycleAlarmEntity) throws RemoteException {
        if (null == cycleAlarmEntity || cycleAlarmEntity.isEmpty()) {
            this.logger.info((Object)"notifyCycleAlert cycleAlarmEntity is null");
            return;
        }
        this.logger.info((Object)("cycleSpaceAlert data size : " + cycleAlarmEntity.size()));
        if (cycleAlarmEntity.size() > 10000) {
            this.logger.info((Object)"cycleAlert data size to long");
            return;
        }
        try {
            this.buffer.addCycleAlarmList(cycleAlarmEntity);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyCycleAlert error ", (Throwable)e);
        }
    }

    @Override
    public void notifyMemoryAlert(List<MemoryAlarmEntity> memoryAlarmEntity) throws RemoteException {
        if (null == memoryAlarmEntity || memoryAlarmEntity.isEmpty()) {
            this.logger.info((Object)"notifyMemoryAlert memoryAlarmEntity is null");
            return;
        }
        this.logger.info((Object)("notifyMemoryAlert data size : " + memoryAlarmEntity.size()));
        if (memoryAlarmEntity.size() > 10000) {
            this.logger.info((Object)"notifyMemoryAlert data size to long");
            return;
        }
        try {
            this.buffer.addMemoryAlarmList(memoryAlarmEntity);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyMemoryAlert error ", (Throwable)e);
        }
    }

    @Override
    public void notifyDropLogAlert(List<DropLogAlarmEntity> dropLogAlarmEntity) throws RemoteException {
        if (null == dropLogAlarmEntity || dropLogAlarmEntity.isEmpty()) {
            this.logger.info((Object)"notifyDropLogAlert dropLogAlarmEntity is null");
            return;
        }
        this.logger.info((Object)("notifyMemoryAlert data size : " + dropLogAlarmEntity.size()));
        if (dropLogAlarmEntity.size() > 10000) {
            this.logger.info((Object)"notifyMemoryAlert data size to long");
            return;
        }
        try {
            this.buffer.addDropLogAlarmList(dropLogAlarmEntity);
        }
        catch (Exception e) {
            this.logger.error((Object)"notifyMemoryAlert error ", (Throwable)e);
        }
    }
}

