/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.sdk.bis.service.impl;

import com.hs.atic.util.AticUtil;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.comm.BatchOperation;
import com.hs.lego.core.sdk.comm.BatchOperationResult;
import com.hs.lego.core.sdk.comm.Paging;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.device.model.AticDevice;
import com.huawei.atic.sdk.bis.form.DefendGroupForm;
import com.huawei.atic.sdk.bis.model.DefendGroup;
import com.huawei.atic.sdk.bis.service.IDefendGroupService;
import com.huawei.atic.sdk.bis.service.dao.DefendGroupDao;
import com.huawei.atic.secne.sdk.service.IAticDeviceService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DefendGroupServiceImpl
implements IDefendGroupService {
    private static final int FIRST_INDEX = 1;
    private DefendGroupDao defendGroupDao;
    private IAticDeviceService aticDeviceService;
    private final Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);

    @Override
    public Paging queryByPage(Map<String, String> queryMap, int start, int pageSize) {
        List<DefendGroup> allData = this.defendGroupDao.getAll();
        List<DefendGroup> pageDataList = this.getPageData(allData, start, pageSize);
        ArrayList<DefendGroupForm> formList = new ArrayList<DefendGroupForm>();
        for (DefendGroup group : pageDataList) {
            DefendGroupForm form = new DefendGroupForm();
            AticUtil.copyProperties((Object)group, (Object)form);
            formList.add(form);
        }
        Paging page = new Paging();
        page.setData(formList);
        page.setCount(allData.size());
        this.logger.info((Object)("query defend group list, size = " + allData.size()));
        return page;
    }

    private List<DefendGroup> getPageData(List<DefendGroup> securityList, int start, int pageSize) {
        int end = start + pageSize;
        int total = securityList.size();
        if (end > total) {
            end = total;
        }
        List<DefendGroup> pageDataList = new ArrayList<DefendGroup>();
        if (!securityList.isEmpty()) {
            pageDataList = securityList.subList(start, end);
        }
        return pageDataList;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    @Override
    public Long saveDefendGroup(DefendGroupForm defendGroupForm) {
        DefendGroup defendGroup = (DefendGroup)AticUtil.copyProperties((Object)defendGroupForm, (Object)new DefendGroup());
        this.defendGroupDao.saveOrUpdate(defendGroup);
        Long id = defendGroup.getId();
        this.logger.info((Object)("save defend group, name is : " + this.getcleanedMessage(defendGroup.getGroupName())));
        return id;
    }

    @Override
    public DefendGroupForm findById(Long defendGroupId) {
        DefendGroup defendGroup = this.defendGroupDao.get(defendGroupId);
        this.logger.info((Object)("find defend group by id : " + defendGroupId));
        return (DefendGroupForm)AticUtil.copyProperties((Object)defendGroup, (Object)new DefendGroupForm());
    }

    @Override
    public BatchOperationResult batchDelDefendGroup(List<BatchOperation> boList) {
        BatchOperationResult result = new BatchOperationResult();
        int fail = 0;
        if (null == boList) {
            return result;
        }
        if (!boList.isEmpty()) {
            for (BatchOperation bo : boList) {
                try {
                    if (null == this.findById(bo.getTargetId())) {
                        this.logger.error((Object)("delete defendGroup : " + this.getcleanedMessage(bo.getTargetName()) + " failed, not exists"));
                        ++fail;
                        bo.setErrorCode(571004L);
                        continue;
                    }
                    this.delById(bo.getTargetId());
                    String[] detailPara = bo.getTargetNameParam();
                    if (detailPara.length < 4) {
                        bo.setOptDetail("atic.bis.defendGroup.delSummary");
                        bo.setDetailParam(detailPara);
                    } else {
                        bo.setOptDetail("atic.bis.defendGroup.delSummary.noNet");
                        bo.setDetailParam(detailPara);
                    }
                    this.logger.info((Object)("delete defend group : " + this.getcleanedMessage(bo.getTargetName()) + "successfully."));
                }
                catch (Exception e) {
                    ++fail;
                    bo.setErrorCode(570507L);
                    this.logger.error((Object)("delete defendGroup : " + this.getcleanedMessage(bo.getTargetName()) + " failed"), (Throwable)e);
                }
            }
        }
        result.setResult(boList);
        result.setFailCount(fail);
        result.setTotalCount(boList.size());
        result.setSucceedCount(boList.size() - fail);
        this.logger.info((Object)("batch delete defend group result : total = " + result.getTotalCount() + ", success = " + result.getSucceedCount() + ", fail = " + result.getFailCount()));
        return result;
    }

    @Override
    public void delById(Long id) {
        this.defendGroupDao.update(id);
        this.defendGroupDao.remove(id);
    }

    @Override
    public boolean isExists(Long excludeId, String defendGroupName) {
        return this.defendGroupDao.isExists(excludeId, defendGroupName);
    }

    @Override
    public int getCounts() {
        int all = this.defendGroupDao.getAll().size();
        this.logger.info((Object)("get defend group's all counts : " + all));
        return all;
    }

    @Override
    public int getDetectTypeByFirewallId(long firewallId, long anotherFirewallId) {
        if (firewallId == anotherFirewallId) {
            this.logger.error((Object)"two firewallIds are same.");
            return -1;
        }
        List<DefendGroup> defendGroupList = this.defendGroupDao.getAll();
        if (defendGroupList.isEmpty()) {
            this.logger.error((Object)"no defend group.");
        }
        if (!defendGroupList.isEmpty()) {
            for (DefendGroup defendGroup : defendGroupList) {
                List<Long> deviceList = defendGroup.getFirewallIds();
                if (deviceList.contains(firewallId) && deviceList.contains(anotherFirewallId)) {
                    this.logger.info((Object)"the two firewalls are in the same defend group.");
                    return defendGroup.getDetectMode();
                }
                if (!deviceList.contains(firewallId) && !deviceList.contains(anotherFirewallId)) continue;
                this.logger.info((Object)"the two firewalls are in the different defendgroup.");
                return -1;
            }
        }
        this.logger.info((Object)"neither of the two firewalls in a defend group.");
        return -1;
    }

    @Override
    public String getDevicesNotBelongMe(Long excludeId) {
        return this.defendGroupDao.getDevicesNotBelongMe(excludeId);
    }

    @Override
    public List<DefendGroupForm> getAll(long userId, boolean isAdmin) {
        List<DefendGroup> allList = this.defendGroupDao.getAll();
        ArrayList<DefendGroupForm> allFormList = new ArrayList<DefendGroupForm>();
        if (!allList.isEmpty()) {
            List<Long> allMoIds = this.defendGroupDao.queryAllMoId(userId);
            HashSet<String> moIDSet = new HashSet<String>();
            for (Long item : allMoIds) {
                moIDSet.add(String.valueOf(item).toLowerCase(Locale.getDefault()));
            }
            for (DefendGroup defendGroup : allList) {
                if (userId > 1L && !isAdmin) {
                    String[] moidArray;
                    String deviceIDs = defendGroup.getDevices();
                    HashSet moIDclone = (HashSet)moIDSet.clone();
                    int num = moIDclone.size();
                    for (String item : moidArray = deviceIDs.split(",")) {
                        moIDclone.add(item.toLowerCase(Locale.getDefault()));
                    }
                    if (num < moIDclone.size()) continue;
                }
                allFormList.add((DefendGroupForm)AticUtil.copyProperties((Object)defendGroup, (Object)new DefendGroupForm()));
            }
        }
        this.logger.info((Object)("get all defend group, size = " + allFormList.size()));
        return allFormList;
    }

    @Override
    public List<DefendGroupForm> getAll() {
        List<DefendGroup> allList = this.defendGroupDao.getAll();
        ArrayList<DefendGroupForm> allFormList = new ArrayList<DefendGroupForm>();
        if (!allList.isEmpty()) {
            for (DefendGroup defendGroup : allList) {
                allFormList.add((DefendGroupForm)AticUtil.copyProperties((Object)defendGroup, (Object)new DefendGroupForm()));
            }
        }
        this.logger.info((Object)("get all defend group, size = " + allFormList.size()));
        return allFormList;
    }

    @Override
    public void respondMsgDelDevice(List<Long> firewallIdSet) {
        List<DefendGroup> defendGroupList = this.defendGroupDao.getAll();
        for (DefendGroup defendGroup : defendGroupList) {
            List<Long> firewLongs = defendGroup.getFirewallIds();
            if (!firewLongs.removeAll(firewallIdSet)) continue;
            String firewallIdsStr = firewLongs.toString();
            defendGroup.setDevices(firewallIdsStr.substring(1, firewallIdsStr.length() - 1));
            this.defendGroupDao.saveOrUpdate(defendGroup);
        }
        this.logger.info((Object)("cascade delete defend group's device info while deleting firewall sucessfully. firewall = " + firewallIdSet));
    }

    @Override
    public List<List<Long>> getRedundancyFirewallList(List<Long> firewallIdList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        List<DefendGroup> defendGroupList = this.defendGroupDao.getAll();
        if (!defendGroupList.isEmpty()) {
            for (DefendGroup defendGroup : defendGroupList) {
                if (defendGroup.getDetectMode() != 0) continue;
                defendGroup.getFirewallIds().retainAll(firewallIdList);
                result.add(defendGroup.getFirewallIds());
            }
        }
        return result;
    }

    @Override
    public boolean isDevIdExistDefendGroup(Long devId) {
        DefendGroup group = this.defendGroupDao.getDefendGroupByDevId(devId);
        return group == null;
    }

    @Override
    public DefendGroupForm getById(Long id) {
        DefendGroup defendGroup = this.defendGroupDao.get(id);
        DefendGroupForm defendGroupForm = (DefendGroupForm)AticUtil.copyProperties((Object)defendGroup, (Object)new DefendGroupForm());
        return defendGroupForm;
    }

    @Override
    public List<DefendGroupForm> getDefendGroupFormListByDevId(long deviceId) {
        DefendGroup defendGroup = this.defendGroupDao.getDefendGroupByDevId(deviceId);
        ArrayList<DefendGroupForm> defendGroupFormList = new ArrayList<DefendGroupForm>();
        if (defendGroup != null) {
            DefendGroupForm defendGroupForm = new DefendGroupForm();
            AticUtil.copyProperties((Object)defendGroup, (Object)defendGroupForm);
            defendGroupFormList.add(defendGroupForm);
        }
        return defendGroupFormList;
    }

    @Override
    public List<DefendGroupForm> findByUpstreamGroupId(Long upstreamGroupId) {
        List<DefendGroup> defendGroupList = this.defendGroupDao.getByUpstreamGroupId(upstreamGroupId);
        ArrayList<DefendGroupForm> defendGroupFormList = new ArrayList<DefendGroupForm>();
        if (null == defendGroupList) {
            return defendGroupFormList;
        }
        for (DefendGroup defendGroup : defendGroupList) {
            DefendGroupForm defendGroupForm = new DefendGroupForm();
            AticUtil.copyProperties((Object)defendGroup, (Object)defendGroupForm);
            defendGroupFormList.add(defendGroupForm);
        }
        return defendGroupFormList;
    }

    @Override
    public void updateDefendGroupByDevId(Long dfId, Long deviceId) {
        DefendGroup defendGroup = this.defendGroupDao.get(dfId);
        if (null == defendGroup) {
            return;
        }
        String[] idStrings = defendGroup.getDevices().split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : idStrings) {
            idList.add(Long.valueOf(id));
        }
        idList.remove(deviceId);
        if (idList.isEmpty()) {
            this.delById(defendGroup.getId());
        }
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < idList.size(); ++i) {
            if (0 == i) {
                ids.append(idList.get(i));
                continue;
            }
            ids.append(",").append(idList.get(i));
        }
        defendGroup.setDevices(ids.toString());
        this.defendGroupDao.update(defendGroup);
    }

    @Override
    public List<AticDevice> getLinkageCleanDevices(AticDevice device) {
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        DefendGroup defendGroup = this.defendGroupDao.getDefendGroupByDevId(device.getMoId());
        if (null != defendGroup) {
            Long linkageGroupId = defendGroup.getUpstreamGroupId();
            if (null != linkageGroupId) {
                DefendGroup linkageGroup = this.defendGroupDao.get(linkageGroupId);
                if (null != linkageGroup) {
                    List<Long> deviceIdList = linkageGroup.getFirewallIds();
                    for (Long deviceId : deviceIdList) {
                        AticDevice tempDevice = this.aticDeviceService.getDeviceByMoid(deviceId);
                        if (0 != tempDevice.getDdosType() && 2 != tempDevice.getDdosType()) continue;
                        deviceList.add(tempDevice);
                    }
                } else {
                    this.logger.error((Object)"linkageGroup is null");
                }
            } else {
                this.logger.error((Object)"linkageGroupId is null");
            }
        } else {
            this.logger.error((Object)"defendGroup is null");
        }
        return deviceList;
    }

    @Override
    public List<AticDevice> getUpGroupCleanDevices(AticDevice device) {
        List<AticDevice> deviceList = new ArrayList<AticDevice>();
        DefendGroup defendGroup = this.defendGroupDao.getDefendGroupByDevId(device.getMoId());
        List<DefendGroup> defendGroups = null;
        if (null != defendGroup) {
            Long linkageGroupId = defendGroup.getUpstreamGroupId();
            if (null != linkageGroupId) {
                DefendGroup linkageGroup = this.defendGroupDao.get(linkageGroupId);
                if (null != linkageGroup) {
                    deviceList = this.filterCleanDeviceByDeviceId(linkageGroup.getFirewallIds());
                } else {
                    this.logger.error((Object)"linkageGroup is null");
                }
            } else {
                Long groupId = defendGroup.getId();
                defendGroups = this.defendGroupDao.getByUpstreamGroupId(groupId);
                if (null != defendGroups && !defendGroups.isEmpty()) {
                    deviceList = this.filterCleanDeviceByDeviceId(defendGroup.getFirewallIds());
                }
            }
        } else {
            this.logger.error((Object)"defendGroup is null");
        }
        return deviceList;
    }

    @Override
    public List<AticDevice> getGroupCleanDevices(AticDevice device) {
        List<AticDevice> deviceList = new ArrayList<AticDevice>();
        DefendGroup defendGroup = this.defendGroupDao.getDefendGroupByDevId(device.getMoId());
        if (null != defendGroup) {
            if (defendGroup.getFirewallIds().contains(device.getMoId())) {
                deviceList = this.filterCleanDeviceByDeviceId(defendGroup.getFirewallIds());
                for (Long deviceId : defendGroup.getFirewallIds()) {
                    AticDevice deviceTemp = this.aticDeviceService.getDeviceByMoid(deviceId);
                    if (0 != deviceTemp.getDdosType() && 2 != deviceTemp.getDdosType()) continue;
                    deviceList.add(deviceTemp);
                }
            }
        } else {
            this.logger.error((Object)"defendGroup is null");
        }
        return deviceList;
    }

    @Override
    public List<AticDevice> getDownGroupCleanDevices(AticDevice device) {
        List<AticDevice> deviceList = new ArrayList<AticDevice>();
        DefendGroup defendGroup = this.defendGroupDao.getDefendGroupByDevId(device.getMoId());
        List<DefendGroup> defendGroups = null;
        if (null != defendGroup) {
            Long linkageGroupId = defendGroup.getUpstreamGroupId();
            if (null != linkageGroupId) {
                DefendGroup linkageGroup = this.defendGroupDao.get(linkageGroupId);
                if (null != linkageGroup) {
                    deviceList = this.filterCleanDeviceByDeviceId(defendGroup.getFirewallIds());
                }
            } else {
                Long groupId = defendGroup.getId();
                defendGroups = this.defendGroupDao.getByUpstreamGroupId(groupId);
                if (null != defendGroups) {
                    for (DefendGroup defendGroupTemp : defendGroups) {
                        List<AticDevice> devices = this.filterCleanDeviceByDeviceId(defendGroupTemp.getFirewallIds());
                        if (devices.isEmpty()) continue;
                        deviceList.addAll(devices);
                    }
                } else {
                    deviceList = this.filterCleanDeviceByDeviceId(defendGroup.getFirewallIds());
                }
            }
        } else {
            this.logger.error((Object)"defendGroup is null");
        }
        return deviceList;
    }

    private List<AticDevice> filterCleanDeviceByDeviceId(List<Long> deviceIdList) {
        ArrayList<AticDevice> deviceList = new ArrayList<AticDevice>();
        for (Long deviceId : deviceIdList) {
            AticDevice tempDevice = this.aticDeviceService.getDeviceByMoid(deviceId);
            if (0 != tempDevice.getDdosType() && 2 != tempDevice.getDdosType()) continue;
            deviceList.add(tempDevice);
        }
        return deviceList;
    }

    public DefendGroupDao getDefendGroupDao() {
        return this.defendGroupDao;
    }

    public void setDefendGroupDao(DefendGroupDao defendGroupDao) {
        this.defendGroupDao = defendGroupDao;
    }

    public IAticDeviceService getAticDeviceService() {
        return this.aticDeviceService;
    }

    public void setAticDeviceService(IAticDeviceService aticDeviceService) {
        this.aticDeviceService = aticDeviceService;
    }
}

