/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.adapter.capability.service;

import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.huawei.atic.secne.adapter.capability.common.CapabilityConstant;
import com.huawei.atic.secne.adapter.capability.model.CommonCapaBean;
import com.huawei.atic.secne.adapter.capability.model.DevParasBean;
import com.huawei.atic.secne.adapter.capability.model.DevTypeBean;
import com.huawei.atic.secne.adapter.capability.model.DeviceTypeInfo;
import com.huawei.atic.secne.adapter.capability.model.PackageBean;
import com.huawei.atic.secne.adapter.capability.model.ParaBean;
import com.huawei.atic.secne.adapter.capability.model.SupportsBean;
import com.huawei.atic.secne.adapter.frame.exception.SecNEAdapterException;
import com.huawei.atic.secne.adapter.frame.service.DevPkgManager;
import com.huawei.atic.secne.adapter.frame.util.AdapterHelper;
import com.huawei.atic.util.CapaUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseDevCapaManager {
    private static final String CAPA_FILE_POSTFIX = ".xml";
    protected transient Log logger = LogFactory.getInstance((Module)Module.ATIC_CBB_SECNE);
    protected String devCapaPath = "";
    private CommonCapaBean commonCapaBean = null;
    private Map<String, PackageBean> pkgName2BeanMap = null;
    private DevPkgManager devPkgManager = null;

    protected BaseDevCapaManager() {
        this.init();
    }

    public abstract void setDevPkgPath();

    public abstract ClassLoader getConfClassLoader();

    private void init() {
        this.devPkgManager = DevPkgManager.getInstance();
        this.setDevPkgPath();
    }

    public String getDevCapaPath() {
        return this.devCapaPath;
    }

    protected void loadCommonCapaFile() {
        this.logger.info((Object)"in adapter function loadCommonCapaFile");
        String confFile = this.getDevCapaPath() + "CommonCapability.xml";
        String confFileRule = "conf/adapter/capability/rule/CommonCapabilityRule.xml";
        this.commonCapaBean = (CommonCapaBean)AdapterHelper.parseXml2Bean(confFile, confFileRule);
        this.logger.info((Object)"out adapter function loadCommonCapaFile");
    }

    protected void loadDevAdapterFile(String pkgName) {
        this.logger.info((Object)("in adapter function loadDevAdapterFile,pkgName:" + this.getcleanedMessage(pkgName)));
        String confFile = this.getDevCapaPath() + pkgName + CAPA_FILE_POSTFIX;
        String confFileRule = "conf/adapter/capability/rule/DevPkgCapabilityRule.xml";
        PackageBean pkgBean = (PackageBean)AdapterHelper.parseXml2Bean(confFile, confFileRule);
        this.getPkgName2BeanMap().put(pkgName, pkgBean);
    }

    public PackageBean getPkgBean(String pkgName) {
        this.logger.info((Object)("@ adapter function getPkgBean,pkgName = " + this.getcleanedMessage(pkgName)));
        PackageBean pkgBean = this.getPkgName2BeanMap().get(pkgName);
        if (null == pkgBean) {
            this.loadDevAdapterFile(pkgName);
            pkgBean = this.getPkgName2BeanMap().get(pkgName);
        }
        this.logger.info((Object)"out adapter function getPkgBean");
        return pkgBean;
    }

    public List<PackageBean> getPkgBeanList(List<String> pkgNameLst) {
        ArrayList<PackageBean> pkgBeanLst = new ArrayList<PackageBean>();
        if (null == pkgNameLst) {
            this.logger.info((Object)"in adapter function getPkgBeanList: pkgNameLst is null");
            return pkgBeanLst;
        }
        this.logger.info((Object)("in adapter function getPkgBeanList:" + this.getcleanedMessage(pkgNameLst.toString())));
        PackageBean pkgBean = null;
        for (String pkgName : pkgNameLst) {
            pkgBean = this.getPkgBean(pkgName);
            if (null == pkgBean) {
                this.logger.warn((Object)("@ adapter function getPkgBeanList,load package file failed: " + this.getcleanedMessage(pkgName)));
                continue;
            }
            pkgBeanLst.add(pkgBean);
        }
        return pkgBeanLst;
    }

    public Map<String, PackageBean> getPkgName2BeanMap() {
        if (null == this.pkgName2BeanMap) {
            this.pkgName2BeanMap = new HashMap<String, PackageBean>();
        }
        return this.pkgName2BeanMap;
    }

    public CommonCapaBean getCommonCapaBean() {
        if (null == this.commonCapaBean) {
            try {
                this.loadCommonCapaFile();
            }
            catch (SecNEAdapterException adapterExc) {
                this.logger.error((Object)("@ adapter function getCommonCapaBean,\u52a0\u8f7d\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\u5931\u8d25," + adapterExc));
            }
        }
        return this.commonCapaBean;
    }

    public DevParasBean getCommonParasBean() {
        DevParasBean devParasBean = null;
        CommonCapaBean commonCapa = this.getCommonCapaBean();
        if (null != commonCapa) {
            devParasBean = commonCapa.getDevParasBean();
        }
        return devParasBean;
    }

    private String getcleanedMessage(String message) {
        if (message == null) {
            return "";
        }
        message = message.replace('\n', '_').replace('\r', '_');
        return message;
    }

    public ParaBean getCommonParaBean(String paraName) {
        ParaBean para = null;
        DevParasBean commonParas = this.getCommonParasBean();
        if (null != commonParas) {
            para = commonParas.getParaBean(paraName);
        }
        return para;
    }

    public DevTypeBean getDevTypeBean(long devid) {
        return this.getDevTypeBean(CapaUtil.getDevTypeInfo(devid));
    }

    public DevTypeBean getDevTypeBean(DeviceTypeInfo devInfo) {
        this.logger.info((Object)("in adapter function getDevTypeBean,DeviceTypeInfo:" + devInfo));
        DevTypeBean devType = null;
        String pkdName = this.devPkgManager.getDevPkgName(devInfo);
        this.logger.info((Object)("@@@@getDevTypeBean,DeviceTypeInfo:pkdName=" + pkdName));
        PackageBean pkg = this.getPkgBean(pkdName);
        if (null != pkg) {
            devType = pkg.getDevTypeName2BeanMap().get(devInfo.getDevVersion());
        }
        this.logger.info((Object)"out adapter function getDevTypeBean");
        return devType;
    }

    private DevTypeBean getDefaultDevTypeBean(DeviceTypeInfo devInfo) {
        DevTypeBean devType = null;
        String pkdName = this.devPkgManager.getDevPkgName(devInfo);
        PackageBean pkg = this.getPkgBean(pkdName);
        if (null != pkg) {
            devType = pkg.getDevTypeName2BeanMap().get("Default");
        }
        return devType;
    }

    private SupportsBean getDefaultSupportsBean(DeviceTypeInfo devInfo) {
        SupportsBean supports = null;
        DevTypeBean devType = this.getDefaultDevTypeBean(devInfo);
        if (null != devType) {
            supports = devType.getSupportsBean();
        }
        return supports;
    }

    private boolean checkSupportsParaExist(SupportsBean supportsBean, String attr) {
        boolean exist = false;
        if (null != supportsBean) {
            exist = supportsBean.getSupportMap().containsKey(attr);
        }
        return exist;
    }

    public SupportsBean getSupportsBean(long devid) {
        return this.getSupportsBean(CapaUtil.getDevTypeInfo(devid));
    }

    public SupportsBean getSupportsBean(DeviceTypeInfo devInfo) {
        SupportsBean supports = null;
        DevTypeBean devType = this.getDevTypeBean(devInfo);
        if (null != devType) {
            supports = devType.getSupportsBean();
        }
        return supports;
    }

    public boolean isSupported(long devid, String sNodeType) {
        return this.isSupported(CapaUtil.getDevTypeInfo(devid), sNodeType);
    }

    public boolean isSupported(DeviceTypeInfo devInfo, String sNodeType) {
        boolean val = false;
        SupportsBean bean = this.getSupportsBean(devInfo);
        if (!this.checkSupportsParaExist(bean, sNodeType)) {
            bean = this.getDefaultSupportsBean(devInfo);
        }
        if (null != bean) {
            val = bean.isSupport(sNodeType);
        }
        return val;
    }

    public Set<DeviceTypeInfo> getSupportedDevices(Set<DeviceTypeInfo> devInfoSet, String sNodeType) {
        HashSet<DeviceTypeInfo> supportSet = new HashSet<DeviceTypeInfo>();
        if (null != devInfoSet && !devInfoSet.isEmpty()) {
            for (DeviceTypeInfo deviceTypeInfo : supportSet) {
                if (!this.isSupported(deviceTypeInfo, sNodeType)) continue;
                supportSet.add(deviceTypeInfo);
            }
        }
        return supportSet;
    }

    public Set<String> getAllSupportedAttr(long devid) {
        return this.getAllSupportedAttr(CapaUtil.getDevTypeInfo(devid));
    }

    public Set<String> getAllSupportedAttr(DeviceTypeInfo devTypeInfo) {
        this.logger.info((Object)("in adapter function getAllSupportedAttr,DeviceTypeInfo: " + devTypeInfo));
        HashSet<String> devSet = new HashSet<String>();
        HashSet<String> knownDevSet = new HashSet<String>();
        SupportsBean supports = this.getSupportsBean(devTypeInfo);
        Set<String> knownAttrs = null;
        if (null != supports) {
            knownAttrs = supports.getSupportMap().keySet();
            for (String attr : knownAttrs) {
                if (!supports.isSupport(attr)) continue;
                knownDevSet.add(attr);
            }
        }
        devSet.addAll(knownDevSet);
        this.logger.info((Object)("@@@@,DeviceTypeInfo: " + devTypeInfo + " knownDevSet: " + knownDevSet));
        HashSet<String> defaultDevSet = new HashSet<String>();
        SupportsBean defaultSupports = this.getDefaultSupportsBean(devTypeInfo);
        if (null != defaultSupports) {
            Set<String> defAttrs = defaultSupports.getSupportMap().keySet();
            for (String attr : defAttrs) {
                if (null == knownAttrs) {
                    if (!defaultSupports.isSupport(attr)) continue;
                    defaultDevSet.add(attr);
                    continue;
                }
                if (knownAttrs.contains(attr) || !defaultSupports.isSupport(attr)) continue;
                defaultDevSet.add(attr);
            }
        }
        this.logger.info((Object)("@@@@,defaultDevSet: " + defaultDevSet));
        devSet.addAll(defaultDevSet);
        this.logger.info((Object)("@@@@,devSet: " + devSet));
        this.logger.info((Object)"out adapter function getAllSupportedAttr");
        return devSet;
    }

    public DevParasBean getParasBean(long devid) {
        return this.getParasBean(CapaUtil.getDevTypeInfo(devid));
    }

    public DevParasBean getParasBean(DeviceTypeInfo devInfo) {
        DevParasBean devPara = null;
        DevTypeBean devType = this.getDevTypeBean(devInfo);
        if (null != devType) {
            devPara = devType.getDevParasBean();
        }
        return devPara;
    }

    private DevParasBean getDefaultParasBean(DeviceTypeInfo devInfo) {
        DevParasBean devPara = null;
        DevTypeBean devType = this.getDefaultDevTypeBean(devInfo);
        if (null != devType) {
            devPara = devType.getDevParasBean();
        }
        return devPara;
    }

    public ParaBean getParaBean(long devid, String paraName) {
        return this.getParaBean(CapaUtil.getDevTypeInfo(devid), paraName);
    }

    public ParaBean getParaBean(DeviceTypeInfo devInfo, String paraName) {
        ParaBean paraBean = new ParaBean();
        DevParasBean devParasBean = this.getParasBean(devInfo);
        if (!this.checkParaExist(devParasBean, paraName)) {
            devParasBean = this.getDefaultParasBean(devInfo);
        }
        if (null != devParasBean) {
            paraBean = devParasBean.getParaBean(paraName);
        }
        return paraBean;
    }

    private boolean checkParaExist(DevParasBean devParasBean, String para) {
        boolean exist = false;
        if (null != devParasBean) {
            exist = devParasBean.getAllBeanMap().containsKey(para);
        }
        return exist;
    }

    public ParaBean getParaRangeInterSection(List<Long> devids, String paraName) {
        if (null == devids) {
            this.logger.info((Object)"in adapter function getParaRangeInterSection: devids is null");
            return null;
        }
        this.logger.info((Object)("@ adapter function getParaRangeInterSection,devids: " + devids + " paraName: " + this.getcleanedMessage(paraName)));
        HashSet<DeviceTypeInfo> devInfoSet = new HashSet<DeviceTypeInfo>();
        for (Long devid : devids) {
            devInfoSet.add(CapaUtil.getDevTypeInfo(devid));
        }
        return this.getParaRangeInterSection(devInfoSet, paraName);
    }

    public ParaBean getParaRangeInterSection(Set<DeviceTypeInfo> devInfoSet, String paraName) {
        this.logger.info((Object)"in adapter function getParaRangeInterSection");
        ParaBean retParaBean = new ParaBean();
        int maxVal = -1;
        int minVal = -1;
        for (DeviceTypeInfo deviceTypeInfo : devInfoSet) {
            try {
                retParaBean = this.getParaBean(deviceTypeInfo, paraName).clone();
            }
            catch (CloneNotSupportedException e) {
                this.logger.warn((Object)("@ adapter function getParaRangeInterSection," + e));
            }
            maxVal = retParaBean.getMaxVal();
            minVal = retParaBean.getMinVal();
        }
        String paraRange = minVal + CapabilityConstant.DASH_SPLIT + maxVal;
        retParaBean.setParaRange(paraRange);
        retParaBean.setParaDefault(String.valueOf(maxVal));
        this.logger.info((Object)"out adapter function getParaRangeInterSection");
        return retParaBean;
    }

    public Map<String, ParaBean> getAllParaBeanMap(long devid) {
        this.logger.info((Object)("@ adapter function getAllParaBeanMap,devid:" + devid));
        return this.getAllParaBeanMap(CapaUtil.getDevTypeInfo(devid));
    }

    public Map<String, ParaBean> getAllParaBeanMap(DeviceTypeInfo devInfo) {
        Map<String, ParaBean> defMap;
        DevParasBean devDefaultParasBean;
        this.logger.info((Object)("in adapter function getAllParaBeanMap,DeviceTypeInfo: " + devInfo));
        HashMap<String, ParaBean> paraName2BeanMap = new HashMap<String, ParaBean>();
        Map<String, ParaBean> devParaMap = null;
        DevParasBean devParasBean = this.getParasBean(devInfo);
        if (null != devParasBean && !(devParaMap = devParasBean.getAllBeanMap()).isEmpty()) {
            paraName2BeanMap.putAll(devParaMap);
        }
        if (null != (devDefaultParasBean = this.getDefaultParasBean(devInfo)) && !(defMap = devDefaultParasBean.getAllBeanMap()).isEmpty()) {
            if (null == devParaMap) {
                paraName2BeanMap.putAll(defMap);
            } else {
                Set<Map.Entry<String, ParaBean>> set = defMap.entrySet();
                Map.Entry<String, ParaBean> entry2 = null;
                for (Map.Entry<String, ParaBean> entry2 : set) {
                    String defPara = entry2.getKey();
                    ParaBean value = entry2.getValue();
                    if (devParaMap.containsKey(defPara)) continue;
                    paraName2BeanMap.put(defPara, value);
                }
            }
        }
        this.logger.info((Object)"out adapter function getAllParaBeanMap");
        return paraName2BeanMap;
    }

    public Map<String, String> getAllParasDefaultValue(long devid) {
        this.logger.info((Object)("@ adapter function getAllParasDefaultValue,devid:" + devid));
        return this.getAllParasDefaultValue(CapaUtil.getDevTypeInfo(devid));
    }

    public Map<String, String> getAllParasDefaultValue(DeviceTypeInfo devInfo) {
        this.logger.info((Object)("in adapter function getAllParasDefaultValue,DeviceTypeInfo: " + devInfo));
        HashMap<String, String> paraName2DefValMap = new HashMap<String, String>();
        Map<String, ParaBean> name2BeanMap = this.getAllParaBeanMap(devInfo);
        if (!name2BeanMap.isEmpty()) {
            Set<Map.Entry<String, ParaBean>> set = name2BeanMap.entrySet();
            Map.Entry<String, ParaBean> entry2 = null;
            for (Map.Entry<String, ParaBean> entry2 : set) {
                paraName2DefValMap.put(entry2.getKey(), entry2.getValue().getParaDefault());
            }
        }
        this.logger.info((Object)"out adapter function getAllParasDefaultValue");
        return paraName2DefValMap;
    }

    public Map<String, String> getAllParasRangeValue(long devid) {
        this.logger.info((Object)("@ adapter function getAllParasRangeValue,devid:" + devid));
        return this.getAllParasRangeValue(CapaUtil.getDevTypeInfo(devid));
    }

    public Map<String, String> getAllParasRangeValue(DeviceTypeInfo devInfo) {
        this.logger.info((Object)("in adapter function getAllParasRangeValue,DeviceTypeInfo: " + devInfo));
        HashMap<String, String> paraName2ValMap = new HashMap<String, String>();
        Map<String, ParaBean> name2BeanMap = this.getAllParaBeanMap(devInfo);
        if (!name2BeanMap.isEmpty()) {
            Set<Map.Entry<String, ParaBean>> set = name2BeanMap.entrySet();
            Map.Entry<String, ParaBean> entry2 = null;
            for (Map.Entry<String, ParaBean> entry2 : set) {
                paraName2ValMap.put(entry2.getKey(), entry2.getValue().getParaRange());
            }
        }
        this.logger.info((Object)"out adapter function getAllParasRangeValue");
        return paraName2ValMap;
    }
}

