/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.atic.secne.sdk.common;

import java.io.UnsupportedEncodingException;

public final class StringUtils {
    public static final String EMPTY = "";
    public static final String SLOGAN_LINKSTR = ",";
    public static final int INDEX_NOT_FOUND = -1;

    private StringUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        if (null != str && 0 != str.length()) {
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static String replaceNulltoBlank(String source) {
        String source1 = null;
        source1 = null == source ? EMPTY : source;
        return source1;
    }

    public static String escapeAll(String source) {
        if (StringUtils.isEmpty(source)) {
            return source;
        }
        String result = source.replaceAll("'", "&apos;");
        result = result.replaceAll("\"", "&quot;");
        result = result.replaceAll("\\\\", "%5C");
        result = result.replaceAll(">", "%3C");
        result = result.replaceAll("<", "%3E");
        return result;
    }

    public static String unEscapeAll(String source) {
        if (StringUtils.isEmpty(source)) {
            return source;
        }
        String result = source.replaceAll("&apos;", "'");
        result = result.replaceAll("&quot;", "\"");
        result = result.replaceAll("%5C", "\\\\");
        result = result.replaceAll("%3C", ">");
        result = result.replaceAll("%3E", "<");
        return result;
    }

    public static String arrayToString(int[] arr) {
        StringBuffer sb = new StringBuffer();
        if (null != arr) {
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                sb.append(arr[i] + SLOGAN_LINKSTR);
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String arrayToString(String[] arr) {
        StringBuffer sb = new StringBuffer();
        if (null != arr) {
            int size = arr.length;
            for (int i = 0; i < size; ++i) {
                sb.append(arr[i] + SLOGAN_LINKSTR);
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Long[] stringToLongArray(String longTypeStr) {
        if (null == longTypeStr || EMPTY.equals(longTypeStr)) {
            return new Long[0];
        }
        String[] ids = longTypeStr.split(SLOGAN_LINKSTR);
        Long[] lIds = new Long[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            lIds[i] = Long.parseLong(ids[i]);
        }
        return lIds;
    }

    public static String encodeHtmlStr(String str) {
        String str1 = str;
        if (str1 == null || str1.trim().length() == 0) {
            return str1;
        }
        str1 = str1.replaceAll("&", "&amp;");
        str1 = str1.replaceAll("<", "&lt;");
        str1 = str1.replaceAll(">", "&gt;");
        str1 = str1.replaceAll("'", "&apos;");
        str1 = str1.replaceAll("\"", "&quot;");
        return str1;
    }

    public static String decodeHtmlStr(String str) {
        String str1 = str;
        if (str1 == null || str1.trim().length() == 0) {
            return str1;
        }
        str1 = str1.replaceAll("&amp;", "&");
        str1 = str1.replaceAll("&lt;", "<");
        str1 = str1.replaceAll("&gt;", ">");
        str1 = str1.replaceAll("&apos;", "'");
        str1 = str1.replaceAll("&quot;", "\"");
        return str1;
    }

    public static byte[] stringToByte(String str, String charEncode) {
        byte[] destObj = null;
        try {
            if (null == str || EMPTY.equals(str.trim())) {
                destObj = new byte[]{};
                return destObj;
            }
            destObj = str.getBytes(charEncode);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
        return destObj;
    }

    public static String encodeLuceneStr(String str) {
        String str1 = str;
        if (str1 == null || str1.trim().length() == 0) {
            return str1;
        }
        str1 = str1.replace("_", "(**,,_,,**)");
        str1 = str1.replace(".", "(**,,@,,**)");
        return str1;
    }

    public static String deencodeLuceneStr(String str) {
        String str1 = str;
        if (str1 == null || str1.trim().length() == 0) {
            return str1;
        }
        str1 = str1.replace("(**,,_,,**)", "_");
        str1 = str1.replace("(**,,@,,**)", ".");
        return str1;
    }
}

